#include "copyright2.h"
#include <sys/file.h>
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <sys/types.h>
#include <sys/time.h>
#include <ctype.h>
#include <string.h>
#include <assert.h>
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"

#include "prog_version.h"

#ifdef MAKE_XTREKRC
#define DEFAULT_SAVEFILE  "/tmp/netrek_motd"
#define NORMAL_FONT     "6x10"
#define BOLD_FONT       "-*-clean-bold-r-normal--10-100-75-75-c-60-*"
#define ITALIC_FONT     "-*-clean-bold-r-normal--10-100-75-75-c-60-*"
#define BIG_FONT        "-*-lucidatypewriter-*-*-*-*-40-*-*-*-*-*-*-*"
#define IND_FONT        "-*-clean-bold-r-normal--10-100-75-75-c-60-*"
#define FONTS 4

extern char     cname[];

struct colors
{
  char           *name;
  GC              contexts[FONTS + 1];
  Pixmap          pixmap;
  int             pixelValue;
};
extern struct colors colortable[];

make_xtrekrc (mode)
  int             mode;

{
  char            buf[128], defaultstring[100], *fontname, *defaults,
                  *adefault, filename[128];
  extern int      forceMono, recordGame;
  int             width, height, x, y, i;
  W_Window        parent;

  filename[0] = '\0';

  switch (mode)
  {
    case 0:
      strcpy (filename, "sample-xtrekrc");
      set_defaults_filename (filename);
      comment_default ("#\n#\n#\n# Sample xtrekrc defaults file\n#");
      comment_default ("# ***REMEMBER THIS FILE DOES NOT INCLUDE");
      comment_default ("# ***MACROS OR SERVER ALIASES\n#\n#\n#");
      break;
    case 1:
      if (getenv ("HOME"))
	strcpy (filename, (char *) getenv ("HOME"));

      strcat (filename, "/.cow-literc");
      set_defaults_filename (filename);
      comment_default ("#\n#\n#\n# .cow-literc defaults file\n#");
      comment_default ("# ***REMEMBER THIS FILE IS AUTOMATICALLY");
      comment_default ("# ***GENERATED ANY EDITS TO THIS FILE");
      comment_default ("# ***MAY BE LOST\n#\n#\n#");
      break;
  }


  if (mode == 0)
  {
    comment_default ("\n# Various fonts used by the client:\n");

    fontname = getdefault ("font");
    if (fontname == NULL)
      fontname = NORMAL_FONT;
    show_defaults ("fonts", "font", fontname,
		   "Default font.");
    fontname = getdefault ("boldfont");
    if (fontname == NULL)
      fontname = BOLD_FONT;
    show_defaults ("fonts", "boldfont", fontname,
		   "Bold font -- used for highlighting.");
    fontname = getdefault ("italicfont");
    if (fontname == NULL)
      fontname = ITALIC_FONT;
    show_defaults ("fonts", "italicfont", fontname,
		   "Italic font.");
    fontname = getdefault ("bigfont");
    if (fontname == NULL)
      fontname = BIG_FONT;
    show_defaults ("fonts", "bigfont", fontname,
	       "Large font -- used to display number of players per team.");

    comment_default ("\n# Various colors used by the client:\n");

    for (i = 0; i < 6; i++)
    {
      sprintf (defaultstring, "color.%s", colortable[i].name);

      defaults = getdefault (defaultstring);
      if (defaults == NULL)
	defaults = colortable[i].name;
      show_defaults ("display", defaultstring, defaults,
		     "Color remapping");
    }
  }

  /*
   * if (mode == 1) { show_defaults ("window", "stats.mapped", W_IsMapped
   * (statwin) ? "on" : "off", "Color remapping"); show_defaults ("window",
   * "help.mapped", W_IsMapped (helpWin) ? "on" : "off", "Color remapping");
   * show_defaults ("window", "review_all.mapped", W_IsMapped (messwa) ? "on"
   * : "off", "Color remapping"); show_defaults ("window",
   * "review_team.mapped", W_IsMapped (messwt) ? "on" : "off", "Color
   * remapping"); show_defaults ("window", "review_your.mapped", W_IsMapped
   * (messwi) ? "on" : "off", "Color remapping"); show_defaults ("window",
   * "review_kill.mapped", W_IsMapped (messwk) ? "on" : "off", "Color
   * remapping"); show_defaults ("window", "player.mapped", W_IsMapped
   * (playerw) ? "on" : "off", "Color remapping"); show_defaults ("window",
   * "review.mapped", W_IsMapped (reviewWin) ? "on" : "off", "Color
   * remapping"); }
   */

  comment_default ("\n# Resources controlling display:\n");

  show_defaults ("display", "forceMono", forceMono ? "on" : "off",
		 "Force black&white even if color supported.");

  show_defaults ("display", "showPlanetNames", namemode ? "on" : "off",
		 "Show planet names");
  show_defaults ("display", "showShields", showShields ? "on" : "off",
		 "Show ship shields");
  show_defaults ("display", "showStats", showStats ? "on" : "off",
		 "Show stats window");
  show_defaults ("display", "galacticFrequent", "on",
		 "Update galactic map frequently.");
  show_defaults ("display", "newPlanetBitmaps", myPlanetBitmap ? "on" : "off",
		 "Use MOO planet bitmaps.");

#ifdef ZZ_BITMAPS
  sprintf (buf, "%d", myPlanetBitmap);
  show_defaults ("display", "whichNewPlanetBitmaps", buf,
       "Local: 1 -- Use rabbit eared bitmaps, 2 -- Use ZZ minimal bitmaps");
#endif
  
  show_defaults ("display", "showTractorPressor", showTractorPressor ? "on" : "off",
		 "Show your own tractor/pressor.");
  show_defaults ("display", "fillTriangle", fillTriangle ? "on" : "off",
		 "If locks are shown, whether or not to fill the triangle.");
  show_defaults ("display", "continueTractor", continueTractor ? "on" : "off",
		 "If off, only shows tractors for a short time.");
  show_defaults ("display", "extraAlertBorder", extraBorder ? "on" : "off",
		 "Also uses inside border to show alert status.");
  show_defaults ("display", "varyShields", VShieldBitmaps ? "on" : "off",
		 "Change shields to reflect damage.");
  show_defaults ("display", "useMsgw", use_msgw ? "on" : "off",
		 "Display the last message in the warning message window.");
  sprintf (buf, "%d", phas_msg);
  show_defaults ("display", "PhaserMsg", buf, 
	"Phaser Window: 0 -- none, 1 -- review all, 2 -- review team, 3 -- review indiv, 4 -- review kill, 5 -- total");
  sprintf (buf, "%d", showlocal);
  show_defaults ("display", "showLocal", buf,
           "Local: 0 -- show owner, 1 -- show resoures, 2 -- show nothing");
  sprintf (buf, "%d", showgalactic);
  show_defaults ("display", "showGalactic", buf,
        "Galactic: 0 -- show owner, 1 -- show resoures, 2 -- show nothing");
  sprintf (buf, "%d", showLock);
  show_defaults ("display", "showLock", buf,
                 "0 -- dont show lock, 1 -- show on galactic, \n\
#2 -- show on local, 3 -- show on both.");
  show_defaults ("display", "sortPlayers", sortPlayers ? "on" : "off",
		 "Sort player listings by team.");

#ifdef NEW_PL
  show_defaults ("display", "newPlist", newPlist ? "on" : "off",
		 "Reduced stats format for the player list.");
#endif

#ifdef PLIST
  if (plist)
    show_defaults ("display", "playerlist", plist,
		   "User configurable player list");
  else
    show_defaults ("display", "playerlist", "nTRNKWLr O D d ",
		   "User configurable player list");
#endif

  sprintf (buf, "%d", tclock);
  show_defaults ("display", "tclock", buf,
                 "Stat clock: 0 -- no clock, 1 -- h:m, 2 -- h:m:s.");
  show_defaults ("display", "shortKillMesg", abbr_kmesg ? "on" : "off",
                 "Shrink and line up all kill messages.");
  show_defaults ("display", "shortKillMesg", abbr_kmesg ? "on" : "off",
		 "Shrink and line up all kill messages.");

#ifdef DASHBOARD
  show_defaults ("display", "dashboard", dashboard ? "on" : "off",
		 "Use a dashboard (LAB) style for the stats line.");
#endif

#ifdef NEW_DASHBOARD_2
  show_defaults ("display", "newdashboard2", cup_half_full ? "on" : "off",
		 "Use a dashboard (KRP + LAB) style for the stats line.");
#endif

#ifdef TNG_FED_BITMAPS
  show_defaults ("display", "useTNGBitmaps", use_tng_fed_bitmaps ? "on" : "off",
		 "Use next generation style bitmaps.");
#endif

#ifdef VARY_HULL
  show_defaults ("display", "warnHull", vary_hull ? "on" : "off",
		 "Warn hull state according to damage.");
#endif

#ifdef SHOW_MY_SPEED
  show_defaults ("display", "showMySpeed", showMySpeed ? "on" : "off",
                 "Show your speed on tactical");
#endif

#ifdef KEEP_INFO
  sprintf (buf, "%d", keepInfo);
  show_defaults ("display", "keepInfo", buf,
                 "Number of updates to keep info windows.");
#endif

  show_defaults ("display", "showPlayerStatus", plshowstatus ? "on" : "off",
		 "Player list: also show players not alive.");

#ifdef SHOW_IND
  show_defaults ("display", "showIND", showIND ? "on" : "off",
		 "Show independant planet with X trough it.");
#endif

#ifdef CLOAK_CHARS
  show_defaults ("display", "cloakChars", cloakChars ? cloakChars : "??",
		 "Chars to draw cloakers with on map.");
#endif

  sprintf (buf, "%d", enemyPhasers);
  show_defaults ("display", "enemyPhasers", buf,
		 "Width to draw enemy phasers.");

#ifdef JUBILEE_PHASERS
  show_defaults ("display", "colorfulPhasers", jubilee_phasers ? "on" : "off",
		 "Draw phasers using multiple colors when you hit.");
#endif

#ifdef BEEPLITE
  show_defaults ("misc", "DefLite", DefLite ? "on" : "off",
		 "Highlight default RCD messages.");
  show_defaults ("misc", "UseLite", UseLite ? "on" : "off",
		 "Use RCD highlighting.");
  
  sprintf (buf, "%d", beep_lite_cycle_time_planet);
  show_defaults ("display", "planetCycleTime", buf,
		 "Number of updates to draw RCD planet highlight.");
  sprintf (buf, "%d", beep_lite_cycle_time_player);
  show_defaults ("display", "playerCycleTime", buf,
		 "Number of updates to draw RCD player highlight.");
#endif

  show_defaults ("misc", "askforUpdate", askforUpdate ? "on" : "off",
		 "When entering game, send request for full update.");
  
  
#ifdef ROMVLVS_BITMAPS
  show_defaults ("display", "ROMVLVS", ROMVLVS ? "on" : "off",
		 "Use alternate romulan cruiser bitmap.");
#endif


  comment_default ("\n# UDP control resources:\n");

  show_defaults ("UDP", "tryUdp", tryUdp ? "on" : "off",
		 "Try to use udp upon entering the game.");
  show_defaults ("UDP", "udpSequenceChk", udpSequenceChk ? "on" : "off",
		 "Throw out udp packets that arrive out of order.");
  sprintf (buf, "%d", udpDebug);
  show_defaults ("UDP", "udpDebug", buf,
                 "Level of UDP code debugging.");
  sprintf (buf, "%d", udpClientSend);
  show_defaults ("UDP", "udpClientSend", buf, 
                 "0 -- TCP, 1 -- simple UDP, 2 -- enforced UDP (state only)\n\
#3 -- enforce UDP (state & weapon)");
  sprintf (buf, "%d", udpClientRecv);
  show_defaults ("UDP", "udpClientRecv", buf, 
                 "0 -- TCP, 1 -- simple UDP, 2 -- fat UDP");

  comment_default ("\n# Short packet control resources:\n");

  show_defaults ("short-packets", "tryShort", tryShort ? "on" : "off",
		 "Try short-packets (HW) upon entering.");

#ifdef FEATURE
    if (macrokey == 27)
      strcpy (buf, "ESC");
    else if (macrokey == 9)
      strcpy (buf, "TAB");
    else
    {
      buf[0] = (char) macrokey;
      buf[1] = '\0';
    }

  show_defaults ("input", "macroKey", buf,
		"Name of key to use for macro escape (TAB,ESC, or <key>).");
  
  make_singlemacrokeys (buf);
    
  if (buf [0])
    show_defaults ("input", "singleMacro", buf, "Single key macros.");    
#endif

  comment_default ("\n# Various keymaps used by the client:\n");


  if (mode == 1)
  {
    char            kmap[192];

    make_keymap (kmap, 0);
    defaults = kmap;
    show_defaults ("input", "keymap", defaults ? defaults : "aabbcc",
		   "Maps new keys to old keys. Format: <new key><old key><new key><old key>...");
  }
  else
  {
    defaults = getdefault ("keymap");
    show_defaults ("input", "keymap", defaults ? defaults : "aabbcc",
		   "Maps new keys to old keys. Format: <new key><old key><new key><old key>...");
  }

#ifdef CONTROL_KEY
  if (mode == 1)
  {
    char            ckmap[384];

    make_keymap (ckmap, 1);
    defaults = ckmap;
    show_defaults ("input", "ckeymap", defaults ? defaults : "aabbcc",
		   "Maps new keys to old keys. Format: <new key><old key><new key><old key>...");
  }
  else
  {
    defaults = getdefault ("ckeymap");
    show_defaults ("input", "ckeymap", defaults ? defaults : "aabbcc",
		   "Maps new keys to old keys. Format: <new key><old key><new key><old key>...");
  }
#endif

  if (mode == 1)
  {
    char            buttons[64];
    make_buttonmap (buttons);
    show_defaults ("input", "buttonmap", buttons[0] ? buttons : "1t2p3k",
		"Maps buttons to key functions.  Format: <button><key>...");
  }

  comment_default ("\n# Alternate mouse input modes:\n");

#ifdef MOTION_MOUSE
  show_defaults ("input", "continuousMouse", motion_mouse ? "on" : "off",
		 "Use continuous mouse tracking.");
  {
    char            ints[18];
    sprintf (ints, "%d", user_motion_thresh);
    show_defaults ("input", "motionThresh", ints,
		   "Motion threshhold for continuousMouse.");
  }
#endif

#ifdef SHIFTED_MOUSE
  show_defaults ("input", "shiftedMouse", extended_mouse ? "on" : "off",
		 "Use shifted mouse for more mouse buttons.");
#endif

  comment_default ("\n# Various startup values:\n");

  {
    char            ints[10];
    sprintf (ints, "%d", 5);
    show_defaults ("startup", "updatesPerSecond", ints,
		 "Number of updates per second (most servers limit to 5).");
  }
  show_defaults ("startup", "zeroArgUsage", "on",
     "If no arguments, print usage instead of looking for default server.");

  if (mode == 0)
    show_defaults ("startup", "useRSA", RSA_Client ? "on" : "off",
		   "Use RSA verification.");

  show_defaults ("startup", "waitMotd", showMotdOnQ ? "on" : "off",
		 "Show the motd while on the wait q.");

  if (mode == 1)
  {
    if (cname[0] == '\0')
      defaults = getdefault ("name");
    else
      defaults = cname;

    show_defaults ("startup", "name", defaults ? defaults : "your-name-here",
		   "The default player name shown at the login window.\n");
  }
  else
  {
    defaults = getdefault ("name");
    show_defaults ("startup", "name", defaults ? defaults : "your-name-here",
		   "The default player name shown at the login window.\n");
  }

  show_defaults ("startup", "dontPing", "off",
		 "Don't attempt to start ping packets from the server.");


  if (mode == 0)
  {
    comment_default ("\n# Server defaults:\n");
    show_defaults ("startup", "port", "2592", "Default port to use.");

    show_defaults ("startup", "server.alias", "x.y.z",
		   "Aliases.  Replace x.y.z with full server name, and specify <alias>\n\
#From then on you can specify that server by doing 'netrek -h <alias>'");
    show_defaults ("startup", "port.x.y.z", "2592",
		   "Default port to use with server x.y.z.\n\
#NOTE: if x.y.z is aliased (server.alias: x.y.z), use the alias instead.");
    show_defaults ("startup", "useRSA.x.y.z", RSA_Client ? "on" : "off",
		   "Default RSA use for server x.y.z.\n\
#NOTE: if x.y.z is aliased (server.alias: x.y.z), use the alias instead.");
    show_defaults ("startup", "server", "default.server.edu",
	   "Name of the default server to use if the -h flag isn't given.");
  }


  comment_default ("\n# Window resources:\n");

  show_defaults ("window", "phaserWindow", phaserWindow ? "on" : "off",
		 "Show phaser-hit messages in seperate window.\n\
#  See also review_phaser for default mapping and geometry \n\
#  (message widths 13, 32, 80 supported).");


  comment_default ("\n# Misc. resources:\n");

  show_defaults ("misc", "netstats", netstat ? "on" : "off",
		 "Keep lag statistics.");
  show_defaults ("misc", "warp", warp ? "on" : "off",
	       "Warp the mouse to the message window during message send.");
  show_defaults ("misc", "keepPeace", keeppeace ? "on" : "off",
		 "Keep peace with races after death.");
  show_defaults ("misc", "reportKills", reportKills ? "on" : "off",
		 "Show kill messages.");
  show_defaults ("misc", "logMessage", logMess ? "on" : "off",
		 "Log messages.");
  sprintf (buf, "%d", netstatfreq);
  show_defaults ("misc", "netStatFreq", buf, 
                 "Lag stats update: 1 -- least often, 10 -- most often.");
  show_defaults ("misc", "newMesgFlags", new_messages ? "on" : "off",
		 "Server-dependent. Should be on for all new servers.");
#ifdef USE_TR_PORTS
  show_defaults ("misc", "useTRPorts", useTRPorts ? "on" : "off",
		 "Use trace route ports for UDP connections.");
#endif

#ifdef MAP_NAMES
  show_defaults ("display", "showMapPlanetNames", draw_map_names ? "on" : "off",
		 "Draw planet names on the galactic map.");
  show_defaults ("display", "showOwnerOnMap", show_owner_map ? "on" : "off",
		 "Draw planet owner on the galactic map.");
#endif
  
#ifdef SHOW_FUEL_ON_LOCAL
  show_defaults ("display", "showFuelOnLocal",
		 show_fuel_on_local ? "on" : "off",
		 "Show fuel on tactical display.");
#endif

  defaults = getdefault ("motd.savefile");
  show_defaults ("string", "motd.savefile", defaults ? defaults :
		 DEFAULT_SAVEFILE,
	      "Name of file to save motd in if 'S' typed in entry window.");

  finish_defaults ();
}

make_buttonmap (bmap)
  char           *bmap;
{
  int             i, j;

  for (i = 1, j = 0; i < 13; i++)
    if (buttonmap[i])
    {
      if (i < 10)
	bmap[j++] = (char) (i + '0');
      else
	bmap[j++] = (char) (i - 10 + 'a');

      bmap[j++] = buttonmap[i];
    }

  bmap[j] = '\0';
}

make_keymap (kmap, mode)
  char           *kmap;
  int             mode;

{
  int             i, j, k = 96;
  char           *str;

  k *= mode;
  *kmap++ = 7;
  *kmap++ = 7;

  for (i = 0 + k, j = 0; i < (95 + k); i++)
    if (mystats->st_keymap[i] != ((char) (i + ' ')))
    {
      if (mode == 0)
      {
	if (mystats->st_keymap[i] >= ' ' &&
	    mystats->st_keymap[i] < 127)
	{
	  kmap[j++] = ((char) (i + ' '));
	  kmap[j++] = mystats->st_keymap[i];
	}
      }
      else
      {
	/* Handle target control key. */
	if (((char) (mystats->st_keymap[i] - 96)) >= ' ')
	{
	  kmap[j++] = '^';
	  kmap[j++] = ((char) (i - 96 + ' '));
	  kmap[j++] = '^';
	  kmap[j++] = ((char) (mystats->st_keymap[i] - 96));
	}
	else
	{
	  kmap[j++] = '^';
	  kmap[j++] = ((char) (i - 96 + ' '));
	  kmap[j++] = mystats->st_keymap[i];
	}
      }
    }

  kmap[j] = '\0';
}

make_singlemacrokeys (single)
  char *single;
  
{
  char *str = singleMacro;
  int i, ch;
  
  single [0] = '\0';
  
  if (!str)
    return;
    
  for (i = 0; *str; str++)
    if (*str > 0)
      single [i++] = *str;
    else
      {
        single [i++] = '^';
        single [i++] = (char) (*str - 96);
      }
      
  single [i] = '\0';
}

#endif
