/*
 * interface.c
 * 
 * This file will include all the interfaces between the input routines and the
 * daemon.  They should be useful for writing robots and the like
 */
#include "copyright.h"

#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <sys/time.h>
#ifndef sgi
#include <sys/timeb.h>
#endif
#include <signal.h>
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"
#include "packets.h"

set_speed(speed)
    int             speed;
{
   sendSpeedReq(speed);
}

set_course(dir)
    unsigned char   dir;
{
   sendDirReq(dir);
}

shield_up()
{
   if (!(me->p_flags & PFSHIELD)) {
      sendShieldReq(1);
   }
}

shield_down()
{
   if (me->p_flags & PFSHIELD) {
      sendShieldReq(0);
   }
}

shield_tog()
{
   if (me->p_flags & PFSHIELD) {
      sendShieldReq(0);
   } else {
      sendShieldReq(1);
   }
}

bomb_planet()
{
   if (!(me->p_flags & PFBOMB)) {
      sendBombReq(1);
   }
}

beam_up()
{
   if (!(me->p_flags & PFBEAMUP)) {
      sendBeamReq(1);		/* 1 means up... */
   }
}

beam_down()
{
   if (!(me->p_flags & PFBEAMDOWN)) {
      sendBeamReq(2);		/* 2 means down... */
   }
}

repair()
{
   if (!(me->p_flags & PFREPAIR)) {
      sendRepairReq(1);
   }
}

repair_off()
{
   if (me->p_flags & PFREPAIR) {
      sendRepairReq(0);
   }
}

repeat_message()
{
   if (++lastm == MAXMESSAGE);
   lastm = 0;
}

cloak()
{
   if (me->p_flags & PFCLOAK) {
      sendCloakReq(0);
   } else {
      sendCloakReq(1);
   }
}

cloak_on()
{
   if (!(me->p_flags & PFCLOAK)) {
      sendCloakReq(1);
   }
}

cloak_off()
{
   if (me->p_flags & PFCLOAK) {
      sendCloakReq(0);
   }
}

mstime()
{
   static
   struct timeval  tv_base;
   struct timeval  tv;

   if (!tv_base.tv_sec) {
      gettimeofday(&tv_base, NULL);
      return 0;
   }
   gettimeofday(&tv, NULL);
   return (tv.tv_sec - tv_base.tv_sec) * 1000 +
      (tv.tv_usec - tv_base.tv_usec) / 1000;
}

msetime()
{
   struct timeval  tv;
   gettimeofday(&tv, NULL);
   return (tv.tv_sec - 732737182) * 1000 + tv.tv_usec / 1000;
}

#ifdef nodefGALAXY_BORG_FEATURES/* borg alert! */
/* robot features */

unsigned char 
our_calc(x, y)
    int             x, y;
{
   return (atan2((double) (x), (double) (y)) / 3.14159 * 128.);
}

plasma_phaser(pt)
    register struct plasmatorp *pt;
{
   int             myphrange;
   int             x, y;

   x = (pt->pt_x - me->p_x);
   y = (me->p_y - pt->pt_y);
   myphrange = PHASEDIST * me->p_ship.s_phaserdamage / 100;
   if (pt->pt_status != PTMOVE)
      return;
   if (!(pt->pt_war & me->p_team) && !(me->p_hostile & pt->pt_team))
      return;
   if (abs(pt->pt_x - me->p_x) > myphrange)
      return;
   if (abs(pt->pt_y - me->p_y) > myphrange)
      return;
   if (hypot((float) pt->pt_x - me->p_x, (float) pt->pt_y - me->p_y) >
       myphrange)
      return;
   if (!(me->p_flags & PFCLOAK) && !(me->p_flags & PFREPAIR)) {
      warning(" --- Firing auto-plasma phaser --- ");
      sendPhaserReq(our_calc(x, y));
   }
}

get_enemy(data)
    W_Event        *data;
{
   int             myphrange;
   register int    i;
   register struct player *j;
   int             g_x, g_y;
   double          dist, closedist;
   unsigned char   course;

   closedist = GWIDTH;
   myphrange = PHASEDIST * me->p_ship.s_phaserdamage / 100;
   if (data->Window == mapw) {
      g_x = data->x * (GWIDTH / WINSIDE);
      g_y = data->y * (GWIDTH / WINSIDE);
   } else {
      g_x = me->p_x + ((data->x - WINSIDE / 2) * SCALE);
      g_y = me->p_y + ((data->y - WINSIDE / 2) * SCALE);
   }

   for (i = 0, j = &players[i]; i < MAXPLAYER; i++, j++) {
      if ((j->p_status != PALIVE) || (j == me))
	 continue;
      if (!(j->p_swar & me->p_team) && !(me->p_hostile & j->p_team))
	 continue;
      if (abs(j->p_x - me->p_x) > myphrange)
	 continue;
      if (abs(j->p_y - me->p_y) > myphrange)
	 continue;
      dist = hypot((double) (g_x - j->p_x), (double) (g_y - j->p_y));
      if (dist > myphrange)
	 continue;
      if (dist < closedist) {
	 data->x = j->p_x;
	 data->y = j->p_y;
	 closedist = dist;
      }
   }

   if (closedist == GWIDTH)
      course = getcourse(data->Window, data->x, data->y);
   else
      course = our_calc((data->x - me->p_x), (me->p_y - data->y));

   sendPhaserReq(course);
}
#endif

#ifdef MOO
#ifdef TIME_STAMP_ON_PHASER
update_timebuf()
{
  static int	   lasttime;
  long            curtime;
  struct tm      *tm;

  time(&curtime);
  if(tclock == 1)
  {
    if(curtime/60 == lasttime/60) return;
  }
  else
  { /* tclock == 2 */
    if(curtime == lasttime) return;
  }
  lasttime = curtime;
  tm = localtime(&curtime);
#ifdef NO_SPRINTF
  timebuf [0] = tm->tm_hour/10 + '0';
  timebuf [1] = (tm->tm_hour%10) + '0';
  timebuf [2] = ':';
  timebuf [3] = tm->tm_min/10 + '0';
  timebuf [4] = (tm->tm_min%10) + '0';
  timebuf [5] = ':';
  timebuf [6] = tm->tm_sec/10 + '0';
  timebuf [7] = (tm->tm_sec%10) + '0';
  timebuf [8] = '\0';
#else
  sprintf(timebuf, "%2d:%02d:%02d", tm->tm_hour, tm->tm_min, tm->tm_sec);
#endif
}
#endif

char            timebuf[10] = "";

run_clock()
{
   static int	   lasttime;
   long            curtime;
   struct tm      *tm;

   time(&curtime);
   if(tclock == 1){
      if(curtime/60 == lasttime/60) return;
   }
   else{ /* tclock == 2 */
      if(curtime == lasttime) return;
   }
   lasttime = curtime;
   tm = localtime(&curtime);
#ifdef NO_SPRINTF
      timebuf [0] = tm->tm_hour/10 + '0';
      timebuf [1] = (tm->tm_hour%10) + '0';
      timebuf [2] = ':';
      timebuf [3] = tm->tm_min/10 + '0';
      timebuf [4] = (tm->tm_min%10) + '0';
      timebuf [5] = ':';
      timebuf [6] = tm->tm_sec/10 + '0';
      timebuf [7] = (tm->tm_sec%10) + '0';
      timebuf [8] = '\0';
#else
   sprintf(timebuf, "%2d:%02d:%02d", tm->tm_hour, tm->tm_min, tm->tm_sec);
#endif
#ifdef DASHBOARD
   if(dashboard)
      W_WriteText (tstatw, 2, 30, textColor, timebuf, (tclock==2)?8:5, 
        W_RegularFont);
   else
#endif
      W_WriteText(tstatw, 50 + (66 * W_Textwidth), 27, W_Yellow, timebuf, 
	 (tclock==2)?8:5,
		  W_BoldFont);
}
#endif
