/*
 * getname.c
 * 
 * Kevin P. Smith 09/28/88
 * 
 */
#include "copyright2.h"

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#ifdef hpux
#include <time.h>
#else
#include <sys/time.h>
#endif
#include <errno.h>
#include <pwd.h>
#include <string.h>
#include <ctype.h>
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"

static char     tempname[16];
static char     password1[16];
static char     password2[16];
static int      state;
static struct passwd *passwd;
#define ST_GETNAME 0
#define ST_GETPASS 1
#define ST_MAKEPASS1 2
#define ST_MAKEPASS2 3
#define ST_DONE 4

/* added 11-4-92 for when getpwuid fails */
static struct passwd bozopwd;

#ifdef AUTOLOGIN
static int      autolog;
#endif /* AUTOLOGIN */

extern char cname [];

#ifdef AUTOLOGIN
noautologin ()
{
  static char *alf = "Automatic login failed";

  autolog = 0;
  *defpasswd = *password1 = *password2 = '\0';
  W_WriteText (w, 100, 130, textColor, alf, strlen (alf),
               W_BoldFont);
 
}
#endif /* AUTOLOGIN */

getname(defname)
    char           *defname;
    /* Let person identify themselves from w */
{
   W_Event         event;
   char            ch;
   int             secondsLeft = 99;
   char            tempstr[40];
   LONG            lasttime;
   int             j;
   struct timeval  tv;
   fd_set	   mask;

   passwd = getpwuid((uid_t) getuid());

   if (passwd == NULL) {
      perror("getpwuid error!");
      /* find some random thing to use in its place */
      passwd = &bozopwd;
      passwd->pw_name = defname;
   }
#ifdef nodef
#ifndef PCLIENT
   {
      char           *log = getdefault("login");
      if (log) {
	 passwd->pw_name = log;
	 strncpy(loginnam, log, sizeof(loginnam));
	 loginnam[sizeof(login) - 1] = '\0';
      }
   }
#else				/* PCLIENT */
#endif
#endif

   bzero(mystats, sizeof(struct stats));
   mystats->st_tticks = 1;
   for (j = 0; j < 95; j++) {
      mystats->st_keymap[j] = j + 32;
      mystats->st_keymap[j + 96] = j + 32 + 96;
 
#ifdef MOUSE_AS_SHIFT
      mystats->st_keymap[j + 192] = j + 32;
      mystats->st_keymap[j + 288] = j + 32;
      mystats->st_keymap[j + 384] = j + 32;
#endif
   }
   mystats->st_keymap[95] = 0;
   mystats->st_flags = ST_MAPMODE + ST_NAMEMODE + ST_SHOWSHIELDS +
      ST_KEEPPEACE + ST_SHOWLOCAL * 2 + ST_SHOWGLOBAL * 2;
   lasttime = time(NULL);
   tempname[0] = '\0';
   password1[0] = '\0';
   password2[0] = '\0';
   state = ST_GETNAME;

#ifdef AUTOLOGIN
   autolog = (*defpasswd && *defname) ? 1 : 0;

   if (autolog)
	try_autologin(defname);
   if (state == ST_DONE)
	 return;
#endif /*AUTOLOGIN*/

   displayStartup(defname);
   for (;;) {
      /* TSH: added select here so this doesn't busy wait (only done once
	 but it messes up performance metrics) */

      if (state == ST_DONE) {
	 W_ClearWindow(w);
	 return;
      }

      if(!W_EventsPending()){
	 tv.tv_sec = 1;
	 tv.tv_usec = 0;
	 FD_ZERO(&mask);
	 FD_SET(W_Socket(), &mask);
	 FD_SET(sock, &mask);
	 /* udp sock will not be active here */
	 select(32, &mask, 0, 0, &tv);

	 if(FD_ISSET(sock, &mask)){
	    readFromServer(&mask);

	    if (isServerDead()) {
	       printf("Ack!  We've been ghostbusted!\n");
	       exit(0);
	    }
	 }

	 if (lasttime != time(NULL)) {
	    lasttime++;
	    secondsLeft--;
	    sprintf(tempstr, "Seconds to go: %d ", secondsLeft);
	    W_WriteText(w, 150, 400, textColor, tempstr, strlen(tempstr),
			W_BoldFont);
	    if (secondsLeft == 0) {
	       me->p_status = PFREE;
	       printf("Auto-Quit\n");
	       exit(0);
	    }
	 }
	 if (!FD_ISSET(W_Socket(), &mask))
	    continue;
      }

      W_NextEvent(&event);
      if (event.Window != w)
	 continue;
      switch ((int) event.type) {
      case W_EV_EXPOSE:
	 displayStartup(defname);
	 break;
      case W_EV_KEY:
	 ch = event.key;
	 if (ch == 10)
	    ch = 13;
#ifdef CONTROL_KEY
        if ((ch == 4 || ch == ((char) ('d' + 96)) || 
          ch == ((char) ('D' + 96))) && state == ST_GETNAME && 
          *tempname == '\0')
#else
        if (ch == 4 && state == ST_GETNAME && *tempname == '\0')
#endif
         {
	    exit(0);
	 }
	 if (ch < 32 && ch != 21 && ch != 13 && ch != 8)
	    break;
	 switch (state) {
	 case ST_GETNAME:
	    if (ch == 13) {
	       if (*tempname == '\0') {
		  strcpy(tempname, defname);
	       }
	       loaddude();
	       displayStartup(defname);
	    } else {
	       adjustString(ch, tempname, defname);
	    }
	    break;
	 case ST_GETPASS:
	    if (ch == 13) {
	       checkpassword();
	       displayStartup(defname);
	    } else {
	       adjustString(ch, password1, defname);
	    }
	    break;
	 case ST_MAKEPASS1:
	    if (ch == 13) {
	       state = ST_MAKEPASS2;
	       displayStartup(defname);
	    } else {
	       adjustString(ch, password1, defname);
	    }
	    break;
	 case ST_MAKEPASS2:
	    if (ch == 13) {
	       makeNewGuy();
	       displayStartup(defname);
	    } else {
	       adjustString(ch, password2, defname);
	    }
	    break;
	 }
      }
/* See option.c */
strcpy (cname, defname);
   }
}

#ifdef AUTOLOGIN
try_autologin(defname)
char *defname;
{
   strcpy(tempname, defname);
   loaddude();
   if (state != ST_DONE) {
       strcpy(password1, defpasswd);
       checkpassword();
   }
   if (state == ST_GETNAME)
	noautologin();
}
#endif


loaddude()
    /*
     * Query dude.
     */
{
   if (strcmp(tempname, "Guest") == 0 || strcmp(tempname, "guest") == 0) {
      loginAccept = -1;
      sendLoginReq(tempname, "\0", (char *) passwd->pw_name, 0);
      state = ST_DONE;
      me->p_pos = -1;
      me->p_stats.st_tticks = 1;/* prevent overflow */
      strcpy(me->p_name, tempname);
      while (loginAccept == -1) {
	 socketPause();
	 readFromServer(NULL);
	 if (isServerDead()) {
	    printf("Server is dead!\n");
	    exit(0);
	 }
      }
      if (loginAccept == 0) {
	 printf("Hmmm... The SOB server won't let me log in as guest!\n");
	 exit(0);
      }
      return;
   }
   /* Ask about the user */
   loginAccept = -1;
   sendLoginReq(tempname, "\0", passwd->pw_name, 1);
   while (loginAccept == -1) {
      socketPause();
      readFromServer(NULL);
      if (isServerDead()) {
	 printf("Server is dead!\n");
	 exit(0);
      }
   }
   *password1 = *password2 = 0;
   if (loginAccept == 0) {
      state = ST_MAKEPASS1;
   } else {
      state = ST_GETPASS;
   }
}

checkpassword()
    /*
     * Check dude's password. If he is ok, move to state ST_DONE.
     */
{
   char           *s;

   sendLoginReq(tempname, password1, passwd->pw_name, 0);
   loginAccept = -1;
   while (loginAccept == -1) {
      socketPause();
      readFromServer(NULL);
      if (isServerDead()) {
	 printf("Server is dead!\n");
	 exit(0);
      }
   }
   if (loginAccept == 0) {
      s = "Bad password!";
      W_WriteText(w, 100, 100, textColor, s, strlen(s), W_BoldFont);
      (void) W_EventsPending();
      sleep(3);
      W_ClearWindow(w);
      *tempname = 0;
      state = ST_GETNAME;
      return;
   }
   strcpy(me->p_name, tempname);

#ifndef MOO			/* MOO does all this stuff from netrekrc */
   showShields = (me->p_stats.st_flags / ST_SHOWSHIELDS) & 1;
#ifdef nodef
   mapmode = (me->p_stats.st_flags / ST_MAPMODE) & 1;
#endif
   namemode = (me->p_stats.st_flags / ST_NAMEMODE) & 1;
   keeppeace = (me->p_stats.st_flags / ST_KEEPPEACE) & 1;
   showlocal = (me->p_stats.st_flags / ST_SHOWLOCAL) & 3;
   showgalactic = (me->p_stats.st_flags / ST_SHOWGLOBAL) & 3;
#endif				/* MOO */

   state = ST_DONE;
}

makeNewGuy()
    /*
     * Make the dude with name tempname and password password1. Move to state
     * ST_DONE.
     */
{
   char           *s;

   if (strcmp(password1, password2) != 0) {
      s = "Passwords do not match";
      W_WriteText(w, 100, 120, textColor, s, strlen(s), W_BoldFont);
      (void) W_EventsPending();
      sleep(3);
      W_ClearWindow(w);
      *tempname = 0;
      state = ST_GETNAME;
      return;
   }
   /* same routine! */
   checkpassword();
}

adjustString(ch, str, defname)
    char            ch, *str;
    char           *defname;
{
   if (ch == 21) {
      *str = '\0';
      if (state == ST_GETNAME)
	 displayStartup(defname);
   } else if (ch == 8 || ch == '\177') {
      if (strlen(str) > 0) {
	 str[strlen(str) - 1] = '\0';
	 if (state == ST_GETNAME)
	    displayStartup(defname);
      }
   } else {
      if (strlen(str) == 15)
	 return;
      str[strlen(str) + 1] = '\0';
      str[strlen(str)] = ch;
      if (state == ST_GETNAME)
	 displayStartup(defname);
   }
}

displayStartup(defname)
    char           *defname;
    /* Draws entry screen based upon state. */
{
   char            s[100];
   char           *t;

   if (state == ST_DONE)
      return;
   t = "Enter your name.  Use the name 'guest' to remain anonymous.";
   W_WriteText(w, 100, 30, textColor, t, strlen(t), W_BoldFont);
   t = "Type ^D (Ctrl - D) to quit.";
   W_WriteText(w, 100, 40, textColor, t, strlen(t), W_BoldFont);
   sprintf(s, "Your name (default = %s): %s               ", defname, tempname);
   W_WriteText(w, 100, 50, textColor, s, strlen(s), W_BoldFont);
   if (state == ST_GETPASS) {
      t = "Enter password: ";
      W_WriteText(w, 100, 60, textColor, t, strlen(t), W_BoldFont);
   }
   if (state > ST_GETPASS) {
      t = "You need to make a password.";
      W_WriteText(w, 100, 70, textColor, t, strlen(t), W_BoldFont);
      t = "So think of a password you can remember, and enter it.";
      W_WriteText(w, 100, 80, textColor, t, strlen(t), W_BoldFont);
      t = "What is your password? :";
      W_WriteText(w, 100, 90, textColor, t, strlen(t), W_BoldFont);
   }
   if (state == ST_MAKEPASS2) {
      t = "Enter it again to make sure you typed it right.";
      W_WriteText(w, 100, 100, textColor, t, strlen(t), W_BoldFont);
      t = "Your password? :";
      W_WriteText(w, 100, 110, textColor, t, strlen(t), W_BoldFont);
   }
}
