/*
 * getdefaults.c : Read defaults from .xtrekrc file here <isae@iastate.edu>
 */

#ifdef MOO
#include "copyright2.h"
#include <stdio.h>
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"

extern int      updateSpeed;	/* from option.c */
extern int      oldBless;	/* from main.c */

#ifdef RECORD
extern char    *recordFileName;	/* from main.c */
#endif

#ifdef LOGMESG
extern char    *logFileName;	/* from main.c */
#endif

readDefaults ()
{

#ifdef CLOAK_CHARS
  char           *pek;
#endif
  char            buf[32];
  printf ("Reading default values ...\n");

  /* Read keymap */
  initkeymap ();

  /* Boolean defaults */

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "showPlanetNames", namemode ? "on" : "off",
		 "Show planet names");
#endif

  namemode = booleanDefault ("showPlanetNames", namemode);

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "showShields", showShields ? "on" : "off",
		 "Show ship shields");
#endif

  showShields = booleanDefault ("showShields", showShields);

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "showStats", showStats ? "on" : "off",
		 "Show stats window");
#endif

  showStats = booleanDefault ("showStats", showStats);

#ifdef SHOW_DEFAULTS
  show_defaults ("misc", "keepPeace", keeppeace ? "on" : "off",
		 "Keep peace with races after death.");
#endif

  keeppeace = booleanDefault ("keepPeace", keeppeace);

#ifdef SHOW_DEFAULTS
  show_defaults ("window", "phaserWindow", phaserWindow ? "on" : "off",
		 "Show phaser-hit messages in seperate window.  See also review_phaser\n\
for default mapping and geometry (message widths 13, 32, 80 supported).");
#endif

  phaserWindow = booleanDefault ("phaserWindow", phaserWindow);

#ifdef SHOW_DEFAULTS
  show_defaults ("misc", "reportKills", reportKills ? "on" : "off",
		 "Show kill messages.");
#endif

  reportKills = booleanDefault ("reportKills", reportKills);

#ifdef ZZ_BITMAPS

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "newPlanetBitmaps", myPlanetBitmap ? "on" : "off",
		 "Use MOO planet bitmaps.");
#endif

  myPlanetBitmap = booleanDefault ("newPlanetBitmaps", myPlanetBitmap);

  if (myPlanetBitmap)
    myPlanetBitmap = intDefault ("whichNewPlanetBitmaps", myPlanetBitmap);

#ifdef SHOW_DEFAULTS
  if (myPlanetBitmap == 1)
    show_defaults ("display", "whichNewPlanetBitmaps", "on",
		   "Use rabbit eared bitmaps.");
  else
    show_defaults ("display", "whichNewPlanetBitmaps", "on",
		   "Use ZZ minimal bitmaps.");
#endif

#else

#ifdef MOOBITMAPS

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "newPlanetBitmaps", myPlanetBitmap ? "on" : "off",
		 "Use MOO planet bitmaps.");
#endif

  myPlanetBitmap = booleanDefault ("newPlanetBitmaps", myPlanetBitmap);
#endif

#endif

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "showTractorPressor", showTractorPressor ? "on" : "off",
		 "Show your own tractor/pressor.");
#endif

  showTractorPressor = booleanDefault ("showTractorPressor", showTractorPressor);

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "fillTriangle", fillTriangle ? "on" : "off",
		 "If locks are shown, whether or not to fill the triangle.");
#endif

  fillTriangle = booleanDefault ("fillTriangle", fillTriangle);

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "continueTractor", continueTractor ? "on" : "off",
		 "If off, only shows tractors for a short time.");
#endif

  continueTractor = booleanDefault ("continueTractor", continueTractor);

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "extraAlertBorder", extraBorder ? "on" : "off",
		 "Also uses inside border to show alert status.");
#endif

  extraBorder = booleanDefault ("extraAlertBorder", extraBorder);

#ifdef NETSTAT

#ifdef SHOW_DEFAULTS
  show_defaults ("misc", "netstats", netstat ? "on" : "off",
		 "Keep lag statistics.");
#endif

  netstat = booleanDefault ("netstats", netstat);
#endif

#ifdef SHOW_DEFAULTS
  show_defaults ("misc", "warp", warp ? "on" : "off",
	       "Warp the mouse to the message window during message send.");
#endif

  warp = booleanDefault ("warp", warp);

#ifdef SHOW_DEFAULTS
  show_defaults ("UDP", "tryUdp", tryUdp ? "on" : "off",
		 "Try to use udp upon entering the game.");
#endif

  tryUdp = booleanDefault ("tryUdp", tryUdp);

#ifdef SHOW_DEFAULTS
  show_defaults ("UDP", "udpSequenceChk", udpSequenceChk ? "on" : "off",
		 "Throw out udp packets that arrive out of order.");
#endif

  udpSequenceChk = booleanDefault ("udpSequenceCheck", udpSequenceChk);

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "galacticFrequent", "on",
		 "Update galactic map frequently.");
#endif

  if (booleanDefault ("galacticFrequent", 1))
    mapmode = 2;

#ifdef LOGMESG

#ifdef SHOW_DEFAULTS
  show_defaults ("misc", "logMessage", logMess ? "on" : "off",
		 "Log messages.");
#endif

  logMess = booleanDefault ("logMessage", logMess);
#endif

#ifdef VSHIELD_BITMAPS

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "varyShields", VShieldBitmaps ? "on" : "off",
		 "Change shields to reflect damage.");
#endif

  VShieldBitmaps = booleanDefault ("varyShields", VShieldBitmaps);
#endif

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "useMsgw", use_msgw ? "on" : "off",
		 "Display the last message in the warning message window.");
#endif

  use_msgw = booleanDefault ("useMsgw", use_msgw);

#ifdef SHOW_DEFAULTS
  {
    char            ints[10];
    sprintf (ints, "%d", phas_msg);
    show_defaults ("display", "PhaserMsg", ints,
        "Phaser Window: 0 -- none, 1 -- review all, 2 -- review team, 3 = review indiv, 4 = review kill, 5 = total");
  }
#endif

  phas_msg = intDefault ("PhaserMsg", phas_msg);
  if (phas_msg > 5)
    phas_msg = 5;

#ifdef RECORD
  /* My attempt to control the recorder during the game */

#ifdef SHOW_DEFAULTS
  show_defaults ("misc", "recordGame", recordGame ? "on" : "off",
		 "Record game (probably doesn't work -- no playback.)");
#endif

  recordGame = booleanDefault ("recordGame", recordGame);
#endif

  /* Numeric defaults */

#ifdef SHOW_DEFAULTS
  {
    char            ints[10];
    sprintf (ints, "%d", showlocal);
    show_defaults ("display", "showLocal", ints,
	   "Local: 0 -- show owner, 1 -- show resoures, 2 -- show nothing");
  }
#endif

  showlocal = intDefault ("showLocal", showlocal);
  if (showlocal > 2)
    showlocal = 2;

#ifdef SHOW_DEFAULTS
  {
    char            ints[10];
    sprintf (ints, "%d", showgalactic);
    show_defaults ("display", "showGalactic", ints,
	"Galactic: 0 -- show owner, 1 -- show resoures, 2 -- show nothing");
  }
#endif

  showgalactic = intDefault ("showGalactic", showgalactic);
  if (showgalactic > 2)
    showgalactic = 2;

#ifdef SHOW_DEFAULTS
  {
    char            ints[10];
    sprintf (ints, "%d", 2592);
    show_defaults ("startup", "port", ints,
		   "Default port to use.");
  }
#endif

  xtrekPort = intDefault ("port", -1);

#ifdef SHOW_DEFAULTS
  {
    char            ints[10];
    sprintf (ints, "%d", showLock);
    show_defaults ("display", "showLock", ints,
		   "0 -- dont show lock, 1 -- show on galactic, \n\
2 -- show on local, 3 -- show on both.");
  }
#endif

  showLock = intDefault ("showLock", showLock);
  if (showlocal > 3)
    showlocal = 3;

#ifdef SHOW_DEFAULTS
  {
    char            ints[10];
    sprintf (ints, "%d", udpDebug);
    show_defaults ("UDP", "udpDebug", ints,
		   "Level of UDP code debugging.");
  }
#endif

  udpDebug = intDefault ("udpDebug", udpDebug);

#ifdef SHOW_DEFAULTS
  {
    char            ints[10];
    sprintf (ints, "%d", udpClientSend);
    show_defaults ("UDP", "udpClientSend", ints,
		   "0 -- TCP, 1 -- simple UDP, 2 -- enforced UDP (state only)\n\
3 -- enforce UDP (state & weapon)");
  }
#endif

  udpClientSend = intDefault ("udpClientSend", udpClientSend);

#ifdef SHOW_DEFAULTS
  {
    char            ints[10];
    sprintf (ints, "%d", udpClientRecv);
    show_defaults ("UDP", "udpClientRecv", ints,
		   "0 -- TCP, 1 -- simple UDP, 2 -- fat UDP");
  }
#endif

  udpClientRecv = intDefault ("udpClientReceive", udpClientRecv);

#ifdef NETSTAT

#ifdef SHOW_DEFAULTS
  {
    char            ints[10];
    sprintf (ints, "%d", netstatfreq);
    show_defaults ("misc", "netStatFreq", ints,
		   "Lag stats update: 1 -- least often, 10 -- most often.");
  }
#endif

  netstatfreq = intDefault ("netstatfreq", netstatfreq);
  if (netstatfreq <= 0)
    netstatfreq = 1;
#endif

#ifdef SHORT_PACKETS

#ifdef SHOW_DEFAULTS
  show_defaults ("short-packets", "tryShort", tryShort ? "on" : "off",
		 "Try short-packets (HW) upon entering.");
#endif

  tryShort = booleanDefault ("tryShort", tryShort);
#endif

#ifdef EM

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "sortPlayers", sortPlayers ? "on" : "off",
		 "Sort player listings by team.");
#endif

  sortPlayers = booleanDefault ("sortplayers", sortPlayers);
#endif

#ifdef PLIST

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "newPlist", newPlist ? "on" : "off",
		 "Reduced stats format for the player list.");
#endif

  newPlist = booleanDefault ("newPlist", newPlist);
#endif

#ifdef SHOW_DEFAULTS
  show_defaults ("misc", "newMesgFlags", new_messages ? "on" : "off",
		 "Server-dependent. Should be on for all new servers.");
#endif

  new_messages = booleanDefault ("newMesgFlags", new_messages);

#ifdef SHOW_DEFAULTS
  {
    char            ints[10];
    sprintf (ints, "%d", tclock);
    show_defaults ("display", "clock", ints,
		   "Stat clock: 0 -- no clock, 1 -- h:m, 2 -- h:m:s.");
  }
#endif

  tclock = intDefault ("clock", tclock);

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "shortKillMesg", abbr_kmesg ? "on" : "off",
		 "Shrink and line up all kill messages.");
#endif

  abbr_kmesg = booleanDefault ("shortKillMesg", abbr_kmesg);

  /*
   * updateSpeed = abs(intDefault("updatesPerSecond", 5) - 10);
   */

#ifdef SHOW_DEFAULTS
  {
    char            ints[10];
    sprintf (ints, "%d", 5);
    show_defaults ("startup", "updatesPerSecond", ints,
		 "Number of updates per second (most servers limit to 5).");
  }
#endif

  updateSpeed = intDefault ("updatesPerSecond", 5);

#ifdef RECORD
  /* Get the record filename and message log file from .xtrekrc */

#ifdef SHOW_DEFAULTS
  show_defaults ("misc", "recordFile", "record-file",
	   "Name of file to record game in (may not work -- no playback).");
#endif

  if (recordFileName == NULL)
  {
    recordFileName = getdefault ("recordFile");
    if (recordFileName != NULL)
    {
      recordFile = fopen (recordFileName, "wb");
      if (recordFile == NULL)
      {
	perror (recordFileName);
	exit (1);
      }
      recordGame = 1;		/* We want to record the game */
    }
    else
      recordGame = 0;
  }
#endif

#ifdef FEATURE
#ifdef BEEPLITE
  { 
    DefLite = booleanDefault ("DefLite", DefLite);
    UseLite = booleanDefault ("UseLite", UseLite);
 
    if (DefLite)
      litedefaults();

    beep_lite_cycle_time_planet = intDefault ("planetCycleTime",
					    beep_lite_cycle_time_planet);
    beep_lite_cycle_time_player = intDefault ("playerCycleTime",
					    beep_lite_cycle_time_player);
  }
#endif /* BEEPLITE */
 
  {
    char           *macrokey_s = getdefault ("macroKey");

#ifdef SHOW_DEFAULTS
    show_defaults ("input", "macroKey", "x",
		"Name of key to use for macro escape (TAB,ESC, or <key>).");
#endif

    if (macrokey_s)
    {
      if (strcmp (macrokey_s, "TAB") == 0)
	macrokey = 9;
      else if (strcmp (macrokey_s, "ESC") == 0)
	macrokey = 27;
      else
	macrokey = (int) macrokey_s[0];
    }
  }
#endif

#ifdef DASHBOARD

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "dashboard", dashboard ? "on" : "off",
		 "Use a dashboard (LAB) style for the stats line.");
#endif

  dashboard = booleanDefault ("dashboard", dashboard);
#endif

#ifdef NEW_DASHBOARD_2

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "newdashboard2", cup_half_full ? "on" : "off",
		 "Use a dashboard (KRP + LAB) style for the stats line.");
#endif

  cup_half_full = booleanDefault ("newdashboard2", cup_half_full);
  if (cup_half_full)
    dashboard = cup_half_full;
#endif

#ifdef MOTION_MOUSE

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "continuousMouse", motion_mouse ? "on" : "off",
		 "Use continuous mouse tracking.");
#endif

  motion_mouse = booleanDefault ("continuousMouse", motion_mouse);

  user_motion_thresh = intDefault ("motionThresh", user_motion_thresh);
#endif

#ifdef SHIFTED_MOUSE

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "shiftedMouse", extended_mouse ? "on" : "off",
		 "Use shifted mouse for more mouse buttons.");
#endif

  extended_mouse = booleanDefault ("shiftedMouse", extended_mouse);
#endif

#ifdef TNG_FED_BITMAPS

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "useTNGBitmaps", use_tng_fed_bitmaps ? "on" : "off",
		 "Use next generation style bitmaps.");
#endif

  use_tng_fed_bitmaps = booleanDefault ("useTNGBitmaps", use_tng_fed_bitmaps);
#endif

#ifdef VARY_HULL

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "warnHull", vary_hull ? "on" : "off",
		 "Warn hull state according to damage.");
#endif

  vary_hull = booleanDefault ("warnHull", vary_hull);
#endif

#ifdef REFRESH_INTERVAL
  refresh_interval = intDefault ("refreshInterval", refresh_interval);

  if (refresh_interval <= 20)
  {
    printf ("refreshInterval must be greater than 19 seconds.\n");
    refresh_interval = 0;
  }
  else
    refresh_interval *= updatespeed;
#endif

#ifdef KEEP_INFO

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "keepInfo", sprintf (buf, "%d", keepInfo),
		 "Number of updates to keep info windows.");
#endif

  keepInfo = intDefault ("keepInfo", keepInfo);
#endif

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "showPlayerStatus", plshowstatus ? "on" : "off",
		 "Player list: also show players not alive.");
#endif

  plshowstatus = booleanDefault ("showPlayerStatus", plshowstatus);

#ifdef SHOW_IND

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "showIND", showIND ? "on" : "off",
		 "Show independant planet with X trough it.");
#endif

  showIND = booleanDefault ("showIND", showIND);
#endif

#ifdef CLOAK_CHARS

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "cloakChars", cloakChars ? "on" : "off",
		 "Chars to draw cloakers with on map.");
#endif

  pek = getdefault ("cloakChars");
  if (pek != (char *) NULL)
    strncpy (cloakChars, pek, 2);
#endif

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "enemyPhasers", sprintf (buf, "%d", enemyPhasers),
		 "Width to draw enemy phasers.");
#endif

  enemyPhasers = intDefault ("enemyPhasers", enemyPhasers);

#ifdef ROMVLVS_BITMAPS

#ifdef SHOW_DEFAULTS
  show_defaults ("display", "ROMVLVS", ROMVLVS ? "on" : "off",
		 "Use alternate romulan cruiser bitmap.");
#endif

  ROMVLVS = booleanDefault ("ROMVLVS", ROMVLVS);
#endif

  sendOptionsPacket ();

#ifdef PLIST
  if (newPlist)
  {
    playerlistnum ();
    playerlist ();
  }
#endif

#ifdef USE_TR_PORTS
  useTRPorts = booleanDefault ("useTRPorts", useTRPorts);
  
  if (useTRPorts)
    printf ("Using Trace Route ports for UDP connection.\n");
#endif

#ifdef MAP_NAMES
  draw_map_names = booleanDefault ("showMapPlanetNames", draw_map_names);
  show_owner_map = booleanDefault ("showOwnerOnMap", show_owner_map);
#endif

#ifdef SHOW_MY_SPEED
  showMySpeed = booleanDefault ("showMySpeed", showMySpeed);
#endif

#ifdef JUBILEE_PHASERS
  jubilee_phasers = booleanDefault ("colorfulPhasers", jubilee_phasers);
#endif
  
#ifdef SHOW_FUEL_ON_LOCAL
  show_fuel_on_local = booleanDefault ("showFuelOnLocal",
				       show_fuel_on_local);
#endif
  
/* Added 3/15/94 SRS - When enter game, send request for full update */
  askforUpdate = booleanDefault ("askforUpdate", askforUpdate);

  printf ("Done reading default values ...\n");
}

/* totally re-do the defaults! */
extern int init_macros;

ReReadDefaults ()
{

  extern char    *defaultsFile;
  extern char    *cow_literc_file;
  char            buf [256];

  FreeDefaults ();
  init_macros = 1;
  
  if (defaultsFile)
    warning (sprintf (buf, "Reading defaults from file %s", defaultsFile));

#ifdef MAKE_XTREKRC
  if (cow_literc_override)
  {
    initDefaults (defaultsFile);
    initDefaults (cow_literc_file);
  }
  else
  {
    initDefaults (cow_literc_file);
    initDefaults (defaultsFile);
  }
#else
  initDefaults (defaultsFile);
#endif

  readDefaults ();
}

#endif				/* MOO */


#ifdef LOGMESG
/* log the message sent here into a file */
LogMessage (message)
  char           *message;
{

  if (!logMess)
    return;

  if (logFile == NULL)
  {
    /*
     * need to open the logfile! if (logFileName == NULL) logFileName =
     * getdefault("logFile");
     * 
    /* If we don't get it from rc file, we use the default filename. Note we
     * won't log the messages unless logMess==1 (can be toggled via keyboard)
     * <isae>
     */

    if (logFileName == NULL)
      logFileName = DEFAULT_RECORDFILE;
    logFile = fopen (logFileName, "w+");
    if (logFile == NULL)
    {
      fprintf (stderr, "Can't open message logfile!\n");
      perror (logFileName);
      fprintf (stderr, "no messages logging being done!\n");
      return;
    }
  }
  fprintf (logFile, "%s\n", message);
}

#endif
