/*
 * findslot.c
 * 
 * Kevin Smith 03/23/88
 * 
 */
#include "copyright2.h"

#include <stdio.h>
#include <sys/types.h>
#include <errno.h>
#include <pwd.h>
#include <string.h>
#include <ctype.h>
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"

#ifdef EM
#define WAITMOTD
#endif

#define WAITWIDTH 180
#define WAITHEIGHT 60
#define WAITTITLE 15		/* height of title for wait window */

findslot()
{
   int             oldcount = -1;
   W_Window        waitWin, qwin, countWin;
#ifdef WAITMOTD
   W_Window        MotdWin;
   extern int      MaxMotdLine;
   int             WaitMotdLine = 0;
#endif
   W_Event         event;

   /* Wait for some kind of indication about in/not in */
   while (queuePos == -1) {
      socketPause();
      if (isServerDead()) {
	 printf("Augh!  Ghostbusted!\n");
	 exit(0);
      }
      readFromServer(NULL);
      if (me != NULL) {
	 /* We are in! */
	 return (me->p_no);
      }
   }

   /* We have to wait.  Make appropriate windows, etc... */
   waitWin = W_MakeWindow("wait", 0, 0, WAITWIDTH, WAITHEIGHT, NULL, 2, foreColor);

   countWin = W_MakeWindow("count", WAITWIDTH / 2, WAITTITLE, WAITWIDTH / 2,
			   WAITHEIGHT - WAITTITLE, waitWin, 1, foreColor);
   qwin = W_MakeWindow("waitquit", 0, WAITTITLE, WAITWIDTH / 2, WAITHEIGHT - WAITTITLE,
		       waitWin, 1, foreColor);
#ifdef WAITMOTD
   MotdWin = W_MakeWindow("Wait and Read the Motd", 0, WAITWIDTH + 1, 500, 500, 0, 2, foreColor);

#ifdef MOO
   if(showMotdOnQ)
      W_MapWindow(MotdWin);
#else
   if(showMotdOnQ)
      W_MapWindow(MotdWin);
#endif
   showMotd(MotdWin, WaitMotdLine);
#endif
   W_MapWindow(waitWin);
   W_MapWindow(countWin);
   W_MapWindow(qwin);
   W_Flush();
   for (;;) {
      socketPause();
      readFromServer(NULL);
      if (isServerDead()) {
	 printf("We've been ghostbusted!\n");
	 exit(0);
      }
      while (W_EventsPending()) {
	 W_NextEvent(&event);
	 switch ((int) event.type) {
	 case W_EV_BUTTON:
	 case W_EV_KEY:
#ifdef WAITMOTD
	    if (event.Window == MotdWin) {
	       if (event.key == 'b') {
		  WaitMotdLine -= 28;
		  WaitMotdLine = MAX(WaitMotdLine, 0);
	       } else if (event.key == 'S') {
		  SaveMotd();
	       } else {
		  WaitMotdLine += 28;
		  /* scroll to start if it goes over */
		  if (WaitMotdLine > MaxMotdLine)
		     WaitMotdLine = 0;
	       }
	       W_ClearWindow(MotdWin);
	       showMotd(MotdWin, WaitMotdLine);
	       break;
	    }
#endif
	    if (event.Window == qwin) {
	       printf("OK, bye!\n");
	       exit(0);
	    }
	    break;
	 case W_EV_EXPOSE:
	    if (event.Window == waitWin) {
	       mapWaitWin(waitWin);
#ifdef WAITMOTD
	    } else if (event.Window == MotdWin) {
	       showMotd(MotdWin, WaitMotdLine);
#endif
	    } else if (event.Window == qwin) {
	       mapWaitQuit(qwin);
	    } else if (event.Window == countWin) {
	       mapWaitCount(countWin, queuePos);
	    }
	    break;
	 default:
	    break;
	 }
      }
      if (queuePos != oldcount) {
	 mapWaitCount(countWin, queuePos);
	 oldcount = queuePos;
      }
      if (me != NULL) {
	 W_DestroyWindow(waitWin);
#ifdef WAITMOTD
	 W_DestroyWindow(MotdWin);
#endif
#ifdef MOO
	 W_Beep();
	 W_Beep();
	 W_Beep();
#endif
	 return (me->p_no);
      }
   }
}

mapWaitWin(waitWin)
    W_Window        waitWin;
{
   char           *s = "Xtrek:  Game is full.";

   W_WriteText(waitWin, 15, 5, textColor, s, strlen(s), W_RegularFont);
}

mapWaitQuit(qwin)
    W_Window        qwin;
{
   char           *s = "Quit";

   W_WriteText(qwin, 10, 15, textColor, s, strlen(s), W_RegularFont);
}

mapWaitCount(countWin, count)
    W_Window        countWin;
    unsigned int    count;
{
   char           *s = "Wait Queue";
   char            buf[10];

   W_WriteText(countWin, 5, 10, textColor, s, strlen(s), W_RegularFont);
   sprintf(buf, "%d    ", count);
   if (count == -1)
      strcpy(buf, "?");
   W_WriteText(countWin, 5, 25, textColor, buf, strlen(buf), W_RegularFont);
}
