#ifdef FEATURE
#include "copyright.h"

#include <stdio.h>
#include <math.h>
#if defined (_IBMR2) || defined(SYSV)
#include <time.h>
#endif				/* _IBMR2 */
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"
#include <sys/time.h>
#include "prog_version.h"

#define TESTCAP(c,s)    (c ? strcap(s) : s)

struct int_range {
   int             min_value;	/* value is >= this */
   int             max_value;	/* value is <= this */
   int             increment;	/* a click raises/lowers this amount */
};
extern struct int_range motion_mouse_range;
extern struct int_range multiline_macro_range;

static int                      version_sent = 0;
CheckFeatures(m)
   char                           *m;
{
  char buf[BUFSIZ];
  char *pek = &m[10];
  int features;
 
  if (strlen (m) < 11)
    return;

  while ((*pek == ' ') && (*pek != '\0'))
    pek++;

  strcpy(buf, "COW-lite:  ");

  if (strstr (pek, "NO_NEWMACRO"))
    {
      F_UseNewMacro = 0;
      features++;
      strcat (buf, pek);
    }
 
  if (strstr (pek, "NO_SMARTMACRO"))
    {
      F_UseSmartMacro = 0;
      features++;
      strcat (buf, pek);
    }

  if (strstr (pek, "WHY_DEAD"))
    {
      F_why_dead = 1;
      strcat (buf, pek);
      features++;
    }
 
  if (strstr (pek, "RC_DISTRESS"))
    {
      F_gen_distress = 1;
      distmacro = dist_prefered;
      strcat (buf, "RC_DISTRESS");
      features++;
    }

#ifdef MOTION_MOUSE
  if (strstr (pek, "NO_CONTINUOUS_MOUSE"))
  {
    motion_mouse_enablable = 0;
    features++;
    strcat (buf, pek);
  }

  if (strstr (pek, "STRICT_NO_CONTINUOUS_MOUSE"))
  {
    motion_mouse_enablable = 0;
    steering_mouse = 0;
    motion_mouse_range.increment = 0;
    features++;
    strcat (buf, pek);
  }
#endif

#ifdef MULTILINE_MACROS
  if (strstr (pek, "MULTIMACROS"))
  {
    multiline_macro_range.increment = 1;
    multiline_enabled = 1;
    features++;
    strcat (buf, pek);
  }
#endif
  
#ifdef SBHOURS
  if (strstr (pek, "SBHOURS"))
  {
    SBhours = 1;
    features++;
    strcat (buf, pek);
  }  
#endif
  
   if(!features)
     return;
  
   buf[strlen(buf)] = 0;

   W_WriteText(reviewWin, 0, 0, W_White, buf, strlen(buf), 0);
   W_WriteText(messwa, 0, 0, W_White, buf, strlen(buf), 0);
}

sendVersion()
{
  char                            client_ver[15];
  
  if (!version_sent)
  {
    version_sent = 1;
    sprintf(client_ver, "@%s.%d", VERSION, PATCHLEVEL);

    sendMessage(client_ver, MINDIV|MCONFIG, me->p_no);
  }
}


doMacro(key, data)

   int          key;
   W_Event	*data;
{
   int   	found = 0;
   register	c;
   struct obtype *gettarget(), *target = NULL;
   char		who;
   int		targettype;
   int		i;

   if (key == '?') {
      showMacroWin();
      macro_off();
      return(0);
   } else {
      if (F_UseNewMacro) {
/* sorry guys, I only program in kludge - jn 6/3/93 */
	 if (MacroNum > -1) {	/* macro identified, who to? */
	    if (MacroNum >= MAX_MACRO)
	       fprintf(stderr, "Unknown macro number %d.\n", MacroNum);
	    if (!pmacro(MacroNum, key, data))
	       W_Beep();

	    macro_off();
	    return (0);
	 }
      }
      for (c = 0; c < macrocnt && !found; c++) {
	 if (macro[c].key == key) {
	    found = 1;
	    if (F_UseNewMacro) {
	       switch (macro[c].type) {
	       case NBTM:
		  pnbtmacro(c);
		  break;
	       case NEWM:
		  MacroNum = c;
		  return (0);
		  break;
	       case NEWMMOUSE:
                    /* first translate into who, then send */
		  switch (macro[c].who) {

		     struct player *j;
		     struct planet* l;

		     case MACRO_FRIEND:
		     case MACRO_ENEMY:
                     case MACRO_PLAYER:
			targettype = TARG_PLAYER;
                        if (macro[c].who == MACRO_ENEMY)
			   targettype |= TARG_ENEMY;
                        else if (macro[c].who == MACRO_FRIEND)
			   targettype |= TARG_FRIEND;

			target = gettarget(data->Window, data->x, data->y,
                        		   TARG_PLAYER|TARG_CLOAK);
                        if (target->o_type == PLAYERTYPE) {
			   j = &players[target->o_num];
			   if(j->p_flags & PFCLOAK) maskrecip = 1;
			   who = j->p_mapchars[1];
                        }
                        else {
			   who = me->p_mapchars[1];
			   warning("Can only send a message to a player");
                        }
                        break;
		     case MACRO_TEAM:
			target = gettarget(data->Window, data->x, data->y,
                        		   TARG_PLAYER|TARG_PLANET);
                        if (target->o_type == PLANETTYPE) {
			   l = &planets[target->o_num];
			   who = teamlet[l->pl_owner];
                        }
                        else if (target->o_type == PLAYERTYPE) {
			   j = &players[target->o_num];
			   who = j->p_mapchars[0];
                        }
                        else {
			   who = me->p_mapchars[1];
			   warning("Player or planet only please");
                        }
                        break;
		     default:
                         who = me->p_mapchars[1];
                         break;
		  }
		  if (!pmacro(c,who,data))
		     W_Beep();
		  break;

	       case NEWMULTIM:
		  found = 0;
		  if (!pmacro(c, macro[c].who, data))
		    {
		      W_Beep();
		    }
		  continue;
		  break;

	       case NEWMSPEC:
		  if (!pmacro(c, macro[c].who, data))
		    {
		      W_Beep();
		    }
		  break;

	       default:
		  fprintf(stderr, "Unknown macro type %d.\n", macro[c].type);
		  break;
	       }
	    } else {
	       pnbtmacro(c);
	    }
            macro_off ();
	    return(1);
	 }
      }

   }

/* scan for distress call here */
 
#ifdef DIST_KEY_NAME
      for (i = take; distmacro[i].name; i++)
        {
          if (distmacro[i].c == data->key)
            {
              rcd (i, data);

              macro_off ();
              return (1);
	      
            }
        }
#endif
   
   if (!found) 
     {
       W_Beep();
     }

   macro_off();
   return (0);

}

macro_off()
{
  warning (" ");                /* clear warning message */
  MacroMode = 0;
  MacroNum = -1;
}


/* Used in NEWMACRO, useful elsewhere also */
int 
getgroup(addr, recip)
   char                            addr;
   int                            *recip;
{
   *recip = 0;

   switch (addr) {
   case 'A':
      *recip = 0;
      return (MALL);
      break;
   case 'F':
      *recip = FED;
      return (MTEAM);
      break;
   case 'R':
      *recip = ROM;
      return (MTEAM);
      break;
   case 'K':
      *recip = KLI;
      return (MTEAM);
      break;
   case 'O':
      *recip = ORI;
      return (MTEAM);
      break;
   case 'G':
      *recip = 0;
      return (MGOD);
      break;
   case '0':
   case '1':
   case '2':
   case '3':
   case '4':
   case '5':
   case '6':
   case '7':
   case '8':
   case '9':
      if (players[addr - '0'].p_status == PFREE) {
	 warning("That player left the game. message not sent.");
	 return 0;
      }
      *recip = addr - '0';
      return (MINDIV);
      break;
   case 'a':
   case 'b':
   case 'c':
   case 'd':
   case 'e':
   case 'f':
   case 'g':
   case 'h':
   case 'i':
   case 'j':
   case 'k':
   case 'l':
   case 'm':
   case 'n':
   case 'o':
   case 'p':
   case 'q':
   case 'r':
   case 's':
   case 't':
   case 'u':
   case 'v':
   case 'w':
   case 'x':
   case 'y':
   case 'z':
      if (players[addr - 'a' + 10].p_status == PFREE) {
	 warning("That player left the game. message not sent.");
	 return 0;
      }
      *recip = addr - 'a' + 10;
      return (MINDIV);
      break;
   default:
      warning("Not legal recipient");
   }
   return 0;
}


pnbtmacro(c)
   int                             c;
{
   switch (macro[c].who) {
   case 'A':
      pmessage(macro[c].string, 0, MALL);
      break;
   case 'F':
      pmessage(macro[c].string, FED, MTEAM);
      break;
   case 'R':
      pmessage(macro[c].string, ROM, MTEAM);
      break;
   case 'K':
      pmessage(macro[c].string, KLI, MTEAM);
      break;
   case 'O':
      pmessage(macro[c].string, ORI, MTEAM);
      break;
   case 'T':
      pmessage(macro[c].string, me->p_team, MTEAM);
      break;
   }
}

#endif

