#ifdef XTREKRC_HELP
/*
 * taken from helpwin.c (copyright 1991 ERic mehlhaff Free to use, hack, etc.
 * Just keep these credits here. Use of this code may be dangerous to your
 * health and/or system. Its use is at your own risk. I assume no
 * responsibility for damages, real, potential, or imagined, resulting  from
 * the use of it.)
 * 
 * $Log:$
 */

#include <stdio.h>
#include "math.h"
#include <signal.h>
#include <sys/types.h>

#ifdef hpux
#include <time.h>
#else				/* hpux */
#include <sys/time.h>
#endif				/* hpux */

#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"
#include <strings.h>

/* this is the number of help messages there are */

#define INT_DEF		0
#define BOOL_DEF	1
#define STR_DEF		2
#define SINT_DEF	3

#define NAME_WIDTH	18
#define VAL_WIDTH	8
#define INDENT		3
#define MAX_VLINES	42

extern int      updateSpeed;

#ifdef RECORD
extern char    *recordFileName;
#endif

#define DEFMESSAGES	(sizeof(def_messages)/ sizeof(struct def))

#ifdef CONTROL_KEY
char           *ckeymap = NULL;
#endif

#ifdef CLOAK_CHARS
char           *cloak_chars = NULL;
#endif

char           *name = NULL, *bmap = NULL, *keymap = NULL, *pl_list = NULL;

/* sure its a mess, but it gets the job done */

static
struct def
{
  char           *name;
  int             type;
  char           *desc;
  int            *variable;

  struct
  {
    int             i_value;	/* if int or bool */
    char           *s_value;	/* if str */
    char           *desc;
  }               values[10];
}               def_messages[] =

{
  {
    "extraAlertBorder", BOOL_DEF, "Show alert on local border",
    &extraBorder,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },
  {
    "keepPeace", BOOL_DEF, "Stay peaceful when reborn",
    &keeppeace,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },

#ifdef KEEP_INFO
  {
    "keepInfo", SINT_DEF, "No. of updates to keep info windows",
    &keepInfo,
    {
      {
	0, NULL, NULL
      },
    },
  },
#endif

  {
    "netStatFreq", SINT_DEF, "Frequency of updates to calc lag",
    &netstatfreq,
    {
      {
	0, NULL, NULL
      },
    },
  },
  {
    "enemyPhasers", SINT_DEF, "Width of enemy phasers",
    &enemyPhasers,
    {
      {
	0, NULL, NULL
      },
    },
  },
  {
    "netStats", BOOL_DEF, "Lag stats and lag meter display",
    &netstat,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },

#ifdef VARY_HULL
  {
    "warnHull", BOOL_DEF, "Warn hull state based on damage",
    &vary_hull,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },
#endif

#ifdef VSHIELD_BITMAPS
  {
    "varyShields", BOOL_DEF, "Vary shields base on damage",
    &VShieldBitmaps,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },
#else
  {
    "warnShields", BOOL_DEF, "Warn shields based on damage",
    &warnShields,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },
#endif

#ifdef ZZ_BITMAPS
  {
    "newPlanetBitmaps", INT_DEF, "MOO planet bitmaps",
    &myPlanetBitmap,
    {
      {
	0, NULL, "Use normal bitmaps"
      },
      {
	1, NULL, "Use rabbit ear bitmaps"
      },
      {
	2, NULL, "Use ZZ minimal bitmaps"
      },
      {
	0, NULL, NULL
      },
    },
  },
#else
  {
    "newPlanetBitmaps", BOOL_DEF, "MOO planet bitmaps",
    &myPlanetBitmap,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },
#endif

  {
    "reportKills", BOOL_DEF, "Report kill messages",
    &reportKills,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },
  {
    "showGalactic", INT_DEF, "Galactic planet bitmaps",
    &showgalactic,
    {
      {
	0, NULL, "show owner on galactic map"
      },
      {
	1, NULL, "show resources on galactic map"
      },
      {
	2, NULL, "show nothing on galactic map"
      },
      {
	0, NULL, NULL
      },
    },
  },
  {
    "showLocal", INT_DEF, "Local planet bitmaps",
    &showlocal,
    {
      {
	0, NULL, "show owner on local map"
      },
      {
	1, NULL, "show resources on local map"
      },
      {
	2, NULL, "show nothing on local map"
      },
      {
	0, NULL, NULL
      },
    },
  },
  {
    "showLock", INT_DEF, "Lock display for planets/players",
    &showLock,
    {
      {
	0, NULL, "don't show lock"
      },
      {
	1, NULL, "show lock on galactic only"
      },
      {
	2, NULL, "show lock on tactical only"
      },
      {
	3, NULL, "show lock on both"
      },
      {
	0, NULL, NULL
      },
    }
  },
  {
    "name", STR_DEF, "Default player name",
    (int *) &(name),
    {
      {
	0, NULL, NULL
      },
    },
  },
  {
    "keymap", STR_DEF, "Keyboard map",
    (int *) &(keymap),
    {
      {
	0, NULL, NULL
      },
    },
  },

#ifdef CONTROL_KEY
  {
    "ckeymap", STR_DEF, "Control keyboard map",
    (int *) &(ckeymap),
    {
      {
	0, NULL, NULL
      },
    },
  },
#endif

  {
    "buttonmap", STR_DEF, "Mouse button map",
    (int *) &(bmap),
    {
      {
	0, NULL, NULL
      },
    },
  },

#ifdef CLOAK_CHARS
  {
    "cloakChars", STR_DEF, "Cloak chars for map",
    (int *) &(cloak_chars),
    {
      {
	0, NULL, NULL
      },
    },
  },
#endif

  {
    "newPlist", BOOL_DEF, "Show new player list",
    &newPlist,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },
  {
    "sortPlayers", BOOL_DEF, "Sort players by team",
    &sortPlayers,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },

#ifdef PLIST
  {
    "playerlist", STR_DEF, "What to show on player list",
    (int *) &(pl_list),
    {
      {
	0, NULL, NULL
      },
    },
  },
#endif

  {
    "showPlanetNames", BOOL_DEF, "Show names on map/local",
    &namemode,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },
  {
    "showTractorPressor", BOOL_DEF, "Show my tract/press",
    &showTractorPressor,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },
  /*
   * { "continuetractor", BOOL_DEF, "Keep showing tract/press",
   * &continuetractor, { { 0, NULL, "" }, { 0, NULL, NULL }, }, },
   */

#ifdef SHORT_PACKETS
  {
    "tryShort", BOOL_DEF, "Try SHORT-PACKETS at startup",
    &tryShort,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },
#endif

  {
    "tryUdp", BOOL_DEF, "Try UDP automatically",
    &tryUdp,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },
  {
    "udpClientReceive", INT_DEF, "UDP receive mode",
    &udpClientRecv,
    {
      {
	0, NULL, "TCP only"
      },
      {
	1, NULL, "simple UDP"
      },
      {
	2, NULL, "fat UDP"
      },
      {
	3, NULL, "double UDP (obsolete)"
      },
      {
	0, NULL, NULL
      },
    },
  },
  {
    "udpClientSend", INT_DEF, "UDP send mode",
    &udpClientSend,
    {
      {
	0, NULL, "TCP only"
      },
      {
	1, NULL, "simple UDP"
      },
      {
	2, NULL, "enforced UDP (state only)"
      },
      {
	3, NULL, "enforced UDP (state & weapon)"
      },
      {
	0, NULL, NULL
      },
    },
  },
  {
    "udpSequenceCheck", BOOL_DEF, "UDP sequence checking",
    &udpSequenceChk,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },

#ifdef RSA
  {
    "useRSA", BOOL_DEF, "Use RSA checking",
    &RSA_Client,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },
#endif

  {
    "newdashboard", BOOL_DEF, "Use new dashboard",
    &dashboard,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },

#ifdef NEW_DASHBOARD_2
  {
    "newdashboard2", BOOL_DEF, "Use new new dashboard",
    &cup_half_full,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },
#endif
#ifdef BEEPLITE
  {
    "lite", BOOL_DEF, "Use message highliting",
    &UseLite,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },
  {
    "DefLite", BOOL_DEF, "Use default lites",
    &DefLite,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },
#endif

  /*
   * { "newDistress", BOOL_DEF, "Use new distress call", &UseNewDistress, { {
   * 0, NULL, "" }, { 0, NULL, NULL }, }, },
   */
  /*
   * { "rejectMacro", BOOL_DEF, "Reject macros", &rejectMacro, { { 0, NULL,
   * "" }, { 0, NULL, NULL }, }, },
   */

#ifdef SHOW_IND
  {
    "showIND", BOOL_DEF, "Show independant planets w/X",
    &showIND,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },
#endif

#ifdef IGNORE_SIGNALS_SEGV_BUS
  {
    "ignoreSignals", BOOL_DEF, "Ignore SIGSEGV and SIGBUS",
    &ignore_signals,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },
#endif

#ifdef MOTION_MOUSE
  {
    "continuousMouse", BOOL_DEF, "Continuous mouse input",
    &motion_mouse,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },
  {
    "motionThresh", SINT_DEF, "Threshold for above",
    &user_motion_thresh,
    {
      {
	0, NULL, NULL
      },
    },
  },
#endif

#ifdef SHIFTED_MOUSE
  {
    "shiftedMouse", BOOL_DEF, "More mouse buttons with shift",
    &extended_mouse,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },
#endif

#ifdef TNG_FED_BITMAPS
  {
    "useTNGBitmaps", BOOL_DEF, "Use next generation bitmaps",
    &use_tng_fed_bitmaps,
    {
      {
	0, NULL, ""
      },
      {
	0, NULL, NULL
      },
    },
  },
#endif
};

char           *itos (v)
  int             v;
{
  static char     value[10];
  sprintf (value, "%d", v);
  return value;
}

char           *btoa (v)
  int             v;
{
  if (v)
    return "on";
  else
    return "off";
}

void            showdef ()
{
  register        i, j, x = 0, y = 0, xo = 0, yo = 0, max_desc = 0, height = 1, width = 1;
  register struct def *d;
  char           *val;

  name = getdefault ("name");
  keymap = getdefault ("keymap");

  /*
   * Handle leading ^G generated by make_xtrekrc () routine.
   */
  if (keymap && keymap[0] == 7 && keymap[1] == 7)
    keymap = &(keymap[2]);

#ifdef CONTROL_KEY
  ckeymap = getdefault ("ckeymap");

  /*
   * Handle leading ^G generated by make_xtrekrc () routine.
   */
  if (ckeymap && ckeymap[0] == 7 && ckeymap[1] == 7)
    ckeymap = &(ckeymap[2]);
#endif

#ifdef PLIST
  pl_list = getdefault ("playerlist");
#endif

#ifdef CLOAK_CHARS
  cloak_chars = cloakChars;
#endif

  bmap = getdefault ("buttonmap");

  if (!defWin)
    defWin = W_MakeTextWindow ("xtrekrc_help", 1, 100, 174, 41, NULL, BORDER);

  for (i = 0, d = def_messages; i < DEFMESSAGES; i++, d++)
  {
    x = xo;
    y = yo;

    W_WriteText (defWin, x, y, W_Yellow, d->name, strlen (d->name),
		 W_BoldFont);
    x += NAME_WIDTH;

    W_WriteText (defWin, x, y, textColor, d->desc, strlen (d->desc),
		 W_RegularFont);
    if (strlen (d->desc) > max_desc)
    {
      max_desc = strlen (d->desc);
      width = MAX (width, x + max_desc);
    }
    y++;
    x = xo + INDENT;

    if (d->type != STR_DEF)
    {
      if (!d->values[0].desc && d->variable)
      {
	if (d->type == SINT_DEF)
	  val = itos (*d->variable);
	else
	  val = itos (d->values[0].i_value);

	W_WriteText (defWin, x, y, W_Green, val, strlen (val),
		     W_RegularFont);
	y++;
      }
      for (j = 0; d->values[j].desc; j++)
      {
	switch (d->type)
	{
	  case INT_DEF:
	    val = itos (d->values[j].i_value);
	    if (d->values[j].i_value == *d->variable)
	    {
	      W_WriteText (defWin, x, y, W_Green, val, strlen (val),
			   W_BoldFont);
	      if (W_Mono ())
	      {
		W_WriteText (defWin, x + 1, y, W_Green, "*", 1,
			     W_RegularFont);
	      }
	    }
	    else
	      W_WriteText (defWin, x, y, textColor, val, strlen (val),
			   W_RegularFont);
	    x = xo + NAME_WIDTH;
	    W_WriteText (defWin, x, y, textColor, d->values[j].desc,
			 strlen (d->values[j].desc), W_RegularFont);
	    y++;
	    x = xo + INDENT;
	    break;

	  case BOOL_DEF:
	    val = btoa (*d->variable);
	    W_WriteText (defWin, x, y, W_Green, val, strlen (val),
			 W_RegularFont);
	    y++;
	    x = xo + INDENT;
	    break;
	  default:
	    fprintf (stderr, "Unknown type.\n");
	    break;
	}
      }
    }
    else if (d->variable && *d->variable)
    {
      W_WriteText (defWin, x, y, W_Green, (char *) *d->variable,
		   strlen ((char *) (*d->variable)),
		   W_RegularFont);
      y++;
    }

    height = MAX (height, y);
    if (y > MAX_VLINES)
    {
      yo = 0;
      xo += NAME_WIDTH + max_desc + 2;
      max_desc = 0;
    }
    else
    {
      yo = y + 1;
    }
  }

  if (!W_IsMapped (defWin))
  {
    W_ResizeTextWindow (defWin, width, height);
    W_MapWindow (defWin);
  }
}

#endif
