/*
 * death.c
 */
#include "copyright.h"

#include <stdio.h>
#include <signal.h>
#include <setjmp.h>
#include <sys/types.h>
#ifdef hpux
#include <time.h>
#else	/* hpux */
#include <sys/time.h>
#endif				/* hpux */
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"

extern jmp_buf  env;

static struct itimerval udt;
static char    *teamstring[9] =
{"", "and the Federation",
 "and the Romulan Empire", "",
 "and the Klingon Empire", "", "", "",
 "and the Orions"};

death()
{
   char            buf[80];
   W_Event         event;
   W_Window        oldw;
   oldw = w;
   w = mapw;

#ifdef XSIG
   xsig_off();
#endif

   W_ClearWindow(w);
   W_ClearWindow(iconWin);
   if (oldalert != PFGREEN) {
      if (extraBorder)
	 W_ChangeBorder(oldw, gColor);
      W_ChangeBorder(baseWin, gColor);
      oldalert = PFGREEN;
   }
   if (W_IsMapped(statwin)) {
      W_UnmapWindow(statwin);
      showStats = 1;
   } else {
      showStats = 0;
   }
   if (infomapped)
      destroyInfo();
   W_UnmapWindow(planetw);
   W_UnmapWindow(rankw);
   W_UnmapWindow(war);
   if (optionWin)
      optiondone();

   switch (me->p_whydead) {
   case KQUIT:
      sprintf(buf, "You have self-destructed.");
      W_WriteText(w, 50, 80, textColor, buf, strlen(buf), W_RegularFont);
      break;
   case KTORP:
      sprintf(buf, "You were killed by a photon torpedo from %s (%c%c).",
	      players[me->p_whodead].p_name,
	      teamlet[players[me->p_whodead].p_team],
	      shipnos[me->p_whodead]);
      W_WriteText(w, 50, 80, textColor, buf, strlen(buf), W_RegularFont);
      break;
   case KPLASMA:
      sprintf(buf, "You were killed by a plasma torpedo from %s (%c%c)",
	      players[me->p_whodead].p_name,
	      teamlet[players[me->p_whodead].p_team],
	      shipnos[me->p_whodead]);
      W_WriteText(w, 50, 80, textColor, buf, strlen(buf), W_RegularFont);
      break;
   case KPHASER:
      sprintf(buf, "You were killed by a phaser shot from %s (%c%c)",
	      players[me->p_whodead].p_name,
	      teamlet[players[me->p_whodead].p_team],
	      shipnos[me->p_whodead]);
      W_WriteText(w, 50, 80, textColor, buf, strlen(buf), W_RegularFont);
      break;
   case KPLANET:
      sprintf(buf, "You were killed by planetary fire from %s (%c)",
	      planets[me->p_whodead].pl_name,
	      teamlet[planets[me->p_whodead].pl_owner]);
      W_WriteText(w, 50, 80, textColor, buf, strlen(buf), W_RegularFont);
      break;
   case KSHIP:
      sprintf(buf, "You were killed by an exploding ship formerly owned by %s (%c%c)",
	      players[me->p_whodead].p_name,
	      teamlet[players[me->p_whodead].p_team],
	      shipnos[me->p_whodead]);
      W_WriteText(w, 50, 80, textColor, buf, strlen(buf), W_RegularFont);
      break;
   case KDAEMON:
      sprintf(buf, "You were killed by a dying daemon.");
      W_WriteText(w, 50, 80, textColor, buf, strlen(buf), W_RegularFont);
      break;
   case KWINNER:
      sprintf(buf, "Galaxy has been conquered by %s (%c%c) %s",
	      players[me->p_whodead].p_name,
	      teamlet[players[me->p_whodead].p_team],
	      shipnos[players[me->p_whodead].p_no],
	      teamstring[players[me->p_whodead].p_team]);
      W_WriteText(w, 50, 80, textColor, buf, strlen(buf), W_RegularFont);
      break;
   case KGHOST:
      sprintf(buf, "You were killed by a confused daemon.");
      W_WriteText(w, 50, 80, textColor, buf, strlen(buf), W_RegularFont);
      break;
   case KGENOCIDE:
      sprintf(buf, "Your team was genocided by %s (%c%c) %s.",
	      players[me->p_whodead].p_name,
	      teamlet[players[me->p_whodead].p_team],
	      shipnos[me->p_whodead],
	      teamstring[players[me->p_whodead].p_team]);
      W_WriteText(w, 50, 80, textColor, buf, strlen(buf), W_RegularFont);
      break;
   case KPROVIDENCE:
      sprintf(buf, "You were removed from existence by divine mercy.");
      W_WriteText(w, 50, 80, textColor, buf, strlen(buf), W_RegularFont);
      break;
   case KOVER:
      sprintf(buf, "The a game is  over!");
      W_WriteText(w, 50, 80, textColor, buf, strlen(buf), W_RegularFont);
      break;
   case TOURNSTART:
      sprintf(buf, "The a tournament game has begun!");
      W_WriteText(w, 50, 80, textColor, buf, strlen(buf), W_RegularFont);
      break;
   case TOURNEND:
      sprintf(buf, "The a tournament game has ended.");
      W_WriteText(w, 50, 80, textColor, buf, strlen(buf), W_RegularFont);
      break;
   case KBINARY:
      sprintf(buf, "Your netrek executable didn't verify correctly.");
      W_WriteText(w, 50, 80, textColor, buf, strlen(buf), W_RegularFont);
      sprintf(buf, "(could be an old copy or illegal cyborg)");
      W_WriteText(w, 50, 100, textColor, buf, strlen(buf), W_RegularFont);
      break;
   default:
      sprintf(buf, "You were killed by something unknown to this game?");
      W_WriteText(w, 50, 80, textColor, buf, strlen(buf), W_RegularFont);
      break;
   }
   /* First we check for promotions: */
   if (promoted) {
      sprintf(buf, "Congratulations!  You have been promoted to %s",
	      ranks[mystats->st_rank].name);
      W_WriteText(w, 50, 100, W_Yellow, buf, strlen(buf), W_BoldFont);
      promoted = 0;
   }
   w = oldw;
   while (W_EventsPending()) {
      W_NextEvent(&event);
   }
   longjmp(env, 0);
}
