#ifndef _DAVIS_MALLOC_H__
#define _DAVIS_MALLOC_H__
/* system specific malloc prototypes and macros. */
/* 
 * Copyright (c) 1992, 1994 John E. Davis 
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.   Permission is not granted to modify this
 * software for any purpose without written agreement from John E. Davis.
 *
 * IN NO EVENT SHALL JOHN E. DAVIS BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF JOHN E. DAVIS
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * JOHN E. DAVIS SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"
 * BASIS, AND JOHN E. DAVIS HAS NO OBLIGATION TO PROVIDE MAINTENANCE,
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */


/*  __SC__ is defined for Symantec C++
   DOS386 is defined for -mx memory model, 32 bit DOS extender. */

#if defined(msdos) && !defined(DOS386)
#  ifdef __SC__
#    include <dos.h>
#  endif
#  define VOID void
#  include <alloc.h>
#  define FREE(buf)  farfree((void far *)(buf))
#  define MALLOC(x) farmalloc((unsigned long) (x))
#  define REALLOC(buf, n) farrealloc((void far *) (buf), (unsigned long) (n))
#  define CALLOC(n, m) farcalloc((unsigned long) (n), (unsigned long) (m))
#else
#  ifndef NO_STDLIB_H
#    include <stdlib.h>
#  endif
#  define VOID unsigned char
#  define FREE(p) free((VOID *)(p))
#  define MALLOC malloc
#  define REALLOC realloc
#  define CALLOC calloc
#endif


/* _DAVIS_MALLOC_H__ */
#endif 
