/*
 * parser.c: Parser for MAKEDEV, a program to create entries in /dev.
 *
 * Based on the MAKEDEV shell script, version 2.0, distributed with
 * util-linux 1.10 and written by Nick Holloway. 
 *
 * A number of bugs were fixed, and some additional features added.
 * Written 10-Dec-94 by David A. Holland, dholland@husc.harvard.edu
 * Rik Faith (faith@cs.unc.edu) contributed ideas and patches.
 *
 * Copyright 1994, 1995. All rights reserved. 
 * See the file LEGAL.NOTICE for conditions of redistribution.
 *
 * Bugs:
 *    None known right now.
 *
 * History:
 *
 * Version 2: 25-Mar-95    Fixed makefile. 
 *    Look for config files in ".." under testing conditions.
 *    Big source split: makedev.syn -> parser.syn and devices.c.
 *    Consequently, this file's version numbers aren't the same as the
 *    whole program's any more.
 * Version 1.4b: 25-Mar-95 Merged Rik's changes. Additional bug fixes:
 *    Don't leave off the last entry in a range.
 *    Parse hex digits correctly [sigh...].
 *    Now we actually *use* the ishex flag.
 * Version 1.4a: 26-Feb-95 Forced devinfo and makedev.cfg to be in /etc.
 *                         [from faith@cs.unc.edu]
 * Version 1.4: 15-Jan-95  Wrote man pages. Now reads DEVINFO.local.
 * Version 1.3: 31-Dec-94  Bug fixes. Added batches. Added omits.
 * Version 1.2: 11-Dec-94  Add configuration file parsing.
 * Version 1.1: 11-Dec-94  Distinguish block and character devices in the
 *    table of major device numbers. Changed the name and format of the
 *    update cache file to include the type. It appears that the old script
 *    was broken in this regard.
 * Version 1.0: 10-Dec-94  Initial version.
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <unistd.h>
#include <fcntl.h>
#include <pwd.h>
#include <grp.h>
#include <sys/stat.h>

#include "devices.h"



/*

 AnaGram Parsing Engine
 Copyright (c) 1993, Parsifal Software.
 This module may be copied and/or distributed at the discretion of the
 AnaGram licensee.

*/



#ifndef PARSER_H
#include "parser.h"
#endif

#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define RULE_CONTEXT (&((PCB).cs[(PCB).ssx]))
#define ERROR_CONTEXT ((PCB).cs[(PCB).error_frame_ssx])
#define CONTEXT ((PCB).cs[(PCB).ssx])



parse_pcb_type parse_pcb;
#define PCB parse_pcb

#line 56 "/usr/home/dholland/Programs/Utils/makedev/current/parser.syn"
/************************* parsing support *************************/

/*
 * Don't use the built-in error printing.
 */
#define SYNTAX_ERROR
#define PARSER_STACK_OVERFLOW
#define REDUCTION_TOKEN_ERROR

void doparse(FILE *f, int filetype, const char *filename) {
  char *x;
  int i=0, len;
  if (filetype<1 || filetype>4) crash("tried to parse a bad file type");
  if (filetype!=1) { /* /proc/devices won't stat intelligently */
    struct stat buf;
    if (fstat(fileno(f), &buf)) crash("fstat failed?!?");
    len = buf.st_size;
  }
  else len=1023;
  x = malloc(len+1);
  if (!x) crash("Out of memory");

  len = fread(x, 1, len, f);  /* it shouldn't return a short count... */
  if (len<0) crash("fread failed?!?");
  x[len]=0;

  init_parse();
  PCB.input_code = filetype+'0';
  parse();
  PCB.column--; /* correct for the filetype token */
  while (!PCB.exit_flag) {
    PCB.input_code = x[i++];
    parse();
  }
  if (PCB.exit_flag == AG_SYNTAX_ERROR_CODE) {
    warn("syntax error: %s, line %d, column %d in file %s",
         PCB.error_message, PCB.line, PCB.column, filename);
    crash("Sorry, can't continue.");
  }
  else if (PCB.exit_flag != AG_SUCCESS_CODE) {
    crash("parser stack overflow!");
  }
}

#define STRINGSIZE 8192
static char string_space[STRINGSIZE];
static int stringptr=0;

static const char *string_start(int c) {
  if (stringptr>=STRINGSIZE) crash("out of string space");
  return string_space[stringptr]=c, string_space+stringptr++;
}

static void string_push(int c) {
  if (stringptr>=STRINGSIZE) crash("out of string space");
  string_space[stringptr++] = c;
}

static void string_finish(void) {
  string_push(0);
}


#line 148 "parser.c"
#line 198 "/usr/home/dholland/Programs/Utils/makedev/current/parser.syn"
  static const char *cur_group=NULL, *cur_class=NULL;
  static int cur_type;
  static int cur_maj=0, cur_min=0, cur_bot=0, cur_top=0, ishex=0;

  static void dhsproc(const char *g, const char *p, int t, int m) {
    cur_group = g;
    cur_type = t;
    cur_maj = get_major(p, (t=='c'), m);
    cur_min = 0;
    cur_bot = cur_top = ishex = 0;
    if (p) addalias(p,g);
  }

  static void newdev(const char *n) {
    if (cur_maj<0) return;
    init(n, cur_group, cur_class, cur_maj, cur_min, cur_type);
  }
  static void devrange(const char *n, const char *n1) {
    char temp[32];
    if (cur_maj<0) return;
    sprintf(temp, "%s%%%c%s", n, ishex ? 'x' : 'd', n1 ? n1 : "");
    initlots(temp, cur_bot, cur_top, cur_group, cur_class,
	     cur_maj, cur_min, cur_type);
  }
  static void doinitlink(const char *src, const char *tg) {
    if (cur_maj>=0) initlink(src, cur_group, tg);
  }

#line 178 "parser.c"
#ifndef CONVERT_CASE
#define CONVERT_CASE(c) (c)
#endif
#ifndef TAB_SPACING
#define TAB_SPACING 8
#endif

#define ag_rp_1(n, s) (set_major(s,YES,n))

#define ag_rp_2(n, s) (set_major(s,NO,n))

#define ag_rp_3(n, maj, t) (updatefromcache(n,maj,t))

#define ag_rp_4() ('b')

#define ag_rp_5() ('c')

#define ag_rp_8(n, i) (add2batch(addbatch(n), i))

#define ag_rp_9(b, i) (add2batch(b,i))

#define ag_rp_10(n) (n)

#define ag_rp_11(n) (ignore_procname(n))

#define ag_rp_12(t, g, p) (dhsproc(g,p,t,-1))

#define ag_rp_13(t, g, p, m) (dhsproc(g,p,t,m))

#define ag_rp_14(t, g, m) (dhsproc(g,NULL,t,m))

#define ag_rp_15(classname) (classname)

#define ag_rp_16(c, min) ((cur_class=c, cur_min=min))

#define ag_rp_17(a, b) (cur_bot=a, cur_top=b, ishex=0)

#define ag_rp_18(a, b) (cur_bot=a, cur_top=b, ishex=1)

#define ag_rp_19(n) (newdev(n))

#define ag_rp_20(n, n1) (devrange(n,n1))

#define ag_rp_21(n) (devrange(n,NULL))

#define ag_rp_22(n, a, b, p, m) (initdisk(n, a, b, p, cur_maj, m))

#define ag_rp_23(n, tg) (doinitlink(n, tg))

#define ag_rp_24(n) (n)

#define ag_rp_25(n) (n)

#define ag_rp_26(n) (n)

#define ag_rp_27(n, o, g, m) (addclass(n,o,g,m))

#define ag_rp_28(n) (make(n, M_OMIT))

#define ag_rp_29(n) (make(n, M_OMIT))

#define ag_rp_30(n) (n)

#define ag_rp_31(s) (string_finish(), s)

#define ag_rp_32(s) (s)

#define ag_rp_33(c) (string_start(c))

#define ag_rp_34(s, c) (string_push(c), s)

#define ag_rp_35(s) (string_finish(), s)

#define ag_rp_36(c) (string_start(c))

#define ag_rp_37(s, c) (string_push(c), s)

#define ag_rp_38(c) (c)

#define ag_rp_39() ('\\')

#define ag_rp_40() ('"')

#define ag_rp_41(d) (d-'0')

#define ag_rp_42(n, d) (n*10 + d-'0')

#define ag_rp_43(d) (d)

#define ag_rp_44(n, d) (16*n+d)

#define ag_rp_45(d) (d)

#define ag_rp_46(n, d) (16*n+d)

#define ag_rp_47(d) (d-'0')

#define ag_rp_48(d) (10 + d-'a')

#define ag_rp_49(d) (10 + d-'A')

#define ag_rp_50(d) (d-'0')

#define ag_rp_51(n, d) (n*8+d-'0')

#define ag_rp_52(x, t) (x+t)

#define ag_rp_53(x, t) (x-t)

#define ag_rp_54(t, f) (t*f)

#define ag_rp_55(f) (-f)

#define ag_rp_56(x) (x)


#define READ_COUNTS 
#define WRITE_COUNTS 
static parse_vs_type ag_null_value;
#define V(i,t) (*(t *) (&(PCB).vs[(PCB).ssx + i]))
#define VS(i) (PCB).vs[(PCB).ssx + i]

#ifndef GET_CONTEXT
#define GET_CONTEXT CONTEXT = (PCB).input_context
#endif

typedef enum {
  ag_action_1,
  ag_action_2,
  ag_action_3,
  ag_action_4,
  ag_action_5,
  ag_action_6,
  ag_action_7,
  ag_action_8,
  ag_action_9,
  ag_action_10,
  ag_action_11,
  ag_action_12
} ag_parser_action;

static int ag_ap;



static const unsigned char ag_rpx[] = {
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  2,
    0,  0,  0,  3,  4,  5,  4,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  6,  0,  0,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
   19, 20, 21, 22, 23, 24,  0,  0,  0,  0,  0, 25, 26,  0,  0,  0, 27, 28,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,  0,  0, 41, 42, 43, 44,
   45, 46, 47, 48, 49,  0, 50, 51,  0, 52,  0,  0, 53, 54
};

static unsigned char ag_key_itt[] = {
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0
};

static unsigned short ag_key_pt[] = {
  1,122,  1,123,  1,126,  1,127,  1,139,  1,140,0
};

static unsigned char ag_key_ch[] = {
    0, 47,255, 42,255, 42, 47,255, 88,120,255, 97,108,255,104,108,255, 45,
   47, 48, 66, 67, 98, 99,105,111,255, 42, 47,255, 47, 99,111,255, 42, 47,
  255, 97,108,255, 47, 98, 99,105,255, 42, 47,255, 47,255, 42, 47,255, 47,
   66, 67,255, 47, 99,111,255, 97,108,255, 47, 98, 99,105,255, 47,255, 47,
   66, 67,255, 42, 47,255, 97,108,255,104,108,255, 47, 66, 67, 98, 99,105,
  111,255, 97,108,255,104,108,255, 47, 66, 67, 98, 99,105,111,255, 99,111,
  255, 97,108,255, 98, 99,105,255, 66, 67,255, 42, 47,255, 45, 47,255, 88,
  120,255, 47, 48,255, 42, 47,255, 47, 98, 99,255, 98, 99,255, 42, 47,255,
   97,108,255,104,108,255, 47, 98, 99,105,111,255, 45,255, 88,120,255, 48,
  255
};

static unsigned char ag_key_act[] = {
  0,3,4,3,4,0,0,4,0,0,4,7,7,4,7,7,4,3,2,2,3,3,2,2,7,7,4,0,0,4,2,7,7,4,0,
  0,4,7,7,4,2,2,7,7,4,0,0,4,2,4,0,0,4,2,3,3,4,3,7,7,4,7,7,4,3,2,7,7,4,3,
  4,3,3,3,4,0,0,4,7,7,4,7,7,4,2,3,3,2,2,7,7,4,7,7,4,7,7,4,3,3,3,2,2,7,7,
  4,7,7,4,7,7,4,2,7,7,4,3,3,4,0,0,4,3,2,4,0,0,4,3,2,4,0,0,4,2,7,7,4,7,7,
  4,0,0,4,7,7,4,7,7,4,2,2,2,7,7,4,3,4,0,0,4,2,4
};

static unsigned char ag_key_parm[] = {
    0, 80,  0, 84,  0, 80, 86,  0,146,145,  0,  6,  0,  0,  2,  8,  0,138,
    0,  0,119,118,  0,  0,  4, 10,  0, 80, 86,  0,  0,  8, 10,  0, 80, 86,
    0,  6,  0,  0,  0,  0,  2,  4,  0, 80, 86,  0,  0,  0, 80, 86,  0,  0,
  119,118,  0, 86,  8, 10,  0,  6,  0,  0, 86,  0,  2,  4,  0, 86,  0, 86,
  119,118,  0, 80, 86,  0,  6,  0,  0,  2,  8,  0,  0,119,118,  0,  0,  4,
   10,  0,  6,  0,  0,  2,  8,  0, 86,119,118,  0,  0,  4, 10,  0,  8, 10,
    0,  6,  0,  0,  0,  2,  4,  0,119,118,  0, 80, 86,  0,138,  0,  0,146,
  145,  0, 80,  0,  0, 80, 86,  0,  0,  0,  2,  0,  0,  2,  0, 80, 86,  0,
    6,  0,  0,  2,  8,  0,  0,  0,  0,  4, 10,  0,138,  0,146,145,  0,  0,
    0
};

static unsigned short ag_key_jmp[] = {
    0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0, 38, 42,  0, 46, 49,  0,  4,
    5,  8,  6, 20, 11, 14, 53, 59,  0,  0,  0,  0, 27, 63, 68,  0,  0,  0,
    0, 72, 76,  0, 34, 37, 80, 84,  0,  0,  0,  0, 45,  0,  0,  0,  0, 50,
   90,104,  0,122,124,129,  0,135,139,  0,133, 61,143,147,  0,153,  0,155,
  157,171,  0,  0,  0,  0,221,225,  0,229,232,  0, 75,189,203, 78, 81,236,
  242,  0,280,284,  0,288,291,  0,246,248,262, 92, 95,295,301,  0,305,310,
    0,314,318,  0,109,322,326,  0,332,346,  0,  0,  0,  0,364,119,  0,  0,
    0,  0,366,125,  0,  0,  0,  0,131,368,373,  0,377,382,  0,  0,  0,  0,
  386,390,  0,394,397,  0,141,144,147,401,407,  0,411,  0,  0,  0,  0,158,
    0
};

static unsigned short ag_key_index[] = {
    1,  3, 17,  0,  3,  3, 30, 40, 48, 53, 57, 64, 69, 71,  0,  0, 84, 98,
  106,112,  0,116,  0,  1,  1,  0,  0,106, 48, 48, 48, 48,  1,  1,  0,  0,
    0, 69,112,  0,122, 48,  0,  0, 48, 48, 69, 69,116, 48, 69, 69,  0,128,
    0,  0,  0, 69,  0, 69,  0,  0,134,138,  0,  0,  0,128,  0,  0, 69, 48,
   69,  0,150, 64,  0,156,  0, 69,  0,116,  0,116, 69,  0,  0,  0,  1,  0,
    0, 69, 69,  0,  1,  0,128,161,  0,  0,  0,  0,  0, 69, 69,  0, 57,  0,
    0,  0, 69,  0, 64, 69,  1,  0,  1,  1,  0,  0,  0,  0,  0,161, 64, 48,
   69, 69, 48,  0,128,  0, 48, 48,  0,  0,161,161, 69, 69, 69, 69,  0,  0,
    0,  0,  0,128,161,161,128,161,  1,  0, 69, 69,  0,  1,  0, 69,  0
};

static unsigned char ag_key_ends[] = {
42,0, 47,0, 62,0, 108,111,99,107,32,100,101,118,105,99,101,115,58,0, 
104,97,114,97,99,116,101,114,32,100,101,118,105,99,101,115,58,0, 
116,99,104,0, 111,99,107,0, 97,114,0, 97,115,115,0, 
103,110,111,114,101,0, 109,105,116,0, 108,97,115,115,0, 
109,105,116,0, 116,99,104,0, 111,99,107,0, 104,97,114,0, 
103,110,111,114,101,0, 108,111,99,107,32,100,101,118,105,99,101,115,58,0, 
104,97,114,97,99,116,101,114,32,100,101,118,105,99,101,115,58,0, 
47,0, 108,97,115,115,0, 109,105,116,0, 47,0, 116,99,104,0, 
111,99,107,0, 104,97,114,0, 103,110,111,114,101,0, 47,0, 47,0, 
108,111,99,107,32,100,101,118,105,99,101,115,58,0, 
104,97,114,97,99,116,101,114,32,100,101,118,105,99,101,115,58,0, 
108,111,99,107,32,100,101,118,105,99,101,115,58,0, 
104,97,114,97,99,116,101,114,32,100,101,118,105,99,101,115,58,0, 
116,99,104,0, 111,99,107,0, 97,114,0, 97,115,115,0, 
103,110,111,114,101,0, 109,105,116,0, 47,0, 
108,111,99,107,32,100,101,118,105,99,101,115,58,0, 
104,97,114,97,99,116,101,114,32,100,101,118,105,99,101,115,58,0, 
116,99,104,0, 111,99,107,0, 97,114,0, 97,115,115,0, 
103,110,111,114,101,0, 109,105,116,0, 108,97,115,115,0, 
109,105,116,0, 116,99,104,0, 111,99,107,0, 104,97,114,0, 
103,110,111,114,101,0, 108,111,99,107,32,100,101,118,105,99,101,115,58,0, 
104,97,114,97,99,116,101,114,32,100,101,118,105,99,101,115,58,0, 
62,0, 42,0, 108,111,99,107,0, 104,97,114,0, 108,111,99,107,0, 
104,97,114,0, 116,99,104,0, 111,99,107,0, 97,114,0, 97,115,115,0, 
103,110,111,114,101,0, 109,105,116,0, 62,0, 
};
#define AG_TCV(x) (((int)(x) >= -1 && (int)(x) <= 255) ? ag_tcv[(x) + 1] : 0)

static const unsigned char ag_tcv[] = {
   18, 18,154,154,154,154,154,154,154,154,152, 93,154,154,152,154,154,154,
  154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,153,155, 95,
   87,155,155,155,155,131,129,151,150,128,134,155,136,156,114,115,116,117,
  156,156,156,157,157,132,155,155,130,155,155,155,148,148,148,148,148,148,
  158,158,158,158,158,158,158,158,158,158,158,158,158,158,158,158,158,158,
  158,158,135, 99,133,155,158,155,159,120,121,159,159,159,158,158,158,158,
  158,158,158,158,158,158,158,158,158,158,158,158,158,158,158,158,125,155,
  124,155,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,
  154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,
  154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,
  154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,
  154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,
  154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,
  154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,
  154,154,154,154,154
};

#ifndef SYNTAX_ERROR
#define SYNTAX_ERROR fprintf(stderr,"%s, line %d, column %d\n", \
  (PCB).error_message, (PCB).line, (PCB).column)
#endif

#ifndef FIRST_LINE
#define FIRST_LINE 1
#endif

#ifndef FIRST_COLUMN
#define FIRST_COLUMN 1
#endif


#ifndef PARSER_STACK_OVERFLOW
#define PARSER_STACK_OVERFLOW {fprintf(stderr, \
   "\nParser stack overflow, line %d, column %d\n",\
   (PCB).line, (PCB).column);}
#endif

#ifndef REDUCTION_TOKEN_ERROR
#define REDUCTION_TOKEN_ERROR {fprintf(stderr, \
    "\nReduction token error, line %d, column %d\n", \
    (PCB).line, (PCB).column);}
#endif


typedef enum
  {ag_accept_key, ag_set_key, ag_jmp_key, ag_end_key, ag_no_match_key,
   ag_cf_accept_key, ag_cf_set_key, ag_cf_end_key} key_words;


static void ag_track(void) {
  int ag_k = 0;
  while (ag_k < (PCB).rx) {
    int ag_ch = (PCB).lab[ag_k++];
    switch (ag_ch) {
    case '\n':
      (PCB).column = 1, (PCB).line++;
    case '\r':
    case '\f':
      break;
    case '\t':
      (PCB).column += (TAB_SPACING) - ((PCB).column - 1) % (TAB_SPACING);
      break;
    default:
      (PCB).column++;
    }
  }
  ag_k = 0;
  while ((PCB).rx < (PCB).fx) (PCB).lab[ag_k++] = (PCB).lab[(PCB).rx++];
  (PCB).fx = ag_k;
  (PCB).rx = 0;
}


static void ag_prot(void) {
  int ag_k = 38 - ++(PCB).btsx;
  if (ag_k <= (PCB).ssx) {
    (PCB).exit_flag = AG_STACK_ERROR_CODE;
    PARSER_STACK_OVERFLOW;
    return;
  }
  (PCB).bts[(PCB).btsx] = (PCB).sn;
  (PCB).bts[ag_k] = (PCB).ssx;
  (PCB).vs[ag_k] = (PCB).vs[(PCB).ssx];
  (PCB).ss[ag_k] = (PCB).ss[(PCB).ssx];
}

static void ag_undo(void) {
  if ((PCB).drt == -1) return;
  while ((PCB).btsx) {
    int ag_k = 38 - (PCB).btsx;
    (PCB).sn = (PCB).bts[(PCB).btsx--];
    (PCB).ssx = (PCB).bts[ag_k];
    (PCB).vs[(PCB).ssx] = (PCB).vs[ag_k];
    (PCB).ss[(PCB).ssx] = (PCB).ss[ag_k];
  }
  (PCB).token_number = (parse_token_type) (PCB).drt;
  (PCB).ssx = (PCB).dssx;
  (PCB).sn = (PCB).dsn;
  (PCB).drt = -1;
}


static const unsigned char ag_tstt[] = {
153,152,80,0,2,112,113,
159,158,157,156,155,154,153,152,151,150,148,136,135,134,133,132,131,130,129,
  128,125,124,121,120,117,116,115,114,99,95,93,87,0,82,83,
153,152,80,0,2,
117,116,115,114,0,5,6,8,10,12,
159,158,157,156,155,154,153,152,151,150,148,136,135,134,133,132,131,130,129,
  128,125,124,121,120,117,116,115,114,99,95,93,87,0,
84,0,
153,152,80,0,2,112,113,
153,152,80,0,2,112,113,
153,152,80,0,2,112,113,
153,152,80,0,2,112,113,
140,139,93,87,86,0,3,13,14,15,85,88,92,141,
127,126,123,122,121,120,93,87,86,0,3,11,14,15,85,88,92,141,
159,158,148,134,121,120,95,93,87,86,0,3,9,14,15,85,88,92,141,
119,118,93,87,86,0,3,7,14,15,85,88,92,141,
159,158,157,156,155,154,153,152,151,150,148,136,135,134,133,132,131,130,129,
  128,125,124,121,120,117,116,115,114,99,95,87,18,0,90,91,
93,0,
153,152,80,0,2,112,113,
159,158,157,156,148,140,139,134,128,127,126,124,123,122,121,120,119,118,117,
  116,115,114,95,93,87,86,18,0,3,88,92,141,
140,139,0,69,70,71,72,73,75,
127,126,123,122,121,120,0,29,30,31,32,33,34,35,36,42,45,
159,158,148,134,121,120,95,0,1,4,26,27,28,142,143,
119,118,0,16,17,19,22,
159,158,157,156,155,154,153,152,151,150,148,136,135,134,133,132,131,130,129,
  128,125,124,121,120,117,116,115,114,99,95,87,18,0,
153,152,80,0,2,112,113,
153,152,80,0,2,112,113,
159,158,148,134,125,121,120,95,0,1,4,26,37,142,143,
159,158,148,134,121,120,95,0,1,4,26,142,143,
140,139,18,0,69,71,72,73,75,
153,152,80,0,2,112,113,
153,152,80,0,2,112,113,
153,152,80,0,2,112,113,
153,152,80,0,2,112,113,
153,152,80,0,2,112,113,
153,152,80,0,2,112,113,
131,0,50,
159,158,148,134,121,120,95,0,1,4,26,46,142,143,
125,0,37,
159,158,148,134,125,121,120,95,93,87,86,0,3,14,15,37,85,88,92,141,
127,126,123,122,121,120,18,0,29,30,31,32,33,34,36,42,45,
159,158,157,156,155,153,151,150,148,136,135,134,133,132,131,130,129,128,125,
  124,121,120,117,116,115,114,99,87,0,96,97,
153,152,80,0,2,112,113,
159,158,157,156,153,152,148,134,121,120,117,116,115,114,80,0,2,112,113,
157,156,117,116,115,114,0,25,100,
159,158,148,134,121,120,95,18,0,1,4,26,27,142,143,
153,152,80,0,2,112,113,
153,152,80,0,2,112,113,
87,86,0,3,14,85,88,92,141,
87,86,0,3,14,85,88,92,141,
119,118,18,0,16,19,22,
153,152,80,0,2,112,113,
159,158,148,134,121,120,95,93,87,86,0,3,14,15,85,88,92,141,
87,86,0,3,14,85,88,92,141,
132,0,57,
153,152,80,0,2,112,113,
159,158,148,134,121,120,95,0,1,4,26,51,142,143,
125,0,37,
128,124,0,41,48,49,
159,158,148,134,121,120,95,93,87,86,0,3,14,15,85,88,92,141,
159,158,148,134,121,120,95,0,1,4,26,38,65,142,143,
159,158,148,134,124,121,120,95,93,87,86,0,3,14,15,85,88,92,141,
99,95,0,
159,158,157,156,155,153,151,150,148,136,135,134,133,132,131,130,129,128,125,
  124,121,120,117,116,115,114,99,95,87,0,97,
153,152,80,0,2,112,113,
157,156,123,122,121,120,117,116,115,114,0,29,30,31,32,33,100,
157,156,117,116,115,114,0,23,24,25,100,
157,156,117,116,115,114,0,20,21,25,100,
159,158,148,134,121,120,95,0,1,4,26,76,77,142,143,
153,152,80,0,2,112,113,
159,158,148,134,121,120,95,0,1,4,26,142,143,
130,128,0,48,52,
159,158,148,134,121,120,95,93,87,86,0,3,14,15,85,88,92,141,
153,152,80,0,2,112,113,
159,158,148,134,124,121,120,95,93,87,86,0,3,14,15,85,88,92,141,
159,158,148,134,121,120,95,0,1,4,26,47,142,143,
153,152,80,0,2,112,113,
127,126,123,122,121,120,93,87,86,18,0,3,14,15,85,88,92,141,
159,158,148,134,121,120,95,0,1,4,26,43,44,142,143,
138,135,131,0,50,55,56,59,60,68,
159,158,148,134,121,120,95,0,1,4,26,38,39,40,65,142,143,
87,86,0,3,14,85,88,92,141,
159,158,157,156,148,134,121,120,117,116,115,114,95,0,1,4,26,100,142,143,
157,156,117,116,115,114,0,23,25,100,
159,158,157,156,148,134,121,120,117,116,115,114,95,0,1,4,26,100,142,143,
157,156,117,116,115,114,0,20,25,100,
159,158,148,134,128,124,121,120,95,93,87,86,0,3,14,15,85,88,92,141,
159,158,148,134,124,121,120,95,0,1,4,26,41,76,142,143,
159,158,148,134,121,120,95,0,1,4,26,142,143,
157,156,117,116,115,114,0,25,100,
153,152,80,0,2,112,113,
159,158,148,134,121,120,95,0,1,4,26,53,142,143,
159,158,148,134,121,120,95,0,1,4,26,47,142,143,
159,158,148,134,128,124,121,120,95,93,87,86,0,3,14,15,85,88,92,141,
159,158,148,134,128,124,121,120,95,93,87,86,0,3,14,15,85,88,92,141,
159,158,148,134,124,121,120,95,0,1,4,26,41,43,142,143,
153,152,80,0,2,112,113,
159,158,148,134,121,120,95,0,1,4,26,142,143,
153,152,80,0,2,112,113,
159,158,157,156,148,146,145,134,121,120,117,116,115,114,0,25,63,66,100,101,
  102,103,
159,158,148,134,131,121,120,95,0,1,4,26,50,55,56,65,142,143,
159,158,148,134,121,120,95,0,1,4,26,142,143,
132,0,57,
159,158,148,134,121,120,95,0,1,4,26,38,65,142,143,
124,0,41,
87,86,0,3,14,85,88,92,141,
87,86,0,3,14,85,88,92,141,
128,0,48,49,
140,139,93,87,86,18,0,3,14,15,85,88,92,141,
156,117,116,115,114,0,74,78,107,
157,156,129,117,116,115,114,0,54,100,
129,128,0,48,54,
159,158,148,134,128,124,121,120,95,93,87,86,0,3,14,15,85,88,92,141,
128,0,48,49,
127,126,123,122,121,120,93,87,86,18,0,3,14,15,85,88,92,141,
87,86,0,3,14,85,88,92,141,
153,152,80,0,2,112,113,
134,0,61,
153,152,80,0,2,112,113,
153,152,80,0,2,112,113,
159,157,156,148,121,120,117,116,115,114,0,100,104,105,106,
159,157,156,148,134,121,120,117,116,115,114,0,61,100,104,105,106,
157,156,134,117,116,115,114,0,61,100,
131,0,50,55,56,
129,0,54,
157,156,146,145,134,131,117,116,115,114,0,25,50,58,61,63,100,101,102,103,
  108,110,
127,126,123,122,121,120,93,87,86,18,0,3,14,15,85,88,92,141,
153,152,80,0,2,112,113,
156,117,116,115,114,0,107,
87,86,0,3,14,85,88,92,141,
153,152,80,0,2,112,113,
157,156,117,116,115,114,0,25,100,
153,152,80,0,2,112,113,
159,158,148,134,121,120,0,66,
153,152,80,0,2,112,113,
153,152,80,0,2,112,113,
159,157,156,148,121,120,117,116,115,114,0,64,100,104,105,106,
157,156,117,116,115,114,0,25,100,
157,156,146,145,134,131,117,116,115,114,0,25,50,58,61,63,100,101,102,103,
  108,110,
157,156,146,145,134,131,117,116,115,114,0,25,50,61,63,100,101,102,103,110,
159,157,156,148,121,120,117,116,115,114,0,100,104,105,106,
157,156,117,116,115,114,0,100,
151,0,111,
150,134,87,86,0,3,14,61,85,88,92,109,141,
157,156,129,117,116,115,114,0,54,100,
133,0,62,
159,157,156,148,133,121,120,117,116,115,114,0,62,100,104,105,106,
157,156,133,117,116,115,114,0,62,100,
150,134,129,0,54,61,109,
153,152,80,0,2,112,113,
157,156,146,145,134,131,117,116,115,114,0,25,50,61,63,100,101,102,103,110,
157,156,146,145,134,131,117,116,115,114,0,25,50,61,63,100,101,102,103,108,
  110,
153,152,80,0,2,112,113,
157,156,146,145,134,131,117,116,115,114,0,25,50,61,63,100,101,102,103,108,
  110,
153,152,80,0,2,112,113,
157,156,117,116,115,114,0,25,100,
151,0,111,
151,0,111,
157,156,136,117,116,115,114,0,67,100,
153,152,80,0,2,112,113,
157,156,117,116,115,114,0,25,100,
157,156,117,116,115,114,87,86,0,3,14,85,88,92,100,141,
  0
};


static unsigned char ag_astt[1882] = {
  1,1,1,8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,8,1,1,9,9,1,5,3,1,1,1,1,7,0,1,1,1,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
  9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,5,3,7,1,1,1,5,1,1,3,1,1,1,5,1,1,3,1,1,1,5,1,
  1,3,1,1,1,5,1,1,3,8,8,8,1,1,7,1,3,1,1,1,1,1,1,8,8,8,8,8,8,8,1,1,7,1,3,1,1,
  1,1,1,1,8,8,8,8,8,8,8,8,1,1,7,1,3,1,1,1,1,1,1,8,8,8,1,1,7,1,3,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,3,3,7,
  1,1,1,5,1,1,3,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,8,1,1,5,7,3,1,
  1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,7,1,2,2,2,2,1,1,1,1,1,2,2,2,2,2,2,1,7,2,
  2,1,1,1,1,1,1,1,7,1,1,1,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
  9,9,9,9,9,9,9,9,5,1,1,1,5,1,1,3,1,1,1,5,1,1,3,2,2,2,2,1,2,2,1,7,2,2,1,1,1,
  1,2,2,2,2,2,2,1,7,2,2,1,1,1,1,1,3,7,3,3,3,1,1,1,1,1,5,1,1,3,1,1,1,5,1,1,3,
  1,1,1,5,1,1,3,1,1,1,5,1,1,3,1,1,1,5,1,1,3,1,1,1,5,1,1,3,1,7,1,2,2,2,2,2,2,
  1,7,2,2,1,1,1,1,1,7,1,8,8,8,8,1,8,8,8,8,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  3,7,1,2,2,2,2,3,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  1,2,7,1,2,1,1,1,5,1,1,3,10,10,10,10,1,1,10,10,10,10,10,10,10,10,1,5,1,1,3,
  1,1,1,1,1,1,7,1,2,2,2,2,2,2,2,1,3,7,2,2,1,3,1,1,1,1,1,5,1,1,3,1,1,1,5,1,1,
  3,1,1,8,1,1,1,1,1,1,1,1,8,1,1,1,1,1,1,1,1,3,7,3,1,1,1,1,1,5,1,1,3,8,8,8,8,
  8,8,8,8,1,1,7,1,1,1,1,1,1,1,1,1,8,1,2,1,1,1,1,1,7,1,1,1,1,5,1,1,3,2,2,2,2,
  2,2,1,7,2,2,2,1,1,1,1,7,1,1,1,8,1,1,1,8,8,8,8,8,8,8,8,1,1,7,1,1,1,1,1,1,1,
  2,2,2,2,2,2,1,7,2,2,2,3,1,1,1,8,8,8,8,8,8,8,8,8,1,1,7,1,1,1,1,1,1,1,2,2,7,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,7,2,1,1,1,5,1,1,
  3,1,1,1,1,1,1,1,1,1,1,7,1,2,2,2,2,2,1,1,1,1,1,1,7,1,1,1,2,1,1,1,1,1,1,7,1,
  1,1,2,2,2,2,2,2,2,1,7,2,2,1,1,1,1,1,1,1,1,5,1,1,3,2,2,2,2,2,2,1,7,2,2,1,1,
  1,1,1,7,1,1,8,8,8,8,8,8,8,8,1,1,7,1,1,1,1,1,1,1,1,1,1,5,1,1,3,5,5,5,5,5,5,
  5,5,8,1,1,7,1,3,3,1,1,1,1,2,2,2,2,2,2,1,7,2,2,2,1,1,1,1,1,1,5,1,1,3,5,5,5,
  5,5,5,8,1,1,5,7,1,3,3,1,1,1,1,2,2,2,2,2,2,1,7,2,2,1,1,1,1,1,1,1,1,7,1,1,2,
  1,1,1,2,2,2,2,2,2,1,8,2,2,2,1,1,1,1,1,1,1,1,8,1,2,1,1,1,1,2,2,1,1,2,2,2,2,
  1,1,1,1,1,7,2,2,1,2,1,1,1,1,1,1,1,1,5,3,1,2,2,2,1,1,2,2,2,2,1,1,1,1,1,7,2,
  2,1,2,1,1,1,1,1,1,1,1,5,3,1,2,8,8,8,8,8,8,8,8,8,8,1,1,7,1,1,1,1,1,1,1,2,2,
  2,2,1,2,2,1,7,2,2,1,1,3,1,1,2,2,2,2,2,2,1,7,2,2,1,1,1,1,1,1,1,1,1,7,1,2,1,
  1,1,5,1,1,3,2,2,2,2,2,2,1,7,2,2,2,1,1,1,2,2,2,2,2,2,1,7,2,2,2,1,1,1,5,5,5,
  5,5,5,5,5,5,8,1,1,7,1,2,2,1,1,1,1,8,8,8,8,8,8,8,8,8,8,1,1,7,1,1,1,1,1,1,1,
  2,2,2,2,1,2,2,1,7,2,2,1,1,3,1,1,1,1,1,5,1,1,3,2,2,2,2,2,2,1,7,2,2,1,1,1,1,
  1,1,5,1,1,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,2,1,1,1,2,2,2,2,1,2,2,1,7,
  2,2,2,1,1,2,1,1,1,2,2,2,2,2,2,1,7,2,2,1,1,1,1,7,1,2,2,2,2,2,2,1,5,2,2,2,3,
  1,1,1,1,7,1,1,1,8,1,2,1,1,1,1,1,1,8,1,2,1,1,1,1,1,5,1,2,5,5,8,1,1,5,7,1,3,
  3,1,1,1,1,1,1,1,1,1,7,1,1,2,1,1,1,1,1,1,1,7,2,2,1,1,7,1,2,5,5,5,5,5,5,5,5,
  5,8,1,1,7,1,2,2,1,1,1,1,1,5,1,2,5,5,5,5,5,5,8,1,1,5,7,1,3,3,1,1,1,1,1,1,8,
  1,2,1,1,1,1,1,1,1,5,1,1,3,1,7,1,1,1,1,5,1,1,3,1,1,1,5,1,1,3,1,1,1,1,1,1,1,
  1,1,1,7,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,7,1,2,2,2,2,1,1,1,1,1,1,1,7,1,2,1,7,
  1,1,2,1,7,2,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,2,1,1,1,1,1,5,5,5,5,5,5,8,1,1,
  5,7,1,3,3,1,1,1,1,1,1,1,5,1,1,3,1,1,1,1,1,4,2,1,1,8,1,2,1,1,1,1,1,1,1,5,1,
  1,3,1,1,1,1,1,1,7,1,2,1,1,1,5,1,1,3,1,1,1,1,1,1,7,1,1,1,1,5,1,1,3,1,1,1,5,
  1,1,3,1,1,1,1,1,1,1,1,1,1,7,1,2,2,2,2,1,1,1,1,1,1,7,1,2,1,1,1,1,1,1,1,1,1,
  1,7,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,2,1,1,1,2,1,1,1,1,
  1,1,1,1,1,1,5,2,2,2,2,1,1,1,1,1,1,5,2,1,5,1,1,1,1,1,8,1,2,1,1,1,1,1,1,1,1,
  1,1,1,1,1,7,2,2,1,7,1,1,1,1,1,1,1,1,1,1,1,1,7,2,2,2,2,2,1,1,1,1,1,1,1,7,2,
  2,1,1,1,7,2,1,1,1,1,1,5,1,1,3,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,2,1,1,1,2,1,1,
  1,1,1,1,1,1,1,1,7,1,1,1,1,2,1,1,1,1,1,1,1,1,5,1,1,3,1,1,1,1,1,1,1,1,1,1,7,
  1,1,1,1,2,1,1,1,1,1,1,1,1,5,1,1,3,1,1,1,1,1,1,7,1,2,1,4,1,1,4,1,1,1,1,1,1,
  1,1,7,1,2,1,1,1,5,1,1,3,1,1,1,1,1,1,7,1,2,1,1,1,1,1,1,1,1,8,1,2,1,1,1,2,1,11
};


static unsigned char ag_pstt[] = {
2,2,1,3,2,2,3,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,4,5,
123,123,1,125,123,
6,7,8,9,3,0,13,12,11,10,
74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,
  74,74,74,74,74,74,74,76,
77,5,
2,2,1,124,2,2,129,
2,2,1,124,2,2,128,
2,2,1,124,2,2,127,
2,2,1,124,2,2,126,
18,18,15,14,14,10,17,4,18,18,17,14,15,16,
19,19,19,19,19,19,15,14,14,11,17,3,19,19,17,14,15,16,
20,20,20,20,20,20,20,15,14,14,12,17,2,20,20,17,14,15,16,
21,21,15,14,14,13,17,1,21,21,17,14,15,16,
22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,
  22,22,22,22,22,22,22,85,22,88,
89,15,
2,2,1,124,2,2,153,
80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,15,14,
  14,80,17,79,14,15,16,
23,24,18,27,27,27,27,26,25,
32,33,28,29,30,31,19,34,22,23,24,25,38,38,37,36,35,
92,92,92,92,92,92,39,20,90,91,42,43,43,41,40,
44,45,21,48,48,47,46,
84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,86,
2,2,1,124,2,2,152,
2,2,1,124,2,2,151,
92,92,92,92,49,92,92,39,25,90,91,51,50,41,40,
92,92,92,92,92,92,39,26,90,91,52,41,40,
23,24,62,27,61,61,61,26,25,
2,2,1,124,2,2,135,
2,2,1,124,2,2,134,
2,2,1,124,2,2,133,
2,2,1,124,2,2,132,
2,2,1,124,2,2,139,
2,2,1,124,2,2,138,
53,34,54,
92,92,92,92,92,92,39,35,90,91,55,56,41,40,
49,36,57,
58,58,58,58,49,58,58,58,15,14,14,37,17,58,58,59,17,14,15,16,
32,33,28,29,30,31,28,38,34,22,23,24,25,27,37,36,35,
97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,
  97,60,97,39,61,95,
2,2,1,124,2,2,155,
93,93,93,93,2,2,93,93,93,93,93,93,93,93,1,124,2,2,154,
62,62,62,62,62,62,42,63,100,
92,92,92,92,92,92,39,20,43,90,91,42,19,41,40,
2,2,1,124,2,2,131,
2,2,1,124,2,2,130,
14,14,15,17,64,17,14,15,16,
14,14,15,17,65,17,14,15,16,
44,45,9,48,8,47,46,
2,2,1,124,2,2,137,
66,66,66,66,66,66,66,15,14,14,50,17,66,66,17,14,15,16,
14,14,15,17,66,17,14,15,16,
67,52,68,
2,2,1,124,2,2,143,
92,92,92,92,92,92,39,54,90,91,58,69,41,40,
49,55,70,
71,74,73,75,72,73,
76,76,76,76,76,76,76,15,14,14,57,17,76,76,17,14,15,16,
92,92,92,92,92,92,39,58,90,91,57,34,77,41,40,
78,78,78,78,78,78,78,78,15,14,14,59,17,78,78,17,14,15,16,
98,99,60,
97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,
  97,60,94,97,61,96,
2,2,1,124,2,2,156,
62,62,28,29,30,31,62,62,62,62,63,79,22,23,24,25,101,
62,62,62,62,62,62,64,81,81,80,100,
62,62,62,62,62,62,65,83,83,82,100,
92,92,92,92,92,92,39,66,90,91,84,85,85,41,40,
2,2,1,124,2,2,144,
92,92,92,92,92,92,39,68,90,91,86,41,40,
88,71,69,87,89,
90,90,90,90,90,90,90,15,14,14,70,17,90,90,17,14,15,16,
2,2,1,124,2,2,140,
5,5,5,5,5,5,5,5,15,14,14,72,17,41,41,17,14,15,16,
92,92,92,92,92,92,39,73,90,91,43,91,41,40,
2,2,1,124,2,2,136,
5,5,5,5,5,5,15,14,14,5,75,17,38,38,17,14,15,16,
92,92,92,92,92,92,39,76,90,91,92,93,93,41,40,
94,96,53,77,99,100,52,98,97,95,
92,92,92,92,92,92,39,102,90,91,57,101,101,102,77,41,40,
14,14,15,17,21,17,14,15,16,
92,92,62,62,92,92,92,92,62,62,62,62,39,80,90,91,103,101,41,40,
62,62,62,62,62,62,15,14,80,100,
92,92,62,62,92,92,92,92,62,62,62,62,39,82,90,91,104,101,41,40,
62,62,62,62,62,62,12,11,82,100,
105,105,105,105,105,105,105,105,105,15,14,14,84,17,105,105,17,14,15,16,
92,92,92,92,74,92,92,39,85,90,91,84,106,68,41,40,
92,92,92,92,92,92,39,86,90,91,107,41,40,
62,62,62,62,62,62,87,108,100,
2,2,1,124,2,2,142,
92,92,92,92,92,92,39,89,90,91,59,109,41,40,
92,92,92,92,92,92,39,90,90,91,43,110,41,40,
5,5,5,5,5,5,5,5,5,15,14,14,91,17,42,42,17,14,15,16,
111,111,111,111,111,111,111,111,111,15,14,14,92,17,111,111,17,14,15,16,
92,92,92,92,74,92,92,39,93,90,91,92,112,36,41,40,
2,2,1,124,2,2,150,
92,92,92,92,92,92,39,95,90,91,113,41,40,
2,2,1,124,2,2,147,
114,114,62,62,114,116,117,114,114,114,62,62,62,62,97,120,119,115,100,118,
  118,118,
92,92,92,92,53,92,92,39,98,90,91,57,99,100,54,121,41,40,
92,92,92,92,92,92,39,99,90,91,122,41,40,
67,100,123,
92,92,92,92,92,92,39,32,90,91,57,30,77,41,40,
74,102,124,
14,14,15,17,17,17,14,15,16,
14,14,15,17,16,17,14,15,16,
71,40,72,70,
5,5,15,14,14,5,106,17,69,69,17,14,15,16,
125,125,125,125,125,107,127,126,111,
62,62,128,62,62,62,62,108,47,101,
128,71,109,129,45,
5,5,5,5,5,5,5,5,5,15,14,14,110,17,39,39,17,14,15,16,
71,40,72,44,
5,5,5,5,5,5,15,14,14,5,112,17,37,37,17,14,15,16,
14,14,15,17,56,17,14,15,16,
2,2,1,124,2,2,149,
130,115,131,
2,2,1,124,2,2,158,
2,2,1,124,2,2,157,
132,62,62,133,132,132,62,62,62,62,118,108,104,109,110,
132,62,62,133,130,132,132,62,62,62,62,119,134,108,105,109,110,
62,62,130,62,62,62,62,120,135,101,
53,121,99,100,53,
128,122,48,
62,62,116,117,130,53,62,62,62,62,123,139,136,141,137,138,100,118,118,118,
  140,140,
5,5,5,5,5,5,15,14,14,5,124,17,33,33,17,14,15,16,
2,2,1,124,2,2,161,
125,125,125,125,125,71,112,
14,14,15,17,65,17,14,15,16,
2,2,1,124,2,2,141,
62,62,62,62,62,62,129,142,100,
2,2,1,124,2,2,146,
114,114,114,114,114,114,131,143,
2,2,1,124,2,2,159,
2,2,1,124,2,2,160,
132,62,62,133,132,132,62,62,62,62,134,144,108,106,109,110,
62,62,62,62,62,62,135,145,100,
62,62,116,117,130,53,62,62,62,62,136,139,136,146,137,138,100,118,118,118,
  140,140,
62,62,116,117,130,53,62,62,62,62,137,139,136,137,138,100,118,118,118,120,
132,62,62,133,132,132,62,62,62,62,119,108,105,109,110,
62,62,62,62,62,62,118,101,
147,113,148,
150,130,14,14,15,17,49,149,17,14,15,151,16,
62,62,128,62,62,62,62,142,46,101,
152,143,153,
132,62,62,133,152,132,132,62,62,62,62,144,51,108,107,109,110,
62,62,152,62,62,62,62,145,50,101,
150,130,128,146,121,149,151,
2,2,1,124,2,2,163,
62,62,116,117,130,53,62,62,62,62,148,139,136,137,138,100,118,118,118,117,
62,62,116,117,130,53,62,62,62,62,149,139,136,137,138,100,118,118,118,154,
  154,
2,2,1,124,2,2,162,
62,62,116,117,130,53,62,62,62,62,151,139,136,137,138,100,118,118,118,155,
  155,
2,2,1,124,2,2,145,
62,62,62,62,62,62,153,156,100,
147,115,148,
147,114,148,
62,62,157,62,62,62,62,156,158,101,
2,2,1,124,2,2,148,
62,62,62,62,62,62,158,159,100,
62,62,62,62,62,62,14,14,15,17,55,17,14,15,101,16,
  0
};


static const unsigned short ag_sbt[] = {
     0,   7,  42,  47,  57,  90,  92,  99, 106, 113, 120, 134, 152, 171,
   185, 220, 222, 229, 261, 270, 287, 302, 309, 342, 349, 356, 371, 384,
   393, 400, 407, 414, 421, 428, 435, 438, 452, 455, 475, 492, 523, 530,
   549, 558, 573, 580, 587, 596, 605, 612, 619, 637, 646, 649, 656, 670,
   673, 679, 697, 712, 731, 734, 765, 772, 789, 800, 811, 826, 833, 846,
   851, 869, 876, 895, 909, 916, 934, 949, 959, 976, 985,1005,1015,1035,
  1045,1065,1081,1094,1103,1110,1124,1138,1158,1178,1194,1201,1214,1221,
  1243,1261,1274,1277,1292,1295,1304,1313,1317,1331,1340,1350,1355,1375,
  1379,1397,1406,1413,1416,1423,1430,1445,1462,1472,1477,1480,1502,1520,
  1527,1534,1543,1550,1559,1566,1574,1581,1588,1604,1613,1635,1655,1670,
  1678,1681,1694,1704,1707,1724,1734,1741,1748,1768,1789,1796,1817,1824,
  1833,1836,1839,1849,1856,1865,1881
};


static const unsigned short ag_sbe[] = {
     3,  39,  45,  51,  89,  91,  95, 102, 109, 116, 125, 143, 162, 176,
   217, 221, 225, 256, 263, 276, 294, 304, 341, 345, 352, 364, 378, 387,
   396, 403, 410, 417, 424, 431, 436, 445, 453, 466, 482, 520, 526, 545,
   555, 566, 576, 583, 589, 598, 608, 615, 629, 639, 647, 652, 663, 671,
   675, 689, 704, 723, 733, 763, 768, 782, 795, 806, 818, 829, 840, 848,
   861, 872, 887, 902, 912, 926, 941, 952, 966, 978, 998,1011,1028,1041,
  1057,1073,1088,1100,1106,1117,1131,1150,1170,1186,1197,1208,1217,1235,
  1251,1268,1275,1284,1293,1297,1306,1314,1323,1336,1347,1352,1367,1376,
  1389,1399,1409,1414,1419,1426,1440,1456,1469,1473,1478,1490,1512,1523,
  1532,1536,1546,1556,1562,1572,1577,1584,1598,1610,1623,1645,1665,1676,
  1679,1685,1701,1705,1718,1731,1737,1744,1758,1778,1792,1806,1820,1830,
  1834,1837,1846,1852,1862,1873,1881
};


static const unsigned char ag_fl[] = {
  2,2,2,2,2,0,1,1,2,3,1,2,3,1,2,3,3,3,1,2,3,4,1,1,1,1,1,2,3,1,2,0,1,6,3,
  1,2,6,4,5,0,2,4,1,3,6,8,6,3,4,5,5,2,4,3,10,4,1,1,1,1,2,3,1,1,7,3,1,2,6,
  3,1,1,1,2,0,1,3,1,2,1,1,1,1,2,0,1,0,2,2,1,1,1,2,3,1,2,1,2,2,1,2,1,1,2,
  2,1,2,1,1,1,1,2,1,3,3,1,3,1,1,2,3,1,2,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
};

static const unsigned char ag_ptt[] = {
    0,  5,  5,  5,  5, 15, 15, 17, 17,  7, 21, 21, 16, 24, 24, 16, 20, 23,
   28, 28,  9, 27, 29, 29, 29, 29, 35, 35, 11, 39, 39, 40, 40, 34, 34, 44,
   44, 34, 34, 46, 49, 49, 46, 47, 43, 36, 36, 36, 55, 56, 59, 59, 38, 38,
   38, 38, 38, 65, 51, 53, 70, 70, 13, 69, 69, 71, 72, 77, 77, 72, 76, 74,
    2, 82, 82, 83, 83,  2, 85, 85, 14, 88, 88, 90, 90, 91, 91, 92, 92,141,
   26, 26,142,142,143, 96, 96, 97, 97, 97, 25, 25,103,103, 63, 63, 64, 64,
  104,104,104, 78, 78, 58, 58, 58,108,108,110,110,110,110,112,112,113,113,
    6,  8, 10, 12, 19, 22, 30, 31, 32, 33, 41, 37, 42, 45, 48, 54, 52, 50,
   57, 62, 61, 60, 67, 66, 68, 73, 75,  3,  1,  4,100,101,102,105,106,107,
  109,111
};




static void ag_ra(void)
{
  switch(ag_rpx[ag_ap]) {
  case   1: ag_rp_1(V(0,int), V(1,const char *)); break;
  case   2: ag_rp_2(V(0,int), V(1,const char *)); break;
  case   3: ag_rp_3(V(0,const char *), V(1,int), V(2,char)); break;
  case   4: V(0,char) = ag_rp_4(); break;
  case   5: V(0,char) = ag_rp_5(); break;
  case   6: V(0,batch *) = ag_rp_8(V(0,const char *), V(3,const char *)); break;
  case   7: V(0,batch *) = ag_rp_9(V(0,batch *), V(2,const char *)); break;
  case   8: V(0,const char *) = ag_rp_10(V(0,const char *)); break;
  case   9: ag_rp_11(V(0,const char *)); break;
  case  10: ag_rp_12(V(0,char), V(2,const char *), V(4,const char *)); break;
  case  11: ag_rp_13(V(0,char), V(2,const char *), V(4,const char *), V(6,int)); break;
  case  12: ag_rp_14(V(0,char), V(2,const char *), V(4,int)); break;
  case  13: V(0,const char *) = ag_rp_15(V(1,const char *)); break;
  case  14: ag_rp_16(V(0,const char *), V(2,int)); break;
  case  15: ag_rp_17(V(1,int), V(3,int)); break;
  case  16: ag_rp_18(V(1,int), V(3,int)); break;
  case  17: ag_rp_19(V(0,const char *)); break;
  case  18: ag_rp_20(V(0,const char *), V(2,const char *)); break;
  case  19: ag_rp_21(V(0,const char *)); break;
  case  20: ag_rp_22(V(0,const char *), V(2,int), V(4,int), V(6,int), V(8,int)); break;
  case  21: ag_rp_23(V(0,const char *), V(2,const char *)); break;
  case  22: V(0,const char *) = ag_rp_24(V(0,const char *)); break;
  case  23: V(0,const char *) = ag_rp_25(V(0,const char *)); break;
  case  24: V(0,const char *) = ag_rp_26(V(0,const char *)); break;
  case  25: ag_rp_27(V(1,const char *), V(3,const char *), V(4,const char *), V(5,int)); break;
  case  26: ag_rp_28(V(1,const char *)); break;
  case  27: ag_rp_29(V(0,const char *)); break;
  case  28: V(0,int) = ag_rp_30(V(0,int)); break;
  case  29: V(0,const char *) = ag_rp_31(V(0,const char *)); break;
  case  30: V(0,const char *) = ag_rp_32(V(0,const char *)); break;
  case  31: V(0,const char *) = ag_rp_33(V(0,int)); break;
  case  32: V(0,const char *) = ag_rp_34(V(0,const char *), V(1,int)); break;
  case  33: V(0,const char *) = ag_rp_35(V(1,const char *)); break;
  case  34: V(0,const char *) = ag_rp_36(V(0,char)); break;
  case  35: V(0,const char *) = ag_rp_37(V(0,const char *), V(1,char)); break;
  case  36: V(0,char) = ag_rp_38(V(0,int)); break;
  case  37: V(0,char) = ag_rp_39(); break;
  case  38: V(0,char) = ag_rp_40(); break;
  case  39: V(0,int) = ag_rp_41(V(0,int)); break;
  case  40: V(0,int) = ag_rp_42(V(0,int), V(1,int)); break;
  case  41: V(0,int) = ag_rp_43(V(1,int)); break;
  case  42: V(0,int) = ag_rp_44(V(0,int), V(1,int)); break;
  case  43: V(0,int) = ag_rp_45(V(0,int)); break;
  case  44: V(0,int) = ag_rp_46(V(0,int), V(1,int)); break;
  case  45: V(0,int) = ag_rp_47(V(0,int)); break;
  case  46: V(0,int) = ag_rp_48(V(0,int)); break;
  case  47: V(0,int) = ag_rp_49(V(0,int)); break;
  case  48: V(0,int) = ag_rp_50(V(0,int)); break;
  case  49: V(0,int) = ag_rp_51(V(0,int), V(1,int)); break;
  case  50: V(0,int) = ag_rp_52(V(0,int), V(2,int)); break;
  case  51: V(0,int) = ag_rp_53(V(0,int), V(2,int)); break;
  case  52: V(0,int) = ag_rp_54(V(0,int), V(2,int)); break;
  case  53: V(0,int) = ag_rp_55(V(1,int)); break;
  case  54: V(0,int) = ag_rp_56(V(1,int)); break;
  }
}

#define TOKEN_NAMES parse_token_names
const char *parse_token_names[160] = {
  "file format",
  "identifier",
  "white space",
  "simple eol",
  "quoted string",
  "file format",
  "",
  "devices",
  "",
  "cache",
  "",
  "devinfo",
  "",
  "config",
  "eol",
  "",
  "device list",
  "",
  "eof",
  "",
  "character device",
  "",
  "",
  "block device",
  "",
  "number",
  "name",
  "cachedevice",
  "",
  "devicetype",
  "",
  "",
  "",
  "",
  "device block",
  "",
  "device header spec",
  "",
  "device decl",
  "",
  "",
  "",
  "",
  "ignoramus",
  "",
  "",
  "batch list",
  "batch item",
  "",
  "",
  "",
  "groupname",
  "",
  "procname",
  "",
  "class",
  "device tail",
  "",
  "expr",
  "device range",
  "",
  "",
  "",
  "hex number",
  "auto hex",
  "devname",
  "letter",
  "",
  "",
  "config decl",
  "",
  "class decl",
  "omit decl",
  "",
  "mode",
  "",
  "single omit",
  "",
  "octal number",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "qstring",
  "qstring char",
  "qchar",
  "",
  "digit",
  "",
  "",
  "",
  "hex digit",
  "",
  "",
  "octal digit",
  "term",
  "",
  "factor",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "letter",
  "",
  "",
  "",
  "simple eol",
  "identifier",
  "quoted string",
  "digit",
  "",
  "",
  "",
  "",
  "octal digit",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",

};

static char ag_msg[82];
static char ag_mst[] = "Missing %s";
static char ag_uet[] = "Unexpected %s";
static char ag_ac[4] = "' '";

static void ag_diagnose(void) {
  int ag_snd = (PCB).sn, ag_k;
  const char *ag_p;
  const char *ag_fmt = ag_uet;

  ag_k = ag_sbt[ag_snd];
  if (*TOKEN_NAMES[ag_tstt[ag_k]] && ag_astt[ag_k + 1] == ag_action_8) {
    ag_p = TOKEN_NAMES[ag_tstt[ag_k]];
    ag_fmt = ag_mst;
  }
  else if ((PCB).token_number && *TOKEN_NAMES[(PCB).token_number]) {
    ag_p = TOKEN_NAMES[(PCB).token_number];
  }
  else if (isprint((*(PCB).lab)) && (*(PCB).lab) != '\\') {
    ag_ac[1] = (*(PCB).lab);
    ag_p = ag_ac;
  }
  else ag_p = "input";
  sprintf(ag_msg, ag_fmt, ag_p);
  (PCB).error_message = ag_msg;


}
static int ag_action_1_r_proc(void);
static int ag_action_2_r_proc(void);
static int ag_action_3_r_proc(void);
static int ag_action_4_r_proc(void);
static int ag_action_1_s_proc(void);
static int ag_action_3_s_proc(void);
static int ag_action_1_proc(void);
static int ag_action_2_proc(void);
static int ag_action_3_proc(void);
static int ag_action_4_proc(void);
static int ag_action_5_proc(void);
static int ag_action_6_proc(void);
static int ag_action_7_proc(void);
static int ag_action_8_proc(void);
static int ag_action_9_proc(void);
static int ag_action_10_proc(void);
static int ag_action_11_proc(void);
static int ag_action_8_proc(void);


static int (*ag_r_procs_scan[])(void) = {
  ag_action_1_r_proc,
  ag_action_2_r_proc,
  ag_action_3_r_proc,
  ag_action_4_r_proc
};

static int (*ag_s_procs_scan[])(void) = {
  ag_action_1_s_proc,
  ag_action_2_r_proc,
  ag_action_3_s_proc,
  ag_action_4_r_proc
};

static int (*ag_gt_procs_scan[])(void) = {
  ag_action_1_proc,
  ag_action_2_proc,
  ag_action_3_proc,
  ag_action_4_proc,
  ag_action_5_proc,
  ag_action_6_proc,
  ag_action_7_proc,
  ag_action_8_proc,
  ag_action_9_proc,
  ag_action_10_proc,
  ag_action_11_proc,
  ag_action_8_proc
};


static int ag_action_10_proc(void) {
  (PCB).btsx = 0, (PCB).drt = -1;
  ag_track();
  return 0;
}

static int ag_action_11_proc(void) {
  (PCB).btsx = 0, (PCB).drt = -1;
  (*(int *) &(PCB).vs[(PCB).ssx]) = *(PCB).lab;
  (PCB).ssx--;
  ag_ra();
  (PCB).ssx++;
  ag_track();
  return 0;
}

static int ag_action_3_r_proc(void) {
  int ag_sd = ag_fl[ag_ap] - 1;
  if (ag_sd) (PCB).sn = (PCB).ss[(PCB).ssx -= ag_sd];
  (PCB).btsx = 0, (PCB).drt = -1;
  (PCB).reduction_token = (parse_token_type) ag_ptt[ag_ap];
  ag_ra();
  return 1;
}

static int ag_action_3_s_proc(void) {
  int ag_sd = ag_fl[ag_ap] - 1;
  if (ag_sd) (PCB).sn = (PCB).ss[(PCB).ssx -= ag_sd];
  (PCB).btsx = 0, (PCB).drt = -1;
  (PCB).reduction_token = (parse_token_type) ag_ptt[ag_ap];
  ag_ra();
  return 1;
}

static int ag_action_4_r_proc(void) {
  int ag_sd = ag_fl[ag_ap] - 1;
  if (ag_sd) (PCB).sn = (PCB).ss[(PCB).ssx -= ag_sd];
  (PCB).reduction_token = (parse_token_type) ag_ptt[ag_ap];
  return 1;
}

static int ag_action_2_proc(void) {
  (PCB).btsx = 0, (PCB).drt = -1;
  if ((PCB).ssx >= 38) {
    (PCB).exit_flag = AG_STACK_ERROR_CODE;
    PARSER_STACK_OVERFLOW;
  }
  (*(int *) &(PCB).vs[(PCB).ssx]) = *(PCB).lab;
  (PCB).ss[(PCB).ssx] = (PCB).sn;
  (PCB).ssx++;
  (PCB).sn = ag_ap;
  ag_track();
  return 0;
}

static int ag_action_9_proc(void) {
  if((PCB).drt == -1) {
    (PCB).drt=(PCB).token_number;
    (PCB).dssx=(PCB).ssx;
    (PCB).dsn=(PCB).sn;
  }
  ag_prot();
  (PCB).ss[(PCB).ssx] = (PCB).sn;
  (PCB).ssx++;
  (PCB).sn = ag_ap;
  (PCB).rx = 0;
  return (PCB).exit_flag == AG_RUNNING_CODE;
}

static int ag_action_2_r_proc(void) {
  (PCB).ssx++;
  (PCB).sn = ag_ap;
  return 0;
}

static int ag_action_7_proc(void) {
  --(PCB).ssx;
  (PCB).exit_flag = AG_SUCCESS_CODE;
  (PCB).rx = 0;
  return 0;
}

static int ag_action_1_proc(void) {
  (PCB).exit_flag = AG_SUCCESS_CODE;
  ag_track();
  return 0;
}

static int ag_action_1_r_proc(void) {
  (PCB).exit_flag = AG_SUCCESS_CODE;
  return 0;
}

static int ag_action_1_s_proc(void) {
  (PCB).exit_flag = AG_SUCCESS_CODE;
  return 0;
}

static int ag_action_4_proc(void) {
  int ag_sd = ag_fl[ag_ap] - 1;
  (PCB).reduction_token = (parse_token_type) ag_ptt[ag_ap];
  (PCB).btsx = 0, (PCB).drt = -1;
  (*(int *) &(PCB).vs[(PCB).ssx]) = *(PCB).lab;
  if (ag_sd) (PCB).sn = (PCB).ss[(PCB).ssx -= ag_sd];
  else (PCB).ss[(PCB).ssx] = (PCB).sn;
  ag_track();
  while ((PCB).exit_flag == AG_RUNNING_CODE) {
    unsigned ag_t1 = ag_sbe[(PCB).sn] + 1;
    unsigned ag_t2 = ag_sbt[(PCB).sn+1] - 1;
    do {
      unsigned ag_tx = (ag_t1 + ag_t2)/2;
      if (ag_tstt[ag_tx] < (const unsigned char)(PCB).reduction_token) ag_t1 = ag_tx + 1;
      else ag_t2 = ag_tx;
    } while (ag_t1 < ag_t2);
    ag_ap = ag_pstt[ag_t1];
    if ((ag_s_procs_scan[ag_astt[ag_t1]])() == 0) break;
  }
  return 0;
}

static int ag_action_3_proc(void) {
  int ag_sd = ag_fl[ag_ap] - 1;
  (PCB).btsx = 0, (PCB).drt = -1;
  (*(int *) &(PCB).vs[(PCB).ssx]) = *(PCB).lab;
  if (ag_sd) (PCB).sn = (PCB).ss[(PCB).ssx -= ag_sd];
  else (PCB).ss[(PCB).ssx] = (PCB).sn;
  ag_track();
  (PCB).reduction_token = (parse_token_type) ag_ptt[ag_ap];
  ag_ra();
  while ((PCB).exit_flag == AG_RUNNING_CODE) {
    unsigned ag_t1 = ag_sbe[(PCB).sn] + 1;
    unsigned ag_t2 = ag_sbt[(PCB).sn+1] - 1;
    do {
      unsigned ag_tx = (ag_t1 + ag_t2)/2;
      if (ag_tstt[ag_tx] < (const unsigned char)(PCB).reduction_token) ag_t1 = ag_tx + 1;
      else ag_t2 = ag_tx;
    } while (ag_t1 < ag_t2);
    ag_ap = ag_pstt[ag_t1];
    if ((ag_s_procs_scan[ag_astt[ag_t1]])() == 0) break;
  }
  return 0;
}

static int ag_action_8_proc(void) {
  ag_undo();
  (PCB).rx = 0;
  (PCB).exit_flag = AG_SYNTAX_ERROR_CODE;
  ag_diagnose();
  SYNTAX_ERROR;
  {(PCB).rx = 1; ag_track();}
  return (PCB).exit_flag == AG_RUNNING_CODE;
}

static int ag_action_5_proc(void) {
  int ag_sd = ag_fl[ag_ap];
  if((PCB).drt == -1) {
    (PCB).drt=(PCB).token_number;
    (PCB).dssx=(PCB).ssx;
    (PCB).dsn=(PCB).sn;
  }
  if (ag_sd) (PCB).sn = (PCB).ss[(PCB).ssx -= ag_sd];
  else {
    ag_prot();
    (PCB).ss[(PCB).ssx] = (PCB).sn;
  }
  (PCB).rx = 0;
  (PCB).reduction_token = (parse_token_type) ag_ptt[ag_ap];
  ag_ra();
  while ((PCB).exit_flag == AG_RUNNING_CODE) {
    unsigned ag_t1 = ag_sbe[(PCB).sn] + 1;
    unsigned ag_t2 = ag_sbt[(PCB).sn+1] - 1;
    do {
      unsigned ag_tx = (ag_t1 + ag_t2)/2;
      if (ag_tstt[ag_tx] < (const unsigned char)(PCB).reduction_token) ag_t1 = ag_tx + 1;
      else ag_t2 = ag_tx;
    } while (ag_t1 < ag_t2);
    ag_ap = ag_pstt[ag_t1];
    if ((ag_r_procs_scan[ag_astt[ag_t1]])() == 0) break;
  }
  return (PCB).exit_flag == AG_RUNNING_CODE;
}

static int ag_action_6_proc(void) {
  int ag_sd = ag_fl[ag_ap];
  (PCB).reduction_token = (parse_token_type) ag_ptt[ag_ap];
  if((PCB).drt == -1) {
    (PCB).drt=(PCB).token_number;
    (PCB).dssx=(PCB).ssx;
    (PCB).dsn=(PCB).sn;
  }
  if (ag_sd) {
    (PCB).sn = (PCB).ss[(PCB).ssx -= ag_sd];
  }
  else {
    ag_prot();
    (PCB).vs[(PCB).ssx] = ag_null_value;
    (PCB).ss[(PCB).ssx] = (PCB).sn;
  }
  (PCB).rx = 0;
  while ((PCB).exit_flag == AG_RUNNING_CODE) {
    unsigned ag_t1 = ag_sbe[(PCB).sn] + 1;
    unsigned ag_t2 = ag_sbt[(PCB).sn+1] - 1;
    do {
      unsigned ag_tx = (ag_t1 + ag_t2)/2;
      if (ag_tstt[ag_tx] < (const unsigned char)(PCB).reduction_token) ag_t1 = ag_tx + 1;
      else ag_t2 = ag_tx;
    } while (ag_t1 < ag_t2);
    ag_ap = ag_pstt[ag_t1];
    if ((ag_r_procs_scan[ag_astt[ag_t1]])() == 0) break;
  }
  return (PCB).exit_flag == AG_RUNNING_CODE;
}


void init_parse(void) {
  unsigned ag_t1 = 0;
  (PCB).rx = (PCB).fx = 0;
  (PCB).ss[0] = (PCB).sn = (PCB).ssx = 0;
  (PCB).exit_flag = AG_RUNNING_CODE;
  (PCB).key_sp = NULL;
  (PCB).key_state = 0;
  (PCB).line = FIRST_LINE;
   (PCB).column = FIRST_COLUMN;
  (PCB).btsx = 0, (PCB).drt = -1;
  while (ag_tstt[ag_t1] == 0) {
    ag_ap = ag_pstt[ag_t1];
    (ag_gt_procs_scan[ag_astt[ag_t1]])();
    ag_t1 = ag_sbt[(PCB).sn];
  }
}

void parse(void) {
  (PCB).lab[(PCB).fx++] = (PCB).input_code;
  while ((PCB).exit_flag == AG_RUNNING_CODE) {
    while (1) {
      unsigned char *ag_p;
      int ag_ch;
      if ((PCB).rx >= (PCB).fx) return;
      ag_ch = CONVERT_CASE((PCB).lab[(PCB).rx++]);
      if ((PCB).key_sp) {
        if (ag_ch != *(PCB).key_sp++) {
          (PCB).rx = (PCB).save_index;
          (PCB).key_sp = NULL;
          (PCB).key_state = 0;
          break;
        } else if (*(PCB).key_sp) continue;
        if (ag_key_act[(PCB).key_state] == ag_cf_end_key) {
          int ag_k1;
          int ag_k2;
          if ((PCB).rx >= (PCB).fx) {
            (PCB).rx--;
            (PCB).key_sp--;
            return;
          }
          (PCB).key_sp = NULL;
          ag_k1 = ag_key_parm[(PCB).key_state];
          ag_k2 = ag_key_pt[ag_k1];
          if (ag_key_itt[ag_k2 + CONVERT_CASE((PCB).lab[(PCB).rx])])
            (PCB).rx = (PCB).save_index;
          else {
            (PCB).token_number =  (parse_token_type) ag_key_pt[ag_k1+1];
            (PCB).key_state = 0;
          }
          break;
        }
        else {
          (PCB).token_number = (parse_token_type) ag_key_parm[(PCB).key_state];
          (PCB).key_state = 0;
          (PCB).key_sp = NULL;
        }
        break;
      }
      if ((PCB).key_state == 0) {
        (PCB).token_number = (parse_token_type) AG_TCV(ag_ch);
        if (((PCB).key_state = ag_key_index[(PCB).sn]) == 0) break;
        (PCB).save_index = 1;
      }
      ag_p = &ag_key_ch[(PCB).key_state];
      while (*ag_p < ag_ch) ag_p++;
      if (*ag_p == ag_ch) {
        (PCB).key_state = (int)(ag_p - ag_key_ch);
        switch (ag_key_act[(PCB).key_state]) {
        case ag_cf_set_key: {
          int ag_k1;
          int ag_k2;
          if ((PCB).rx >= (PCB).fx) {
            (PCB).rx--;
            return;
          }
          ag_k1 = ag_key_parm[(PCB).key_state];
          ag_k2 = ag_key_pt[ag_k1];
          (PCB).key_state = ag_key_jmp[(PCB).key_state];
          if (ag_key_itt[ag_k2 + CONVERT_CASE((PCB).lab[(PCB).rx])]) break;
          (PCB).save_index = (PCB).rx;
          (PCB).token_number = (parse_token_type) ag_key_pt[ag_k1+1];
          break;
        }
        case ag_set_key:
          (PCB).save_index = (PCB).rx;
          (PCB).token_number = (parse_token_type) ag_key_parm[(PCB).key_state];
        case ag_jmp_key:
          (PCB).key_state = ag_key_jmp[(PCB).key_state];
          continue;
        case ag_cf_end_key:
        case ag_end_key:
          (PCB).key_sp = ag_key_ends + ag_key_jmp[(PCB).key_state];
          continue;
        case ag_accept_key:
          (PCB).token_number = (parse_token_type) ag_key_parm[(PCB).key_state];
          (PCB).key_state = 0;
          break;
        case ag_cf_accept_key: {
          int ag_k1;
          int ag_k2;
          if ((PCB).rx >= (PCB).fx) {
            (PCB).rx--;
            return;
          }
          ag_k1 = ag_key_parm[(PCB).key_state];
          ag_k2 = ag_key_pt[ag_k1];
          if (ag_key_itt[ag_k2 + CONVERT_CASE((PCB).lab[(PCB).rx])])
            (PCB).rx = (PCB).save_index;
          else {
            (PCB).rx--;
            (PCB).token_number = (parse_token_type) ag_key_pt[ag_k1+1];
            (PCB).key_state = 0;
          }
          break;
        }
        }
        break;
      } else {
        (PCB).rx = (PCB).save_index;
        (PCB).key_state = 0;
        break;
      }
    }

    {
      unsigned ag_t1 = ag_sbt[(PCB).sn];
      unsigned ag_t2 = ag_sbe[(PCB).sn] - 1;
      do {
        unsigned ag_tx = (ag_t1 + ag_t2)/2;
        if (ag_tstt[ag_tx] > (const unsigned char)(PCB).token_number)
          ag_t1 = ag_tx + 1;
        else ag_t2 = ag_tx;
      } while (ag_t1 < ag_t2);
      if (ag_tstt[ag_t1] != (PCB).token_number)  ag_t1 = ag_sbe[(PCB).sn];
      ag_ap = ag_pstt[ag_t1];
      (ag_gt_procs_scan[ag_astt[ag_t1]])();
    }
  }

}


