/*
 *  linux/ibcs/stream.c
 *
 *  Copyright 1994, 1995  Mike Jagdis (jaggy@purplet.demon.co.uk)
 *
 * $Id: stream.c,v 1.4 1995/07/03 12:51:54 mike Exp $
 * $Source: /u3/CVS/ibcs/iBCSemul/stream.c,v $
 */

#include <linux/config.h>

#include <linux/module.h>
#include <linux/version.h>

#include <asm/segment.h>
#ifndef KERNEL_DS
#include <linux/segment.h>
#endif

#include <linux/types.h>
#include <linux/errno.h>
#include <linux/kernel.h>
#include <linux/ptrace.h>
#include <linux/net.h>
#include <linux/mm.h>
#include <linux/socket.h>

#include <ibcs/ibcs.h>
#include <ibcs/stream.h>
#include <ibcs/tli.h>

#ifdef IBCS_TRACE
#include <ibcs/trace.h>
#endif


/* We LIE and pretend that getmsg and putmsg succeeded. This is necessary
 * for the emulation of the /dev/spx interface to the local X server.
 * If you plan on implmenting these tread very carefully...
 */


int
ibcs_getmsg(struct pt_regs *regs)
{
	int fd;
	struct inode *ino;

	fd = (int)get_fs_long(((unsigned long *)regs->esp) + 1);

	if (!current->FD[fd]
	|| !(ino = current->FD[fd]->f_inode)
	|| !ino->i_sock)
		return -EBADF;

	/* Ignore the /dev/spx device used for local X connections. */
	if (MINOR(ino->i_rdev) == 1)
		return 0;

#ifdef EMU_XTI
	return timod_getmsg(fd, ino, regs);
#else
	return -EINVAL;
#endif /* EMU_XTI */
}


int
ibcs_putmsg(struct pt_regs *regs)
{
	int fd;
	struct inode *ino;

	fd = (int)get_fs_long(((unsigned long *)regs->esp) + 1);

	if (!current->FD[fd]
	|| !(ino = current->FD[fd]->f_inode)
	|| !ino->i_sock)
		return -EBADF;

	/* Ignore the /dev/spx device used for local X connections. */
	if (MINOR(ino->i_rdev) == 1)
		return 0;

#ifdef EMU_XTI
	return timod_putmsg(fd, ino, regs);
#else
	return -EINVAL;
#endif
}
