/*
 *  linux/ibcs/mmap.c
 *
 *  Copyright (C) 1994 Eric Youngdale
 *
 */
#include <linux/config.h>

#include <linux/module.h>
#include <linux/version.h>

#include <linux/mm.h>
#include <linux/errno.h>
#include <linux/mman.h>
#include <linux/sched.h>

#include <ibcs/ibcs.h>


int ibcs_mmap(unsigned int vaddr, unsigned int vsize, int prot, int flags,
	      int fd, unsigned int file_offset)
{
	struct file * file = NULL;

	if (!(flags & MAP_ANONYMOUS)) {
		if (fd >= NR_OPEN || !(file = current->FD[fd]))
			return -EBADF;
	}
	return do_mmap(file, vaddr, vsize, prot, flags, file_offset);
}
