% S-Lang mode is just a superset of C mode so make sure it is loaded.
!if (keymap_p ("C")) () = evalfile ("cmode");

$1 = "SLANG";

create_syntax_table ($1);
define_syntax ("%", "", '%', $1);
define_syntax ("([{", ")]}", '(', $1);
define_syntax ('"', '"', $1);
define_syntax ('\'', '\'', $1);
define_syntax ('\\', '\\', $1);
define_syntax ("0-9a-zA-Z_", 'w', $1);        % words
define_syntax ("-+0-9a-FA-F.xX", '0', $1);   % Numbers
define_syntax (",;:", ',', $1);
define_syntax ('#', '#', $1);
define_syntax ("%-+/&*=<>|!~^", '+', $1);

() = define_keywords ($1, "doifor", 2);
() = define_keywords ($1, "andfor", 3);
() = define_keywords ($1, "_forcaseelseloop", 4);
() = define_keywords ($1, "breakwhile", 5);
() = define_keywords ($1, "defineorelsereturnswitch", 6);
() = define_keywords ($1, "andelseforever", 7);
() = define_keywords ($1, "continuevariable", 8);
() = define_keywords ($1, "EXIT_BLOCK", 10);
() = define_keywords ($1, "ERROR_BLOCK", 11);

define slang_mode ()
{
   c_mode ();
   setmode("SL", 2 | 8);
   use_syntax_table ("SLANG");
   runhooks("slang_mode_hook");
}

