% This is a simple shell mode.  It does not defined any form of indentation
% style.  Rather, it simply implements a highlighting scheme.

$1 = "SH";

create_syntax_table ($1);
define_syntax ("#", "", '%', $1);
define_syntax ("([{", ")]}", '(', $1);
define_syntax ('"', '"', $1);
define_syntax ('\'', '\'', $1);
define_syntax ('\\', '\\', $1);
define_syntax ("-0-9a-zA-Z_", 'w', $1);        % words
define_syntax ("-+0-9", '0', $1);   % Numbers
define_syntax (",;:", ',', $1);
define_syntax ("%-+/&*=<>|!~^", '+', $1);

() = define_keywords ($1, "dofiif", 2);
() = define_keywords ($1, "set", 3);
() = define_keywords ($1, "casedoneechoelseesacexitthen", 4);
() = define_keywords ($1, "aliasendifendswshiftunsetwhile", 5);
() = define_keywords ($1, "setenvsourceswitch", 6);
() = define_keywords ($1, "breaksw", 7);

define sh_mode ()
{
   setmode("SH", 0);
   use_syntax_table ("SH");
   runhooks("sh_mode_hook");
}

