.TH ifc 1 "15 September 1989" "InterViews" "InterViews Reference Manual"
.SH NAME
ifc \- file chooser
.SH SYNOPSIS
.B ifc
.RI [ options ]
.RI [ path ]
.SH DESCRIPTION
The file chooser
.I ifc
displays a list of filenames and waits for you to choose one of the
filenames or type in a filename.  The filename need not exist already.
If the filename you choose or type in is a directory,
.I ifc
recursively displays a list of the filenames it contains.  When you
finally choose or type in a non-directory filename, 
.I ifc
prints the filename on standard output and exits.  You could use
.I ifc
in a script to prompt the user for a filename.
.SH ARGUMENTS
By default, 
.I ifc
displays a list of files in the user's home directory.  If
.I ifc
sees a single non-option argument on the command line, it will use the
argument as the path of a directory to open instead of the user's home
directory.
.PP
You may use any of the standard options accepted by all InterViews
programs in addition to the following options:
.TP
.BI \-caption " string"
Customize the prompt.  Defaults to ``Please select a file:''.
.TP
.BI \-subcaption " string"
Add a second line to the prompt.  No default.
.TP
.BI \-rows " number"
Customize the number of rows in the list of filenames.  Defaults to
10. 
.TP
.BI \-cols " number"
Customize the number of columns in the list of filenames.  Defaults to
24. 
.TP
.BI \-accept " string"
Customize the label of the accept button.  Defaults to `` Open ''.
.TP
.B \-static
Keep accepting filenames and printing them until the user presses the
cancel button instead of the accept button.  Defaults to false.
.PP
Each option also has a corresponding resource with the same name as
the option so you can use the resource database as well as options to
customize
.I ifc.
.SH MOUSE BINDINGS
The left mouse button selects a filename in the list of filenames or
text in the stringeditor.  The middle and right mouse buttons scroll
text in different ways.  Pressing and dragging the middle button
causes the text to move along with the mouse.  Pressing with the right
button and ``pushing up'' on the mouse causes the text to scroll
upwards at a rate dependent on the position of the mouse.  ``Pulling
down'' causes downwards scrolling.
.SH SEE ALSO
FileChooser(3I), StringEditor(3I)
