.TH Viewer 3U "6 October 1990" "Unidraw" "InterViews Reference Manual"
.SH NAME
Viewer \- displays a graphical component view hierarchy
.SH SYNOPSIS
.B #include <Unidraw/viewer.h>
.SH DESCRIPTION
A Viewer displays a graphical component view and provides an interface
to scrolling and zooming it.  The viewer also processes user input
events and generates the appropriate calls on Unidraw objects in
response.  The Viewer class is a derived from GraphicBlock; thus it
can draw the structured graphics hierarchy embodied in GraphicView's
graphic.  A viewer uses a damage object to keep the screen up to date.
Viewer's sensor catches up and down events, and its Handle implements
implements the tool manipulation loop.
.SH PUBLIC OPERATIONS
.TP
.B "Viewer("
.ns
.TP
.B "    Editor*, GraphicView*, Page*, Grid* = nil,"
.ns
.TP
.B "    Coord width = 0, Coord height = 0, Orientation = Normal,"
.ns
.TP
.B "    Alignment = Center, Zooming = Binary"
.ns
.TP
.B ")"
.ns
.TP
.B "Viewer("
.ns
.TP
.B "    const char*, Editor*, GraphicView*, Page*, Grid* = nil,"
.ns
.TP
.B "    Coord width = 0, Coord height = 0"
.ns
.TP
.B "    Alignment = Center, Zooming = Binary"
.ns
.TP
.B ")"
.br
Both constructors take the enclosing editor, the GraphicView object
that the viewer will display, a page object, and optionally a grid, a
natural width and height, initial page orientation, alignment, and
zooming specifications.  The second form adds a parameter for
specifying the Viewer's instance name.
.TP
.B "virtual void Update()"
Viewer augments GraphicBlock's Update semantics by repairing any
damage that has been accumulated.  In addition, Update will replace
its graphical view if its subject differs from the editor's component;
in that case, it will create a graphical view of the editor's
component, delete its own view, and replace it with the new one.
.TP
.B "virtual void Adjust(Perspective&)"
Viewer's Adjust operation will automatically update the editor's
MagnifVar (if it defines one) to reflect the current magnification.
.TP
.B "virtual void Handle(Event&)"
By default, Handle employs the editor's current tool on a LEFTMOUSE
down event.  On MIDDLEMOUSE or RIGHTMOUSE down events, it momentarily
engages the editor's MoveTool or SelectTool, respectively, allowing
the user to move or select a graphical component without changing the
current tool explicitly.  Nothing happens if the editor does not
define a keyboard equivalent for engaging these tools.  The Handle
function calls either the UseTool or MomentaryUseTool protected member
functions (described below) in response to these events.
.TP
.B "virtual void SetGraphicView(GraphicView*)"
.ns
.TP
.B "virtual void SetPage(Page*)"
.ns
.TP
.B "virtual void SetGrid(Grid*)"
.ns
.TP
.B "virtual GraphicView* GetGraphicView()"
.ns
.TP
.B "virtual Page* GetPage()"
.ns
.TP
.B "virtual Grid* GetGrid()"
.ns
.TP
.B "virtual Editor* GetEditor()"
Explicitly set or get a constructor-specified parameter.  The Set
operations delete the value they replace if it is different from the
given one.
.TP
.B "virtual void SetMagnification(float)"
Viewer's SetMagnification operation amends
GraphicBlock::SetMagnification to set the value of the enclosing
editor's MagnifVar, if it defines one.
.TP
.B "virtual void SetOrientation(Orientation)"
.ns
.TP
.B "virtual Orientation GetOrientation()"
Set and get the viewer's orientation parameter, which specifies
whether the graphical view, page, and grid will appear in portrait or
landscape mode.  No transformation will be applied in portrait mode,
while landscape mode will rotate the page -90 degrees and translate it
vertically by an amout equal to the width of the page's bounding box.
.TP
.B "virtual Selection* GetSelection()"
Return the enclosing editor's selection object; it is equivalent to
calling GetEditor and then calling GetSelection on the result.
.TP
.B "virtual Damage* GetDamage()"
Return the viewer's damage object.
.TP
.B "virtual void InitRubberband(Rubberband*)"
.ns
.TP
.B "virtual void InitTextDisplay(TextDisplay*, Painter*)"
These operations let Rubberband and TextDisplay instances appear to
work in a viewer by allowing them to draw on the viewer's canvas.
InitRubberband sets the rubberband's canvas to the viewer's and
initializes its painter as well.  InitTextDisplay likewise sets the
TextDisplay's canvas to the viewer's.  It also modifies the given
painter's background color to match the viewer's and supplies the
painter to the TextDisplay for its use.
.TP
.B "virtual void IncurTextDisplayDamage(TextDisplay*, Painter*)"
Incur minimal damage on the viewer's damage object to account for the
TextDisplay's current size.  The TextDisplay's painter must be passed
explicitly.
.TP
.B "virtual void CenterOp()"
.ns
.TP
.B "virtual void Magnify(Coord, Coord, Coord, Coord)"
.ns
.TP
.B "virtual void ReduceToFit()"
Convenience functions for adjusting the viewer's perspective.
CenterOp centers the page in the viewer's canvas without changing the
magnification.  Magnify scrolls and magnifies the given area (in
canvas coordinates) so that it fills the viewer's canvas.  Magnify
ensures that the area will remain fully visible in the viewer.
ReduceToFit scrolls and reduces the view so that the entire page is
visible.
.TP
.B "virtual void Constrain(Coord&, Coord&)"
Constrain the supplied coordinates to fall on the nearest grid point
if the viewer defines a grid and if the enclosing editor defines an
active GravityVar.
.TP
.B "virtual void UseTool(Tool*)"
Commence direct-manipulation with the given tool without an explicit
action on the user's part.  Normally, direct manipulation with the
currently engaged tool (as returned by the editor's GetCurTool
operation) starts automatically when the user clicks in the viewer.
.TP
.B "virtual void Align(GraphicComp*, Alignment)"
Align the graphical component with respect to viewer's canvas,
assuming a view of the component appears in the viewer.  For example,
a ``Center'' alignment will align the component's center with the
canvas'; a ``BottomLeft'' alignment will align the component's
bottom-left corner to the canvas'.
.SH PROTECTED OPERATIONS
.TP
.B "void Init("
.ns
.TP
.B "    Editor*, GraphicView*, Page*, Grid*,"
.ns
.TP
.B "    Coord, Coord, Orientation"
.ns
.TP
.B ")"
.ns
.TP
.B "void Init(Editor*, GraphicView*, Page*, Grid*)"
.br
Initialize the viewer's member variables.  The first form of this
operation initializes all parameters that can be passed to a
constructor.  The first form calls the second form, which initializes
a subset of the attributes that may change independently of the
others.
.TP
.B "Tool* CurTool()"
A convenience function equivalent to calling the same operation on the
enclosing editor.
.TP
.B "Transformer* GetTransformer()"
Return the transformer that the viewer uses to implement scrolling and
zooming.
.TP
.B "virtual void Manipulate(Manipulator*, Event&)"
This operation implements a direct manipulation loop governed by the
given manipulator.  First it calls Grasp on the manipulator with the
given event.  Then it reads events in a loop, calling the
manipulator's Manipulating operation with each new event.  When
Manipulating returns false, it calls Effect on the manipulator with
the event read last.
.TP
.B "virtual void UseTool(Tool*, Event&)"
.ns
.TP
.B "virtual void MomentaryUseTool(Tool*, Event&)"
Helper functions for initiating direct manipulation with tools and
executing their effect.  UseTool first instructs the given tool to
create a manipulator, and then it calls Manipulate to carry the
manipulation through to completion.  Next it asks the tool to
interpret the manipulator, which in turn may produce a command.
Finally, UseTool executes and logs the command produced.
MomentaryUseTool simply engages the given tool, calls UseTool, and
re-engages the original tool.
.TP
.B "virtual void Reorient()"
A helper function that rotates the viewer's graphic to reflect its
current orientation.
.TP
.B "virtual void UpdateMagnifVar()"
A helper function used in SetMagnification to notify the enclosing
viewer's MagnifVar (if it defines one) of the change in magnification.
.TP
.B "virtual ClassId ViewCategory()"
Returns the view category (see classes(3U)) the viewer will use to
instantiate a view if it is not given one explicitly.  ViewCategory
returns COMPONENT_VIEW by default.
.SH SEE ALSO
Damage(3U), Editor(3U), Event(3I), Graphic(3U), GraphicBlock(3U),
GraphicComp(3U), GraphicView(3U), Grid(3U), Manipulator(3U),
MoveTool(3U), Page(3U), Perspective(3I), Rubband(3I), SelectTool(3U),
Selection(3U), Sensor(3I), TextDisplay(3I), Tool(3U), classes(3U),
globals(3U), statevars(3U)
