-----------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                              G N A T V S N                               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.97 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  This package spec holds version information for GNAT and GBIND. It should
--  be updated periodically to reflect changes and in partciular should be
--  updated when bugs in the bug log are fixed.

package Gnatvsn is

   Gnat_Version_String : constant String := "2.04";
   --  Version output when GNAT itself is run (with -gnatv switch set)

   Gnatbind_Version_String : constant String := "2.04";
   --  Version output when GNATBIND is run (with -gnatv switch set)

   Gnatmake_Version_String : constant String := "2.04";
   --  Version output when GNATMAKE is run (with -v switch set)

   Xref_Version : constant String (1 .. 16) := "XREF v1.1       ";
   --  Xref version. Written in the xref files generated by gnatf.

   Library_Version : constant String (1 .. 16) := "GNAT Lib v1.2   ";
   --  Library version. This value must be updated whenever any change to the
   --  compiler affects the library formats in such a way as to obsolete
   --  previously compiled library modules.

   Standard_Version : String (1 .. 16)  := "                ";
   --  A string identifying the version of Standard. Used for library output
   --  and by the binder to check that all modules use the same version of
   --  Standard (otherwise the bind is not permitted). This is updated
   --  whenever a change to Standard requires complete recompilation. The
   --  actual value of this string is established by the Stand package when
   --  package Standard is constructed.

end Gnatvsn;
