/****************************************************************************/
/*                                                                          */
/*                         GNAT COMPILER COMPONENTS                         */
/*                                                                          */
/*                             A - S T R I N G                              */
/*                                                                          */
/*                              C Header File                               */
/*                                                                          */
/*                            $Revision: 1.7 $                              */
/*                                                                          */
/*           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 2,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License */
/* for  more details.  You should have  received  a copy of the GNU General */
/* Public License  distributed with GNAT;  see file COPYING.  If not, write */
/* to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */
/*                                                                          */
/****************************************************************************/

/* This file is the C file that corresponds to the Ada package spec	     */
/* Stringt. It was created manually from stringt.ads and stringt.adb         */

/* Note: only the access functions are provided, since the tree transformer  */
/* is not allowed to modify the tree or its auxiliary structures.	     */

/* This package contains routines for handling the strings table which is    */
/* used to store string constants encountered in the source, and also those  */
/* additional string constants generated by compile time concatenation and   */
/* other similar processing.						     */

/* A string constant in this table consists of a series of Char_Code values, */
/* so that 16-bit character codes can be properly handled if this feature    */
/* is implemented in the scanner.					     */

/* There is no guarantee that hashing is used in the implementation. This    */
/* means that the caller cannot count on having the same Id value for two    */
/* identical strings stored separately. 				     */

   /* The String_Id values reference entries in the Strings table, which     */
   /* contains String_Entry records that record the length of each stored    */
   /* string and its starting location in the String_Chars table.	     */

   struct String_Entry {
      Int String_Index;
      Int Length;
   };

   extern struct String_Entry *Strings_Ptr;
   /* Pointer to string entry vector. This pointer is passed to the tree     */
   /* transformer and stored in a global location for access from here	     */
   /* after subtracting String_First_Entry, so that String_Id values can be  */
   /* used as subscripts into the vector.				     */

   extern Char_Code *String_Chars_Ptr;
   /* Pointer to name characters table. This pointer is passed to the tree   */
   /* transformer and stored in a global location for access from here. The  */
   /* String_Index values are subscripts into this array.		     */


   /* String_Length returns the length of the specified string		     */

   INLINE Int String_Length (String_Id Id)
      { return Strings_Ptr [Id].Length; }


   /* Get_String_Char obtains the specified character from a stored string.  */
   /* The lower bound of stored strings is always 1, so the range of values  */
   /* is 1 to String_Length (Id).					     */

   INLINE Char_Code Get_String_Char (String_Id Id, Int Index)
      { return String_Chars_Ptr [Strings_Ptr [Id].String_Index + Index - 1]; }

/* End of a-string.h (C version of Stringt package spec and body) */
