/****************************************************************************/
/*                                                                          */
/*                         GNAT RUN-TIME COMPONENTS                         */
/*                                                                          */
/*              Auxiliary C functions for Interfaces.C.Streams              */
/*                                                                          */
/*                                   Body                                   */
/*                                                                          */
/*                              $Revision: 1.10 $                            */
/*                                                                          */
/*               Copyright (c) 1995 NYU, All Rights Reserved                */
/*                                                                          */
/* The GNAT library is free software; you can redistribute it and/or modify */
/* it under terms of the GNU Library General Public License as published by */
/* the Free Software  Foundation; either version 2, or (at your option) any */
/* later version.  The GNAT library is distributed in the hope that it will */
/* be useful, but WITHOUT ANY WARRANTY;  without even  the implied warranty */
/* of MERCHANTABILITY  or  FITNESS FOR  A PARTICULAR PURPOSE.  See the  GNU */
/* Library  General  Public  License for  more  details.  You  should  have */
/* received  a copy of the GNU  Library  General Public License  along with */
/* the GNAT library;  see the file  COPYING.LIB.  If not, write to the Free */
/* Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.        */
/*                                                                          */
/****************************************************************************/

/* Routines required for implementing routines in Interfaces.C.Streams */

#include "config.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>

#if defined (__EMX__) || defined (WINNT)
#include <stdlib.h>
int max_path_len = _MAX_PATH;
#else
#include <sys/param.h>
int max_path_len = MAXPATHLEN;
#endif

int feof__ (FILE *stream)
{
   return (feof (stream));
}

int ferror__ (FILE *stream)
{
   return (ferror (stream));
}

int fileno__ (FILE *stream)
{
   return (fileno (stream));
}

int
is_regular_file_fd (fd)
     int fd;
{
  int ret;
  struct stat statbuf;

  ret = fstat (fd, &statbuf);
  return (!ret && S_ISREG (statbuf.st_mode));
}

/* on some systems, the constants for seek are not defined, if so, then
   provide the conventional definitions */
#ifndef SEEK_SET
#define SEEK_SET 0  /* Set file pointer to offset                           */
#define SEEK_CUR 1  /* Set file pointer to its current value plus offset    */
#define SEEK_END 2  /* Set file pointer to the size of the file plus offset */
#endif

int    c_constant_eof      = EOF;
int    c_constant_iofbf    = _IOFBF;
int    c_constant_iolbf    = _IOLBF;
int    c_constant_ionbf    = _IONBF;
int    c_constant_seek_cur = SEEK_CUR;
int    c_constant_seek_end = SEEK_END;
int    c_constant_seek_set = SEEK_SET;

FILE*  c_constant_stderr () {return stderr;}
FILE*  c_constant_stdin  () {return stdin;}
FILE*  c_constant_stdout () {return stdout;}


char *
full_name (char *nam, char *buffer)
{
   char *p;
#if defined (__EMX__) || defined (WINNT)
   _fullpath (buffer, nam, max_path_len);
   for (p = buffer; *p; p++) if (*p == '/') *p = '\\';

#else
#if defined (DOS)
   _fixpath (nam, buffer);
#else
   extern char *getwd();
   if (nam[0] != '/') {
      buffer = getwd (buffer);
      strcat (buffer, "/");
      strcat (buffer, nam);
   }
   else {
      strcpy (buffer, nam);
   }
#endif
#endif
}
