------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                       S Y S T E M . V A L _ D E C                        --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.1 $                              --
--                                                                          --
--        Copyright (c) 1992,1993,1994,1995 NYU, All Rights Reserved        --
--                                                                          --
-- The GNAT library is free software; you can redistribute it and/or modify --
-- it under terms of the GNU Library General Public License as published by --
-- the Free Software  Foundation; either version 2, or (at your option) any --
-- later version.  The GNAT library is distributed in the hope that it will --
-- be useful, but WITHOUT ANY WARRANTY;  without even  the implied warranty --
-- of MERCHANTABILITY  or  FITNESS FOR  A PARTICULAR PURPOSE.  See the  GNU --
-- Library  General  Public  License for  more  details.  You  should  have --
-- received  a copy of the GNU  Library  General Public License  along with --
-- the GNAT library;  see the file  COPYING.LIB.  If not, write to the Free --
-- Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.        --
--                                                                          --
------------------------------------------------------------------------------

with System.Val_Real; use System.Val_Real;

package body System.Val_Dec is

   ------------------
   -- Scan_Decimal --
   ------------------

   --  For decimal types where Size < Integer'Size, it is fine to use
   --  the floating-point circuit, since it certainly has sufficient
   --  precision for any reasonable hardware, and we just don't support
   --  things on junk hardware!

   function Scan_Decimal
     (Str   : String;
      Ptr   : access Positive'Base;
      Max   : Positive'Base;
      Scale : Integer)
      return  Integer
   is
      Val : Long_Long_Float;

   begin
      Val := Scan_Real (Str, Ptr, Max);
      return Integer (Val * 10.0 ** Scale);
   end Scan_Decimal;

   -------------------
   -- Value_Decimal --
   -------------------

   --  Again, we use the real circuit for this purpose

   function Value_Decimal (Str : String; Scale : Integer) return Integer is
   begin
      return Integer (Value_Real (Str) * 10.0 ** Scale);
   end Value_Decimal;

end System.Val_Dec;
