------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                       A D A . S T O R A G E _ I O                        --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.6 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- The GNAT library is free software; you can redistribute it and/or modify --
-- it under terms of the GNU Library General Public License as published by --
-- the Free Software  Foundation; either version 2, or (at your option) any --
-- later version.  The GNAT library is distributed in the hope that it will --
-- be useful, but WITHOUT ANY WARRANTY;  without even  the implied warranty --
-- of MERCHANTABILITY  or  FITNESS FOR  A PARTICULAR PURPOSE.  See the  GNU --
-- Library  General  Public  License for  more  details.  You  should  have --
-- received  a copy of the GNU  Library  General Public License  along with --
-- the GNAT library;  see the file  COPYING.LIB.  If not, write to the Free --
-- Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.        --
--                                                                          --
------------------------------------------------------------------------------

with System.Address_To_Access_Conversions;

package body Ada.Storage_IO is

   package Element_Ops is new
     System.Address_To_Access_Conversions (Element_Type);

   ----------
   -- Read --
   ----------

   procedure Read (Buffer : in  Buffer_Type; Item : out Element_Type) is
   begin
      Element_Ops.To_Pointer (Item'Address).all :=
        Element_Ops.To_Pointer (Buffer'Address).all;
   end Read;


   -----------
   -- Write --
   -----------

   procedure Write (Buffer : out Buffer_Type; Item : in  Element_Type) is
   begin
      Element_Ops.To_Pointer (Buffer'Address).all :=
        Element_Ops.To_Pointer (Item'Address).all;
   end Write;

end Ada.Storage_IO;
