
#ifndef __RawImageLoader__
#define __RawImageLoader__

#include <stdlib.h>
#include <iostream.h>
#include "Bitmap.h"
#include "cfclass.h"

// The RawImageLoader class demonstrates a class derived from ImageLoader
// to load in "version 4 HSI raw image files" stored in a .cf file.

// this is the header for version 4 HSI raw files
class RawHeader
    {
    public:
   	unsigned char	magic[6];
    	unsigned char	version[2];
    	unsigned char	width[2];
    	unsigned char	height[2];
    	unsigned char	palSize[2];
    	unsigned char	Hdpi[2];
    	unsigned char	Vdpi[2];
    	unsigned char	gamma[2];
    	unsigned char	reserved[12];
    };


class RawImageLoader : public ImageLoader
    {
    public:
	RawImageLoader( cfc &cfile ) : Vcfile( &cfile )
		{};

	// by default, load both image and palette.
	int	loadFile( const char *file, char flags );

	int	loadHeader(const char *file);
	void	displayHeader();
	
    private:    
    	cfc	*Vcfile;

	
    	union 
    		{
		RawHeader	header;
    		unsigned char	headerBuf[ sizeof(RawHeader) ];
    		};

	static unsigned char Vmagic[];

	// to ensure no endian ordering problems, this will convert
	// the 2 byte numbers from the header into integers.
	int	bti( const unsigned char p[2] ) const;

    };

#endif
