.\" $XConsortium: xterm.man,v 1.80 94/04/17 19:01:03 rws Exp $
.\" Copyright (c) 1989  X Consortium
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\" 
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.TH XTERM 1 "Release 6" "X Version 11"
.SH NAME
xterm \- terminal emulator for X
.SH SYNOPSIS
.B xterm
[\-\fItoolkitoption\fP ...] [\-option ...]
.SH DESCRIPTION
The \fIxterm\fP program is a terminal emulator for the X Window System.
It provides DEC VT102 and Tektronix 4014 
compatible terminals for programs that can't
use the window system directly.  If the underlying operating system supports 
terminal resizing capabilities (for example, the SIGWINCH signal in systems 
derived from 4.3bsd), \fIxterm\fP will use the facilities to notify programs 
running in the window whenever it is resized.
.PP
The VT102 and Tektronix 4014 terminals each have their own window so that you
can edit text in one and look at graphics in the other at the same time.
To maintain the correct aspect ratio (height/width), Tektronix graphics will
be restricted to the largest box with a 4014's aspect ratio that will fit in 
the window.  This box is located in the upper left area of the window.
.PP
Although both windows may be displayed at the same time, one of them is 
considered the ``active'' window for receiving keyboard input and terminal
output.  This is the window that contains the text cursor.
The active window can be chosen through escape sequences,
the ``VT Options'' menu in the VT102 window, and the ``Tek Options''
menu in the 4014 window.
.SH EMULATIONS
The VT102 emulation is fairly complete, but does not support
smooth scrolling, VT52 mode,
the blinking
character attribute nor the double-wide and double-size character sets.
.IR Termcap (5)
entries that work with
.I xterm
include ``xterm,'' ``vt102,'' ``vt100'' and ``ansi,'' and
.I xterm
automatically searches the termcap file in this order for these entries and then
sets the ``TERM'' and the ``TERMCAP'' environment variables.
.PP
Many of the special
.I xterm
features may be modified under program control
through a set of escape sequences different from the standard VT102 escape
sequences.  
(See the
.I "Xterm Control Sequences"
document.)
.PP
The Tektronix 4014 emulation is also fairly good.
It supports 12-bit graphics addressing, scaled to the window size.
Four different font sizes and five different lines types are supported.
There is no write-through or defocused mode support.
The Tektronix text and graphics commands are recorded internally by
.I xterm
and may be written to a file by sending the COPY escape sequence (or through
the
.B Tektronix
menu; see below).
The name of the file will be
``\fBCOPY\fIyy\fB\-\fIMM\fB\-\fIdd\fB.\fIhh\fB:\fImm\fB:\fIss\fR'', where
.IR yy ,
.IR MM ,
.IR dd ,
.IR hh ,
.I mm
and
.I ss
are the year, month, day, hour, minute and second when the COPY was performed
(the file is created in the directory
.I xterm
is started in, or the home directory for a login
.IR xterm ).
.SH "OTHER FEATURES"
.I Xterm
automatically highlights the text cursor when the
pointer enters the window (selected) and unhighlights it when the pointer
leaves the window (unselected).
If the window is the focus window, then the text cursor is
highlighted no matter where the pointer is.
.PP
In VT102 mode, there are escape sequences to activate and deactivate
an alternate screen buffer, which is the same size as the display area
of the window.
When activated, the current screen is saved and replaced with the alternate
screen.
Saving of lines scrolled off the top of the window is disabled until the
normal screen is restored.
The
.IR termcap (5)
entry for
.I xterm
allows the visual editor
.IR vi (1)
to switch to the alternate screen for editing and to restore the screen
on exit.  
.PP
In either VT102 or Tektronix mode, there are escape sequences to change the
name of the windows.
See \fIXterm Control Sequences\fP for details.
.SH OPTIONS
The \fIxterm\fP terminal emulator 
accepts all of the standard X Toolkit command line options as well as
the following (if the option begins with a
.RB ` + '
instead of a
.RB ` \- ',
the option is restored to its default value):
.TP 8
.B \-help
This causes \fIxterm\fP to print out a verbose message describing its options.
.TP 8
.B \-132
Normally, the VT102 DECCOLM escape sequence that switches between 80 and
132 column mode is ignored.
This option causes the DECCOLM escape sequence to be recognized, and the
.I xterm
window will resize appropriately.
.TP 8
.B \-ah
This option indicates that 
.I xterm
should always highlight the text cursor.  By default,
.I xterm
will display a hollow text cursor whenever the focus is lost or the 
pointer leaves the window.
.TP 8
.B \+ah
This option indicates that
.I xterm
should do text cursor highlighting based on focus.
.TP 8
.BI \-b " number"
This option specifies the size of the inner border (the distance between
the outer edge of the characters and the window border) in pixels.  The
default is 2.
.TP 8
.B "\-cb"
Set the \fIvt100\fP resource \fBcutToBeginningOfLine\fP to FALSE.
.TP 8
.B "\+cb"
Set the \fIvt100\fP resource \fBcutToBeginningOfLine\fP to TRUE.
.TP 8
.B "\-cc \fIcharacterclassrange\fP:\fIvalue\fP[,...]"
This sets classes indicated by the given ranges for using in selecting by
words.  See the section specifying character classes.
.TP 8
.B "\-cn"
This option indicates that newlines should not be cut in line-mode 
selections.
.TP 8
.B \+cn
This option indicates that newlines should be cut in line-mode selections.
.TP 8
.BI \-cr " color"
This option specifies the color to use for text cursor.  The default is to
use the same foreground color that is used for text.
.TP 8
.B \-cu
This option indicates that \fIxterm\fP should work around a bug in the
.IR more (1)
program that causes it
to incorrectly display lines that are exactly the width of the window and
are followed by a line beginning with a tab
(the leading tabs are not displayed).
This option is so named because it was originally thought to be a bug
in the
.IR curses (3x)
cursor motion package.
.TP 8
.B \+cu
This option indicates that \fIxterm\fP should not work around the
.IR more (3x)
bug mentioned above.
.TP 8
.BI \-e " program \fP[ \fIarguments \fP.\|.\|. ]\fI"
This option specifies the program (and its command line arguments) to be
run in the \fIxterm\fP window.  It also sets the window title and icon
name to be the basename of the program being executed if neither \fI\-T\fP
nor \fI\-n\fP are given on the command line.  \fBThis must be the last 
option on the command line.\fP
.TP 8
.BI \-fb " font"
This option specifies a font to be used when displaying bold text.  
This font must be the same height and width as the normal font.
If only one of the normal or bold fonts is specified, it will be used as the
normal font and the bold font will be produced by overstriking this font.
The default is to do overstriking of the normal font.
.TP 8
.B \-im
Turn on the \fBuseInsertMode\fP resource.
.TP 8
.B +im
Turn off the \fBuseInsertMode\fP resource.
.TP 8
.B \-j
This option indicates that \fIxterm\fP should do jump scrolling.  Normally,
text is scrolled one line at a time; this option allows \fIxterm\fP to move
multiple lines at a time so that it doesn't fall as far behind.  Its use is
strongly recommended since it make \fIxterm\fP much faster when scanning
through large amounts of text.  The VT100 escape sequences for enabling and
disabling smooth scroll as well as the ``VT Options''
menu can be used to turn this
feature on or off.
.TP 8
.B \+j
This option indicates that \fIxterm\fP should not do jump scrolling.
.TP 8
.B \-ls
This option indicates that the shell that is started in the \fIxterm\fP window
will be a login shell (i.e., the first character of argv[0] will be a dash,
indicating to the shell that it should read the user's .login or .profile).
.TP 8
.B \+ls
This option indicates that the shell that is started should not be a login
shell (i.e. it will be a normal ``subshell'').
.TP 8
.B \-mb
This option indicates that \fIxterm\fP should ring a margin bell when
the user types near the right end of a line.  This option can be turned on 
and off from the ``VT Options'' menu.
.TP 8
.B \+mb
This option indicates that margin bell should not be rung.
.TP 8
.B "\-mc milliseconds"
This option specifies the maximum time between multi-click selections.
.TP 8
.BI \-ms " color"
This option specifies the color to be used for the pointer cursor.  The default
is to use the foreground color.
.TP 8
.BI \-nb " number"
This option specifies the number of characters from the right end of a line
at which the margin bell, if enabled, will ring.  The default is 10.
.TP 8
.B \-rw
This option indicates that reverse-wraparound should be allowed.  This allows
the cursor to back up from the leftmost column of one line to the rightmost
column of the previous line.  This is very useful for editing long shell
command lines and is encouraged.  This option can be turned on and off from
the ``VT Options'' menu.
.TP 8
.B \+rw
This option indicates that reverse-wraparound should not be allowed.
.TP 8
.B \-aw
This option indicates that auto-wraparound should be allowed.  This
allows the cursor to automatically wrap to the beginning of the next
line when when it is at the rightmost position of a line and text is
output.
.TP 8
.B \+aw
This option indicates that auto-wraparound should not be allowed.
.TP 8
.B \-s
This option indicates that \fIxterm\fP may scroll asynchronously, meaning that
the screen does not have to be kept completely up to date while scrolling.
This allows \fIxterm\fP to run faster when network latencies are very high
and is typically useful when running across a very large internet or many
gateways.
.TP 8
.B \+s
This option indicates that \fIxterm\fP should scroll synchronously.
.TP 8
.B \-sb
This option indicates that some number of lines that are scrolled off the top 
of the window should be saved and that a scrollbar should be displayed so that
those lines can be viewed.  This option may be turned on and off from the
``VT Options'' menu.
.TP 8
.B \+sb
This option indicates that a scrollbar should not be displayed.
.TP 8
.B \-sf
This option indicates that Sun Function Key escape codes should be generated
for function keys.
.TP 8
.B \+sf
This option indicates that the standard escape codes should be generated for
function keys.
.TP 8
.B \-si
This option indicates that output to a window should not automatically
reposition the screen to the bottom of the scrolling region.  
This option can be turned on and off from the ``VT Options'' menu.
.TP 8
.B \+si
This option indicates that output to a window should cause it to
scroll to the bottom.
.TP 8
.B \-sk
This option indicates that pressing a key while 
using the scrollbar to review previous lines of text should
cause the window to be repositioned automatically in the normal position at the
bottom of the scroll region.
.TP 8
.B \+sk
This option indicates that pressing a key while using the scrollbar
should not cause the window to be repositioned.
.TP 8
.BI \-sl " number"
This option specifies the number of lines to save that have been scrolled 
off the top of the screen.  The default is 64.
.TP 8
.B \-t
This option indicates that \fIxterm\fP should start in Tektronix mode, rather
than in VT102 mode.  Switching between the two windows is done using the
``Options'' menus.
.TP 8
.B \+t
This option indicates that \fIxterm\fP should start in VT102 mode.
.TP 8
.BI \-tm " string"
This option specifies a series of terminal setting keywords followed by the
characters that should be bound to those functions, similar to the \fIstty\fP
program.  Allowable keywords include: intr, quit, erase, kill, eof,
eol, swtch, start, stop, brk, susp, dsusp, rprnt, flush, weras, and lnext.
Control characters may be specified as ^char (e.g. ^c or ^u) and ^? may be 
used to indicate delete.
.TP 8
.BI \-tn " name"
This option specifies the name of the terminal type to be set in the TERM
environment variable.  This terminal type must exist in the \fItermcap(5)\fP
database and should have \fIli#\fP and \fIco#\fP entries.
.TP 8
.B \-ut
This option indicates that \fIxterm\fP shouldn't write a record into the 
the system log file \fI/etc/utmp\fP.
.TP 8
.B \+ut
This option indicates that \fIxterm\fP should write a record into the system
log file \fI/etc/utmp\fP.
.TP 8
.B \-vb
This option indicates that a visual bell is preferred over an audible one.
Instead of ringing the terminal bell whenever a Control-G is received, the
window will be flashed.
.TP 8
.B \+vb
This option indicates that a visual bell should not be used.
.TP 8
.B \-wf
This option indicates that \fIxterm\fP should wait for the window to be mapped
the first time before starting the subprocess so that the initial terminal
size settings and environment variables are correct.  It is the application's
responsibility to catch subsequent terminal size changes.
.TP 8
.B \+wf
This option indicates that \fIxterm\fP show not wait before starting the
subprocess.
.TP 8
.B \-C
This option indicates that this window should receive console output.  This
is not supported on all systems.  To obtain console output, you must be the
owner of the console device, and you must have read and write permission
for it.  If you are running X under \fIxdm\fP on the console screen you may
need to have the session startup and reset programs explicitly change the
ownership of the console device in order to get this option to work.
.TP 8
.B \-S\fIccn\fP
This option specifies the last two letters of the name of a pseudoterminal
to use in slave mode, plus the number of the inherited file descriptor.
The option is parsed ``%c%c%d''.
This allows \fIxterm\fP to be used as an input and
output channel for an existing program and is sometimes used in specialized
applications.
.PP
The following command line arguments are provided for compatibility with
older versions.  They may not be supported in the next release as the X 
Toolkit provides standard options that accomplish the same task.
.TP 8
.B "%\fIgeom\fP"
This option specifies the preferred size and position of the Tektronix window.
It is shorthand for specifying the ``\fI*tekGeometry\fP'' resource.
.TP 8
.B \#\fIgeom\fP
This option specifies the preferred position of the icon window.
It is shorthand for specifying the ``\fI*iconGeometry\fP'' resource.
.TP 8
.BI \-T " string"
This option specifies the title for \fIxterm\fP's windows.
It is equivalent to \fB\-title\fP.
.TP 8
.BI \-n " string"
This option specifies the icon name for \fIxterm\fP's windows.
It is shorthand for specifying the ``\fI*iconName\fP'' resource.
Note that this is not the same as the toolkit option \fB\-name\fP (see below).
The default icon name is the application name.
.TP 8
.B \-r
This option indicates that reverse video should be simulated by swapping
the foreground and background colors.  It is equivalent to
\fB\-rv\fP.
.TP 8
.BI \-w " number"
This option specifies the width in pixels of the border surrounding the window.
It is equivalent to \fB\-borderwidth\fP or \fB\-bw\fP.
.PP
The following standard X Toolkit command line arguments are commonly used 
with \fIxterm\fP:
.TP 8
.B \-bg \fIcolor\fP
This option specifies the color to use for the background of the window.  
The default is ``white.''
.TP 8
.B \-bd \fIcolor\fP
This option specifies the color to use for the border of the window.
The default is ``black.''
.TP 8
.B \-bw \fInumber\fP
This option specifies the width in pixels of the border surrounding the window.
.TP 8
.B \-fg \fIcolor\fP
This option specifies the color to use for displaying text.  The default is 
``black.''
.TP 8
.B \-fn \fIfont\fP
This option specifies the font to be used for displaying normal text.  The
default is \fIfixed\fP.
.TP 8
.B \-name \fIname\fP
This option specifies the application name under which resources are to be
obtained, rather than the default executable file name.
\fIName\fP should not contain ``.'' or ``*'' characters.
.TP 8
.B \-title \fIstring\fP
This option specifies the window title string, which may be displayed by
window managers if the user so chooses.  The default title is the command
line specified after the \fB\-e\fP option, if any, otherwise the application
name.
.TP 8
.B \-rv
This option indicates that reverse video should be simulated by swapping
the foreground and background colors.
.TP 8
.B \-geometry \fIgeometry\fP
This option specifies the preferred size and position of the VT102 window;
see \fIX(1)\fP.
.TP 8
.B \-display \fIdisplay\fP
This option specifies the X server to contact; see \fIX(1)\fP.
.TP 8
.B \-xrm \fIresourcestring\fP
This option specifies a resource string to be used.  This is especially
useful for setting resources that do not have separate command line options.
.TP 8
.B \-iconic
This option indicates that \fIxterm\fP should ask the window manager to 
start it as an icon rather than as the normal window.
.SH RESOURCES
The program understands all of the core X Toolkit resource names and
classes as well as:
.\".in +1in
.TP 8
.B "iconGeometry (\fPclass\fB IconGeometry)"
Specifies the preferred size and position of the application when iconified.
It is not necessarily obeyed by all window managers.
.TP 8
.B "iconName (\fPclass\fB IconName)"
Specifies the icon name.  The default is the application name.
.TP 8
.B "termName (\fPclass\fB TermName)"
Specifies the terminal type name to be set in the TERM environment variable.
.TP 8
.B "title (\fPclass\fB Title)"
Specifies a string that may be used by the window manager when displaying
this application.
.TP 8
.B "ttyModes (\fPclass\fB TtyModes)"
Specifies a string containing terminal setting keywords and the characters
to which they may be bound.  Allowable keywords include: intr, quit, 
erase, kill, eof, eol, swtch, start, stop, brk, susp, dsusp, rprnt, flush, 
weras, and lnext.  Control characters may be specified as ^char (e.g. ^c or ^u)
and ^? may be used to indicate Delete.  This is very useful for overriding
the default terminal settings without having to do an \fIstty\fP every time
an \fIxterm\fP is started.
.TP 8
.B "useInsertMode (\fPclass\fB UseInsertMode)
Force use of insert mode by adding appropriate entries to the TERMCAP
environment variable.  This is useful if the system termcap is broken.
The default is ``false.''
.TP 8
.B "utmpInhibit (\fPclass\fB UtmpInhibit)"
Specifies whether or not \fIxterm\fP should try to record the user's terminal
in \fI/etc/utmp\fP.
.TP 8
.B "sunFunctionKeys (\fPclass\fB SunFunctionKeys)"
Specifies whether or not Sun Function Key escape codes should be generated for
function keys instead of standard escape sequences.
.\".in -1in
.TP 8
.B "waitForMap (\fPclass\fB WaitForMap)"
Specifies whether or not \fIxterm\fP should wait for the initial window map
before starting the subprocess.  The default is ``false.''
.\".in 11in
.sp
.PP
The following resources are specified as part of the \fIvt100\fP widget (class
\fIVT100\fP):
.\".in +1in
.TP 8
.B "allowSendEvents (\fPclass\fB AllowSendEvents)"
Specifies whether or not synthetic key and button events (generated using
the X protocol SendEvent request) should be interpreted or discarded.
The default is ``false'' meaning they are discarded.  Note that allowing
such events creates a very large security hole.
.sp
.TP 8
.B "alwaysHighlight (\fPclass\fB AlwaysHighlight)"
Specifies whether or not \fIxterm\fP should always display a highlighted 
text cursor.  By default, a hollow text cursor is displayed whenever the
pointer moves out of the window or the window loses the input focus.
.TP 8
.B "appcursorDefault (\fPclass\fB AppcursorDefault)"
If ``true,'' the cursor keys are initially in application mode.
The default is ``false.''
.TP 8
.B "appkeypadDefault (\fPclass\fB AppkeypadDefault)"
If ``true,'' the keypad keys are initially in application mode.
The default is ``false.''
.TP 8
.B "autoWrap (\fPclass\fB AutoWrap)"
Specifies whether or not auto-wraparound should be enabled.  The
default is ``true.''
.TP 8
.B "bellSuppressTime (\fPclass\fB BellSuppressTime)"
Number of milliseconds after a bell command is sent during which additional
bells will be suppressed.  Default is 200.  If set non-zero,
additional bells
will also be suppressed until the server reports that processing of
the first bell has been completed; this feature is most useful with
the visible bell.
.TP 8
.B "boldFont (\fPclass\fB BoldFont)"
Specifies the name of the bold font to use instead of overstriking.
.TP 8
.B "c132 (\fPclass\fB C132)"
Specifies whether or not the VT102 DECCOLM escape sequence should be honored.
The default is ``false.''
.TP 8
.B "cutNewline (\fPclass\fB CutNewline)"
If false, triple clicking to select a line does not include the Newline
at the end of the line.
If true, the Newline is selected.
The default is ``true.''
.TP 8
.B "cutToBeginningOfLine (\fPclass\fB CutToBeginningOfLine)"
If false, triple clicking to select a line selects only from the
current word forward.
If true, the entire line is selected.
The default is ``true.''
.TP 8
.B "charClass (\fPclass\fB CharClass)"
Specifies comma-separated lists of character class bindings of the form
[\fIlow\fP\-]\fIhigh\fP:\fIvalue\fP.  These are used in determining which
sets of characters should be treated the same when doing cut and paste.
See the section on specifying character classes.
.TP 8
.B "curses (\fPclass\fB Curses)"
Specifies whether or not the last column bug in
.IR more (1)
should be worked around.  See the \fB\-cu\fP option for details.
The default is ``false.''
.TP 8
.B "background (\fPclass\fB Background)"
Specifies the color to use for the background of the window.  The default is 
``white.''
.TP 8
.B "foreground (\fPclass\fB Foreground)"
Specifies the color to use for displaying text in the window.  Setting the
class name instead of the instance name is an easy way to have everything
that would normally appear in the text color change color.  The default
is ``black.''
.TP 8
.B "cursorColor (\fPclass\fB Foreground)"
Specifies the color to use for the text cursor.  The default is ``black.''
.TP 8
.B "eightBitInput (\fPclass\fB EightBitInput\fP)"
If true, Meta characters input from the keyboard are presented as a
single character with the eighth bit turned on.
If false, Meta characters are converted into a two-character
sequence with the character itself preceded by ESC.
The default is ``true.''
.TP 8
.B "eightBitOutput (\fPclass\fB EightBitOutput\fP)"
Specifies whether or not eight-bit characters sent from the host should be
accepted as is or stripped when printed.  The default is ``true.''
.TP 8
.B "font (\fPclass\fB Font)"
Specifies the name of the normal font.  The default is ``fixed.''
.TP 8
.B "font1 (\fPclass\fB Font1)"
Specifies the name of the first alternative font.
.TP 8
.B "font2 (\fPclass\fB Font2)"
Specifies the name of the second alternative font.
.TP 8
.B "font3 (\fPclass\fB Font3)"
Specifies the name of the third alternative font.
.TP 8
.B "font4 (\fPclass\fB Font4)"
Specifies the name of the fourth alternative font.
.TP 8
.B "font5 (\fPclass\fB Font5)"
Specifies the name of the fifth alternative font.
.TP 8
.B "font6 (\fPclass\fB Font6)"
Specifies the name of the sixth alternative font.
.TP 8
.B "geometry (\fPclass\fB Geometry)"
Specifies the preferred size and position of the VT102 window.
.TP 8
.B "hpLowerleftBugCompat (\fPclass\fB HpLowerleftBugCompat)"
Specifies whether to work around a bug in HP's \fIxdb\fP,
which ignores termcap and always sends
ESC F to move to the lower left corner.
``true'' causes xterm to interpret ESC F as a request to move to the
lower left corner of the screen.  The default is ``false.''
.TP 8
.B "internalBorder (\fPclass\fB BorderWidth)"
Specifies the number of pixels between the characters and the window border.
The default is 2.
.TP 8
.B "jumpScroll (\fPclass\fB JumpScroll)"
Specifies whether or not jump scroll should be used.  The default is ``true.''
.TP 8
.B "loginShell (\fPclass\fB LoginShell)"
Specifies whether or not the shell to be run in the window should be started
as a login shell.  The default is ``false.''
.TP 8
.B "marginBell (\fPclass\fB MarginBell)"
Specifies whether or not the bell should be run when the user types near the
right margin.  The default is ``false.''
.TP 8
.B "multiClickTime (\fPclass\fB MultiClickTime)"
Specifies the maximum time in milliseconds between multi-click select
events.  The default is 250 milliseconds.
.TP 8
.B "multiScroll (\fPclass\fB MultiScroll)"
Specifies whether or not scrolling should be done asynchronously.  The default
is ``false.''
.TP 8
.B "nMarginBell (\fPclass\fB Column)"
Specifies the number of characters from the right margin at which the margin
bell should be rung, when enabled.
.TP 8
.B "pointerColor (\fPclass\fB Foreground)"
Specifies the foreground color of the pointer.  The default is 
``XtDefaultForeground.''
.TP 8
.B "pointerColorBackground (\fPclass\fB Background)"
Specifies the background color of the pointer.  The default is
``XtDefaultBackground.''
.TP 8
.B "pointerShape (\fPclass\fB Cursor)"
Specifies the name of the shape of the pointer.  The default is ``xterm.''
.TP 8
.B "resizeGravity (\fPclass\fB ResizeGravity)"
Affects the behavior when the window is resized to be taller or
shorter.  \fBNorthWest\fP
specifies that the top line of text on the screen stay fixed.  If the window
is made shorter, lines are dropped from the bottom; if the window is
made taller, blank lines are added at the bottom.  This is compatible
with the behavior in R4.  \fBSouthWest\fP (the default) specifies that
the bottom line of text on the screen stay fixed.  If the window is
made taller, additional saved lines will be scrolled down onto the
screen; if the window is made shorter, lines will be scrolled off the
top of the screen, and the top saved lines will be dropped.
.TP 8
.B "reverseVideo (\fPclass\fB ReverseVideo)"
Specifies whether or not reverse video should be simulated.  The default is
``false.''
.TP 8
.B "reverseWrap (\fPclass\fB ReverseWrap)"
Specifies whether or not reverse-wraparound should be enabled.  The default is
``false.''
.TP 8
.B "saveLines (\fPclass\fB SaveLines)"
Specifies the number of lines to save beyond the top of the screen when a
scrollbar is turned on.  The default is 64.
.TP 8
.B "scrollBar (\fPclass\fB ScrollBar)"
Specifies whether or not the scrollbar should be displayed.  The default is
``false.''
.TP 8
.B "scrollTtyOutput (\fPclass\fB ScrollCond)"
Specifies whether or not output to the terminal should automatically cause
the scrollbar to go to the bottom of the scrolling region.  The default is
``true.''
.TP 8
.B "scrollKey (\fPclass\fB ScrollCond)"
Specifies whether or not pressing a key should automatically cause the
scrollbar to go to the bottom of the scrolling region.  The default is
``false.''
.TP 8
.B "scrollLines (\fPclass\fB ScrollLines)"
Specifies the number of lines that the \fIscroll-back\fP and
\fIscroll-forw\fP actions should use as a default.  The default value is 1.
.TP 8
.B "signalInhibit (\fPclass\fB SignalInhibit)"
Specifies whether or not the entries in the ``Main Options'' menu for sending
signals to \fIxterm\fP should be disallowed.  The default is ``false.''
.TP 8
.B "tekGeometry (\fPclass\fB Geometry)"
Specifies the preferred size and position of the Tektronix window.
.TP 8
.B "tekInhibit (\fPclass\fB TekInhibit)"
Specifies whether or not
the escape sequence to enter
Tektronix mode should be ignored.  The default is
``false.''
.TP 8
.B "tekSmall (\fPclass\fB TekSmall)"
Specifies whether or not the Tektronix mode window should start in its smallest
size if no explicit geometry is given.  This is useful when running \fIxterm\fP
on displays with small screens.  The default is ``false.''
.TP 8
.B "tekStartup (\fPclass\fB TekStartup)"
Specifies whether or not \fIxterm\fP should start up in Tektronix mode.
The default is ``false.''
.TP 8
.B "titeInhibit (\fPclass\fB TiteInhibit)"
Specifies whether or not \fIxterm\fP should remove remove \fIti\fP and \fIte\fP
termcap entries (used to switch between alternate screens on startup of many
screen-oriented programs) from the TERMCAP string.  If set,
\fIxterm\fP also ignores the escape sequence to switch to the
alternate screen.
.TP 8
.B "translations (\fPclass\fB Translations)"
Specifies the key and button bindings for menus, selections, ``programmed
strings,'' etc.  See \fBACTIONS\fP below.
.TP 8
.B "visualBell (\fPclass\fB VisualBell)"
Specifies whether or not a visible bell (i.e. flashing) should be used instead
of an audible bell when Control-G is received.  The default is ``false.''
.sp
.PP
The following resources are specified as part of the \fItek4014\fP widget
(class \fITek4014\fP):
.\".in +1in
.TP 8
.B "width (\fPclass\fB Width)"
Specifies the width of the Tektronix window in pixels.
.TP 8
.B "height (\fPclass\fB Height)"
Specifies the height of the Tektronix window in pixels.
.TP 8
.B "fontLarge (\fPclass\fB Font)"
Specifies the large font to use in the Tektronix window.
.TP 8
.B "font2 (\fPclass\fB Font)"
Specifies font number 2 to use in the Tektronix window.
.TP 8
.B "font3 (\fPclass\fB Font)"
Specifies font number 3 to use in the Tektronix window.
.TP 8
.B "fontSmall (\fPclass\fB Font)"
Specifies the small font to use in the Tektronix window.
.TP 8
.B "initialFont (\fPclass\fB InitialFont)"
Specifies which of the four Tektronix fonts to use initially.
Values are the same as for the \fIset-tek-text\fP action.
The default is ``large.''
.TP 8
.B "ginTerminator (\fPclass\fB GinTerminator)"
Specifies what character(s) should follow a GIN report or status report.
The possibilities are ``none,'' which sends no terminating characters,
``CRonly,'' which sends CR, and ``CR&EOT,'' which sends both CR and EOT.
The default is ``none.''
.\".in -1in
.sp
.PP
The resources that may be specified for the various menus are described in
the documentation for the Athena \fBSimpleMenu\fP widget.  The name and classes
of the entries in each of the menus are listed below.
.PP
The \fImainMenu\fP has the following entries:
.\".in +1in
.TP 8
.B "securekbd (\fPclass\fB SmeBSB)"
This entry invokes the \fBsecure()\fP action.
.TP 8
.B "allowsends (\fPclass\fB SmeBSB)"
This entry invokes the \fBallow-send-events(toggle)\fP action.
.TP 8
.B "redraw (\fPclass\fB SmeBSB)"
This entry invokes the \fBredraw()\fP action.
.TP 8
.B "line1 (\fPclass\fB SmeLine)"
This is a separator.
.TP 8
.B "suspend (\fPclass\fB SmeBSB)"
This entry invokes the \fBsend-signal(tstp)\fP action on systems that
support job control.
.TP 8
.B "continue (\fPclass\fB SmeBSB)"
This entry invokes the \fBsend-signal(cont)\fP action on systems that
support job control.
.TP 8
.B "interrupt (\fPclass\fB SmeBSB)"
This entry invokes the \fBsend-signal(int)\fP action.
.TP 8
.B "hangup (\fPclass\fB SmeBSB)"
This entry invokes the \fBsend-signal(hup)\fP action.
.TP 8
.B "terminate (\fPclass\fB SmeBSB)"
This entry invokes the \fBsend-signal(term)\fP action.
.TP 8
.B "kill (\fPclass\fB SmeBSB)"
This entry invokes the \fBsend-signal(kill)\fP action.
.TP 8
.B "line2 (\fPclass\fB SmeLine)"
This is a separator.
.TP 8
.B "quit (\fPclass\fB SmeBSB)"
This entry invokes the \fBquit()\fP action.
.\".in -1in
.sp
.PP
The \fIvtMenu\fP has the following entries:
.\".in +1in
.TP 8
.B "scrollbar (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-scrollbar(toggle)\fP action.
.TP 8
.B "jumpscroll (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-jumpscroll(toggle)\fP action.
.TP 8
.B "reversevideo (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-reverse-video(toggle)\fP action.
.TP 8
.B "autowrap (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-autowrap(toggle)\fP action.
.TP 8
.B "reversewrap (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-reversewrap(toggle)\fP action.
.TP 8
.B "autolinefeed (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-autolinefeed(toggle)\fP action.
.TP 8
.B "appcursor (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-appcursor(toggle)\fP action.
.TP 8
.B "appkeypad (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-appkeypad(toggle)\fP action.
.TP 8
.B "scrollkey (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-scroll-on-key(toggle)\fP action.
.TP 8
.B "scrollttyoutput (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-scroll-on-tty-output(toggle)\fP action.
.TP 8
.B "allow132 (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-allow132(toggle)\fP action.
.TP 8
.B "cursesemul (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-cursesemul(toggle)\fP action.
.TP 8
.B "visualbell (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-visualbell(toggle)\fP action.
.TP 8
.B "marginbell (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-marginbell(toggle)\fP action.
.TP 8
.B "altscreen (\fPclass\fB SmeBSB)"
This entry is currently disabled.
.TP 8
.B "line1 (\fPclass\fB SmeLine)"
This is a separator.
.TP 8
.B "softreset (\fPclass\fB SmeBSB)"
This entry invokes the \fBsoft-reset()\fP action.
.TP 8
.B "hardreset (\fPclass\fB SmeBSB)"
This entry invokes the \fBhard-reset()\fP action.
.TP 8
.B "clearsavedlines" (\fPclass\fB SmeBSB)"
This entry invokes the \fBclear-saved-lines()\fP action.
.TP 8
.B "line2 (\fPclass\fB SmeLine)"
This is a separator.
.TP 8
.B "tekshow (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-visibility(tek,toggle)\fP action.
.TP 8
.B "tekmode (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-terminal-type(tek)\fP action.
.TP 8
.B "vthide (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-visibility(vt,off)\fP action.
.\".in -1in
.sp
.PP
The \fIfontMenu\fP has the following entries:
.\".in +1in
.TP 8
.B "fontdefault (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-vt-font(d)\fP action.
.TP 8
.B "font1 (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-vt-font(1)\fP action.
.TP 8
.B "font2 (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-vt-font(2)\fP action.
.TP 8
.B "font3 (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-vt-font(3)\fP action.
.TP 8
.B "font4 (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-vt-font(4)\fP action.
.TP 8
.B "font5 (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-vt-font(5)\fP action.
.TP 8
.B "font6 (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-vt-font(6)\fP action.
.TP 8
.B "fontescape (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-vt-font(e)\fP action.
.TP 8
.B "fontsel (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-vt-font(s)\fP action.
.\".in -1in
.sp
.PP
The \fItekMenu\fP has the following entries:
.\".in +1in
.TP 8
.B "tektextlarge (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-tek-text(l)\fP action.
.TP 8
.B "tektext2 (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-tek-text(2)\fP action.
.TP 8
.B "tektext3 (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-tek-text(3)\fP action.
.TP 8
.B "tektextsmall (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-tek-text(s)\fP action.
.TP 8
.B "line1 (\fPclass\fB SmeLine)"
This is a separator.
.TP 8
.B "tekpage (\fPclass\fB SmeBSB)"
This entry invokes the \fBtek-page()\fP action.
.TP 8
.B "tekreset (\fPclass\fB SmeBSB)"
This entry invokes the \fBtek-reset()\fP action.
.TP 8
.B "tekcopy (\fPclass\fB SmeBSB)"
This entry invokes the \fBtek-copy()\fP action.
.TP 8
.B "line2 (\fPclass\fB SmeLine)"
This is a separator.
.TP 8
.B "vtshow (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-visibility(vt,toggle)\fP action.
.TP 8
.B "vtmode (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-terminal-type(vt)\fP action.
.TP 8
.B "tekhide (\fPclass\fB SmeBSB)"
This entry invokes the \fBset-visibility(tek,toggle)\fP action.
.\".in -1in
.sp
.PP
The following resources are useful when specified for the Athena Scrollbar
widget:
.\".in +1in
.TP 8
.B "thickness (\fPclass\fB Thickness)"
Specifies the width in pixels of the scrollbar.
.TP 8
.B "background (\fPclass\fB Background)"
Specifies the color to use for the background of the scrollbar.
.TP 8
.B "foreground (\fPclass\fB Foreground)"
Specifies the color to use for the foreground of the scrollbar.  The ``thumb''
of the scrollbar is a simple checkerboard pattern alternating pixels for
foreground and background color.
.\".in -1in
.SH "POINTER USAGE"
.PP
Once the VT102 window is created,
.I xterm
allows you to select text and copy it within the same or other windows.
.PP
The selection functions are invoked when the pointer buttons are used with no
modifiers, and when they are used with the ``shift'' key.
The assignment of the functions described below to keys and buttons may
be changed through the resource database; see \fBACTIONS\fP below.
.PP
Pointer button one (usually left) is used to save text into the cut buffer.
Move the cursor to beginning of the text,
and then hold the button down while moving the cursor to the end of the region
and releasing the button.
The selected text is highlighted and is saved in the global cut buffer
and made the PRIMARY selection when
the button is released.  Double-clicking selects by words.  Triple-clicking
selects by lines.  Quadruple-clicking goes back to characters, etc.
Multiple-click is determined by the time from button up to
button down, so you can change the selection unit in the middle of a selection.
If the key/button bindings specify that an X selection is to be made,
\fIxterm\fP will leave the selected text highlighted for as long as it
is the selection owner.
.PP
Pointer button two (usually middle) `types' (pastes) the text from
the PRIMARY selection, if any, otherwise from
the cut buffer,
inserting it as keyboard input.
.PP
Pointer button three (usually right) extends the current selection.
(Without loss of generality,
you can swap ``right'' and ``left'' everywhere in the rest of this
paragraph.)  If pressed while closer to
the right edge of the selection than the left, it extends/contracts the
right edge of the selection.  If you contract the selection past
the left edge of the selection,
.I xterm
assumes you really meant the left edge, restores the original selection, then
extends/contracts the left edge of the selection.  Extension starts in the 
selection unit mode
that the last selection or extension was performed in; you can multiple-click
to cycle through them.
.PP
By cutting and pasting pieces of text without trailing new lines,
you can take text from several places in different windows and form a command
to the shell, for example, or take output from a program and insert it into
your favorite editor.
Since the cut buffer is globally shared among different applications,
you should regard it as a `file' whose contents you know.
The terminal emulator and other text programs should be treating it as if it
were a text file, i.e., the text is delimited by new lines.
.PP
The scroll region displays the position and amount of text currently showing
in the window (highlighted) relative to the amount of text actually saved.
As more text is saved (up to the maximum), the size of the highlighted area
decreases.  
.PP
Clicking button one with the pointer in the scroll region moves the
adjacent line to the top of the display window.
.PP
Clicking button three moves the top line of the display window down to the
pointer position.
.PP
Clicking button two moves the display to a position in the saved text
that corresponds to the pointer's position in the scrollbar.
.PP
.PP
Unlike the VT102 window, the Tektronix window dows not allow the copying of
text.
It does allow Tektronix GIN mode, and in this mode
the cursor will change from an arrow to a cross.
Pressing any key will send that key and the current coordinate of the
cross cursor.
Pressing button one, two, or three will return the letters `l', `m', and
`r', respectively.
If the `shift' key is pressed when a pointer button is pressed, the corresponding
upper case letter is sent.
To distinguish a pointer button from a key, the high bit of the character is
set (but this is bit is normally stripped unless the terminal mode is RAW;
see
.IR tty (4)
for details).
.SH MENUS
.PP
.I Xterm
has four menus, named
.IR mainMenu ,
.IR vtMenu ,
.IR fontMenu ,
and
.IR tekMenu .
Each menu pops up under the correct combinations of key and button presses.
Most menus are divided into two section, separated by a horizontal line.
The top portion contains various modes that can be altered.
A check mark appears next to a mode that is currently active.
Selecting one of these modes toggles its state.
The bottom portion of the menu are command entries; selecting one of these
performs the indicated function.
.PP
The
.B xterm
menu pops up when the ``control'' key and pointer button one are
pressed in a window.
The \fImainMenu\fP contains items that apply to both the VT102 and Tektronix
windows.
The
.B Secure Keyboard
mode is be used when typing in passwords or other sensitive data in an
unsecure environment;
see \fBSECURITY\fP below.
Notable entries in the command section of the menu are the
.BR Continue ,
.BR Suspend ,
.BR Interrupt ,
.BR Hangup ,
.B Terminate
and
.B Kill
which sends the SIGCONT, SIGTSTP, SIGINT, SIGHUP, SIGTERM and
SIGKILL signals, respectively, to the process group of the process running
under
.I xterm
(usually the shell).
The
.B Continue
function is especially useful if the user has accidentally typed CTRL-Z,
suspending the process.
.PP
The
.I vtMenu
sets various modes in the VT102 emulation, and is popped up when the
``control'' key and pointer button two are pressed in the VT102 window.
In the command section of this menu, the soft reset entry will reset
scroll regions.
This can be convenient when some program has left the scroll regions
set incorrectly (often a problem when using VMS or TOPS-20).
The full reset entry will clear the screen, reset tabs to every
eight columns, and reset the terminal modes (such as wrap and smooth scroll)
to their initial states just after
.I xterm
has finished processing the command line options.
.PP
The \fIfontMenu\fP sets the font used in the VT102 window.
In addition to the default font and a number of alternatives that are
set with resources, the menu offers the font last specified by the Set
Font escape sequence (see the document \fIXterm Control Sequences\fP)
and the current selection as a font name (if the PRIMARY selection is owned).
.PP
The
.I tekMenu
sets various modes in the Tektronix emulation, and is popped up when the
``control'' key and pointer button two are pressed in the Tektronix window.
The current font size is checked in the modes section of the menu.
The
.B PAGE
entry in the command section clears the Tektronix window.
.SH SECURITY
.PP
X environments differ in their security consciousness.  Most servers, run
under \fIxdm\fP, are capable of using a ``magic cookie'' authorization
scheme that can provide a reasonable level of security for many people.
If your server is only using a host-based mechanism to control access to
the server (see \fIxhost(1)\fP), then if you enable access for a host and
other users are also permitted to run clients on that same host, there is
every possibility that someone can run an application that will use the
basic services of the X protocol to snoop on your activities, potentially
capturing a transcript of everything you type at the keyboard.
This is of particular concern when you want to type in a password or other
sensitive data.  The best solution to this problem is to use a better
authorization mechanism that host-based control, but a simple
mechanism exists for protecting keyboard input in \fIxterm\fP.
.PP
The \fBxterm\fP menu (see \fBMENUS\fP above) contains a \fBSecure Keyboard\fP
entry which, when enabled, ensures that all keyboard input is directed
\fIonly\fP to \fIxterm\fP (using the GrabKeyboard protocol request).
When an application prompts you for a password
(or other sensitive data), you can enable \fBSecure Keyboard\fP using the
menu, type in the data, and then disable \fBSecure Keyboard\fP using
the menu again.  Only one X client at a time can secure the keyboard,
so when you attempt to enable \fBSecure Keyboard\fP it may fail.  In
this case, the bell will sound.  If the \fBSecure Keyboard\fP succeeds,
the foreground and background colors will be exchanged (as if you
selected the \fBReverse Video\fP entry in the \fBModes\fP menu);
they will be exchanged again when you exit secure mode.  If the colors
do \fInot\fP switch, then
you should be \fIvery\fP suspicious that you are being spoofed.  If
the application you are running displays a prompt before asking for
the password, it is safest to enter secure mode \fIbefore\fP the
prompt gets displayed, and to make sure that the prompt gets displayed
correctly (in the new colors), to minimize the probability of
spoofing.  You can also bring up the menu again and make sure that a check
mark appears next to the entry.
.PP
\fBSecure Keyboard\fP mode will be disabled automatically if your xterm
window becomes iconified (or otherwise unmapped), or if you start up
a reparenting window manager (that places a title bar or other decoration
around the window) while in \fBSecure Keyboard\fP mode.  (This is a
feature of the X protocol not easily overcome.)  When this happens,
the foreground and background colors will be switched back and the bell
will sound in warning.
.SH "CHARACTER CLASSES"
Clicking the middle mouse button twice in rapid succession will cause all
characters of the same class (e.g. letters, white space, punctuation) to be
selected.  Since different people have different preferences for what should
be selected (for example, should filenames be selected as a whole or only
the separate subnames), the default mapping can be overridden through the use 
of the \fIcharClass\fP (class \fICharClass\fP) resource.
.PP
This resource is a
series of comma-separated
of \fIrange\fP:\fIvalue\fP pairs.  The
\fIrange\fP is either a single number or \fIlow\fP-\fIhigh\fP in the range of 0
to 127, corresponding to the ASCII code for the character or characters to be
set.  The \fIvalue\fP is arbitrary, although the default table uses the
character number of the first character occurring in the set.
.PP
The default table is
.sp
.in +8
.ft C			\" Courier
.nf
static int charClass[128] = {
/* NUL  SOH  STX  ETX  EOT  ENQ  ACK  BEL */
    32,   1,   1,   1,   1,   1,   1,   1,
/*  BS   HT   NL   VT   NP   CR   SO   SI */
     1,  32,   1,   1,   1,   1,   1,   1,
/* DLE  DC1  DC2  DC3  DC4  NAK  SYN  ETB */
     1,   1,   1,   1,   1,   1,   1,   1,
/* CAN   EM  SUB  ESC   FS   GS   RS   US */
     1,   1,   1,   1,   1,   1,   1,   1,
/*  SP    !    "    #    $    %    &    ' */
    32,  33,  34,  35,  36,  37,  38,  39,
/*   (    )    *    +    ,    \-    .    / */
    40,  41,  42,  43,  44,  45,  46,  47,
/*   0    1    2    3    4    5    6    7 */
    48,  48,  48,  48,  48,  48,  48,  48,
/*   8    9    :    ;    <    =    >    ? */
    48,  48,  58,  59,  60,  61,  62,  63,
/*   @    A    B    C    D    E    F    G */
    64,  48,  48,  48,  48,  48,  48,  48,
/*   H    I    J    K    L    M    N    O */
    48,  48,  48,  48,  48,  48,  48,  48,
/*   P    Q    R    S    T    U    V    W */ 
    48,  48,  48,  48,  48,  48,  48,  48,
/*   X    Y    Z    [    \\    ]    ^    _ */
    48,  48,  48,  91,  92,  93,  94,  48,
/*   `    a    b    c    d    e    f    g */
    96,  48,  48,  48,  48,  48,  48,  48,
/*   h    i    j    k    l    m    n    o */
    48,  48,  48,  48,  48,  48,  48,  48,
/*   p    q    r    s    t    u    v    w */
    48,  48,  48,  48,  48,  48,  48,  48,
/*   x    y    z    {    |    }    ~  DEL */
    48,  48,  48, 123, 124, 125, 126,   1};
.fi
.ft P
.in -8
.sp
For example, the string ``33:48,37:48,45-47:48,64:48'' indicates that the
exclamation mark, percent sign, dash, period, slash, and ampersand characters
should be treated the same way as characters and numbers.  This is useful 
for cutting and pasting electronic mailing addresses and filenames.
.SH ACTIONS
It is possible to rebind keys (or sequences of keys) to arbitrary strings
for input, by changing the translations for the vt100 or tek4014 widgets.
Changing the translations for events other than key and button events
is not expected, and will cause unpredictable behavior.  The following
actions are provided for using within the \fIvt100\fP or \fItek4014\fP
\fBtranslations\fP resources:
.TP 8
.B "bell([\fIpercent\fP])"
This action rings the keyboard bell at the specified percentage
above or below the base volume.
.TP 8
.B "ignore()"
This action ignores the event but checks for special pointer position
escape sequences.
.TP 8
.B "insert()"
This action inserts the character or string associated with
the key that was pressed.
.TP 8
.B "insert-seven-bit()"
This action is a synonym for \fBinsert()\fP
.TP 8
.B "insert-eight-bit()"
This action inserts an eight-bit (Meta) version of the character or string
associated with the key that was pressed.
The exact action depends on the value of the \fBeightBitInput\fP resource.
.TP 8
.B "insert-selection(\fIsourcename\fP [, ...])"
This action inserts the string found in the selection or cutbuffer indicated
by \fIsourcename\fP.  Sources are checked in the order given (case is
significant) until one is found.  Commonly-used selections include:
\fIPRIMARY\fP, \fISECONDARY\fP, and \fICLIPBOARD\fP.  Cut buffers are 
typically named \fICUT_BUFFER0\fP through \fICUT_BUFFER7\fP.
.TP 8
.B "keymap(\fIname\fP)"
This action dynamically defines a new translation table whose resource 
name is \fIname\fP with the suffix \fIKeymap\fP (case is significant).
The name \fINone\fP restores the original translation table.
.TP 8
.B "popup-menu(\fImenuname\fP)"
This action displays the specified popup menu.  Valid names (case is 
significant) include:  \fImainMenu\fP, \fIvtMenu\fP, \fIfontMenu\fP, 
and \fItekMenu\fP.
.TP 8
.B "secure()"
This action toggles the \fISecure Keyboard\fP mode described in the
section named \fBSECURITY\fP, and is invoked from the \fBsecurekbd\fP
entry in \fImainMenu\fP.
.TP 8
.B "select-start()"
This action begins text selection at the current pointer location.  See
the section on \fBPOINTER USAGE\fP for information on making selections.
.TP 8
.B "select-extend()"
This action tracks the pointer and extends the selection.  It 
should only be bound to Motion events.
.TP 8
.B "select-end(\fIdestname\fP [, ...])"
This action puts the currently selected text into all of the selections or 
cutbuffers specified by \fIdestname\fP.
.TP 8
.B "select-cursor-start()"
This action is similar to \fBselect-start\fP except that it begins the
selection at the current text cursor position.
.TP 8
.B "select-cursor-end(\fIdestname\fP [, ...])"
This action is similar to \fBselect-end\fP except that it should be used
with \fBselect-cursor-start\fP.
.TP 8
.B "set-vt-font(\fId/1/2/3/4/5/6/e/s\fP [,\fInormalfont\fP [, \fIboldfont\fP]])"
This action sets the font or fonts currently being used in the VT102 window.
The first argument is a single character that specifies the font to be 
used: \fId\fP or \fID\fP indicate the default font (the font initially 
used when
\fIxterm\fP was started), \fI1\fP through \fI6\fP indicate the fonts 
specified by the \fIfont1\fP through \fIfont6\fP resources, \fIe\fP or \fIE\fP
indicate the normal and bold fonts that have been set through escape codes 
(or specified as the second and third action arguments, respectively), and
\fIs\fP or \fIS\fP indicate the font selection (as made by programs such as
\fIxfontsel(1)\fP) indicated by the second action argument.
.TP 8
.B "start-extend()"
This action is similar to \fBselect-start\fP except that the 
selection is extended to the current pointer location.
.TP 8
.B "start-cursor-extend()"
This action is similar to \fBselect-extend\fP except that the 
selection is extended to the current text cursor position.
.TP 8
.B "string(\fIstring\fP)"
This action inserts the specified text string as if it had been typed.
Quotation is necessary if the string contains whitespace or
non-alphanumeric characters.  If the string argument begins with the
characters ``0x'', it is interpreted
as a hex character constant.
.TP 8
.B "scroll-back(\fIcount\fP [,\fIunits\fP])"
This action scrolls the text window backward so that text that had previously
scrolled off the top of the screen is now visible.  The \fIcount\fP argument
indicates the number of \fIunits\fP (which may be \fIpage\fP, \fIhalfpage\fP,
\fIpixel\fP, or \fIline\fP) by which to scroll.
.TP 8
.B "scroll-forw(\fIcount\fP [,\fIunits\fP])"
This action scrolls is similar to \fBscroll-back\fP except that it scrolls
the other direction.
.TP 8
.B "allow-send-events(\fIon/off/toggle\fP)"
This action set or toggles the \fBallowSendEvents\fP resource and is also
invoked by the \fBallowsends\fP entry in \fImainMenu\fP.
.TP 8
.B "redraw()"
This action redraws the window and is also invoked by the
\fIredraw\fP entry in \fImainMenu\fP.
.TP 8
.B "send-signal(\fIsigname\fP)"
This action sends the signal named by \fIsigname\fP
to the \fIxterm\fP subprocess (the shell or program specified with
the \fI\-e\fP command line option) and is also invoked by the
.BR suspend ,
.BR continue ,
.BR interrupt ,
.BR hangup ,
.BR terminate ,
and
.BR kill 
entries in \fImainMenu\fP.  Allowable signal names are (case is
not significant):
\fItstp\fP (if supported by the operating system), \fIsuspend\fP (same
as \fItstp\fP), \fIcont\fP
(if supported by the operating system), \fIint\fP, \fIhup\fP, \fIterm\fP,
\fIquit\fP,
\fIalrm\fP, \fIalarm\fP (same as \fIalrm\fP) and \fIkill\fP.
.TP 8
.B "quit()"
This action sends a SIGHUP to the subprogram and exits.  It is also invoked
by the \fBquit\fP entry in \fImainMenu\fP.
.TP 8
.B "set-scrollbar(\fIon/off/toggle\fP)"
This action toggles the \fBscrollbar\fP resource and is also invoked by
the \fBscrollbar\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-jumpscroll(\fIon/off/toggle\fP)"
This action toggles the \fBjumpscroll\fP resource and is also invoked by the
\fBjumpscroll\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-reverse-video(\fIon/off/toggle\fP)"
This action toggles the \fIreverseVideo\fP resource and is also invoked by
the \fBreversevideo\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-autowrap(\fIon/off/toggle\fP)"
This action toggles automatic wrapping of long lines and is also invoked by
the \fBautowrap\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-reversewrap(\fIon/off/toggle\fP)"
This action toggles the \fBreverseWrap\fP resource and is also invoked by
the \fBreversewrap\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-autolinefeed(\fIon/off/toggle\fP)"
This action toggles automatic insertion of linefeeds and is also invoked by
the \fBautolinefeed\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-appcursor(\fIon/off/toggle\fP)"
This action toggles the handling Application Cursor Key mode 
and is also invoked by the \fBappcursor\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-appkeypad(\fIon/off/toggle\fP)"
This action toggles the handling of Application Keypad mode and is also 
invoked by the \fBappkeypad\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-scroll-on-key(\fIon/off/toggle\fP)"
This action toggles the \fBscrollKey\fP resource and is also invoked from
the \fBscrollkey\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-scroll-on-tty-output(\fIon/off/toggle\fP)"
This action toggles the \fBscrollTtyOutput\fP resource and is also invoked
from the \fBscrollttyoutput\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-allow132(\fIon/off/toggle\fP)"
This action toggles the \fBc132\fP resource and is also invoked from the
\fBallow132\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-cursesemul(\fIon/off/toggle\fP)"
This action toggles the \fBcurses\fP resource and is also invoked from the 
\fBcursesemul\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-visual-bell(\fIon/off/toggle\fP)"
This action toggles the \fBvisualBell\fP resource and is also invoked
by the \fBvisualbell\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-marginbell(\fIon/off/toggle\fP)"
This action toggles the \fBmarginBell\fP resource and is also invoked from 
the \fBmarginbell\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-altscreen(\fIon/off/toggle\fP)"
This action toggles between the alternate and current screens.
.TP 8
.B "soft-reset()"
This action resets the scrolling region and is also invoked from the 
\fBsoftreset\fP entry in \fIvtMenu\fP.
.TP 8
.B "hard-reset()"
This action resets the scrolling region, tabs, window size, and cursor keys
and clears the screen.  It is also invoked from the \fBhardreset\fP
entry in \fIvtMenu\fP.
.TP 8
.B "clear-saved-lines()"
This action does \fBhard-reset()\fP (see above) and also clears the history
of lines saved off the top of the screen.
It is also invoked from the \fBclearsavedlines\fP entry in \fIvtMenu\fP.
.TP 8
.B "set-terminal-type(\fItype\fP)"
This action directs output to either the \fIvt\fP or \fItek\fP windows,
according to the \fItype\fP string.  It is also invoked by the
\fBtekmode\fP entry in \fIvtMenu\fP and the \fBvtmode\fP entry in
\fItekMenu\fP. 
.TP 8
.B "set-visibility(\fIvt/tek\fP,\fIon/off/toggle\fP)"
This action controls whether or not the \fIvt\fP or \fItek\fP windows are
visible.  It is also invoked from the \fBtekshow\fP and \fBvthide\fP entries 
in \fIvtMenu\fP and the \fBvtshow\fP and \fBtekhide\fP entries in 
\fItekMenu\fP.
.TP 8
.B "set-tek-text(\fIlarge/2/3/small\fP)"
This action sets font used in the Tektronix window to the value of the 
resources \fBtektextlarge\fP, \fBtektext2\fP, \fBtektext3\fP, and
\fBtektextsmall\fP according to the argument.  It is also by the entries
of the same names as the resources in \fItekMenu\fP.
.TP 8
.B "tek-page()"
This action clears the Tektronix window and is also invoked by the
\fBtekpage\fP entry in \fItekMenu\fP.
.TP 8
.B "tek-reset()"
This action resets the Tektronix window and is also invoked by the
\fItekreset\fP entry in \fItekMenu\fP.
.TP 8
.B "tek-copy()"
This action copies the escape codes used to generate the current window
contents to a file in the current directory beginning with the name COPY.
It is also invoked from the \fItekcopy\fP entry in \fItekMenu\fP.
.TP 8
.B "visual-bell()"
This action flashes the window quickly.
.PP
The Tektronix window also has the following action:
.TP 8
.B "gin-press(\fIl/L/m/M/r/R\fP)"
This action sends the indicated graphics input code.
.PP
The default bindings in the VT102 window are:
.sp
.in +4
.DS
.TA 2.5i
.ta 2.5i
.nf
 Shift <KeyPress> Prior:	scroll-back(1,halfpage) \\n\\
  Shift <KeyPress> Next:	scroll-forw(1,halfpage) \\n\\
Shift <KeyPress> Select:	select-cursor-start() \\
	select-cursor-end(PRIMARY, CUT_BUFFER0) \\n\\
Shift <KeyPress> Insert:	insert-selection(PRIMARY, CUT_BUFFER0) \\n\\
        ~Meta<KeyPress>:	insert-seven-bit() \\n\\
         Meta<KeyPress>:	insert-eight-bit() \\n\\
       !Ctrl <Btn1Down>:	popup-menu(mainMenu) \\n\\
  !Lock Ctrl <Btn1Down>:	popup-menu(mainMenu) \\n\\
       ~Meta <Btn1Down>:	select-start() \\n\\
     ~Meta <Btn1Motion>:	select-extend() \\n\\
       !Ctrl <Btn2Down>:	popup-menu(vtMenu) \\n\\
  !Lock Ctrl <Btn2Down>:	popup-menu(vtMenu) \\n\\
 ~Ctrl ~Meta <Btn2Down>:	ignore() \\n\\
   ~Ctrl ~Meta <Btn2Up>:	insert-selection(PRIMARY, CUT_BUFFER0) \\n\\
       !Ctrl <Btn3Down>:	popup-menu(fontMenu) \\n\\
  !Lock Ctrl <Btn3Down>:	popup-menu(fontMenu) \\n\\
 ~Ctrl ~Meta <Btn3Down>:	start-extend() \\n\\
     ~Meta <Btn3Motion>:	select-extend() \\n\\
                <BtnUp>:	select-end(PRIMARY, CUT_BUFFER0) \\n\\
              <BtnDown>:	bell(0)
.fi
.DE
.sp
.in -4
.PP
The default bindings in the Tektronix window are:
.sp
.in +4
.DS
.TA 2.5i
.ta 2.5i
.nf
      ~Meta<KeyPress>: 	insert-seven-bit() \\n\\
       Meta<KeyPress>: 	insert-eight-bit() \\n\\
     !Ctrl <Btn1Down>: 	popup-menu(mainMenu) \\n\\
!Lock Ctrl <Btn1Down>: 	popup-menu(mainMenu) \\n\\
     !Ctrl <Btn2Down>: 	popup-menu(tekMenu) \\n\\
!Lock Ctrl <Btn2Down>: 	popup-menu(tekMenu) \\n\\
Shift ~Meta<Btn1Down>:	gin-press(L) \\n\\
      ~Meta<Btn1Down>:	gin-press(l) \\n\\
Shift ~Meta<Btn2Down>:	gin-press(M) \\n\\
      ~Meta<Btn2Down>:	gin-press(m) \\n\\
Shift ~Meta<Btn3Down>:	gin-press(R) \\n\\
      ~Meta<Btn3Down>:	gin-press(r)
.fi
.DE
.sp
.in -4
.PP
Below is a sample how of the \fBkeymap()\fP action is used to add special
keys for entering commonly-typed works:
.sp
.in +4
.nf
.DS
.TA .5i 1.5i
.ta .5i 1.5i
.nf
*VT100.Translations: #override <Key>F13: keymap(dbx)
*VT100.dbxKeymap.translations: \\
	<Key>F14:	keymap(None) \\n\\
	<Key>F17:	string("next") string(0x0d) \\n\\
	<Key>F18:	string("step") string(0x0d) \\n\\
	<Key>F19:	string("continue") string(0x0d) \\n\\
	<Key>F20:	string("print ") insert-selection(PRIMARY, CUT_BUFFER0)
.fi
.DE
.sp
.in -4
.SH ENVIRONMENT
.I Xterm
sets the environment variables ``TERM'' and ``TERMCAP'' properly for the
size window you have created.
It also uses and sets the environment
variable ``DISPLAY'' to specify which bit map display terminal to use.
The environment variable ``WINDOWID'' is set to the X window id number
of the
.I xterm
window.
.SH "SEE ALSO"
resize(1), X(1), pty(4), tty(4)
.br
\fIXterm Control Sequences\fP
.SH BUGS
.PP
Large pastes do not work on some systems.  This is not a bug in
\fIxterm\fP; it is a bug in the pseudo terminal driver of those
systems.  \fIxterm\fP feeds large pastes to the pty only as fast as the pty
will accept data, but some pty drivers do not return enough information
to know if the write has succeeded.
.PP
Many of the options are not resettable after
.I xterm
starts.
.PP
Only fixed-width, character-cell fonts are supported.
.PP
This program still needs to be rewritten.  It should be split into very
modular sections, with the various emulators being completely separate
widgets that don't know about each other.  Ideally, you'd like to be able to
pick and choose emulator widgets and stick them into a single control widget.
.PP
There needs to be a dialog box to allow entry of the Tek COPY file name.
.SH AUTHORS
Far too many people, including:
.sp
Loretta Guarino Reid (DEC-UEG-WSL), 
Joel McCormack (DEC-UEG-WSL), Terry Weissman (DEC-UEG-WSL),
Edward Moy (Berkeley), Ralph R. Swick (MIT-Athena),
Mark Vandevoorde (MIT-Athena), Bob McNamara (DEC-MAD),
Jim Gettys (MIT-Athena), Bob Scheifler (MIT X Consortium), Doug Mink (SAO),
Steve Pitschke (Stellar), Ron Newman (MIT-Athena), Jim Fulton (MIT X 
Consortium), Dave Serisky (HP), Jonathan Kamens (MIT-Athena)
