------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                              S E M _ R E S                               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.5 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  Resolution processing for all subexpression nodes. Note that the separate
--  package Sem_Aggr contains the actual resolution routines for aggregates,
--  which are separated off since aggregate processing is complex.

with Types; use Types;

package Sem_Res is

   --  As described in Sem_Ch4, the type resolution proceeds in two phases.
   --  The first phase is a bottom up pass that is achieved during the
   --  recursive traversal performed by the Analyze procedures. This phase
   --  determines unambiguous types, and collects sets of possible types
   --  where the interpretation is potentially ambiguous.

   --  On completing this bottom up pass, which corresponds to a call to
   --  Analyze on a complete context, the Resolve routine is called which
   --  performs a top down resolution with recursive calls to itself to
   --  resolve operands.

   --  Since in practice a lot of semantic analysis has to be postponed until
   --  types are known (e.g. static folding, setting of suppress flags), the
   --  Resolve routines also complete the semantic analyze, and also call the
   --  expander for possibly expansion of the completely type resolved node.

   procedure Resolve (N : Node_Id; Typ : Entity_Id);
   --  Top level type-checking procedure, called in a complete context. The
   --  construct N, which is a subexpression, has already been analyzed, and
   --  is required to be of type Typ given the analysis of the context (which
   --  uses the information gathered on the bottom up phase in Analyze). The
   --  resolve routines do various other processing, e.g. static evaluation.

end Sem_Res;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.3
--  date: Sun Jan  9 11:09:38 1994;  author: dewar
--  New header with 1994 copyright
--  ----------------------------
--  revision 1.4
--  date: Fri Feb 11 23:13:11 1994;  author: dewar
--  (Resolve): New name for both Resolve_Complete_Context and Resolve_Subexpr,
--   which for a while have been entirely identical in action.
--  ----------------------------
--  revision 1.5
--  date: Fri May 20 04:33:30 1994;  author: dewar
--  Minor reformatting and commenting.
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
