------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                           S Y S T E M . F I D                            --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.2 $                              --
--                                                                          --
--             Copyright (c) 1992,1993, NYU, All Rights Reserved            --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms  of the GNU  General  Public  License  as  published  by the  Free --
-- Software  Foundation;  either version 2,  or (at your option)  any later --
-- version.  GNAT is distributed  in the hope  that it will be useful,  but --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT- --
-- ABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public --
-- License  for  more details.  You should have received  a copy of the GNU --
-- General Public License along with GNAT;  see file COPYING. If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains the generic package which is instantiated with
--  predefined integer types to generate the runtime functions called by the
--  expanded code generated by Expand_Fixed_To_Integer_Division. This
--  is an implementation of Paul Hilfinger's algorithms.

package System.Fid is
pragma Pure (Fid);

   generic
      type Int_Type is range <>;

   package Fid_Util is

      function Compute_Result
        (X, Y, A, B, D, Beta1, Beta2 : Int_Type;
         M, N                        : Integer;
         Bool                        : Boolean)
         return                        Int_Type;
      --  X and Y correspond to the two values of the division (X / Y).
      --  A, B and M correspond to scaling factors (2**M * A / B).
      --  Beta1, Beta2, D and  N also correspond to scaling factors, using
      --   another representation then the precedents:
      --   (D / B + 2**N * Beta1 + Beta2)
      --  The boolean parameter is computed in the expander and corresponds to
      --   different cases of Hilfinger's algorithms. It enables this function
      --   to compute the result in different ways depending on its value.

   end Fid_Util;

end System.Fid;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.1
--  date: Mon Jul 18 14:27:24 1994;  author: crozes
--  Initial revision
--  ----------------------------
--  revision 1.2
--  date: Tue Aug  2 12:22:52 1994;  author: dewar
--  Add pragma Pure
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
