
typedef struct hist_entry {
    struct hist_entry *prev;
    struct hist_entry *next;
    char   *text;
} Hist;

typedef struct {
    int  start_x;		/* column input line position */
    int  start_y;		/* row input line position */
    int  point;			/* cursor position in the input line */
    int  mark;			/* The mark position */
    int  first_shown;		/* Index of the first shown character */
    int  current_max_len;	/* Maximum length of input line */
    int  field_len;		/* Lenght of the editing field */
    int  color;			/* color used */
    int  first;			/* Is first keystroke? */
    char *buffer;		/* pointer to editing buffer */
    char *kill_save;		/* Pointer to killed data */
    Hist *history;		/* The history */
    int  need_push;		/* need to psh the current Input on history? */
    WINDOW *window;		/* pointer to window descriptor */
} Input;

Input *create_input (int x, int y, WINDOW *win, int color, int field_len, char *def_text);
void destroy_input (Input *in, int flags);
void handle_char (Input *, int c_code);
void update_input (Input *in);
void new_input (Input *in);
void push_history (Input *in, char *text);
void stuff (Input *in, char *text, int insert_extra_space);

#define XCTRL(x) (x-'a'+1)
#define ALT(x) (0x80|x)

/* Flags for destroy_input */
#define IN_KEEP_BUFFER 1
#define IN_NORMAL 0
