/***************************************************************************
 * This program is Copyright (C) 1986, 1987, 1988 by Jonathan Payne.  JOVE *
 * is provided to you without charge, and with no warranty.  You may give  *
 * away copies of JOVE, including sources, provided that this notice is    *
 * included in all the files.                                              *
 ***************************************************************************/

/* NOTE WELL:
 * This file is "included" into iproc.c -- it is not compiled separately!
 */

#include <sys/time.h>
#include <fcntl.h>
#include "ttystate.h"

#define isdead(p)	((p) == NULL || proc_state((p)) == DEAD || (p)->p_fd == -1)

long	global_fd = 1;	/* set of file descriptors of interest (for select) */

private Process *
proc_pid(pid)
pid_t	pid;
{
	register Process	*p;

	for (p = procs; p != NULL; p = p->p_next)
		if (p->p_pid == pid)
			break;

	return p;
}

void
read_proc(fd)
register int	fd;
{
	register Process	*p;
	int	n;
	char	ibuf[1024];

	for (p = procs; p != NULL; p = p->p_next)
		if (p->p_fd == fd)
			break;

	if (p == NULL) {
		writef("\riproc: unknown fd %d", fd);
		return;
	}

	n = read(fd, (UnivPtr) ibuf, sizeof(ibuf) - 1);
	if (n == -1 && (errno == EIO || errno == EWOULDBLOCK)) {
		if (proc_state(p) == NEW)
			return;
		proc_close(p);
		makedead(p);
		return;
	} else {
		if (proc_state(p) != RUNNING) {
			proc_state(p) = RUNNING;
			UpdModLine = YES;
		}
	}
	if (n <= 0) {
		if (n == 0)
			strcpy(ibuf, "[Process EOF]");
		else
			swritef(ibuf, sizeof(ibuf),
				"\n[pty read error: %d]\n", errno);
	} else
		ibuf[n] = '\0';
	proc_rec(p, ibuf);
}

void
ProcKill()
{
	register Buffer	*b;
	char	*bname;

	bname = ask_buf(curbuf);

	if ((b = buf_exists(bname)) == NULL)
		complain("[No such buffer]");
	if (b->b_process == NULL)
		complain("%s not tied to a process.", bname);
	proc_kill(b->b_process, SIGKILL);
}

void
ProcCont()
{
	Process	*p;

	if ((p = curbuf->b_process) == NULL)
		complain("[No process]");
	if (p->p_state != DEAD) {
		proc_kill(p, SIGCONT);
		UpdModLine = YES;
		p->p_state = RUNNING;
	}
}

private void
send_p(c)
char	c;
{
	Process	*p;
	char	buf[2];

	if ((p = curbuf->b_process) == NULL)
		complain("[No process]");
	ToLast();
	buf[0] = c;
	buf[1] = '\0';
	proc_rec(p, buf);
	(void) write(p->p_fd, (UnivPtr) &c, sizeof(c));
}

void
ProcEof()
{
	send_p(tc[NO].t_eofc);
}

void
ProcInt()
{
	send_p(tc[NO].t_intrc);
}

void
ProcQuit()
{
	send_p(tc[NO].t_quitc);
}

void
ProcStop()
{
	send_p(ls[NO].t_suspc);
}

void
ProcDStop()
{
	send_p(ls[NO].t_dsuspc);
}

private void
proc_close(p)
Process *p;
{
	SigHold(SIGCHLD);	/* be mutually exclusive */

	if (p->p_fd >= 0) {
		(void) close(p->p_fd);
		global_fd &= ~(1L << p->p_fd);
		p->p_fd = -1;
	}

	SigRelse(SIGCHLD);
}

private void
proc_write(p, buf, nbytes)
Process *p;
char	*buf;
size_t	nbytes;
{
	long	mask = (1 << p->p_fd);

	while (write(p->p_fd, (UnivPtr) buf, nbytes) <  0)
		select(p->p_fd + 1, (long *)NULL, &mask, (long *)NULL, (struct timeval *)NULL);
}

#ifdef	STDARGS
private void
proc_strt(char *bufname, int clobber, ...)
#else
private /*VARARGS2*/ void
proc_strt(bufname, clobber, va_alist)
	char	*bufname;
	int	clobber;
	va_dcl
#endif
{
	va_list	ap;
	char	*argv[32],
		*cp;
	Window *owind = curwind;
	pid_t	pid;
	Process	*newp;
	Buffer 	*newbuf;
	int	i,
		ptyfd = -1,
		ldisc,	/* tty line discipline */
		lmode;	/* tty local flags */
	register char	*s,
			*t;
	char	ttybuf[11],
		ptybuf[11];
	char	cmdbuf[LBSIZE];
#ifdef	BRLUNIX
	struct sg_brl sgt;
#else
	struct sgttyb sgt;
#endif

#ifdef	TIOCGWINSZ
	struct winsize win;
#else
#  ifdef	BTL_BLIT
#  include <sys/jioctl.h>
	struct jwinsize jwin;
#  endif
#endif

	isprocbuf(bufname);	/* make sure BUFNAME is either nonexistant
				   or is of type B_PROCESS */
	va_init(ap, clobber);
	make_argv(argv, ap);
	va_end(ap);
	if (access(argv[0], X_OK) != 0) {
		complain("[Couldn't access %s: %s]", argv[0], strerror(errno));
		/* NOTREACHED */
	}
	for (s = "pqrs"; ptyfd<0; s++) {
		if (*s == '\0')
			complain("[Out of ptys!]");
		for (t = "0123456789abcdef"; *t; t++) {
			swritef(ptybuf, sizeof(ptybuf), "/dev/pty%c%c", *s, *t);
			if ((ptyfd = open(ptybuf, 2)) >= 0) {
				strcpy(ttybuf, ptybuf);
				ttybuf[5] = 't';
				/* make sure both ends are available */
				if ((i = open(ttybuf, 2)) < 0) {
					(void) close(ptyfd);
					ptyfd = -1;
				} else {
					(void) close(i);
					break;
				}
			}
		}
	}

#ifdef	TIOCGETD
	(void) ioctl(0, TIOCGETD, (UnivPtr) &ldisc);
#endif
#ifdef	TIOCLGET
	(void) ioctl(0, TIOCLGET, (UnivPtr) &lmode);
#endif
#ifdef	TIOCGWINSZ
	(void) ioctl(0, TIOCGWINSZ, (UnivPtr) &win);
#else
#  ifdef	BTL_BLIT
	(void) ioctl(0, JWINSIZE, (UnivPtr) &jwin);
#  endif	/* BTL_BLIT */
#endif

	SigHold(SIGCHLD);
#ifdef	SIGWINCH
	SigHold(SIGWINCH);
#endif
	switch (pid = fork()) {
	case -1:
		{
		int	ugh = errno;	/* hold across library calls */

		(void) close(ptyfd);
		message("[Fork failed! ");
		message(strerror(ugh));
		message("]");
		goto fail;
		}

	case 0:
		SigRelse(SIGCHLD);
#ifdef	SIGWINCH
		SigRelse(SIGWINCH);
#endif
		jcloseall();
		(void) close(0);
		(void) close(1);
		(void) close(2);

#ifdef	TIOCNOTTY
		if ((i = open("/dev/tty", 2)) >= 0) {
			(void) ioctl(i, TIOCNOTTY, (UnivPtr)NULL);
			(void) close(i);
		}
#endif
		if (open(ttybuf, 2) != 0)
			exit(-1);
		(void) dup2(0, 1);
		(void) dup2(0, 2);

#ifdef	TIOCSETD
		(void) ioctl(0, TIOCSETD, (UnivPtr) &ldisc);
#endif
#ifdef	TIOCLSET
		(void) ioctl(0, TIOCLSET, (UnivPtr) &lmode);
#endif
#ifdef	TIOCSETC
		(void) ioctl(0, TIOCSETC, (UnivPtr) &tc[NO]);
#endif
#ifdef	TIOCSLTC
		(void) ioctl(0, TIOCSLTC, (UnivPtr) &ls[NO]);
#endif

#ifdef	TIOCGWINSZ
#    ifdef	SIGWINCH
		(void) signal(SIGWINCH, SIG_IGN);
#    endif
		win.ws_row = curwind->w_height;
		(void) ioctl(0, TIOCSWINSZ, (UnivPtr) &win);
#else
#  ifdef	BTL_BLIT
		jwin.bytesy = curwind->w_height;
		(void) ioctl(0, JSWINSIZE, (UnivPtr) &jwin);
#  endif
#endif

		sgt = sg[NO];
		sgt.sg_flags &= ~(ECHO | CRMOD | ANYP | ALLDELAY | RAW | LCASE | CBREAK | TANDEM);
		(void) stty(0, &sgt);

		{
			int	on = 1;

			(void) ioctl(0, TIOCREMOTE, (UnivPtr) &on);
		}

		i = getpid();
		(void) ioctl(0, TIOCSPGRP, (UnivPtr) &i);
#ifdef	SYSV
		(void) setpgrp();
#else
		(void) setpgrp(0, i);
#endif
		execv(argv[0], (char *const *) &argv[1]);
		raw_complain("execve failed! %s\n", strerror(errno));
		_exit(errno + 1);
	}

	newp = (Process *) emalloc(sizeof *newp);

#ifdef	O_NDELAY
	fcntl(ptyfd, F_SETFL, O_NDELAY);
#endif
	newp->p_fd = ptyfd;
	newp->p_pid = pid;

	newbuf = do_select((Window *)NULL, bufname);
	newbuf->b_type = B_PROCESS;
	newp->p_buffer = newbuf;
	newbuf->b_process = newp;	/* sorta circular, eh? */
	pop_wind(bufname, clobber, B_PROCESS);
	/* Pop_wind() after everything is set up; important!
	   Bindings won't work right unless newbuf->b_process is already
	   set up BEFORE NEWBUF is first SetBuf()'d. */
	ToLast();
	if (!bolp())
		LineInsert(1);

	cmdbuf[0] = '\0';
	va_init(ap, clobber);
	while ((cp = va_arg(ap, char *)) != NULL) {
		size_t	pl = strlen(cmdbuf);

		swritef(&cmdbuf[pl], sizeof(cmdbuf)-pl, "%s ", cp);
	}
	va_end(ap);

	newp->p_name = copystr(cmdbuf);
	newp->p_state = NEW;
	newp->p_reason = 0;
	newp->p_mark = MakeMark(curline, curchar, M_FLOATER);
	newp->p_dbx_mode = NO;

	newp->p_next = procs;
	procs = newp;
	global_fd |= 1L << newp->p_fd;
	SetWind(owind);

fail:
	SigRelse(SIGCHLD);
#ifdef	SIGWINCH
	SigRelse(SIGWINCH);
#endif
}

SIGRESTYPE
proc_child(junk)
int	junk;	/* needed for signal handler; not used */
{
	int save_errno = errno;	/* Subtle, but necessary! */
	wait_status_t	w;
	register pid_t	pid;

	for (;;) {
		pid = wait_opt(&w, (WNOHANG | WUNTRACED));
		if (pid <= 0)
			break;
		kill_off(pid, w);
	}
	errno = save_errno;
	return SIGRESVALUE;
}

void
closeiprocs()
{
	Process	*p;

	for (p=procs; p!=NULL; p=p->p_next)
		close(p->p_fd);
}
