;
;       bootsect.s              Copyright (C) 1991, 1992 Linus Torvalds
;       cut and modified by     Alessandro Rubini for linux.exe
;                                 (rubini@ipvvis.unipv.it)
;       modified and converted to TASM by
;                               Hans Lermen for LOADLIN
;                                 (lermen@elserv.ffm.fgan.de)

BOOTSEG       = 07C0h            ; original address of boot-sector

VALID_FLAG    = (512-2-2)
VERSION_FLAG  = ((4*512)-2-16-2)
VERSION_MAGIC = 0A5A5h
INT15RESULT   = ((4*512)-4-16-2)

code    segment para USE16
        assume  cs:code,ds:nothing
        org     0 ; NOTE: must really be 0

_main:                         ;
        db      0eah           ; no way switch off optimization of TASM
        dw      go,BOOTSEG     ; this is: JMP FAR PTR GO (jmpi go,BOOTSEG)
go:
        mov     bx,cs
        mov     es,bx
        mov     dx,4000h-12
        mov     ss,bx           ; put stack at cs:0x4000-12.
        mov     sp,dx
                                ; make a snapshot of all desired data
        cld
        cli                     ; keep the shop closed
        xor     si,si
        mov     ds,si
        mov     di,512          ; destination just behind us
        mov     cx,((3*512)-16-2)/2  ; 3 sectors - (16+2) bytes
        rep movsw               ; intvector + bios-data
        mov     si,0FFFFh
        mov     ds,si
        xor     si,si
        mov     cx,8
        rep movsw               ; top 16 bytes of BIOS-ROM
        in      al,21h
        stosb                   ; master-PIC-IMR
        in      al,0a1h
        stosb                   ; slave-PIC-IMR
        mov     si,9FC0h
        mov     ds,si
        xor     si,si
        mov     cx,2*(512/2)-1  ; 2 sectors
        rep movsw               ; bios-scratch-RAM
        sti

        mov     ds,bx           ; DS=CS
        mov     word ptr ds:[VALID_FLAG],1 ; set the valid_flag
        mov     ah,88h
        int     15h
        mov     word ptr ds:[INT15RESULT],ax
        mov     word ptr ds:[VERSION_FLAG],VERSION_MAGIC

        xor     ah,ah                   ; reset FDC
        xor     dl,dl
        int     13h

; save the bootsect an the snapshot (6 sectors)

save_snapshot:
        xor     bx,bx                   ; address = ES:0
        xor     dx, dx                  ; drive 0, head 0
        mov     cx,0001h                ; sector 1, track 0
        mov     ax,0306h                ; service 3 (write), 6 sectors
                                        ; (assume all on head 0, track 0)
        int     13h                     ; write it
        jnc     ok_print_message        ; ok - continue

        push    ax                      ; dump error code
        call    print_nl
        mov     bp, sp
        call    print_hex
        pop     ax

        xor     dl, dl                  ; reset FDC
        xor     ah, ah
        int     13h
        jmp     save_snapshot

ok_print_message:                       ; Print some inane message

        push    cs
        pop     es
        mov     ah,3                    ; read cursor pos
        xor     bh,bh
        int     10h

        mov     cx,msg1_end-msg1        ; char count
        mov     bx,7                    ; page 0, attribute 7 (normal)
        mov     bp,offset msg1
        mov     ax,1301h                ; write string, move cursor
        int     10h

; ok, we've written the message, now hang...

hang:   jmp     hang


comment /*
 *      print_all is for debugging purposes.
 *      It will print out all of the registers.  The assumption is that this is
 *      called from a routine, with a stack frame like
 *      dx
 *      cx
 *      bx
 *      ax
 *      error
 *      ret <- sp
 *
*/

print_all:
        mov     cx, 5           ; error code + 4 registers
        mov     bp, sp

print_loop:
        push    cx              ; save count left
        call    print_nl        ; nl for readability

        cmp     cl, 5
        jae     no_reg          ; see if register name is needed

        mov     ax, 0e05h + 'A' - 1
        sub     al, cl
        int     10h

        mov     al, 'X'
        int     10h

        mov     al, ':'
        int     10h

no_reg:
        add     bp, 2           ; next register
        call    print_hex       ; print it
        pop     cx
        loop    print_loop
        ret

print_nl:
        mov     ax, 0e0dh       ; CR
        int     10h
        mov     al, 0ah         ; LF
        int     10h
        ret

comment /*
 *      print_hex is for debugging purposes, and prints the word
 *      pointed to by ss:bp in hexadecmial.
*/

print_hex:
        mov     cx, 4           ; 4 hex digits
        mov     dx, [bp]        ; load word into dx
print_digit:
        rol     dx, 4           ; rotate so that lowest 4 bits are used
        mov     ah, 0eh
        mov     al, dl          ; mask off so we have only next nibble
        and     al, 0fh
        add     al, '0'         ; convert to 0-based digit
        cmp     al, '9'         ; check for overflow
        jbe     good_digit
        add     al, 'A' - '0' - 10

good_digit:
        int     10h
        loop    print_digit
        ret


comment /*
 * This procedure turns off the floppy drive motor, so that we
 * don't have to worry about it later.
 */
kill_motor:
        push    dx
        mov     dx,03f2h
        xor     al, al
        out     dx,al
        pop     dx
        ret


msg1    label   byte
        db      13,10
        db      'Interrupt table and BIOS-data saved on floppy',13,10
        db      'Open the floppy door and reboot from your hard drive,',13,10
        db      'then run REALBIOS again (step 2)',13,10
msg1_end label  byte

code    ends
        end     _main
