;============================================================================
;   BIOSINTV v1.0 (C) 1994 Hans Lermen (lermen@elserv.ffm.fgan.de)
;   part of package
;   LOADLIN v1.4 (C) 1994 Hans Lermen (lermen@elserv.ffm.fgan.de)
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation; either version 2 of the License, or
;   (at your option) any later version.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;----------------------------------------------------------------------------
;   Comments and bug reports are welcome and may be sent to:
;   E-Mail:    lermen@elserv.ffm.fgan.de
;   SnailMail: Hans Lermen
;              Am Muehlenweg 38
;              D53424 REMAGEN-Unkelbach
;              GERMANY
;
;============================================================================
          name  biosintv
          .386
          locals
          jumps

code    segment para USE16
        assume  cs:code,ds:nothing
        org     0 ; NOTE: must really be 0

        dd     -1              ; chain pointer to next device header
        dw     0c000h          ; character device (with ioctl support)
        dw     strategyRoutine
        dw     DevIntRoutine
        db     '$BIOSINT'


done          =    1         ; complete status, goes into highbyte
inval_function=    8003h     ; invalid function code

current_header dd ?    ; this is the saved pointer from strategy call
num_ints_to_save = 128
intvectbuf     dd  num_ints_to_save dup(?)


strategyRoutine proc far
        mov     word ptr cs:current_header,bx
        mov     word ptr cs:current_header+2,es
        ret
strategyRoutine endp


DevIntRoutine proc far
@@header struc
           db 2 dup(?)
  @@cmd    db ?
  @@status dw ?
@@header ends
        push    ds
        push    es
        push    ax
        push    bx
        push    cx
        push    dx
        push    di
        push    si
        cld
        lds     bx,cs:current_header

        movzx   ax,byte ptr ds:[bx].@@cmd
        cmp     al,12
        ja      @@ex_inval

        shl     ax,1
        mov     di,ax
        xor     ax,ax
        push    offset @@ex_command         ; it's the return address of
        jmp     word ptr cs:@@jumptable[di] ; a simulated call

@@jumptable label word
           dw   init             ; 0, init-routine
           dw   2 dup (@@nosupport)
           dw   ioctl_in         ; 3
           dw   8 dup (@@nosupport)
           dw   ioctl_out        ; 12

@@nosupport:
        add     sp,2             ; readjust stack
@@ex_inval:
        mov     ax,inval_function

@@ex_command:
        lds     bx,cs:current_header
        or      ah,done
        mov     ds:[bx].@@status,ax
        pop     si
        pop     di
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        pop     es
        pop     ds
        ret
DevIntRoutine endp



ioctl_in proc near
@@header struc
           db 14 dup(?);
  @@bufptr dd ?
  @@count  dw ?
@@header ends
        les     di,[bx].@@bufptr
        mov     cx,[bx].@@count
        cmp     cx,num_ints_to_save*4
        jna     @@ok
        mov     cx,num_ints_to_save*4
@@ok:
        mov     [bx].@@count,cx
        shr     cx,2
        push    ds
        push    cs
        pop     ds
        lea     si,intvectbuf
        cld
        rep movsd
        pop     ds
        mov     ax,1            ; status ok
        ret
ioctl_in endp


ioctl_out proc near
        mov     ax,1            ; status ok
        ret
ioctl_out endp


modulend equ    $+15



init proc near
@@header struc
           db 14 dup(?);
  @@endptr dd ?
@@header ends
        mov     word ptr ds:[bx].@@endptr,offset modulend
        mov     word ptr ds:[bx].@@endptr+2,cs
        push    ds
        xor     si,si
        mov     ds,si
        push    cs
        pop     es
        lea     di,intvectbuf
        cld
        mov     cx,num_ints_to_save
        rep movsd
        mov     ax,0
        pop     ds
        ret
init endp

code    ends
        end
