/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	private.H
 *
 *	Functions(s):
 *
 *	Description:
 *		Definitions for functions, constants private to the toolkit
 *
 *	RCSid = "$Id: private.H,v 4.3.1.1 1993/06/01 22:56:12 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_private_H
#define OI_private_H

#include <X11/X.h>
#include <X11/Xatom.h>

#ifndef OI_fd_set_H
#include <OI/fd_set.H>
#endif /* OI_fd_set_H */

#define			OI_FONT_DEFAULT	"-adobe-courier-medium-r-normal--12-120-75-75-m-70-iso8859-1"	/* default font */
#define			OI_LIB		"OI_LIB"			/* environment variable for OI library */
#define			OI_DEF_LIB	"/usr/lib/X11"	/* default object interface library */
#define			OI_HELP_OPENLOOK	"$OI_LIB/OI/O.hp"	/* default openlook model help file */
#define			OI_HELP_MOTIF	"$OI_LIB/OI/M.hp"		/* default motif model help file */
#define			OI_MX_RES_LEN	500				/* max resource string length we can handle */

 /* error routines */
			int		OI_err_hndlr(Display*,XErrorEvent*) ;
			int		OI_io_err_hndlr(Display*) ;
			void		OI_init_err_tbl() ;
 /* info used by main loop select */
		extern	int		OI_max_fd ;		/* max bit # + 1 for select() call */
		extern	fd_set		OI_x_mask ;		/* input fd mask for select() call for X */
		extern	fd_set		OI_inp_mask ;		/* input fd mask for select() */
		extern	fd_set		OI_out_mask ;		/* output fd mask for select() */
		extern	fd_set		OI_ex_mask ;		/* exception fd mask for select() */
 /* ptrs to registered classes */
	extern	class	OI_lang_server	*OI_lang_servers ;	/* ptr to list of registered language servers */
	extern	class	OI_class	*OI_class_treep ;	/* ptr to class tree for all registered classes */

 /* delete_delayed queue info */

 /* application startup info */
		class	OI_app_config	{		/* startup overrides for primary window */
			char		*namp ;		 /* name of this invocation of application */
		const	char		*ttlp ;		/* title */
			OI_bool		ttl_def ;	/* OI_YES if title was defaulted from app name */
		 public:
					OI_app_config()				{ namp=NULL; ttlp=NULL; ttl_def=OI_NO; }
		const	char		*title()				{ return(ttlp); }
			void		set_title(const char *p, OI_bool td=OI_NO)	{ ttlp= p; ttl_def=td; }
			OI_bool		title_is_default()			{ return(ttl_def); }
			void		set_app_name(const char *tp) ;
		} ;
	extern	class	OI_app_config	*OI_init_config ;	/* initial startup info */

 /* stderr stack for callbacks to intercept error messages */
	extern		OI_number	OI_n_stderr_stk ;		/* # entries in stack */
	extern		OI_number	OI_mx_stderr_stk ;		/* max # entries we have room for */
	extern	class	OI_cb		**OI_stderr_stkp ;		/* the error callback stack */

#endif /* OI_private_H */
