/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	conven.H
 *
 *	Functions(s):
 *
 *	Description:
 *		convenience functions for single connection applications
 *
 *	RCSid = "$Id: conven.H,v 4.4.1.1 1993/06/01 22:53:22 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_conven_H
#define OI_conven_H
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		OI_bool		OI_is_my_window(Window w) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

 /* Object Interface global variables header */
		Display		*OI_display() ;
		void		OI_lock_attributes() ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		

		OI_connection	*OI_default_connection() ;
		OI_bool		OI_get_resource(const char *namp,const char **typp,const char **valpp, OI_bool c=OI_yes) ;
		void		OI_dispatch_insert(Window w, int e, unsigned long em, OI_event_fnp fp, void *argp=NULL, OI_number p= -1) ;
		void		OI_dispatch_insert(Window w, unsigned long em, OI_event_fnp fp, void *argp=NULL, OI_number p= -1) ;
		void		OI_dispatch_insert(Window w, int e, unsigned long em, OI_callback *op, OI_event_memfnp mfp,
					void *argp=NULL, OI_number p= -1) ;
		void		OI_dispatch_insert(Window w, unsigned long em, OI_callback *op, OI_event_memfnp mfp, void *argp=NULL,
					OI_number p= -1) ;
		void		OI_dispatch_remove(Window w, int e, unsigned long em, OI_event_fnp fp, void *argp=NULL) ;
		void		OI_dispatch_remove(Window w, unsigned long em, OI_event_fnp fp, void *argp=NULL) ;
		void		OI_dispatch_remove(Window w, int e, unsigned long em, OI_callback *op, OI_event_memfnp mfp,
					void *argp=NULL) ;
		void		OI_dispatch_remove(Window w, unsigned long em, OI_callback *op, OI_event_memfnp mfp, void *argp=NULL) ;
		OI_d_tech	*OI_find_obj(const XEvent *ep, OI_number n=0, OI_d_tech **trep=NULL) ;
		OI_stat		OI_str_color(const char *str, PIXEL *pxlp) ;

#endif /* OI_conven_H */
