/* This file is part of the Project Athena Zephyr Notification System.
 * Created by: Mark W. Eichin <eichin@athena.mit.edu>
 * $Source: /mit/zephyr/src/zwgc/RCS/draw.h,v $
 * $Author: marc $
 *
 *	Copyright (c) 1988 by the Massachusetts Institute of Technology.
 *	For copying and distribution information, see the file
 *	"mit-copyright.h". 
 *
 * $Header: draw.h,v 2.3 89/04/26 13:28:05 marc Exp $
 */

#ifdef X11
#include <X11/Xlib.h>
extern Display *dpy;
#endif

#ifndef X11
typedef int Pixmap;
typedef int Window;
typedef int GC;
#endif

typedef struct _side {
  char		*str;
  int		fontnum;
  int		wid, asc, des;
  int		x;
} *Sides, side;
typedef struct _line {
  Sides		sd[3];
  int		nsd[3];
  int		lwid, amax, dmax;
  int		y;
} *Lines, line;
typedef struct _draw {
  Pixmap	pm;
  Window	w;
  Lines		ln;
  int		nln;
  int		cursid;
  int		curfn;
} draw, *Draw;

#define LEFT 0
#define CENTER 1
#define RIGHT 2
#define GAP 0

int xtx_draw_init();

Draw xtx_newdraw();

void xtx_setfont();
void xtx_setside();
void xtx_breakline();
void xtx_drawtext();
Window xtx_postdraw();
void xtx_dispose_draw();
void xtx_map_draw();

char *malloc(), *realloc();

#define New(type) (type *)malloc(sizeof(type))
#define ANew(type,cnt) (type *)malloc(cnt * sizeof(type))
#define Grow(type,old,new) (type *)realloc(old, new*sizeof(type))
#include "minmax.h"
/* the following should be somewhere special... */
#ifndef FALSE
#define FALSE (0)
#endif

#ifndef TRUE
#define TRUE (!FALSE)
#endif
