/* This file is part of the Project Athena Zephyr Notification System.
 * Created by: Mark W. Eichin <eichin@athena.mit.edu>
 * $Source: /mit/zephyr/src/zwgc/RCS/cmds.h,v $
 * $Author: eichin $
 *
 *	Copyright (c) 1988 by the Massachusetts Institute of Technology.
 *	For copying and distribution information, see the file
 *	"mit-copyright.h". 
 *
 * $Header: cmds.h,v 2.3 88/07/10 08:23:00 eichin Exp $ 
 */

#ifdef CMDCODES
char *table_commands[] =
{
  "DOES", "MATCH", "SHOW",
  "ENDDOES", "ENDMATCH", "ENDSHOW",
  "SUMMARY", "FIELDS", "SET",
  "EXEC", "EXIT", "BUTTON",
  "BEEP",
  NULL,
};
#else
extern char *table_commands[];
#endif

typedef enum {
  CMD_DOES, CMD_MATCH, CMD_SHOW,
  CMD_ENDDOES, CMD_ENDMATCH, CMD_ENDSHOW,
  CMD_SUMMARY, CMD_FIELDS, CMD_SET,
  CMD_EXEC, CMD_EXIT, CMD_BUTTON,
  CMD_BEEP,
} cmd_token;

#ifdef CMDCODES
/* avoid problems, set this high for now... check it later! */
#define M 1000
char *strand_raw[M];
struct _rope *varropes[M];
char *strand_field[M];
char *strand_head[M];
/* struct _rope *ropes_var[100]; */

char *table_heads[] =
{
  "kind", "port", "auth", "time", "date",
  "class", "instance", "opcode",
  "sender", "fullsender", "recipient",
  "message", "fromhost", "mode",
  NULL,
};
#else
extern char *table_heads[];
#endif

typedef enum {
  HEAD_KIND, HEAD_PORT, HEAD_AUTH, HEAD_TIME, HEAD_DATE,
  HEAD_CLASS, HEAD_INSTANCE, HEAD_OPCODE,
  HEAD_SENDER, HEAD_FULL_SENDER, HEAD_RECIPIENT,
  HEAD_MESSAGE, HEAD_FROMHOST, HEAD_MODE,
  HEAD_lasthead,		/* for cleanup */
} head_token;

#ifdef CMDCODES
char *table_shows[] =
{
  "left", "right", "center",
  "bold", "italic", "normal",
  "font0", "font1", "font2", "font3", "font4",
  "font5", "font6", "font7", "font8", "font9",
  NULL,
};
#else
extern char *table_shows[];
#endif
  
typedef enum {
  SHOW_LEFT, SHOW_RIGHT, SHOW_CENTER,
  SHOW_BOLD, SHOW_ITALIC, SHOW_NORMAL,
  SHOW_FONT0,
  SHOW_FONT1,
  SHOW_FONT2,
  SHOW_FONT3,
  SHOW_FONT4,
  SHOW_FONT5,
  SHOW_FONT6,
  SHOW_FONT7,
  SHOW_FONT8,
  SHOW_FONT9,
} show_token;

#ifdef ___FOO___
char *table_seps[] =
{
  "$", "(", ")", "*",
  NULL,
};

typedef enum {
  SEP_USER,
  SEP_NEWLINE, SEP_COMMENT, SEP_WS, SEP_TAB,
  SEP_STAR,
  SEP_STUFF,
} sep_token;

typedef enum {
  FORM_SPACE, FORM_NL,
} form_token;
#endif
  
typedef union {
  cmd_token cmd;
  head_token head;
  show_token show;
#ifdef ___FOO___
  sep_token sep;
  form_token form;
#endif
} token;
