/*
 * METALBASE 5.1
 *
 * Released January 1st, 1993 by Huan-Ti [ t-richj@microsoft.com ]
 *
 */

#ifndef STDINC_H
#define STDINC_H


/*
 * DETERMINATION OF SYSTEM ----------------------------------------------------
 *
 */

#ifndef AMIGA
#ifndef COHERENT  /* Doesn't really count, as of version 3.1 */
#ifndef MSDOS
#ifndef applec

#define UNIX

#endif /* applec */
#endif /* MSDOS */
#endif /* COHERENT */
#endif /* AMIGA */


/*
 * STANDARD SYSTEM DEPENDENCIES -----------------------------------------------
 *
 */

#ifdef COHERENT     /* COHERENT -------------------------------------------- */
#ifndef SYS_FCNTL
#define SYS_FCNTL
#endif
#ifndef NO_VOIDPTR
#define NO_VOIDPTR
#endif
/*
 * #ifdef  NO_USHORT
 * #undef  NO_USHORT
 * #endif
 * #ifdef  NO_ULONG
 * #undef  NO_ULONG
 * #endif
 * #ifdef  LONGARGS
 * #undef  LONGARGS
 * #endif
 *
 */
#endif

#ifdef applec       /* MACINTOSH ------------------------------------------- */
/*
 * #ifdef  NO_USHORT
 * #undef  NO_USHORT
 * #endif
 *
 */
#endif

#ifdef sgi          /* SILICON GRAPHICS ------------------------------------ */
#ifndef NO_ULONG
#define NO_ULONG
#endif
#endif

#ifdef MSDOS        /* MS-DOS ---------------------------------------------- */
#ifndef LONGARGS
#define LONGARGS
#endif
#ifndef SYS_TIMEB
#define SYS_TIMEB
#endif
/*
 * #ifdef  NO_ULONG
 * #undef  NO_ULONG
 * #endif
 * #ifdef  NO_USHORT
 * #undef  NO_USHORT
 * #endif
 *
 */
#endif


/*
 * STANDARD INCLUDES ----------------------------------------------------------
 *
 */

#ifdef MSDOS
#include <io.h>
#include <stdlib.h>
#include <process.h>
#include <share.h>
#else
#ifdef SOLARIS2
#include <stdlib.h>
#endif
#endif

#ifdef SYS_FCNTL
#include <sys/fcntl.h>
#else
#include <fcntl.h>
#endif

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <string.h>
#include <time.h>
#include <sys/stat.h>

#ifndef NO_TIMEB
#ifdef SYS_TIMEB
#include <sys/timeb.h>
#else
#include <timeb.h>
#endif
#endif

#ifdef UNIX
#ifdef NeXT
#include <dir.h>
#else
#ifndef apollo
#include <unistd.h>
#endif
#endif
#endif

#ifdef LONGARGS
#define XARGS(x) x
#else
#define XARGS(x) ()
#endif

extern time_t time  XARGS( (time_t *) );

#ifndef MSDOS
   extern char *getenv XARGS( (char *) );
#endif


/*
 * STANDARD MACROS ------------------------------------------------------------
 *
 */

#ifdef  tolower
#undef  tolower
#endif
#define tolower(x)  (char)(((x)>='A' && (x)<='Z')?((x)+('a'-'A')):(x))

#ifdef  toupper
#undef  toupper
#endif
#define toupper(x)  (char)(((x)>='a' && (x)<='z')?((x)+('A'-'a')):(x))

#ifdef  isdigit
#undef  isdigit
#endif
#define isdigit(x)  ((x) >= '0' && (x) <= '9')

#ifdef  until
#undef  until
#endif
#define until(x)    while (!(x))

#ifdef  New
#undef  New
#endif
#define New(x)      (x *)malloc (sizeof(x))

#ifdef  min
#undef  min
#endif
#define min(a,b)    ((a)<(b)?(a):(b))

#ifdef  max
#undef  max
#endif
#define max(a,b)    ((a)>(b)?(a):(b))


/*
 * STANDARD TYPEDEFS ----------------------------------------------------------
 *
 */

#ifndef NO_UCHAR                        /* uchar --------------------------- */
#ifdef CHAR_IS_UNS
   typedef char uchar;
#else
   typedef unsigned char uchar;
#endif
#endif

#ifndef NO_VOIDPTR                      /* dataptr ------------------------- */
   typedef void * dataptr;
#else
   typedef char * dataptr;
#endif

#ifndef NO_CHARPTR                      /* charptr ------------------------- */
   typedef char * charptr;
#endif

#ifndef NO_ULONG                        /* ulong --------------------------- */
   typedef unsigned long ulong;
#endif

#ifndef NO_USHORT                       /* ushort -------------------------- */
   typedef unsigned short ushort;
#endif

#ifndef NO_FILE                         /* file ---------------------------- */
   typedef int file;
#endif

#ifndef NO_BOOL                         /* bool ---------------------------- */
   typedef char bool;
#endif

#ifndef NO_BYTE                         /* byte ---------------------------- */
   typedef uchar byte;
#endif


/*
 * STANDARD DEFINES -----------------------------------------------------------
 *
 */

#ifdef FALSE
#undef FALSE
#endif
#define FALSE (bool)0

#ifdef TRUE
#undef TRUE
#endif
#define TRUE (bool)1

#ifdef MSDOS
#define DIRSEP  '\\'
#define szEOL   "\r\n"
#else
#define DIRSEP  '/'
#define szEOL   "\n"
#endif

#ifdef ESC
#undef ESC
#endif

#define CTRL_A (char)1
#define CTRL_B (char)2
#define CTRL_C (char)3
#define CTRL_D (char)4
#define CTRL_E (char)5
#define CTRL_F (char)6
#define CTRL_G (char)7
#define CTRL_H (char)8
#define CTRL_I (char)9
#define CTRL_J (char)10
#define CTRL_K (char)11
#define CTRL_L (char)12
#define CTRL_M (char)13
#define CTRL_N (char)14
#define CTRL_O (char)15
#define CTRL_P (char)16
#define CTRL_Q (char)17
#define CTRL_R (char)18
#define CTRL_S (char)19
#define CTRL_T (char)20
#define CTRL_U (char)21
#define CTRL_V (char)22
#define CTRL_W (char)23
#define CTRL_X (char)24
#define CTRL_Y (char)25
#define CTRL_Z (char)26
#define ESC    (char)27


/*
 * PORTABLE FILE OPERATIONS ---------------------------------------------------
 *
 * Use the following functions for file I/O
 *
 *     readx  -  read from a file (of course)
 *     writx  -  write to a file
 *     modex  -  change the attributes on a file
 *     openx  -  open a file (use OPENMODE or READMODE, for R/W or R access)
 *     close  -  close a file
 *     lseek  -  move within a file
 *     creatx -  create a new file
 *
 * A quick note: Never use modex() on a file which has open filehandles; on
 * MS-DOS systems, if SHARE is loaded, that will invalidate the filehandle.
 * Honest!
 *
 */

#define creatx(x)      creat  (x, 0666)
#define modex(f,n)     chmod  (f, n)
#define openx(f,n)     open   (f, n)
#define readx(f,b,n)   read   (f, (char *)(b), (int)(n))
#define writx(f,b,n)   write  (f, (char *)(b), (int)(n))

#define OPENMODE O_RDWR
#define READMODE O_RDONLY

#ifndef S_IWRITE
#undef  modex
#define modex(f,n)
#endif

#ifdef  applec
#undef  creatx
#define creatx(x) creat(x)
#endif

#ifdef MSDOS
#undef  READMODE
#define READMODE O_RDONLY|O_BINARY
#undef  OPENMODE
#define OPENMODE O_RDWR|O_BINARY
#undef  openx
#define openx(f,m)  sopen (f, m, SH_DENYNO, S_IREAD|S_IWRITE)
#endif

#endif  /* STDINC_H */

