#include <mbase.h>
#include "example6.h"

/*
 * PROTOTYPES -----------------------------------------------------------------
 *
 */

   void main XARGS( (void) );


/*
 * CODE -----------------------------------------------------------------------
 *
 */

void
main ()
{
   relation *rel;
   example6  rec, comp;
   int       num;


   if ((rel = mb_inc ("example6", "")) == RNULL)
      {
      fprintf (stderr, "mb_inc() failed: %s\n", mb_error);
      mb_exit (1);
      }


/*
 * Before we can do a sweeping change like this, we oughta lock the
 * relation to keep anyone else from working with any of the records
 * we might change...
 *
 */

   if (mb_lck (rel) != MB_OKAY)
      {
      fprintf (stderr, "couldn't lock: %s\n", mb_error);
      mb_exit (2);
      }


/*
 * Now, as long as we can find records where the price is under $10,
 * increase it to $10 even.
 *
 */

   comp.price = 10.00;

   for (num = 0; ; num++)
      {
      if (mb_sel (rel, idxnum(rel,"ix_price"), &rec, LTHAN, &comp) != MB_OKAY)
         break;
      rec.price = 10.00;

      printf ("updating tape '%s'\n", rec.tape);

      if (mb_upd (rel, &rec) != MB_OKAY)
         {
         fprintf (stderr, "couldn't update record: %s\n", mb_error);
         mb_exit (3);  /* Unlocks relation */
         }
      }


/*
 * Now unlock the relation.  Of course, mb_exit() would do that for
 * us, but hey...
 *
 */

   mb_unl (rel);  /* Okay, so I didn't check the return code. So sue me. */

   if (num == 0)
      {
      printf ("couldn't find any records with prices under $10.00\n");
      printf ("use 'vr example6' to add some, and try this again.\n");
      }

   mb_exit (0);
}

