/*
 * Note that this relation is encrypted; use "key" to look up
 * the information added.
 *
 */

#include <mbase.h>
#include "example5.h"

/*
 * PROTOTYPES -----------------------------------------------------------------
 *
 */

   void main XARGS( (void) );


/*
 * CODE -----------------------------------------------------------------------
 *
 */

void
main ()
{
   relation *rel;
   example5  rec;
   mb_time   start;
   char      yesno[10];
   int       i;

   setbuf (stdout, NULL);  /* So "."'s will print immediately */


   if ((rel = mb_inc ("example5", "key")) == RNULL)
      {
      fprintf (stderr, "mb_inc() failed: %s\n", mb_error);
      mb_exit (1);
      }


/*
 * First, let's see how long it takes to add 50 records...
 *
 */

   printf ("adding 100 records with mb_add()...\n");

   start = curtime();
   for (i = 0; i < 100; i++)
      {
      rec.num = (ushort)( rand() % 0xFFFF );
      if (mb_add (rel, &rec) != MB_OKAY)
         {
         fprintf (stderr, "mb_add() failed: %s\n", mb_error);
         mb_exit (2);
         }
      }

   printf ("...that took %ld seconds\n", elap_t (start));


/*
 * Now, let's see how long it takes to add five times that with mb_add_q()...
 *
 */

   printf ("adding 500 records with mb_add_q()...\n");

   start = curtime();
   for (i = 0; i < 500; i++)
      {
      rec.num = (ushort)( rand() % 0xFFFF );
      if (mb_add_q (rel, &rec) != MB_OKAY)
         {
         fprintf (stderr, "mb_add() failed: %s\n", mb_error);
         mb_exit (2);
         }
      }

   printf ("...that took %ld seconds\n", elap_t (start));


/*
 * And see if the user wants to index all those records...
 *
 */

   printf ("\n");
   printf ("there are %d record(s) to be indexed...\n", mb_num_q(rel));
   printf ("index them now? ");
   gets (yesno);
   printf ("\n");

   if (yesno[0] != 'Y' && yesno[0] != 'y')
      {
      printf ("no?  okay.\n\n");
      printf ("use 'MBDIAG -k key example5' to index them (you need the\n");
      printf ("'-k key' bit because this relation is encrypted)--and see\n");
      printf ("how long it takes.  Then 'build -q example5' and re-run\n");
      printf ("this program, and answer 'y'\n");
      }
   else
      {
      printf ("okay... this could take a bit:\n\n");

      start = curtime();
      do {
         mb_xfer (rel);
         printf (".");
         }
      while (mb_errno == MB_OKAY);

      if (mb_errno != MB_NO_QUEUE)
         {
         fprintf (stderr, "mb_xfer() failed: %s\n", mb_error);
         mb_exit (2);
         }
      printf ("\ndone!  that took %d seconds.\n\n", elap_t(start));

      printf ("Try 'build -q example5', and re-run this without saying Yes.\n");
      printf ("Then use MBDIAG to index all those records...\n");
      }

   mb_rmv (rel);
   mb_exit (0);
}

