.\" Man page for man (and the former manpath)
.\"
.\" Copyright (c) 1990, 1991, John W. Eaton.
.\"
.\" You may distribute under the terms of the GNU General Public
.\" License as specified in the README file that comes with the man 1.0
.\" distribution.  
.\"
.\" John W. Eaton
.\" jwe@che.utexas.edu
.\" Department of Chemical Engineering
.\" The University of Texas at Austin
.\" Austin, Texas  78712
.\"
.\" Many changes - aeb
.\"
.TH man 1 "March 15, 1994"
.LO 1
.SH NAME
man \- format and display the on-line manual pages
.br
manpath \- determine user's search path for man pages
.SH SYNOPSIS
man [\-adfhktw] [\-m system] [\-p string] [\-C config_file] [\-M path]
[\-P pager] [\-S section_list] [section] name ...
.SH DESCRIPTION
.B man
formats and displays the on-line manual pages.  This version knows
about the MANPATH and PAGER environment variables, so you can have
your own set(s) of personal man pages and choose whatever program you
like to display the formatted pages.  If
.I section
is specified, man only looks in that section of the manual.
You may also specify the order to search the sections for entries
and which preprocessors to run on the source files via command line options
or environment variables.
If
.I name
contains a / then it is first tried as a filename, so that you can do
.B "man ./foo.5"
or even
.B "man /cd/foo/bar.1.gz\fR.\fP"
.SH OPTIONS
.TP
.B \-\^C " config_file"
Specify the man.config file to use. This file
.TP
.B \-\^M " path"
Specify the list of directories to seach for man pages.
If no such option is given, the environment variable
.B MANPATH
is used. If no such environment variable is found, this list
is found by consulting 
.TP
.B \-\^P " pager"
Specify which pager to use.  By default, man uses
.B %pager%
This option overrides the
.B PAGER
environment variable.
.TP
.B \-\^S " section_list"
List is a colon separated list of manual sections to search.
This option overrides the
.B MANSECT
environment variable.
.TP
.B \-\^a
By default, man will exit after displaying the first manual page it
finds.  Using this option forces man to display all the manual pages
that match
.B name, 
not just the first.  
.TP
.B \-\^d
Don't actually display the man pages, but do print gobs of debugging
information.
.TP
.B \-\^f
Equivalent to
.B whatis.
.TP
.B \-\^h
Print a one line help message and exit.
.TP
.B \-\^k
Equivalent to
.B apropos.
.TP
.B \-\^m " system"
Specify an alternate set of man pages to search based on the system
name given.
.TP
.B \-\^p " string"
Specify the sequence of preprocessors to run before nroff or troff.
Not all installations will have a full set of preprocessors.
Some of the preprocessors and the letters used to designate them are: 
eqn (e), grap (g), pic (p), tbl (t), vgrind (v), refer (r).
This option overrides the
.B MANROFFSEQ
environment variable.
.TP
.B \-\^t
Use
.B %troff%
to format the manual page, passing the output to 
.B stdout.
The output from
.B %troff%
may need to be passed through some filter or another before being
printed.
.TP
.B \-\^w \fRor\fP \-\-path
Don't actually display the man pages, but do print the location(s) of
the files that would be formatted or displayed. If no argument is given:
display (on stdout) the list of directories that is searched by
.B man
for man pages. If
.B manpath
is a link to man, then "manpath" is equivalent to "man --path".

.SH ENVIRONMENT
.TP \w'MANROFFSEQ\ \ 'u
.B MANPATH
If
.B MANPATH
is set, its value is used as the path to search for manual pages.
.TP
.B MANROFFSEQ
If
.B MANROFFSEQ
is set, its value is used to determine the set of preprocessors run
before running nroff or troff.  By default, pages are passed through
the table preprocessor before nroff.
.TP
.B MANSEC
If
.B MANSEC
is set, its value is used to determine which manual sections to search.
.TP
.B PAGER
If
.B PAGER
is set, its value is used as the name of the program to use to display
the man page.  By default,
.B %pager%
is used.
.SH "SEE ALSO"
apropos(1), whatis(1), less(1), groff(1).
.SH BUGS
The
.B \-t
option only works if a troff-like program is installed.
