dnl A macro to redefine AC_PARSEARGS to recognize the host options.
define(AC_PARSEHOST,
[undefine([AC_PARSEARGS])dnl
define(AC_PARSEARGS,
[for arg
do
  # Handle --exec-prefix with a space before the argument.
  if test x$next_exec_prefix = xyes; then exec_prefix=$arg; next_exec_prefix=
  # Handle --host with a space before the argument.
  elif test x$next_host = xyes; then host=$arg; next_host=
  # Handle --prefix with a space before the argument.
  elif test x$next_prefix = xyes; then prefix=$arg; next_prefix=
  # Handle --srcdir with a space before the argument.
  elif test x$next_srcdir = xyes; then srcdir=$arg; next_srcdir=
  else
    case $arg in
     # For backward compatibility, recognize -exec-prefix and --exec_prefix.
     -exec-prefix=* | --exec_prefix=* | --exec-prefix=* | --exec-prefi=* | --exec-pref=* | --exec-pre=* | --exec-pr=* | --exec-p=* | --exec-=* | --exec=* | --exe=* | --ex=* | --e=*)
changequote(,)dnl
	exec_prefix=`echo $arg | sed 's/[-a-z_]*=//'` ;;
changequote([,])dnl
     -exec-prefix | --exec_prefix | --exec-prefix | --exec-prefi | --exec-pref | --exec-pre | --exec-pr | --exec-p | --exec- | --exec | --exe | --ex | --e)
	next_exec_prefix=yes ;;

     -gas | --gas | --ga | --g) ;;

     -host=* | --host=* | --hos=* | --ho=* | --h=*)
changequote(,)dnl
	host=`echo $arg | sed 's/[-a-z_]*=//'` ;;
changequote([,])dnl
     -host | --host | --hos | --ho | --h)
	next_host=yes ;;

     -nfp | --nfp | --nf) ;;

     -prefix=* | --prefix=* | --prefi=* | --pref=* | --pre=* | --pr=* | --p=*)
changequote(,)dnl
	prefix=`echo $arg | sed 's/[-a-z_]*=//'` ;;
changequote([,])dnl
     -prefix | --prefix | --prefi | --pref | --pre | --pr | --p)
	next_prefix=yes ;;

     -srcdir=* | --srcdir=* | --srcdi=* | --srcd=* | --src=* | --sr=* | --s=*)
changequote(,)dnl
	srcdir=`echo $arg | sed 's/[-a-z_]*=//'` ;;
changequote([,])dnl
     -srcdir | --srcdir | --srcdi | --srcd | --src | --sr | --s)
	next_srcdir=yes ;;

     -with-* | --with-*)
       package=`echo $arg|sed -e 's/-*with-//' -e 's/=.*//'`
       # Reject names that aren't valid shell variable names.
changequote(,)dnl
       if test -n "`echo $package| sed 's/[-a-zA-Z0-9_]//g'`"; then
changequote([,])dnl
         echo "configure: $package: invalid package name" >&2; exit 1
       fi
       package=`echo $package| sed 's/-/_/g'`
       case "$arg" in
changequote(,)dnl
         *=*) val="`echo $arg|sed 's/[^=]*=//'`" ;;
changequote([,])dnl
         *) val=1 ;;
       esac
       eval "with_$package='$val'" ;;

     -v | -verbose | --verbose | --verbos | --verbo | --verb | --ver | --ve | --v)
       verbose=yes ;;

     -*) ;;

     *)
       host=$arg ;;
    esac
  fi
done
])])dnl
dnl
dnl A macro to run config.guess and config.sub if necessary and set
dnl the shell variables $host and $canonical_host.
define(AC_HOST,
[# Maybe guess the host type.
if test -z "$host"
then
	guesssys=`echo [$]0 | sed 's/configure$/config.guess/'`
	if host=`$guesssys`
	then
		:
	else
		echo 'Failed to guess the host type.  You need to tell me.' >&2
		exit 1
	fi
fi

# Canonicalize the host type.
echo "checking the host type"
if canonical_host=`${srcdir}/config.sub "${host}"`
then
	:
else
	exit 1
fi

test -n "$verbose" &&
	echo "	host type is $host"
test -n "$verbose" &&
	echo "	canonical name is $canonical_host"
])dnl
dnl
dnl A macro to find the include directory, useful for cross-compiling.
define(AC_INCLUDEDIR,
[AC_REQUIRE([AC_PROG_AWK])dnl
AC_SUBST(includedir)
echo checking for include directory
includedir=/usr/include
if test -n "$GCC"
then
	>conftest.c
	includedir=`
		$CC -v -E conftest.c 2>&1 | $AWK '
			/^End of search list/ { print last; exit }
			{ last = [$]1 }
		'
	`
	rm -f conftest.c
	if test -n "$includedir" && test -d "$includedir"
	then
		test -n "$verbose" &&
			echo "	setting includedir to $includedir"
	else
		includedir=/usr/include
	fi
else
	test -n "$verbose" &&
		echo "	nothing happens"
fi
])dnl
dnl
dnl A macro to automatically set different CC and HOSTCC if using gcc.
define(AC_PROG_HOSTCC,
[AC_SUBST(HOSTCC)dnl
if test -z "$HOSTCC"
then
	HOSTCC="$CC"
	if test -n "$GCC"
	then
		# Find out if gcc groks our host.
		worked=
		last=
		for i in $1
		do
			test "x$i" = "x$last" && continue
			last="$i"
			CC="$HOSTCC -b $i"
			AC_COMPILE_CHECK([working $CC],,,
				[worked=1
				test -n "$verbose" &&
					echo "	setting CC to $CC"
				break])
		done
		if test -z "$worked"
		then
			CC="$HOSTCC"
		fi
	fi
fi
test "x$HOSTCC" != "x$CC" &&
	test -n "$verbose" &&
		echo "	setting HOSTCC to $HOSTCC"
])dnl
dnl
dnl A macro to set gcc warning flags.
define(AC_WARNFLAGS,
[AC_SUBST(WARNFLAGS)
if test -z "$WARNFLAGS"
then
	if test -n "$GCC"
	then
		# If we're using gcc we want warning flags.
		WARNFLAGS=-Wall
	fi
fi
])dnl
dnl
dnl A macro to determine if procfs is pollable.
define(AC_POLLABLE_PROCFS,
[echo "checking for pollable procfs"
AC_TEST_PROGRAM([
#include <stdio.h>
#include <signal.h>
#include <sys/procfs.h>
#include <sys/stropts.h>
#include <poll.h>

main()
{
	int pid;
	char proc[32];
	FILE *pfp;
	struct pollfd pfd;

	if ((pid = fork()) == 0) {
		pause();
		exit(0);
	}
	sprintf(proc, "/proc/%d", pid);
	if ((pfp = fopen(proc, "r+")) == NULL)
		goto fail;
	if (ioctl(fileno(pfp), PIOCSTOP, NULL) < 0)
		goto fail;
	pfd.fd = fileno(pfp);
	pfd.events = POLLPRI;
	if (poll(&pfd, 1, 0) < 0)
		goto fail;
	if (!(pfd.revents & POLLPRI))
		goto fail;
	kill(pid, SIGKILL);
	exit(0);
fail:
	kill(pid, SIGKILL);
	exit(1);
}
],
AC_DEFINE(HAVE_POLLABLE_PROCFS))
])dnl
dnl
dnl A macro to determine if the prstatus structure has a pr_syscall member.
define(AC_PR_SYSCALL,
[AC_COMPILE_CHECK([pr_syscall in struct prstatus],
[#include <sys/procfs.h>], [struct prstatus s; s.pr_syscall;],
AC_DEFINE(HAVE_PR_SYSCALL))])dnl
dnl
dnl A macro to detect the presence of the sig_atomic_t in signal.h
define(AC_SIG_ATOMIC_T,
[AC_COMPILE_CHECK([sig_atomic_t in signal.h],
[#include <signal.h>],
[sig_atomic_t x;],
AC_DEFINE(HAVE_SIG_ATOMIC_T))
])dnl
dnl
