#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <fcntl.h>

#ifndef O_BINARY
#define O_BINARY 0
#endif

#ifndef DIR_SEPARATOR
#ifdef OS2
#define DIR_SEPARATOR '\\'
#else
#define DIR_SEPARATOR '/'
#endif
#endif

int open_read(char *path)
{
    return open(path, O_RDONLY | O_BINARY);
}

int open_create(char *path)
{
    return open(path, O_WRONLY | O_CREAT | O_TRUNC | O_BINARY,
                S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH);
}

long file_length(int fd)
{
    /* Return the number of bytes in the named file. */
    int ret;
    struct stat statbuf;

    ret = fstat(fd, &statbuf);
    if (ret || !S_ISREG(statbuf.st_mode)) return 0L;
    return (statbuf.st_size);
}

int is_regular_file (char *name)
{
  int ret;
  struct stat statbuf;

  ret = stat(name, &statbuf);
  return (!ret && S_ISREG(statbuf.st_mode));
}

int is_directory_file (char *name)
{
  int ret;
  struct stat statbuf;

  ret = stat(name, &statbuf);
  return (!ret && S_ISDIR(statbuf.st_mode));
}

char   *optarg;				/* Global argument pointer. */

static char *scan = NULL;	        /* Private scan pointer. */

#define MAX_UNITS 100  /* Maximum compilation units per single file */

main (int argc, char *argv [])
{
  int  fd1;
  int  i, n, unit;
  int  overwrite_option = 0;
  int  script_option = 0;
  int  errors = 0;
  char buf [10000];
  char *ptr;
  char *strstr();
  char *strdup();
  char *strrchr();
  char name [10000];
  char *names [MAX_UNITS];
  long offsets [MAX_UNITS];
  long bytes;
  char *directory;
  int  directory_len = 0;
  char *source_name;
  char *script_name;
  FILE *script;
  int c;
  extern char *optarg;
  extern int optind;

  /* Scan the arguments list. The arguments for gnatsplit would be 
   * gnatsplit [-ksw] filename [directory]
   */

  while ((c = getopt(argc, argv, "ksw")) != -1)
     switch (c) {
        case 'k':
            /* passed from k8 option to gnatsplit, ignore it */
            break;
        case 's':
            script_option++;
            break;
        case 'w':
            overwrite_option++;
            break;
        case '?':
            fprintf (stderr, "usage: gnatsplit [-kws] filename [directory]\n");
            exit (1);
     }

  source_name = argv [optind++];

  /* The optional last argument would be a directory name.  If it does not
   * correspond to an existing directory, issue message and abort. 
   */
  if (optind < argc) {
    directory = malloc (strlen (argv[optind]) + 1);
    strcat (directory, argv [optind]);
    if (!is_directory_file (directory)) {
      fprintf(stderr, "%s is not a valid directory\n", directory);
      exit (1);
    }
   directory_len = strlen (directory) + 2;
  }

  /* It is assumed that gcc is called by "gcc -gnatu -gnats -c filename" on 
   * a source file and the subsequent output is redirected as the standard
   * input to this program.  The strings are of the following forms:
   * "Unit XXXXX (spec) line ddd, file offset ddd. file name XXXX.ads" or
   * "Unit XXXXX (body) line ddd, file offset ddd. file name XXXX.adb"
   * ...
   */

  printf("attempting to split %s into: \n", source_name);
  read (0, buf, 10000);
  ptr = buf;
  for (unit=1;;unit++) {
    /* Scan for the word "offset", skip over it and read the actual offset
     * value. If "offset" does not appear in the string, it indicates that
     * the entire string has been fully processed.
     */
    ptr = strstr (ptr, "offset"); 
    if (ptr == (char *) 0) break;
    ptr = ptr + 6;
    sscanf(ptr, "%d", &n);
    offsets [unit] = n;
    /* Scan for the words "file name", skip over them and read in the actual
     * file name to be used when writing out this compilation unit.  If a 
     * directory name was given as an argument, prepend it to the file name.
     */
    ptr = strstr (ptr, "file name"); 
    ptr = ptr + 9;
    sscanf(ptr, "%s", &name);
    names [unit] = malloc (strlen (name) + directory_len);
    if (directory) {
      strcat (names [unit], directory);
      i = strlen (names [unit]);
      names [unit] [i] = DIR_SEPARATOR;
      names [unit] [i+1] = '\0';
    }
    strcat (names [unit], name);
    printf("   %s \n", names [unit]);
  }
  printf("\n"); 
  /* If the overwrite option is not specified check to see if any file that
   * would be written is the name of an existing file and if so print it and
   * later signal an abort after checking all files.
   */

  if (!overwrite_option) {
    for (i = 1; i < unit; i++)
      if (is_regular_file (names [i])) {
        fprintf(stderr, "%s already exists, use -w to overwrite\n", names [i]);
        errors++;
      }
      if (errors) {
        printf("no files have been written\n");
        exit (1);
      }
  }

  fd1 = open_read (source_name);
  bytes = file_length (fd1);
  offsets [unit] = bytes;

  {
    char buf2 [bytes];  /* large enough to read in entire source file. */
    int  fd2;

    int has_no_corresponding_body (char *filename) 
    {
       int i;
       char *fname = strdup (filename);
       fname [strlen (fname) - 1] = 'b';
       for (i = 1; i < unit; i++) {
         if (!strcmp (fname, names [i]))
           return 0;
       }
       return 1;
    }

  /*
   * Read the source file in groups of bytes given by the offsets array
   * and write each group as a separate file using the string given by the
   * names array.
   */
    for (i = 1; i < unit; i++) {
      bytes = offsets [i+1] - offsets [i];
      read (fd1, buf2, bytes);
      fd2 = open_create (names [i]);
      write (fd2, buf2, bytes);
      close (fd2);
    }

    if (script_option) {
       script_name = strdup (source_name);
       ptr = strrchr (script_name, '.');
#ifdef OS2
       strcpy (++ptr, "cmd");
       script = fopen (script_name, "w"); 

       for (i = 1; i < unit; i++)
          if (strstr (names [i], ".adb")
                || has_no_corresponding_body (names [i]))
             fprintf (script,
                      "gcc -c %%1 %%2 %%3 %%4 %%5 %%6 %%7 %%8 %%9 %s\n",
                      names [i]);
#else
       *(++ptr) = 's';
       *(++ptr) = 'h';
       *(++ptr) = '\0';
       script = fopen (script_name, "w"); 
       chmod (script_name, S_IRWXU);

       for (i = 1; i < unit; i++) {
          if (strstr (names [i], ".adb"))
             fprintf (script, "gcc -c $* %s\n", names [i]);
          else if (has_no_corresponding_body (names [i]))
             fprintf (script, "gcc -c $* %s\n", names [i]);
       }
#endif
       printf ("script %s written\n", script_name);
    }

}
  exit (0);
 }
