#include "ps.h"

struct task_struct *
kvm_nextproc(void)
{

	struct task_struct *task, *taskp;
	struct tty_struct *tty;
	static unsigned long _task;
	static int n = NR_TASKS;
	
	if (_task == 0)
		_task = k_addr("_task") + 4;


	task = (struct task_struct *) xmalloc(sizeof(struct task_struct));

repeat:
	if (--n == 0)
		return(NULL);

	kmemread(&taskp, _task, 4);
	_task += 4;

	if (taskp == 0)
		goto repeat;

	kmemread(task, (unsigned long) taskp, sizeof(struct task_struct));

	/* check if valid, proc may have exited */
	if ((unsigned) task->state > 4 || task->pid <= 0)
		goto repeat;


	if (!task->tty)
		return(task);
	tty = (struct tty_struct *) xmalloc(sizeof(struct tty_struct));
	kmemread(tty, (unsigned long) task->tty, sizeof(struct tty_struct));
	task->tty = tty;
	return(task);
}

int
proc_compare(struct task_struct *p1, struct task_struct *p2)
{
	if (p1 == NULL)
		return 1;
	return(p1->counter > p2->counter);
}


#define	FSHIFT	11
#define	FSCALE	(1<<FSHIFT)

void
getloadavg(double *avenrun, int n)
{
    	unsigned long averunnable[3];
	int i;

	kmemread(averunnable, k_addr("_avenrun"), sizeof averunnable);
	for (i = 0; i < n; ++i)
		avenrun[i] = (double) averunnable[i] / FSCALE;
}
