/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

public class VirtuosoPoolStatistic
implements Cloneable {
    protected String name;
    protected int conn_unUsed;
    protected int connIn_Use;
    protected int cacheSize = 0;
    protected int _hits = 0;
    protected int _misses = 0;
    protected long _max_wtime = 0L;
    protected long _min_wtime = 0L;
    protected long _cum_wtime = 0L;

    protected VirtuosoPoolStatistic() {
    }

    protected void setCacheParam(String string, int n, int n2, int n3) {
        this.name = string;
        this.cacheSize = n;
        this.conn_unUsed = n2;
        this.connIn_Use = n3;
    }

    protected void setWaitingTime(long l) {
        if (this._min_wtime == 0L || l < this._min_wtime) {
            this._min_wtime = l;
        }
        if (l > this._max_wtime) {
            this._max_wtime = l;
        }
        this._cum_wtime += l;
    }

    protected synchronized Object clone() {
        try {
            VirtuosoPoolStatistic virtuosoPoolStatistic = (VirtuosoPoolStatistic)super.clone();
            virtuosoPoolStatistic._hits = this._hits;
            virtuosoPoolStatistic._misses = this._misses;
            virtuosoPoolStatistic._max_wtime = this._max_wtime;
            virtuosoPoolStatistic._min_wtime = this._min_wtime;
            virtuosoPoolStatistic._cum_wtime = this._cum_wtime;
            return virtuosoPoolStatistic;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int getHits() {
        return this._hits;
    }

    public int getMisses() {
        return this._misses;
    }

    public long getMaxWaitTime() {
        return this._max_wtime;
    }

    public long getMinWaitTime() {
        return this._min_wtime;
    }

    public long getCumWaitTime() {
        return this._cum_wtime;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public int getConnsInUse() {
        return this.connIn_Use;
    }

    public int getConnsUnUsed() {
        return this.conn_unUsed;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("--------------------------------------\n");
        stringBuffer.append("  ** Cache Statistics for the [" + this.name + "] **\n");
        stringBuffer.append("--------------------------------------\n");
        stringBuffer.append(" connection's cacheSize= ");
        stringBuffer.append(this.cacheSize);
        stringBuffer.append('\n');
        stringBuffer.append("      used connections = ");
        stringBuffer.append(this.connIn_Use);
        stringBuffer.append('\n');
        stringBuffer.append("    unused connections = ");
        stringBuffer.append(this.conn_unUsed);
        stringBuffer.append('\n');
        stringBuffer.append("      total cache hits = ");
        stringBuffer.append(this._hits);
        stringBuffer.append('\n');
        stringBuffer.append("    total cache misses = ");
        stringBuffer.append(this._misses);
        stringBuffer.append('\n');
        stringBuffer.append(" min waiting time (millisec)= ");
        stringBuffer.append(this._min_wtime);
        stringBuffer.append('\n');
        stringBuffer.append(" max waiting time (millisec)= ");
        stringBuffer.append(this._max_wtime);
        stringBuffer.append('\n');
        stringBuffer.append(" avg waiting time (millisec)= ");
        stringBuffer.append(this._misses == 0 ? 0L : this._cum_wtime / (long)this._misses);
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }
}

