/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2003-2013                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

#ifndef TEMPLATE_H
#define TEMPLATE_H

#include "classifierlistitem.h"

/**
 * This class holds information used by template classes, called
 * paramaterised class in UML and a generic in Java.  It has a
 * type (usually just "class") and name.
 *
 * @short Sets up template information.
 * @author Jonathan Riddell
 * @see UMLObject
 * Bugs and comments to uml-devel@lists.sf.net or http://bugs.kde.org
 */
class UMLTemplate : public UMLClassifierListItem
{
public:

    UMLTemplate(UMLObject *parent, const QString& name,
                Uml::ID::Type id = Uml::ID::None, const QString& type = "class");

    explicit UMLTemplate(UMLObject *parent);

    bool operator==(const UMLTemplate &rhs) const;

    virtual void copyInto(UMLObject *lhs) const;

    virtual UMLObject* clone() const;

    virtual ~UMLTemplate();

    QString toString(Uml::SignatureType::Enum sig = Uml::SignatureType::NoSig);

    virtual QString getTypeName() const;

    bool showPropertiesDialog(QWidget* parent);

    void saveToXMI(QDomDocument & qDoc, QDomElement & qElement);

protected:

    bool load(QDomElement & element);

};

#endif
