/* parser auto-generated by pidl */

#include "includes.h"
#include "librpc/gen_ndr/ndr_wbint.h"

#include "librpc/gen_ndr/ndr_lsa.h"
#include "librpc/gen_ndr/ndr_netlogon.h"
_PUBLIC_ enum ndr_err_code ndr_push_wbint_userinfo(struct ndr_push *ndr, int ndr_flags, const struct wbint_userinfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->acct_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->full_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->homedir));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->shell));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->primary_gid));
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, &r->user_sid));
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, &r->group_sid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->acct_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->acct_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->acct_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->acct_name, ndr_charset_length(r->acct_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->full_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->full_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->full_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->full_name, ndr_charset_length(r->full_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->homedir) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->homedir, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->homedir, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->homedir, ndr_charset_length(r->homedir, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->shell) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->shell, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->shell, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->shell, ndr_charset_length(r->shell, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_wbint_userinfo(struct ndr_pull *ndr, int ndr_flags, struct wbint_userinfo *r)
{
	uint32_t _ptr_acct_name;
	uint32_t size_acct_name_1 = 0;
	uint32_t length_acct_name_1 = 0;
	TALLOC_CTX *_mem_save_acct_name_0;
	uint32_t _ptr_full_name;
	uint32_t size_full_name_1 = 0;
	uint32_t length_full_name_1 = 0;
	TALLOC_CTX *_mem_save_full_name_0;
	uint32_t _ptr_homedir;
	uint32_t size_homedir_1 = 0;
	uint32_t length_homedir_1 = 0;
	TALLOC_CTX *_mem_save_homedir_0;
	uint32_t _ptr_shell;
	uint32_t size_shell_1 = 0;
	uint32_t length_shell_1 = 0;
	TALLOC_CTX *_mem_save_shell_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_acct_name));
		if (_ptr_acct_name) {
			NDR_PULL_ALLOC(ndr, r->acct_name);
		} else {
			r->acct_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_full_name));
		if (_ptr_full_name) {
			NDR_PULL_ALLOC(ndr, r->full_name);
		} else {
			r->full_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_homedir));
		if (_ptr_homedir) {
			NDR_PULL_ALLOC(ndr, r->homedir);
		} else {
			r->homedir = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_shell));
		if (_ptr_shell) {
			NDR_PULL_ALLOC(ndr, r->shell);
		} else {
			r->shell = NULL;
		}
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->primary_gid));
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, &r->user_sid));
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, &r->group_sid));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->acct_name) {
			_mem_save_acct_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->acct_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->acct_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->acct_name));
			size_acct_name_1 = ndr_get_array_size(ndr, &r->acct_name);
			length_acct_name_1 = ndr_get_array_length(ndr, &r->acct_name);
			if (length_acct_name_1 > size_acct_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_acct_name_1, length_acct_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_acct_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->acct_name, length_acct_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_acct_name_0, 0);
		}
		if (r->full_name) {
			_mem_save_full_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->full_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->full_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->full_name));
			size_full_name_1 = ndr_get_array_size(ndr, &r->full_name);
			length_full_name_1 = ndr_get_array_length(ndr, &r->full_name);
			if (length_full_name_1 > size_full_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_full_name_1, length_full_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_full_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->full_name, length_full_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_full_name_0, 0);
		}
		if (r->homedir) {
			_mem_save_homedir_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->homedir, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->homedir));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->homedir));
			size_homedir_1 = ndr_get_array_size(ndr, &r->homedir);
			length_homedir_1 = ndr_get_array_length(ndr, &r->homedir);
			if (length_homedir_1 > size_homedir_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_homedir_1, length_homedir_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_homedir_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->homedir, length_homedir_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_homedir_0, 0);
		}
		if (r->shell) {
			_mem_save_shell_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->shell, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->shell));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->shell));
			size_shell_1 = ndr_get_array_size(ndr, &r->shell);
			length_shell_1 = ndr_get_array_length(ndr, &r->shell);
			if (length_shell_1 > size_shell_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_shell_1, length_shell_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_shell_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->shell, length_shell_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_shell_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_userinfo(struct ndr_print *ndr, const char *name, const struct wbint_userinfo *r)
{
	ndr_print_struct(ndr, name, "wbint_userinfo");
	ndr->depth++;
	ndr_print_ptr(ndr, "acct_name", r->acct_name);
	ndr->depth++;
	if (r->acct_name) {
		ndr_print_string(ndr, "acct_name", r->acct_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "full_name", r->full_name);
	ndr->depth++;
	if (r->full_name) {
		ndr_print_string(ndr, "full_name", r->full_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "homedir", r->homedir);
	ndr->depth++;
	if (r->homedir) {
		ndr_print_string(ndr, "homedir", r->homedir);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "shell", r->shell);
	ndr->depth++;
	if (r->shell) {
		ndr_print_string(ndr, "shell", r->shell);
	}
	ndr->depth--;
	ndr_print_hyper(ndr, "primary_gid", r->primary_gid);
	ndr_print_dom_sid(ndr, "user_sid", &r->user_sid);
	ndr_print_dom_sid(ndr, "group_sid", &r->group_sid);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_wbint_SidArray(struct ndr_push *ndr, int ndr_flags, const struct wbint_SidArray *r)
{
	uint32_t cntr_sids_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_sids));
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_sids));
		for (cntr_sids_0 = 0; cntr_sids_0 < r->num_sids; cntr_sids_0++) {
			NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, &r->sids[cntr_sids_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_wbint_SidArray(struct ndr_pull *ndr, int ndr_flags, struct wbint_SidArray *r)
{
	uint32_t size_sids_0 = 0;
	uint32_t cntr_sids_0;
	TALLOC_CTX *_mem_save_sids_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->sids));
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_sids));
		size_sids_0 = ndr_get_array_size(ndr, &r->sids);
		NDR_PULL_ALLOC_N(ndr, r->sids, size_sids_0);
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
		for (cntr_sids_0 = 0; cntr_sids_0 < size_sids_0; cntr_sids_0++) {
			NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, &r->sids[cntr_sids_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, 0);
		if (r->sids) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->sids, r->num_sids));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_SidArray(struct ndr_print *ndr, const char *name, const struct wbint_SidArray *r)
{
	uint32_t cntr_sids_0;
	ndr_print_struct(ndr, name, "wbint_SidArray");
	ndr->depth++;
	ndr_print_uint32(ndr, "num_sids", r->num_sids);
	ndr->print(ndr, "%s: ARRAY(%d)", "sids", (int)r->num_sids);
	ndr->depth++;
	for (cntr_sids_0=0;cntr_sids_0<r->num_sids;cntr_sids_0++) {
		char *idx_0=NULL;
		if (asprintf(&idx_0, "[%d]", cntr_sids_0) != -1) {
			ndr_print_dom_sid(ndr, "sids", &r->sids[cntr_sids_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_wbint_RidArray(struct ndr_push *ndr, int ndr_flags, const struct wbint_RidArray *r)
{
	uint32_t cntr_rids_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_rids));
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_rids));
		for (cntr_rids_0 = 0; cntr_rids_0 < r->num_rids; cntr_rids_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rids[cntr_rids_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_wbint_RidArray(struct ndr_pull *ndr, int ndr_flags, struct wbint_RidArray *r)
{
	uint32_t size_rids_0 = 0;
	uint32_t cntr_rids_0;
	TALLOC_CTX *_mem_save_rids_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->rids));
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_rids));
		size_rids_0 = ndr_get_array_size(ndr, &r->rids);
		NDR_PULL_ALLOC_N(ndr, r->rids, size_rids_0);
		_mem_save_rids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->rids, 0);
		for (cntr_rids_0 = 0; cntr_rids_0 < size_rids_0; cntr_rids_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rids[cntr_rids_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rids_0, 0);
		if (r->rids) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->rids, r->num_rids));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_RidArray(struct ndr_print *ndr, const char *name, const struct wbint_RidArray *r)
{
	uint32_t cntr_rids_0;
	ndr_print_struct(ndr, name, "wbint_RidArray");
	ndr->depth++;
	ndr_print_uint32(ndr, "num_rids", r->num_rids);
	ndr->print(ndr, "%s: ARRAY(%d)", "rids", (int)r->num_rids);
	ndr->depth++;
	for (cntr_rids_0=0;cntr_rids_0<r->num_rids;cntr_rids_0++) {
		char *idx_0=NULL;
		if (asprintf(&idx_0, "[%d]", cntr_rids_0) != -1) {
			ndr_print_uint32(ndr, "rids", r->rids[cntr_rids_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_wbint_Principal(struct ndr_push *ndr, int ndr_flags, const struct wbint_Principal *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, &r->sid));
		NDR_CHECK(ndr_push_lsa_SidType(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->name, ndr_charset_length(r->name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_wbint_Principal(struct ndr_pull *ndr, int ndr_flags, struct wbint_Principal *r)
{
	uint32_t _ptr_name;
	uint32_t size_name_1 = 0;
	uint32_t length_name_1 = 0;
	TALLOC_CTX *_mem_save_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, &r->sid));
		NDR_CHECK(ndr_pull_lsa_SidType(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->name);
		} else {
			r->name = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->name));
			size_name_1 = ndr_get_array_size(ndr, &r->name);
			length_name_1 = ndr_get_array_length(ndr, &r->name);
			if (length_name_1 > size_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_name_1, length_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->name, length_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_Principal(struct ndr_print *ndr, const char *name, const struct wbint_Principal *r)
{
	ndr_print_struct(ndr, name, "wbint_Principal");
	ndr->depth++;
	ndr_print_dom_sid(ndr, "sid", &r->sid);
	ndr_print_lsa_SidType(ndr, "type", r->type);
	ndr_print_ptr(ndr, "name", r->name);
	ndr->depth++;
	if (r->name) {
		ndr_print_string(ndr, "name", r->name);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_wbint_Principals(struct ndr_push *ndr, int ndr_flags, const struct wbint_Principals *r)
{
	uint32_t cntr_principals_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_principals));
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->num_principals));
		for (cntr_principals_0 = 0; cntr_principals_0 < r->num_principals; cntr_principals_0++) {
			NDR_CHECK(ndr_push_wbint_Principal(ndr, NDR_SCALARS, &r->principals[cntr_principals_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_principals_0 = 0; cntr_principals_0 < r->num_principals; cntr_principals_0++) {
			NDR_CHECK(ndr_push_wbint_Principal(ndr, NDR_BUFFERS, &r->principals[cntr_principals_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_wbint_Principals(struct ndr_pull *ndr, int ndr_flags, struct wbint_Principals *r)
{
	uint32_t size_principals_0 = 0;
	uint32_t cntr_principals_0;
	TALLOC_CTX *_mem_save_principals_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->principals));
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->num_principals));
		size_principals_0 = ndr_get_array_size(ndr, &r->principals);
		NDR_PULL_ALLOC_N(ndr, r->principals, size_principals_0);
		_mem_save_principals_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->principals, 0);
		for (cntr_principals_0 = 0; cntr_principals_0 < size_principals_0; cntr_principals_0++) {
			NDR_CHECK(ndr_pull_wbint_Principal(ndr, NDR_SCALARS, &r->principals[cntr_principals_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_principals_0, 0);
		if (r->principals) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->principals, r->num_principals));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		size_principals_0 = ndr_get_array_size(ndr, &r->principals);
		_mem_save_principals_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->principals, 0);
		for (cntr_principals_0 = 0; cntr_principals_0 < size_principals_0; cntr_principals_0++) {
			NDR_CHECK(ndr_pull_wbint_Principal(ndr, NDR_BUFFERS, &r->principals[cntr_principals_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_principals_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_Principals(struct ndr_print *ndr, const char *name, const struct wbint_Principals *r)
{
	uint32_t cntr_principals_0;
	ndr_print_struct(ndr, name, "wbint_Principals");
	ndr->depth++;
	ndr_print_int32(ndr, "num_principals", r->num_principals);
	ndr->print(ndr, "%s: ARRAY(%d)", "principals", (int)r->num_principals);
	ndr->depth++;
	for (cntr_principals_0=0;cntr_principals_0<r->num_principals;cntr_principals_0++) {
		char *idx_0=NULL;
		if (asprintf(&idx_0, "[%d]", cntr_principals_0) != -1) {
			ndr_print_wbint_Principal(ndr, "principals", &r->principals[cntr_principals_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_wbint_userinfos(struct ndr_push *ndr, int ndr_flags, const struct wbint_userinfos *r)
{
	uint32_t cntr_userinfos_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_userinfos));
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_userinfos));
		for (cntr_userinfos_0 = 0; cntr_userinfos_0 < r->num_userinfos; cntr_userinfos_0++) {
			NDR_CHECK(ndr_push_wbint_userinfo(ndr, NDR_SCALARS, &r->userinfos[cntr_userinfos_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_userinfos_0 = 0; cntr_userinfos_0 < r->num_userinfos; cntr_userinfos_0++) {
			NDR_CHECK(ndr_push_wbint_userinfo(ndr, NDR_BUFFERS, &r->userinfos[cntr_userinfos_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_wbint_userinfos(struct ndr_pull *ndr, int ndr_flags, struct wbint_userinfos *r)
{
	uint32_t size_userinfos_0 = 0;
	uint32_t cntr_userinfos_0;
	TALLOC_CTX *_mem_save_userinfos_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->userinfos));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_userinfos));
		size_userinfos_0 = ndr_get_array_size(ndr, &r->userinfos);
		NDR_PULL_ALLOC_N(ndr, r->userinfos, size_userinfos_0);
		_mem_save_userinfos_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->userinfos, 0);
		for (cntr_userinfos_0 = 0; cntr_userinfos_0 < size_userinfos_0; cntr_userinfos_0++) {
			NDR_CHECK(ndr_pull_wbint_userinfo(ndr, NDR_SCALARS, &r->userinfos[cntr_userinfos_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_userinfos_0, 0);
		if (r->userinfos) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->userinfos, r->num_userinfos));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		size_userinfos_0 = ndr_get_array_size(ndr, &r->userinfos);
		_mem_save_userinfos_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->userinfos, 0);
		for (cntr_userinfos_0 = 0; cntr_userinfos_0 < size_userinfos_0; cntr_userinfos_0++) {
			NDR_CHECK(ndr_pull_wbint_userinfo(ndr, NDR_BUFFERS, &r->userinfos[cntr_userinfos_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_userinfos_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_userinfos(struct ndr_print *ndr, const char *name, const struct wbint_userinfos *r)
{
	uint32_t cntr_userinfos_0;
	ndr_print_struct(ndr, name, "wbint_userinfos");
	ndr->depth++;
	ndr_print_uint32(ndr, "num_userinfos", r->num_userinfos);
	ndr->print(ndr, "%s: ARRAY(%d)", "userinfos", (int)r->num_userinfos);
	ndr->depth++;
	for (cntr_userinfos_0=0;cntr_userinfos_0<r->num_userinfos;cntr_userinfos_0++) {
		char *idx_0=NULL;
		if (asprintf(&idx_0, "[%d]", cntr_userinfos_0) != -1) {
			ndr_print_wbint_userinfo(ndr, "userinfos", &r->userinfos[cntr_userinfos_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_wbint_IdType(struct ndr_push *ndr, int ndr_flags, enum wbint_IdType r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_wbint_IdType(struct ndr_pull *ndr, int ndr_flags, enum wbint_IdType *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_IdType(struct ndr_print *ndr, const char *name, enum wbint_IdType r)
{
	const char *val = NULL;

	switch (r) {
		case WBINT_ID_TYPE_NOT_SPECIFIED: val = "WBINT_ID_TYPE_NOT_SPECIFIED"; break;
		case WBINT_ID_TYPE_UID: val = "WBINT_ID_TYPE_UID"; break;
		case WBINT_ID_TYPE_GID: val = "WBINT_ID_TYPE_GID"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_wbint_Ping(struct ndr_push *ndr, int flags, const struct wbint_Ping *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.in_data));
	}
	if (flags & NDR_OUT) {
		if (r->out.out_data == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.out_data));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_Ping(struct ndr_pull *ndr, int flags, struct wbint_Ping *r)
{
	TALLOC_CTX *_mem_save_out_data_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.in_data));
		NDR_PULL_ALLOC(ndr, r->out.out_data);
		ZERO_STRUCTP(r->out.out_data);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.out_data);
		}
		_mem_save_out_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.out_data, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.out_data));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_out_data_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_Ping(struct ndr_print *ndr, const char *name, int flags, const struct wbint_Ping *r)
{
	ndr_print_struct(ndr, name, "wbint_Ping");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_Ping");
		ndr->depth++;
		ndr_print_uint32(ndr, "in_data", r->in.in_data);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_Ping");
		ndr->depth++;
		ndr_print_ptr(ndr, "out_data", r->out.out_data);
		ndr->depth++;
		ndr_print_uint32(ndr, "out_data", *r->out.out_data);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_LookupSid(struct ndr_push *ndr, int flags, const struct wbint_LookupSid *r)
{
	if (flags & NDR_IN) {
		if (r->in.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->in.sid));
	}
	if (flags & NDR_OUT) {
		if (r->out.type == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_SidType(ndr, NDR_SCALARS, *r->out.type));
		if (r->out.domain == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.domain));
		if (*r->out.domain) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.domain, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.domain, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.domain, ndr_charset_length(*r->out.domain, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->out.name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.name));
		if (*r->out.name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.name, ndr_charset_length(*r->out.name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_LookupSid(struct ndr_pull *ndr, int flags, struct wbint_LookupSid *r)
{
	uint32_t _ptr_domain;
	uint32_t size_domain_2 = 0;
	uint32_t length_domain_2 = 0;
	uint32_t _ptr_name;
	uint32_t size_name_2 = 0;
	uint32_t length_name_2 = 0;
	TALLOC_CTX *_mem_save_sid_0;
	TALLOC_CTX *_mem_save_type_0;
	TALLOC_CTX *_mem_save_domain_0;
	TALLOC_CTX *_mem_save_domain_1;
	TALLOC_CTX *_mem_save_name_0;
	TALLOC_CTX *_mem_save_name_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.type);
		ZERO_STRUCTP(r->out.type);
		NDR_PULL_ALLOC(ndr, r->out.domain);
		ZERO_STRUCTP(r->out.domain);
		NDR_PULL_ALLOC(ndr, r->out.name);
		ZERO_STRUCTP(r->out.name);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.type);
		}
		_mem_save_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.type, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_SidType(ndr, NDR_SCALARS, r->out.type));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_type_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.domain);
		}
		_mem_save_domain_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.domain, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain));
		if (_ptr_domain) {
			NDR_PULL_ALLOC(ndr, *r->out.domain);
		} else {
			*r->out.domain = NULL;
		}
		if (*r->out.domain) {
			_mem_save_domain_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.domain, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.domain));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.domain));
			size_domain_2 = ndr_get_array_size(ndr, r->out.domain);
			length_domain_2 = ndr_get_array_length(ndr, r->out.domain);
			if (length_domain_2 > size_domain_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_domain_2, length_domain_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_2, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.domain, length_domain_2, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.name);
		}
		_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, *r->out.name);
		} else {
			*r->out.name = NULL;
		}
		if (*r->out.name) {
			_mem_save_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.name));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.name));
			size_name_2 = ndr_get_array_size(ndr, r->out.name);
			length_name_2 = ndr_get_array_length(ndr, r->out.name);
			if (length_name_2 > size_name_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_name_2, length_name_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_name_2, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.name, length_name_2, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_LookupSid(struct ndr_print *ndr, const char *name, int flags, const struct wbint_LookupSid *r)
{
	ndr_print_struct(ndr, name, "wbint_LookupSid");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_LookupSid");
		ndr->depth++;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_LookupSid");
		ndr->depth++;
		ndr_print_ptr(ndr, "type", r->out.type);
		ndr->depth++;
		ndr_print_lsa_SidType(ndr, "type", *r->out.type);
		ndr->depth--;
		ndr_print_ptr(ndr, "domain", r->out.domain);
		ndr->depth++;
		ndr_print_ptr(ndr, "domain", *r->out.domain);
		ndr->depth++;
		if (*r->out.domain) {
			ndr_print_string(ndr, "domain", *r->out.domain);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "name", r->out.name);
		ndr->depth++;
		ndr_print_ptr(ndr, "name", *r->out.name);
		ndr->depth++;
		if (*r->out.name) {
			ndr_print_string(ndr, "name", *r->out.name);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_LookupName(struct ndr_push *ndr, int flags, const struct wbint_LookupName *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.domain, ndr_charset_length(r->in.domain, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		if (r->in.name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.name, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.name, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.name, ndr_charset_length(r->in.name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.type == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_SidType(ndr, NDR_SCALARS, *r->out.type));
		if (r->out.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->out.sid));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_LookupName(struct ndr_pull *ndr, int flags, struct wbint_LookupName *r)
{
	uint32_t size_domain_1 = 0;
	uint32_t length_domain_1 = 0;
	uint32_t size_name_1 = 0;
	uint32_t length_name_1 = 0;
	TALLOC_CTX *_mem_save_type_0;
	TALLOC_CTX *_mem_save_sid_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.domain));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.domain));
		size_domain_1 = ndr_get_array_size(ndr, &r->in.domain);
		length_domain_1 = ndr_get_array_length(ndr, &r->in.domain);
		if (length_domain_1 > size_domain_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_domain_1, length_domain_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.domain, length_domain_1, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.name));
		size_name_1 = ndr_get_array_size(ndr, &r->in.name);
		length_name_1 = ndr_get_array_length(ndr, &r->in.name);
		if (length_name_1 > size_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_name_1, length_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_name_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.name, length_name_1, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.type);
		ZERO_STRUCTP(r->out.type);
		NDR_PULL_ALLOC(ndr, r->out.sid);
		ZERO_STRUCTP(r->out.sid);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.type);
		}
		_mem_save_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.type, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_SidType(ndr, NDR_SCALARS, r->out.type));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_type_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->out.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_LookupName(struct ndr_print *ndr, const char *name, int flags, const struct wbint_LookupName *r)
{
	ndr_print_struct(ndr, name, "wbint_LookupName");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_LookupName");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain", r->in.domain);
		ndr->depth++;
		ndr_print_string(ndr, "domain", r->in.domain);
		ndr->depth--;
		ndr_print_ptr(ndr, "name", r->in.name);
		ndr->depth++;
		ndr_print_string(ndr, "name", r->in.name);
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_LookupName");
		ndr->depth++;
		ndr_print_ptr(ndr, "type", r->out.type);
		ndr->depth++;
		ndr_print_lsa_SidType(ndr, "type", *r->out.type);
		ndr->depth--;
		ndr_print_ptr(ndr, "sid", r->out.sid);
		ndr->depth++;
		ndr_print_dom_sid(ndr, "sid", r->out.sid);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_Sid2Uid(struct ndr_push *ndr, int flags, const struct wbint_Sid2Uid *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.dom_name));
		if (r->in.dom_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.dom_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.dom_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.dom_name, ndr_charset_length(r->in.dom_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->in.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->in.sid));
	}
	if (flags & NDR_OUT) {
		if (r->out.uid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->out.uid));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_Sid2Uid(struct ndr_pull *ndr, int flags, struct wbint_Sid2Uid *r)
{
	uint32_t _ptr_dom_name;
	uint32_t size_dom_name_1 = 0;
	uint32_t length_dom_name_1 = 0;
	TALLOC_CTX *_mem_save_dom_name_0;
	TALLOC_CTX *_mem_save_sid_0;
	TALLOC_CTX *_mem_save_uid_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dom_name));
		if (_ptr_dom_name) {
			NDR_PULL_ALLOC(ndr, r->in.dom_name);
		} else {
			r->in.dom_name = NULL;
		}
		if (r->in.dom_name) {
			_mem_save_dom_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.dom_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dom_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.dom_name));
			size_dom_name_1 = ndr_get_array_size(ndr, &r->in.dom_name);
			length_dom_name_1 = ndr_get_array_length(ndr, &r->in.dom_name);
			if (length_dom_name_1 > size_dom_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dom_name_1, length_dom_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dom_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.dom_name, length_dom_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dom_name_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.uid);
		ZERO_STRUCTP(r->out.uid);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.uid);
		}
		_mem_save_uid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.uid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->out.uid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_uid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_Sid2Uid(struct ndr_print *ndr, const char *name, int flags, const struct wbint_Sid2Uid *r)
{
	ndr_print_struct(ndr, name, "wbint_Sid2Uid");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_Sid2Uid");
		ndr->depth++;
		ndr_print_ptr(ndr, "dom_name", r->in.dom_name);
		ndr->depth++;
		if (r->in.dom_name) {
			ndr_print_string(ndr, "dom_name", r->in.dom_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_Sid2Uid");
		ndr->depth++;
		ndr_print_ptr(ndr, "uid", r->out.uid);
		ndr->depth++;
		ndr_print_hyper(ndr, "uid", *r->out.uid);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_Sid2Gid(struct ndr_push *ndr, int flags, const struct wbint_Sid2Gid *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.dom_name));
		if (r->in.dom_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.dom_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.dom_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.dom_name, ndr_charset_length(r->in.dom_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->in.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->in.sid));
	}
	if (flags & NDR_OUT) {
		if (r->out.gid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->out.gid));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_Sid2Gid(struct ndr_pull *ndr, int flags, struct wbint_Sid2Gid *r)
{
	uint32_t _ptr_dom_name;
	uint32_t size_dom_name_1 = 0;
	uint32_t length_dom_name_1 = 0;
	TALLOC_CTX *_mem_save_dom_name_0;
	TALLOC_CTX *_mem_save_sid_0;
	TALLOC_CTX *_mem_save_gid_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dom_name));
		if (_ptr_dom_name) {
			NDR_PULL_ALLOC(ndr, r->in.dom_name);
		} else {
			r->in.dom_name = NULL;
		}
		if (r->in.dom_name) {
			_mem_save_dom_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.dom_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dom_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.dom_name));
			size_dom_name_1 = ndr_get_array_size(ndr, &r->in.dom_name);
			length_dom_name_1 = ndr_get_array_length(ndr, &r->in.dom_name);
			if (length_dom_name_1 > size_dom_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dom_name_1, length_dom_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dom_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.dom_name, length_dom_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dom_name_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.gid);
		ZERO_STRUCTP(r->out.gid);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.gid);
		}
		_mem_save_gid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.gid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->out.gid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_gid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_Sid2Gid(struct ndr_print *ndr, const char *name, int flags, const struct wbint_Sid2Gid *r)
{
	ndr_print_struct(ndr, name, "wbint_Sid2Gid");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_Sid2Gid");
		ndr->depth++;
		ndr_print_ptr(ndr, "dom_name", r->in.dom_name);
		ndr->depth++;
		if (r->in.dom_name) {
			ndr_print_string(ndr, "dom_name", r->in.dom_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_Sid2Gid");
		ndr->depth++;
		ndr_print_ptr(ndr, "gid", r->out.gid);
		ndr->depth++;
		ndr_print_hyper(ndr, "gid", *r->out.gid);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_Uid2Sid(struct ndr_push *ndr, int flags, const struct wbint_Uid2Sid *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.dom_name));
		if (r->in.dom_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.dom_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.dom_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.dom_name, ndr_charset_length(r->in.dom_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.uid));
	}
	if (flags & NDR_OUT) {
		if (r->out.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->out.sid));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_Uid2Sid(struct ndr_pull *ndr, int flags, struct wbint_Uid2Sid *r)
{
	uint32_t _ptr_dom_name;
	uint32_t size_dom_name_1 = 0;
	uint32_t length_dom_name_1 = 0;
	TALLOC_CTX *_mem_save_dom_name_0;
	TALLOC_CTX *_mem_save_sid_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dom_name));
		if (_ptr_dom_name) {
			NDR_PULL_ALLOC(ndr, r->in.dom_name);
		} else {
			r->in.dom_name = NULL;
		}
		if (r->in.dom_name) {
			_mem_save_dom_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.dom_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dom_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.dom_name));
			size_dom_name_1 = ndr_get_array_size(ndr, &r->in.dom_name);
			length_dom_name_1 = ndr_get_array_length(ndr, &r->in.dom_name);
			if (length_dom_name_1 > size_dom_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dom_name_1, length_dom_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dom_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.dom_name, length_dom_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dom_name_0, 0);
		}
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.uid));
		NDR_PULL_ALLOC(ndr, r->out.sid);
		ZERO_STRUCTP(r->out.sid);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->out.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_Uid2Sid(struct ndr_print *ndr, const char *name, int flags, const struct wbint_Uid2Sid *r)
{
	ndr_print_struct(ndr, name, "wbint_Uid2Sid");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_Uid2Sid");
		ndr->depth++;
		ndr_print_ptr(ndr, "dom_name", r->in.dom_name);
		ndr->depth++;
		if (r->in.dom_name) {
			ndr_print_string(ndr, "dom_name", r->in.dom_name);
		}
		ndr->depth--;
		ndr_print_hyper(ndr, "uid", r->in.uid);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_Uid2Sid");
		ndr->depth++;
		ndr_print_ptr(ndr, "sid", r->out.sid);
		ndr->depth++;
		ndr_print_dom_sid(ndr, "sid", r->out.sid);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_Gid2Sid(struct ndr_push *ndr, int flags, const struct wbint_Gid2Sid *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.dom_name));
		if (r->in.dom_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.dom_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.dom_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.dom_name, ndr_charset_length(r->in.dom_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.gid));
	}
	if (flags & NDR_OUT) {
		if (r->out.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->out.sid));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_Gid2Sid(struct ndr_pull *ndr, int flags, struct wbint_Gid2Sid *r)
{
	uint32_t _ptr_dom_name;
	uint32_t size_dom_name_1 = 0;
	uint32_t length_dom_name_1 = 0;
	TALLOC_CTX *_mem_save_dom_name_0;
	TALLOC_CTX *_mem_save_sid_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dom_name));
		if (_ptr_dom_name) {
			NDR_PULL_ALLOC(ndr, r->in.dom_name);
		} else {
			r->in.dom_name = NULL;
		}
		if (r->in.dom_name) {
			_mem_save_dom_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.dom_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dom_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.dom_name));
			size_dom_name_1 = ndr_get_array_size(ndr, &r->in.dom_name);
			length_dom_name_1 = ndr_get_array_length(ndr, &r->in.dom_name);
			if (length_dom_name_1 > size_dom_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dom_name_1, length_dom_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dom_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.dom_name, length_dom_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dom_name_0, 0);
		}
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.gid));
		NDR_PULL_ALLOC(ndr, r->out.sid);
		ZERO_STRUCTP(r->out.sid);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->out.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_Gid2Sid(struct ndr_print *ndr, const char *name, int flags, const struct wbint_Gid2Sid *r)
{
	ndr_print_struct(ndr, name, "wbint_Gid2Sid");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_Gid2Sid");
		ndr->depth++;
		ndr_print_ptr(ndr, "dom_name", r->in.dom_name);
		ndr->depth++;
		if (r->in.dom_name) {
			ndr_print_string(ndr, "dom_name", r->in.dom_name);
		}
		ndr->depth--;
		ndr_print_hyper(ndr, "gid", r->in.gid);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_Gid2Sid");
		ndr->depth++;
		ndr_print_ptr(ndr, "sid", r->out.sid);
		ndr->depth++;
		ndr_print_dom_sid(ndr, "sid", r->out.sid);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_AllocateUid(struct ndr_push *ndr, int flags, const struct wbint_AllocateUid *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.uid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->out.uid));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_AllocateUid(struct ndr_pull *ndr, int flags, struct wbint_AllocateUid *r)
{
	TALLOC_CTX *_mem_save_uid_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.uid);
		ZERO_STRUCTP(r->out.uid);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.uid);
		}
		_mem_save_uid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.uid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->out.uid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_uid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_AllocateUid(struct ndr_print *ndr, const char *name, int flags, const struct wbint_AllocateUid *r)
{
	ndr_print_struct(ndr, name, "wbint_AllocateUid");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_AllocateUid");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_AllocateUid");
		ndr->depth++;
		ndr_print_ptr(ndr, "uid", r->out.uid);
		ndr->depth++;
		ndr_print_hyper(ndr, "uid", *r->out.uid);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_AllocateGid(struct ndr_push *ndr, int flags, const struct wbint_AllocateGid *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.gid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->out.gid));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_AllocateGid(struct ndr_pull *ndr, int flags, struct wbint_AllocateGid *r)
{
	TALLOC_CTX *_mem_save_gid_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.gid);
		ZERO_STRUCTP(r->out.gid);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.gid);
		}
		_mem_save_gid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.gid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->out.gid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_gid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_AllocateGid(struct ndr_print *ndr, const char *name, int flags, const struct wbint_AllocateGid *r)
{
	ndr_print_struct(ndr, name, "wbint_AllocateGid");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_AllocateGid");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_AllocateGid");
		ndr->depth++;
		ndr_print_ptr(ndr, "gid", r->out.gid);
		ndr->depth++;
		ndr_print_hyper(ndr, "gid", *r->out.gid);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_QueryUser(struct ndr_push *ndr, int flags, const struct wbint_QueryUser *r)
{
	if (flags & NDR_IN) {
		if (r->in.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->in.sid));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_wbint_userinfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_QueryUser(struct ndr_pull *ndr, int flags, struct wbint_QueryUser *r)
{
	TALLOC_CTX *_mem_save_sid_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_userinfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_QueryUser(struct ndr_print *ndr, const char *name, int flags, const struct wbint_QueryUser *r)
{
	ndr_print_struct(ndr, name, "wbint_QueryUser");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_QueryUser");
		ndr->depth++;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_QueryUser");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_wbint_userinfo(ndr, "info", r->out.info);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_LookupUserAliases(struct ndr_push *ndr, int flags, const struct wbint_LookupUserAliases *r)
{
	if (flags & NDR_IN) {
		if (r->in.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_wbint_SidArray(ndr, NDR_SCALARS, r->in.sids));
	}
	if (flags & NDR_OUT) {
		if (r->out.rids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_wbint_RidArray(ndr, NDR_SCALARS, r->out.rids));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_LookupUserAliases(struct ndr_pull *ndr, int flags, struct wbint_LookupUserAliases *r)
{
	TALLOC_CTX *_mem_save_sids_0;
	TALLOC_CTX *_mem_save_rids_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_SidArray(ndr, NDR_SCALARS, r->in.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.rids);
		ZERO_STRUCTP(r->out.rids);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rids);
		}
		_mem_save_rids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_RidArray(ndr, NDR_SCALARS, r->out.rids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_LookupUserAliases(struct ndr_print *ndr, const char *name, int flags, const struct wbint_LookupUserAliases *r)
{
	ndr_print_struct(ndr, name, "wbint_LookupUserAliases");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_LookupUserAliases");
		ndr->depth++;
		ndr_print_ptr(ndr, "sids", r->in.sids);
		ndr->depth++;
		ndr_print_wbint_SidArray(ndr, "sids", r->in.sids);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_LookupUserAliases");
		ndr->depth++;
		ndr_print_ptr(ndr, "rids", r->out.rids);
		ndr->depth++;
		ndr_print_wbint_RidArray(ndr, "rids", r->out.rids);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_LookupUserGroups(struct ndr_push *ndr, int flags, const struct wbint_LookupUserGroups *r)
{
	if (flags & NDR_IN) {
		if (r->in.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->in.sid));
	}
	if (flags & NDR_OUT) {
		if (r->out.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_wbint_SidArray(ndr, NDR_SCALARS, r->out.sids));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_LookupUserGroups(struct ndr_pull *ndr, int flags, struct wbint_LookupUserGroups *r)
{
	TALLOC_CTX *_mem_save_sid_0;
	TALLOC_CTX *_mem_save_sids_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.sids);
		ZERO_STRUCTP(r->out.sids);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_SidArray(ndr, NDR_SCALARS, r->out.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_LookupUserGroups(struct ndr_print *ndr, const char *name, int flags, const struct wbint_LookupUserGroups *r)
{
	ndr_print_struct(ndr, name, "wbint_LookupUserGroups");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_LookupUserGroups");
		ndr->depth++;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_LookupUserGroups");
		ndr->depth++;
		ndr_print_ptr(ndr, "sids", r->out.sids);
		ndr->depth++;
		ndr_print_wbint_SidArray(ndr, "sids", r->out.sids);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_QuerySequenceNumber(struct ndr_push *ndr, int flags, const struct wbint_QuerySequenceNumber *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.sequence == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.sequence));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_QuerySequenceNumber(struct ndr_pull *ndr, int flags, struct wbint_QuerySequenceNumber *r)
{
	TALLOC_CTX *_mem_save_sequence_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.sequence);
		ZERO_STRUCTP(r->out.sequence);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sequence);
		}
		_mem_save_sequence_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sequence, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.sequence));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sequence_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_QuerySequenceNumber(struct ndr_print *ndr, const char *name, int flags, const struct wbint_QuerySequenceNumber *r)
{
	ndr_print_struct(ndr, name, "wbint_QuerySequenceNumber");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_QuerySequenceNumber");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_QuerySequenceNumber");
		ndr->depth++;
		ndr_print_ptr(ndr, "sequence", r->out.sequence);
		ndr->depth++;
		ndr_print_uint32(ndr, "sequence", *r->out.sequence);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_LookupGroupMembers(struct ndr_push *ndr, int flags, const struct wbint_LookupGroupMembers *r)
{
	if (flags & NDR_IN) {
		if (r->in.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->in.sid));
		NDR_CHECK(ndr_push_lsa_SidType(ndr, NDR_SCALARS, r->in.type));
	}
	if (flags & NDR_OUT) {
		if (r->out.members == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_wbint_Principals(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.members));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_LookupGroupMembers(struct ndr_pull *ndr, int flags, struct wbint_LookupGroupMembers *r)
{
	TALLOC_CTX *_mem_save_sid_0;
	TALLOC_CTX *_mem_save_members_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_SidType(ndr, NDR_SCALARS, &r->in.type));
		NDR_PULL_ALLOC(ndr, r->out.members);
		ZERO_STRUCTP(r->out.members);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.members);
		}
		_mem_save_members_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.members, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_Principals(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.members));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_members_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_LookupGroupMembers(struct ndr_print *ndr, const char *name, int flags, const struct wbint_LookupGroupMembers *r)
{
	ndr_print_struct(ndr, name, "wbint_LookupGroupMembers");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_LookupGroupMembers");
		ndr->depth++;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr_print_lsa_SidType(ndr, "type", r->in.type);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_LookupGroupMembers");
		ndr->depth++;
		ndr_print_ptr(ndr, "members", r->out.members);
		ndr->depth++;
		ndr_print_wbint_Principals(ndr, "members", r->out.members);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_QueryUserList(struct ndr_push *ndr, int flags, const struct wbint_QueryUserList *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.users == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_wbint_userinfos(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.users));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_QueryUserList(struct ndr_pull *ndr, int flags, struct wbint_QueryUserList *r)
{
	TALLOC_CTX *_mem_save_users_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.users);
		ZERO_STRUCTP(r->out.users);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.users);
		}
		_mem_save_users_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.users, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_userinfos(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.users));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_users_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_QueryUserList(struct ndr_print *ndr, const char *name, int flags, const struct wbint_QueryUserList *r)
{
	ndr_print_struct(ndr, name, "wbint_QueryUserList");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_QueryUserList");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_QueryUserList");
		ndr->depth++;
		ndr_print_ptr(ndr, "users", r->out.users);
		ndr->depth++;
		ndr_print_wbint_userinfos(ndr, "users", r->out.users);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_QueryGroupList(struct ndr_push *ndr, int flags, const struct wbint_QueryGroupList *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.groups == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_wbint_Principals(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.groups));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_QueryGroupList(struct ndr_pull *ndr, int flags, struct wbint_QueryGroupList *r)
{
	TALLOC_CTX *_mem_save_groups_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.groups);
		ZERO_STRUCTP(r->out.groups);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.groups);
		}
		_mem_save_groups_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.groups, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_Principals(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.groups));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_groups_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_QueryGroupList(struct ndr_print *ndr, const char *name, int flags, const struct wbint_QueryGroupList *r)
{
	ndr_print_struct(ndr, name, "wbint_QueryGroupList");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_QueryGroupList");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_QueryGroupList");
		ndr->depth++;
		ndr_print_ptr(ndr, "groups", r->out.groups);
		ndr->depth++;
		ndr_print_wbint_Principals(ndr, "groups", r->out.groups);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_DsGetDcName(struct ndr_push *ndr, int flags, const struct wbint_DsGetDcName *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain_name, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain_name, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.domain_name, ndr_charset_length(r->in.domain_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.domain_guid));
		if (r->in.domain_guid) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->in.domain_guid));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.site_name));
		if (r->in.site_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.site_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.site_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.site_name, ndr_charset_length(r->in.site_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.dc_info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.dc_info));
		if (*r->out.dc_info) {
			NDR_CHECK(ndr_push_netr_DsRGetDCNameInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.dc_info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_DsGetDcName(struct ndr_pull *ndr, int flags, struct wbint_DsGetDcName *r)
{
	uint32_t size_domain_name_1 = 0;
	uint32_t length_domain_name_1 = 0;
	uint32_t _ptr_domain_guid;
	uint32_t _ptr_site_name;
	uint32_t size_site_name_1 = 0;
	uint32_t length_site_name_1 = 0;
	uint32_t _ptr_dc_info;
	TALLOC_CTX *_mem_save_domain_guid_0;
	TALLOC_CTX *_mem_save_site_name_0;
	TALLOC_CTX *_mem_save_dc_info_0;
	TALLOC_CTX *_mem_save_dc_info_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.domain_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.domain_name));
		size_domain_name_1 = ndr_get_array_size(ndr, &r->in.domain_name);
		length_domain_name_1 = ndr_get_array_length(ndr, &r->in.domain_name);
		if (length_domain_name_1 > size_domain_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_domain_name_1, length_domain_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_name_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.domain_name, length_domain_name_1, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_guid));
		if (_ptr_domain_guid) {
			NDR_PULL_ALLOC(ndr, r->in.domain_guid);
		} else {
			r->in.domain_guid = NULL;
		}
		if (r->in.domain_guid) {
			_mem_save_domain_guid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_guid, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->in.domain_guid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_guid_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_site_name));
		if (_ptr_site_name) {
			NDR_PULL_ALLOC(ndr, r->in.site_name);
		} else {
			r->in.site_name = NULL;
		}
		if (r->in.site_name) {
			_mem_save_site_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.site_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.site_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.site_name));
			size_site_name_1 = ndr_get_array_size(ndr, &r->in.site_name);
			length_site_name_1 = ndr_get_array_length(ndr, &r->in.site_name);
			if (length_site_name_1 > size_site_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_site_name_1, length_site_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_site_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.site_name, length_site_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_site_name_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.dc_info);
		ZERO_STRUCTP(r->out.dc_info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.dc_info);
		}
		_mem_save_dc_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.dc_info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dc_info));
		if (_ptr_dc_info) {
			NDR_PULL_ALLOC(ndr, *r->out.dc_info);
		} else {
			*r->out.dc_info = NULL;
		}
		if (*r->out.dc_info) {
			_mem_save_dc_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.dc_info, 0);
			NDR_CHECK(ndr_pull_netr_DsRGetDCNameInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.dc_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dc_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dc_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_DsGetDcName(struct ndr_print *ndr, const char *name, int flags, const struct wbint_DsGetDcName *r)
{
	ndr_print_struct(ndr, name, "wbint_DsGetDcName");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_DsGetDcName");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_name", r->in.domain_name);
		ndr->depth++;
		ndr_print_string(ndr, "domain_name", r->in.domain_name);
		ndr->depth--;
		ndr_print_ptr(ndr, "domain_guid", r->in.domain_guid);
		ndr->depth++;
		if (r->in.domain_guid) {
			ndr_print_GUID(ndr, "domain_guid", r->in.domain_guid);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "site_name", r->in.site_name);
		ndr->depth++;
		if (r->in.site_name) {
			ndr_print_string(ndr, "site_name", r->in.site_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_DsGetDcName");
		ndr->depth++;
		ndr_print_ptr(ndr, "dc_info", r->out.dc_info);
		ndr->depth++;
		ndr_print_ptr(ndr, "dc_info", *r->out.dc_info);
		ndr->depth++;
		if (*r->out.dc_info) {
			ndr_print_netr_DsRGetDCNameInfo(ndr, "dc_info", *r->out.dc_info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_LookupRids(struct ndr_push *ndr, int flags, const struct wbint_LookupRids *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->in.domain_sid));
		if (r->in.rids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_wbint_RidArray(ndr, NDR_SCALARS, r->in.rids));
	}
	if (flags & NDR_OUT) {
		if (r->out.domain_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.domain_name));
		if (*r->out.domain_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.domain_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.domain_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.domain_name, ndr_charset_length(*r->out.domain_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->out.names == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_wbint_Principals(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_LookupRids(struct ndr_pull *ndr, int flags, struct wbint_LookupRids *r)
{
	uint32_t _ptr_domain_name;
	uint32_t size_domain_name_2 = 0;
	uint32_t length_domain_name_2 = 0;
	TALLOC_CTX *_mem_save_domain_sid_0;
	TALLOC_CTX *_mem_save_rids_0;
	TALLOC_CTX *_mem_save_domain_name_0;
	TALLOC_CTX *_mem_save_domain_name_1;
	TALLOC_CTX *_mem_save_names_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_sid);
		}
		_mem_save_domain_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->in.domain_sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_sid_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.rids);
		}
		_mem_save_rids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.rids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_RidArray(ndr, NDR_SCALARS, r->in.rids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.domain_name);
		ZERO_STRUCTP(r->out.domain_name);
		NDR_PULL_ALLOC(ndr, r->out.names);
		ZERO_STRUCTP(r->out.names);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.domain_name);
		}
		_mem_save_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.domain_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_name));
		if (_ptr_domain_name) {
			NDR_PULL_ALLOC(ndr, *r->out.domain_name);
		} else {
			*r->out.domain_name = NULL;
		}
		if (*r->out.domain_name) {
			_mem_save_domain_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.domain_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.domain_name));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.domain_name));
			size_domain_name_2 = ndr_get_array_size(ndr, r->out.domain_name);
			length_domain_name_2 = ndr_get_array_length(ndr, r->out.domain_name);
			if (length_domain_name_2 > size_domain_name_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_domain_name_2, length_domain_name_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_name_2, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.domain_name, length_domain_name_2, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_name_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_name_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.names);
		}
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_Principals(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_LookupRids(struct ndr_print *ndr, const char *name, int flags, const struct wbint_LookupRids *r)
{
	ndr_print_struct(ndr, name, "wbint_LookupRids");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_LookupRids");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_sid", r->in.domain_sid);
		ndr->depth++;
		ndr_print_dom_sid(ndr, "domain_sid", r->in.domain_sid);
		ndr->depth--;
		ndr_print_ptr(ndr, "rids", r->in.rids);
		ndr->depth++;
		ndr_print_wbint_RidArray(ndr, "rids", r->in.rids);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_LookupRids");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_name", r->out.domain_name);
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_name", *r->out.domain_name);
		ndr->depth++;
		if (*r->out.domain_name) {
			ndr_print_string(ndr, "domain_name", *r->out.domain_name);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "names", r->out.names);
		ndr->depth++;
		ndr_print_wbint_Principals(ndr, "names", r->out.names);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_CheckMachineAccount(struct ndr_push *ndr, int flags, const struct wbint_CheckMachineAccount *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_CheckMachineAccount(struct ndr_pull *ndr, int flags, struct wbint_CheckMachineAccount *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_CheckMachineAccount(struct ndr_print *ndr, const char *name, int flags, const struct wbint_CheckMachineAccount *r)
{
	ndr_print_struct(ndr, name, "wbint_CheckMachineAccount");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_CheckMachineAccount");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_CheckMachineAccount");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_ChangeMachineAccount(struct ndr_push *ndr, int flags, const struct wbint_ChangeMachineAccount *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_ChangeMachineAccount(struct ndr_pull *ndr, int flags, struct wbint_ChangeMachineAccount *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_ChangeMachineAccount(struct ndr_print *ndr, const char *name, int flags, const struct wbint_ChangeMachineAccount *r)
{
	ndr_print_struct(ndr, name, "wbint_ChangeMachineAccount");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_ChangeMachineAccount");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_ChangeMachineAccount");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_PingDc(struct ndr_push *ndr, int flags, const struct wbint_PingDc *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_PingDc(struct ndr_pull *ndr, int flags, struct wbint_PingDc *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_PingDc(struct ndr_print *ndr, const char *name, int flags, const struct wbint_PingDc *r)
{
	ndr_print_struct(ndr, name, "wbint_PingDc");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_PingDc");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_PingDc");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_SetMapping(struct ndr_push *ndr, int flags, const struct wbint_SetMapping *r)
{
	if (flags & NDR_IN) {
		if (r->in.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->in.sid));
		NDR_CHECK(ndr_push_wbint_IdType(ndr, NDR_SCALARS, r->in.type));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.id));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_SetMapping(struct ndr_pull *ndr, int flags, struct wbint_SetMapping *r)
{
	TALLOC_CTX *_mem_save_sid_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_IdType(ndr, NDR_SCALARS, &r->in.type));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.id));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_SetMapping(struct ndr_print *ndr, const char *name, int flags, const struct wbint_SetMapping *r)
{
	ndr_print_struct(ndr, name, "wbint_SetMapping");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_SetMapping");
		ndr->depth++;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr_print_wbint_IdType(ndr, "type", r->in.type);
		ndr_print_hyper(ndr, "id", r->in.id);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_SetMapping");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_RemoveMapping(struct ndr_push *ndr, int flags, const struct wbint_RemoveMapping *r)
{
	if (flags & NDR_IN) {
		if (r->in.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->in.sid));
		NDR_CHECK(ndr_push_wbint_IdType(ndr, NDR_SCALARS, r->in.type));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.id));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_RemoveMapping(struct ndr_pull *ndr, int flags, struct wbint_RemoveMapping *r)
{
	TALLOC_CTX *_mem_save_sid_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_IdType(ndr, NDR_SCALARS, &r->in.type));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.id));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_RemoveMapping(struct ndr_print *ndr, const char *name, int flags, const struct wbint_RemoveMapping *r)
{
	ndr_print_struct(ndr, name, "wbint_RemoveMapping");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_RemoveMapping");
		ndr->depth++;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr_print_wbint_IdType(ndr, "type", r->in.type);
		ndr_print_hyper(ndr, "id", r->in.id);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_RemoveMapping");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_SetHWM(struct ndr_push *ndr, int flags, const struct wbint_SetHWM *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_wbint_IdType(ndr, NDR_SCALARS, r->in.type));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.id));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_SetHWM(struct ndr_pull *ndr, int flags, struct wbint_SetHWM *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_wbint_IdType(ndr, NDR_SCALARS, &r->in.type));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.id));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_SetHWM(struct ndr_print *ndr, const char *name, int flags, const struct wbint_SetHWM *r)
{
	ndr_print_struct(ndr, name, "wbint_SetHWM");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_SetHWM");
		ndr->depth++;
		ndr_print_wbint_IdType(ndr, "type", r->in.type);
		ndr_print_hyper(ndr, "id", r->in.id);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_SetHWM");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call wbint_calls[] = {
	{
		"wbint_Ping",
		sizeof(struct wbint_Ping),
		(ndr_push_flags_fn_t) ndr_push_wbint_Ping,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_Ping,
		(ndr_print_function_t) ndr_print_wbint_Ping,
		false,
	},
	{
		"wbint_LookupSid",
		sizeof(struct wbint_LookupSid),
		(ndr_push_flags_fn_t) ndr_push_wbint_LookupSid,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_LookupSid,
		(ndr_print_function_t) ndr_print_wbint_LookupSid,
		false,
	},
	{
		"wbint_LookupName",
		sizeof(struct wbint_LookupName),
		(ndr_push_flags_fn_t) ndr_push_wbint_LookupName,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_LookupName,
		(ndr_print_function_t) ndr_print_wbint_LookupName,
		false,
	},
	{
		"wbint_Sid2Uid",
		sizeof(struct wbint_Sid2Uid),
		(ndr_push_flags_fn_t) ndr_push_wbint_Sid2Uid,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_Sid2Uid,
		(ndr_print_function_t) ndr_print_wbint_Sid2Uid,
		false,
	},
	{
		"wbint_Sid2Gid",
		sizeof(struct wbint_Sid2Gid),
		(ndr_push_flags_fn_t) ndr_push_wbint_Sid2Gid,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_Sid2Gid,
		(ndr_print_function_t) ndr_print_wbint_Sid2Gid,
		false,
	},
	{
		"wbint_Uid2Sid",
		sizeof(struct wbint_Uid2Sid),
		(ndr_push_flags_fn_t) ndr_push_wbint_Uid2Sid,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_Uid2Sid,
		(ndr_print_function_t) ndr_print_wbint_Uid2Sid,
		false,
	},
	{
		"wbint_Gid2Sid",
		sizeof(struct wbint_Gid2Sid),
		(ndr_push_flags_fn_t) ndr_push_wbint_Gid2Sid,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_Gid2Sid,
		(ndr_print_function_t) ndr_print_wbint_Gid2Sid,
		false,
	},
	{
		"wbint_AllocateUid",
		sizeof(struct wbint_AllocateUid),
		(ndr_push_flags_fn_t) ndr_push_wbint_AllocateUid,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_AllocateUid,
		(ndr_print_function_t) ndr_print_wbint_AllocateUid,
		false,
	},
	{
		"wbint_AllocateGid",
		sizeof(struct wbint_AllocateGid),
		(ndr_push_flags_fn_t) ndr_push_wbint_AllocateGid,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_AllocateGid,
		(ndr_print_function_t) ndr_print_wbint_AllocateGid,
		false,
	},
	{
		"wbint_QueryUser",
		sizeof(struct wbint_QueryUser),
		(ndr_push_flags_fn_t) ndr_push_wbint_QueryUser,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_QueryUser,
		(ndr_print_function_t) ndr_print_wbint_QueryUser,
		false,
	},
	{
		"wbint_LookupUserAliases",
		sizeof(struct wbint_LookupUserAliases),
		(ndr_push_flags_fn_t) ndr_push_wbint_LookupUserAliases,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_LookupUserAliases,
		(ndr_print_function_t) ndr_print_wbint_LookupUserAliases,
		false,
	},
	{
		"wbint_LookupUserGroups",
		sizeof(struct wbint_LookupUserGroups),
		(ndr_push_flags_fn_t) ndr_push_wbint_LookupUserGroups,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_LookupUserGroups,
		(ndr_print_function_t) ndr_print_wbint_LookupUserGroups,
		false,
	},
	{
		"wbint_QuerySequenceNumber",
		sizeof(struct wbint_QuerySequenceNumber),
		(ndr_push_flags_fn_t) ndr_push_wbint_QuerySequenceNumber,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_QuerySequenceNumber,
		(ndr_print_function_t) ndr_print_wbint_QuerySequenceNumber,
		false,
	},
	{
		"wbint_LookupGroupMembers",
		sizeof(struct wbint_LookupGroupMembers),
		(ndr_push_flags_fn_t) ndr_push_wbint_LookupGroupMembers,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_LookupGroupMembers,
		(ndr_print_function_t) ndr_print_wbint_LookupGroupMembers,
		false,
	},
	{
		"wbint_QueryUserList",
		sizeof(struct wbint_QueryUserList),
		(ndr_push_flags_fn_t) ndr_push_wbint_QueryUserList,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_QueryUserList,
		(ndr_print_function_t) ndr_print_wbint_QueryUserList,
		false,
	},
	{
		"wbint_QueryGroupList",
		sizeof(struct wbint_QueryGroupList),
		(ndr_push_flags_fn_t) ndr_push_wbint_QueryGroupList,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_QueryGroupList,
		(ndr_print_function_t) ndr_print_wbint_QueryGroupList,
		false,
	},
	{
		"wbint_DsGetDcName",
		sizeof(struct wbint_DsGetDcName),
		(ndr_push_flags_fn_t) ndr_push_wbint_DsGetDcName,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_DsGetDcName,
		(ndr_print_function_t) ndr_print_wbint_DsGetDcName,
		false,
	},
	{
		"wbint_LookupRids",
		sizeof(struct wbint_LookupRids),
		(ndr_push_flags_fn_t) ndr_push_wbint_LookupRids,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_LookupRids,
		(ndr_print_function_t) ndr_print_wbint_LookupRids,
		false,
	},
	{
		"wbint_CheckMachineAccount",
		sizeof(struct wbint_CheckMachineAccount),
		(ndr_push_flags_fn_t) ndr_push_wbint_CheckMachineAccount,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_CheckMachineAccount,
		(ndr_print_function_t) ndr_print_wbint_CheckMachineAccount,
		false,
	},
	{
		"wbint_ChangeMachineAccount",
		sizeof(struct wbint_ChangeMachineAccount),
		(ndr_push_flags_fn_t) ndr_push_wbint_ChangeMachineAccount,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_ChangeMachineAccount,
		(ndr_print_function_t) ndr_print_wbint_ChangeMachineAccount,
		false,
	},
	{
		"wbint_PingDc",
		sizeof(struct wbint_PingDc),
		(ndr_push_flags_fn_t) ndr_push_wbint_PingDc,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_PingDc,
		(ndr_print_function_t) ndr_print_wbint_PingDc,
		false,
	},
	{
		"wbint_SetMapping",
		sizeof(struct wbint_SetMapping),
		(ndr_push_flags_fn_t) ndr_push_wbint_SetMapping,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_SetMapping,
		(ndr_print_function_t) ndr_print_wbint_SetMapping,
		false,
	},
	{
		"wbint_RemoveMapping",
		sizeof(struct wbint_RemoveMapping),
		(ndr_push_flags_fn_t) ndr_push_wbint_RemoveMapping,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_RemoveMapping,
		(ndr_print_function_t) ndr_print_wbint_RemoveMapping,
		false,
	},
	{
		"wbint_SetHWM",
		sizeof(struct wbint_SetHWM),
		(ndr_push_flags_fn_t) ndr_push_wbint_SetHWM,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_SetHWM,
		(ndr_print_function_t) ndr_print_wbint_SetHWM,
		false,
	},
	{ NULL, 0, NULL, NULL, NULL, false }
};

static const char * const wbint_endpoint_strings[] = {
	"ncalrpc:", 
};

static const struct ndr_interface_string_array wbint_endpoints = {
	.count	= 1,
	.names	= wbint_endpoint_strings
};

static const char * const wbint_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array wbint_authservices = {
	.count	= 1,
	.names	= wbint_authservice_strings
};


const struct ndr_interface_table ndr_table_wbint = {
	.name		= "wbint",
	.syntax_id	= {
		{0xbf09192c,0xed60,0x4928,{0x9d,0xff},{0xd0,0xd7,0xbc,0xb0,0x3e,0xd8}},
		NDR_WBINT_VERSION
	},
	.helpstring	= NDR_WBINT_HELPSTRING,
	.num_calls	= 24,
	.calls		= wbint_calls,
	.endpoints	= &wbint_endpoints,
	.authservices	= &wbint_authservices
};

