/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sail;

import java.io.File;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailException;

public class SailRepository
implements Repository {
    private final Sail sail;

    public SailRepository(Sail sail) {
        this.sail = sail;
    }

    public File getDataDir() {
        return this.sail.getDataDir();
    }

    public void setDataDir(File dataDir) {
        this.sail.setDataDir(dataDir);
    }

    public void initialize() throws RepositoryException {
        try {
            this.sail.initialize();
        }
        catch (SailException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
    }

    public void shutDown() throws RepositoryException {
        try {
            this.sail.shutDown();
        }
        catch (SailException e) {
            throw new RepositoryException("Unable to shutdown Sail", e);
        }
    }

    public Sail getSail() {
        return this.sail;
    }

    public boolean isWritable() throws RepositoryException {
        try {
            return this.sail.isWritable();
        }
        catch (SailException e) {
            throw new RepositoryException("Unable to determine writable status of Sail", e);
        }
    }

    public ValueFactory getValueFactory() {
        return this.sail.getValueFactory();
    }

    public SailRepositoryConnection getConnection() throws RepositoryException {
        try {
            return new SailRepositoryConnection(this, this.sail.getConnection());
        }
        catch (SailException e) {
            throw new RepositoryException(e);
        }
    }
}

