/*
 * This file is part of the DOM implementation for KDE.
 *
 * Copyright (C) 2003 Lars Knoll (knoll@kde.org)
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

/* This file is mostly data generated by flex. Unfortunately flex
   can't handle 16bit strings directly, so we just copy the part of
   the code we need and modify it to our needs.

   Most of the defines below are to make sure we can easily use the
   flex generated code, using as little editing as possible.

   The flex syntax to generate the lexer are more or less directly
   copied from the CSS2.1 specs, with some fixes for comments and
   the important symbol.

   To regenerate, run flex on tokenizer.flex. After this, copy the
   data tables and the YY_DECL method over to this file. Remove the
   init code from YY_DECL and change the YY_END_OF_BUFFER to only call
   yyterminate().

*/

// --------- begin generated code -------------------


#include "CSSGrammar.h"

#define INITIAL 0
#define mediaquery 1
#define forkeyword 2

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L
#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t;
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */
#define YY_NUM_RULES 68
#define YY_END_OF_BUFFER 69
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[479] =
    {   0,
        0,    0,    0,    0,    0,    0,   69,   67,    2,    2,
       67,   67,   67,   67,   67,   67,   67,   67,   67,   56,
       67,   67,   67,   67,   15,   15,   15,   67,   67,   66,
       15,   15,   15,   65,   15,    2,    0,    0,    0,   14,
        0,    0,    0,    0,   18,   18,    8,    0,    0,    9,
        0,    0,    0,   15,   15,   15,   57,    0,   55,    0,
        0,   56,    0,   54,   54,   54,   54,   54,   54,   54,
       54,   54,   54,   16,   54,   54,   51,   54,    0,    0,
        0,   35,   35,   35,   35,   35,   35,   35,   15,   15,
        7,   62,   15,    0,    0,   15,   15,    0,   15,    6,

        5,   15,   15,   15,   15,    0,    0,    0,   14,    0,
        0,    0,   18,   18,   18,    0,   18,    0,    0,   14,
        0,    0,    4,   16,   15,    0,    0,   54,   54,   54,
        0,   54,   41,   54,   37,   39,   54,   52,   43,   54,
       42,   50,   54,   45,   44,   40,   54,   54,    0,   35,
       35,   35,   35,    0,   35,   35,   35,   35,   35,   35,
       15,   15,   15,   16,   15,   15,   63,   63,   15,   12,
       10,   15,   13,    0,    0,    0,   17,   18,   18,   18,
       17,    0,    0,   15,    0,    1,   54,   54,   54,   54,
       46,   54,   53,   16,   47,   54,    3,   35,   35,   35,

       35,   35,   35,   35,   35,   35,   35,   15,   15,   58,
        0,   63,   63,   63,   62,   11,    0,    0,    0,   18,
       18,   18,    0,   15,    0,    0,   54,   54,   54,   48,
       49,   35,   35,   35,   35,   35,   35,   35,   35,   20,
       15,   15,   64,   63,   63,   63,   63,    0,    0,    0,
        0,   60,    0,    0,    0,    0,   18,   18,   18,    0,
       15,   54,   54,   38,   35,   35,   35,   35,   35,   35,
       21,   35,   15,   15,   64,   63,   63,   63,   63,   63,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   60,
        0,    0,    0,    0,   17,   18,   18,   17,    0,   15,

       54,   54,   35,   35,   35,   35,   35,   19,   35,   15,
       15,   64,   63,   63,   63,   63,   63,   63,    0,   59,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   18,   18,    0,   15,   54,   54,   35,
       35,   35,   23,   35,   35,   15,   64,   63,   63,   63,
       63,   63,   63,   63,    0,   59,    0,    0,    0,   59,
        0,    0,    0,    0,   18,   15,   54,   35,   35,   35,
       35,   64,    0,    0,    0,   36,   15,   35,   35,   35,
       35,   35,   35,   22,   24,   64,    0,    0,    0,   15,
       35,   35,   35,   35,   35,   35,    0,    0,    0,   62,

       35,   35,   35,   35,   35,   35,   35,   35,    0,    0,
        0,    0,    0,    0,   35,   35,   35,   35,   25,   35,
       35,   35,    0,    0,    0,   61,    0,    0,   26,   35,
       35,   35,   35,   27,   35,    0,    0,    0,    0,   31,
       35,   35,   35,   35,    0,    0,    0,   35,   35,   35,
       35,    0,    0,   35,   35,   29,   35,    0,    0,   35,
       33,   35,   30,    0,    0,   35,   28,   35,    0,   35,
       35,   35,   35,   34,   35,   35,   32,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    4,    5,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    6,    7,    8,    9,   10,   11,   12,   13,   14,
       15,   16,   17,   12,   18,   19,   20,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   12,   22,   23,
       24,   25,   26,   27,   31,   32,   33,   34,   35,   36,
       37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
       47,   48,   49,   50,   51,   52,   53,   54,   55,   56,
       12,   28,   12,   29,   30,   12,   31,   32,   33,   34,

       35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
       45,   46,   47,   48,   49,   50,   51,   52,   53,   54,
       55,   56,   57,   58,   12,   59,    1,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,

       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60
    } ;

static yyconst flex_int32_t yy_meta[61] =
    {   0,
        1,    2,    3,    3,    3,    4,    5,    5,    5,    5,
        5,    5,    5,    6,    7,    5,    5,    8,    5,    5,
        9,    5,    5,    5,    5,   10,    5,   11,    5,   11,
       12,   12,   12,   12,   12,   12,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,    5,    5,    5,   11
    } ;

static yyconst flex_int16_t yy_base[517] =
    {   0,
        0,    0,   39,   41, 1573, 1566, 1594, 2399,   62,   71,
       76,   61,   69, 1560,   78, 1559,   89, 1561, 1565,  132,
     1573,   91,  123, 1555,   80,  104,   97, 1554, 1551, 2399,
       85,  176,  175, 2399,  177,  193,  204, 1531,   84, 2399,
      242,  110,  180,  196, 1545,  205, 2399,  113,  277, 2399,
     1547,   72,  221,  133,  206,  234,  181, 1555, 1548, 1530,
     1528,    0,  268,  118, 1515,  221,   60,  240,   92,  230,
       95,  223,  244,  267,  238,  286, 1512,  268, 1521,  279,
      294, 1510,  278,  190,  290,  232,  292,  293,  308,  335,
     2399, 2399,  317,  326, 1516,  351,  336,  356,  366, 2399,

     2399,  320,  367,  369,  370, 1478,  393,  327,  345,  420,
      455,  398, 1495,  490, 1481,  446,  481,  372,  365,  386,
      525,  560, 2399,  325,  388, 1491,  387, 1477,  595, 1476,
      516,  399, 1475,   34, 1472, 1461,  378, 1438, 1430,  318,
     1429, 1426,  323, 1424, 1423, 1422,  231,  387, 1430,  377,
     1411,  630, 1396,  551,  382,  108,  415,  408,  419,  412,
      586,  436,  665, 1400,  624,  456,  419, 1382,  457,  490,
      491,  625,  492, 1362,  526,  656,  672,  681, 1378,  716,
      707,  527,  723,  561, 1374, 2399,  732, 1346,  767,  437,
     1322,  410, 1312,  445, 1311,  546, 2399,  469,  758, 1303,

      802,  576,  482,  580,  470,  440,  472,  793,  809, 2399,
      818,  515, 1288, 1273,  853,  552, 1205,  839,  855,  861,
      877,  883,  899,  645, 1227,  483,  905,  921,  612, 1183,
     1168,  609,  927,  943,  626,  517,  628,  508,  629, 1167,
      949,  965,  971,  550, 1167, 1157, 1123, 1006, 1020,  666,
      682, 2399, 1047, 1091, 1006, 1038, 1055, 1063, 1071, 1079,
      632, 1087, 1095, 1105,  539, 1103, 1111,  542,  543,  681,
     1097,  683, 1119, 1127, 1135,  585, 1091, 1083, 1067, 1039,
      721,  752,  772, 1170,  717, 1205, 1184, 1217, 1244, 1258,
     1285, 1320,  984, 1244, 2399, 1276, 1311,  917, 1328,  767,

     1336, 1344,  733, 1352, 1360,  734,  578,  899,  582, 1395,
     1381, 1397,  623,  853,  822,  794,  793,  760,  807, 2399,
      875,  788, 1432, 1459, 1494,  818,  769, 1440, 1529, 1564,
     1438,  702, 1485,  919, 1520, 1555,  849,  963, 1572,  587,
     1299, 1580,  706,  441,  614, 1615, 1601,  715, 2399, 2399,
     2399, 2399, 2399, 2399, 1473,  839,  856, 1617, 1652,  804,
      852, 1638, 1654,  633, 1480,  871, 1508, 1650, 1542,  644,
      834, 1673, 1679, 1695, 1701, 2399, 1015,  872,  915,  916,
      877,  959,  704,  616,  586, 2399, 1717, 1723, 1739, 1002,
     1148,  514,  961,  989,  990, 1016, 1745, 1761, 1767, 1802,

     1137, 1008, 1018, 1017,  985, 1129,  878, 1038, 1790, 1806,
     1829, 1211, 1827, 1849,  944, 1057, 1152,  787,  584,  615,
     1196,  918, 1863, 1890, 1279, 2399, 1869, 1867,  516, 1199,
     1154,  943, 1242,  515,  653, 1904, 1906, 1941, 1968,  480,
      945, 1200, 1149, 1214, 1927, 1949, 1947, 1239, 1301, 1207,
     1302, 1974, 1990, 1392, 1267,  411, 1354, 1996, 2012, 1310,
      376, 1241, 1039, 2018, 2034, 1338,  348, 1377, 2040, 1216,
     1391, 1421, 1394,  324, 1226, 1376,  263, 2399, 2075, 2080,
     2091, 2096, 2101, 2110, 2117, 2128, 2137, 2142, 2153, 2165,
     2167, 2176, 2181, 2190, 2195, 2204, 2213, 2225, 2234, 2243,

     2248, 2260, 2265, 2276, 2281, 2292, 2303, 2314, 2319, 2330,
     2341, 2346, 2357, 2366, 2377, 2386
    } ;

static yyconst flex_int16_t yy_def[517] =
    {   0,
      478,    1,    1,    1,    1,    1,  478,  478,  478,  478,
      478,  479,  480,  478,  481,  478,  482,  478,  478,  478,
      478,  483,  484,  478,  485,  485,  485,  478,  478,  478,
      485,  485,  485,  478,  485,  478,  478,  478,  479,  478,
      486,  480,  478,  487,  488,  488,  478,  481,  489,  478,
      478,  478,  484,  485,  485,  485,   20,  490,  478,  491,
      478,   20,  492,  493,  493,  493,  493,  493,  493,  493,
      493,  493,  493,  493,  493,  493,  493,  493,  478,  483,
      494,  495,  495,  495,  495,  495,  495,  495,  485,  485,
      478,  478,  485,  496,  478,  485,  485,  478,  485,  478,

      478,  485,  485,  485,  485,  478,  479,  479,  479,  479,
      486,  478,  488,   46,  488,  497,   46,  481,  481,  481,
      481,  489,  478,  478,  485,  490,  498,  493,  493,  493,
      499,  493,  493,  493,  493,  493,  493,  493,  493,  493,
      493,  493,  493,  493,  493,  493,  493,  493,  478,  495,
      495,  495,  495,  500,  495,  495,  495,  495,  495,  495,
       90,  485,   90,  478,  485,  485,  501,  478,  485,  485,
      485,  485,  485,  478,  479,  110,  478,  114,  488,  114,
       46,  481,  121,  485,  502,  478,  129,  493,  129,  493,
      493,  493,  493,  493,  493,  493,  478,  495,  152,  495,

      152,  495,  495,  495,  495,  495,  495,   90,  163,  478,
      478,  503,  478,  478,  504,  485,  478,  110,  478,  114,
      180,   46,  121,  485,  502,  498,  129,  189,  493,  493,
      493,  495,  152,  201,  495,  495,  495,  495,  495,  495,
       90,  163,  478,  505,  478,  478,  478,  504,  504,  506,
      507,  478,  508,  478,  110,  478,  114,  180,   46,  121,
      485,  129,  189,  493,  495,  152,  201,  495,  495,  495,
      495,  495,   90,  163,  478,  509,  478,  478,  478,  478,
      478,  506,  478,  510,  507,  511,  504,  504,  504,  504,
      504,  508,  478,  110,  478,  114,  180,  488,  121,  485,

      129,  189,  495,  152,  201,  495,  495,  495,  495,  485,
      163,  478,  512,  478,  478,  478,  478,  478,  478,  478,
      506,  506,  506,  506,  510,  507,  507,  507,  507,  511,
      291,  478,  110,  488,  180,  121,  485,  493,  189,  495,
      495,  201,  495,  495,  495,  485,  478,  478,  478,  478,
      478,  478,  478,  478,  506,  506,  506,  324,  507,  507,
      507,  329,  291,  478,  488,  485,  493,  495,  495,  495,
      495,  478,  324,  329,  291,  478,  485,  495,  495,  495,
      495,  495,  495,  495,  495,  478,  324,  329,  291,  485,
      495,  495,  495,  495,  495,  495,  324,  329,  291,  513,

      495,  495,  495,  495,  495,  495,  495,  495,  324,  329,
      513,  411,  514,  515,  495,  495,  495,  495,  495,  495,
      495,  495,  515,  515,  478,  478,  515,  516,  495,  495,
      495,  495,  495,  495,  495,  515,  424,  515,  424,  495,
      495,  495,  495,  495,  424,  515,  439,  495,  495,  495,
      495,  424,  439,  495,  495,  495,  495,  424,  439,  495,
      495,  495,  495,  424,  439,  495,  495,  495,  439,  495,
      495,  495,  495,  495,  495,  495,  495,    0,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,

      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478
    } ;

static yyconst flex_int16_t yy_nxt[2460] =
    {   0,
        8,    9,   10,    9,    9,    9,   11,   12,   13,   14,
        8,    8,   15,    8,    8,   16,    8,   17,   18,   19,
       20,    8,   21,    8,    8,    8,   22,   23,   24,   25,
       25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
       25,   25,   25,   26,   25,   25,   25,   25,   25,   25,
       27,   25,   25,   25,   25,   25,    8,   28,   29,   25,
       30,  131,   30,   36,   36,   36,   36,   36,   40,   31,
      191,   31,   36,   36,   36,   36,   36,   37,   37,   37,
       37,   37,   32,   33,   32,   33,   42,  131,   41,   43,
       40,   40,   52,   92,  134,   34,   44,   34,   92,   46,

       46,   46,   46,   46,   46,   49,   51,   94,   80,   52,
       92,   41,   94,   98,   38,  124,   53,   92,   81,  131,
       95,   96,  131,   83,   94,   40,   84,  478,  102,   85,
      478,   94,   55,   86,   87,  154,   88,   44,  139,  137,
       49,   56,   59,   90,   99,  131,   92,  132,   97,   60,
       61,  203,   62,   90,   90,   90,   90,   90,   90,   63,
       94,   64,   65,   65,   66,   67,   68,   65,   69,   70,
       71,   65,   72,   65,   73,   74,   65,   75,   65,   76,
       77,   78,   65,   65,   65,   65,   65,   65,   92,   92,
       92,   65,   95,   96,   36,   36,   36,   36,   36,  478,

      112,   57,   94,   94,   94,   37,   37,   37,   37,   37,
      112,  112,  112,  112,  112,  112,  114,  154,  104,   92,
      103,  105,   95,   96,   65,  117,  114,  114,  114,  114,
      114,  114,  116,   94,  156,  117,  117,  117,  117,  117,
      117,   90,   38,   39,   39,   39,  107,   92,  131,  109,
      131,   90,   90,   90,   90,   90,   90,  131,  131,  154,
      140,   94,  110,  133,  195,  131,  158,  131,  125,  111,
      144,  131,  110,  110,  110,  110,  110,  110,   48,   48,
       48,  118,  135,   95,  143,  138,  141,  145,  129,  120,
      154,  146,  142,  136,  131,  131,  478,  121,  129,  129,

      129,  129,  129,  129,  122,  154,   81,  121,  121,  121,
      121,  121,  121,  131,  152,  155,  147,  154,  148,  154,
      154,   92,  159,  160,  152,  152,  152,  152,  152,  152,
       92,  150,  157,   92,   40,   94,   89,   89,   89,   89,
       89,   95,   95,  194,   94,  131,  163,   94,   92,   92,
      131,  154,   40,  170,   41,  161,  163,  163,  163,  163,
      163,  163,   94,   94,   92,  161,  161,  161,  161,  161,
      161,  165,   41,  193,   48,  154,  167,   40,   94,   92,
       92,  168,   92,   92,   40,  166,  167,  167,  167,  167,
      167,  167,   49,   94,   94,   39,   94,   94,   40,   49,

       40,   92,  127,  154,  154,  131,  186,  169,  192,  154,
      172,  198,  202,   49,  131,   94,  171,  173,  177,  184,
       41,  108,  175,  175,  175,  108,  131,   40,  177,  177,
      177,  177,  177,  177,  196,  154,  211,  131,  154,  154,
      176,  205,  154,  230,  213,  190,  154,   41,  207,   92,
      176,  176,  176,  176,  176,  176,   39,   39,   39,  107,
      204,  206,  109,   94,  131,  194,  180,  154,  154,  210,
      215,  229,  131,  370,  239,  110,  180,  180,  180,  180,
      180,  180,  111,   94,   94,  110,  110,  110,  110,  110,
      110,  113,  113,  113,  113,  113,  154,  154,  226,  154,

      232,  181,  186,   92,  210,   92,  240,  154,  238,  154,
      178,  181,  181,  181,  181,  181,  181,   94,   94,   94,
      178,  178,  178,  178,  178,  178,  119,  182,  182,  182,
      119,  236,  211,   40,  269,  154,  189,   40,  271,   40,
      245,  154,  154,  154,  154,  183,  189,  189,  189,  189,
      189,  189,   49,   41,   49,  183,  183,  183,  183,  183,
      183,   48,   48,   48,  118,   92,  154,  211,  403,  154,
      154,  201,  120,  131,   92,  277,  306,  303,  307,   94,
      121,  201,  201,  201,  201,  201,  201,  122,   94,  231,
      121,  121,  121,  121,  121,  121,  128,  128,  128,  128,

      128,  224,  211,  154,  368,  154,  208,  154,  344,  154,
      314,  154,  345,  154,  154,  187,  208,  208,  208,  208,
      208,  208,  131,  235,  237,  187,  187,  187,  187,  187,
      187,  151,  151,  151,  151,  151,  154,   92,   92,  131,
      211,  154,  154,  154,  165,   92,  371,  433,  349,  265,
      199,   94,   94,  154,  264,  154,  154,  154,   92,   94,
      199,  199,  199,  199,  199,  199,  162,  162,  162,  162,
      162,  154,   94,  283,  268,  270,  218,  272,  384,  216,
      154,  300,  376,  261,  444,  209,  218,  218,  218,  218,
      218,  218,  219,  284,  283,  209,  209,  209,  209,  209,

      209,  220,  219,  219,  219,  219,  219,  219,  154,  286,
      154,  220,  220,  220,  220,  220,  220,  179,  179,  179,
      179,  179,  281,  281,  281,  281,  281,  222,  309,  283,
      308,  154,  211,  154,  396,  252,  221,  222,  222,  222,
      222,  222,  222,  223,  286,  364,  221,  221,  221,  221,
      221,  221,  227,  223,  223,  223,  223,  223,  223,  283,
      154,  154,  227,  227,  227,  227,  227,  227,  188,  188,
      188,  188,  188,  319,  319,  319,  319,  319,  233,  284,
       92,  283,  340,  343,  337,  354,  320,  228,  233,  233,
      233,  233,  233,  233,   94,  283,  286,  228,  228,  228,

      228,  228,  228,  200,  200,  200,  200,  200,  319,  319,
      319,  319,  319,  241,  154,  284,  283,  432,  353,  352,
      285,  320,  234,  241,  241,  241,  241,  241,  241,  242,
      283,  286,  234,  234,  234,  234,  234,  234,  243,  242,
      242,  242,  242,  242,  242,  286,  283,  351,  243,  243,
      243,  243,  243,  243,  248,  248,  248,  248,  248,  255,
      250,  154,   92,  283,  283,  251,  284,  252,  385,  255,
      255,  255,  255,  255,  255,  256,   94,  282,  350,  286,
      253,  257,  283,  284,   92,  256,  256,  256,  256,  256,
      256,  257,  257,  257,  257,  257,  257,  258,   94,  154,

      366,  377,  284,  259,  154,  154,  391,  258,  258,  258,
      258,  258,  258,  259,  259,  259,  259,  259,  259,  260,
      113,  113,  113,  113,  113,  262,  154,  394,  421,  260,
      260,  260,  260,  260,  260,  262,  262,  262,  262,  262,
      262,  263,  154,  154,  116,  154,  116,  266,  435,  392,
      393,  263,  263,  263,  263,  263,  263,  266,  266,  266,
      266,  266,  266,  267,  128,  128,  128,  128,  128,  273,
      154,  154,  154,  267,  267,  267,  267,  267,  267,  273,
      273,  273,  273,  273,  273,  274,  154,  448,  154,  442,
      131,  275,  429,  395,  404,  274,  274,  274,  274,  274,

      274,  275,  275,  275,  275,  275,  275,  248,  248,  248,
      248,  248,  154,  250,  332,  400,  154,  154,  251,  419,
      252,  281,  281,  281,  281,  281,  294,  478,   92,   94,
      405,  406,  478,  253,  252,  154,  294,  294,  294,  294,
      294,  294,   94,  154,  154,  154,  416,  253,  281,  281,
      281,  281,  287,  417,  289,  418,  468,  407,  295,  289,
      289,  290,  390,  408,  318,  154,  154,  291,  295,  295,
      295,  295,  295,  295,  292,  296,  422,  291,  291,  291,
      291,  291,  291,  297,  154,  296,  296,  296,  296,  296,
      296,  298,  317,  297,  297,  297,  297,  297,  297,  299,

      430,  298,  298,  298,  298,  298,  298,  301,  316,  299,
      299,  299,  299,  299,  299,  302,  315,  301,  301,  301,
      301,  301,  301,  304,  154,  302,  302,  302,  302,  302,
      302,  305,  131,  304,  304,  304,  304,  304,  304,  310,
      293,  305,  305,  305,  305,  305,  305,  311,  280,  310,
      310,  310,  310,  310,  310,  312,  154,  311,  311,  311,
      311,  311,  311,  420,  154,  312,  312,  312,  312,  312,
      312,  282,  282,  282,  321,  154,  154,  323,  415,  154,
      401,  154,  279,  402,  441,  281,  281,  281,  281,  281,
      324,  478,  278,  450,  154,  131,  478,  325,  252,  431,

      324,  324,  324,  324,  324,  324,  285,  285,  285,  326,
      131,  253,  478,  478,  478,  478,  478,  328,  281,  281,
      281,  281,  281,  154,  478,  329,  154,  154,  478,  478,
      434,  252,  330,  440,  154,  329,  329,  329,  329,  329,
      329,  154,  226,  154,  253,  281,  281,  281,  281,  281,
      449,  478,  254,  154,  456,  451,  478,  472,  252,  281,
      281,  281,  281,  281,  333,  478,  154,  476,  154,  154,
      478,  253,  252,  454,  333,  333,  333,  333,  333,  333,
      425,  425,  425,  425,  425,  253,  287,  287,  287,  287,
      287,  443,  478,  426,  154,  467,  334,  478,  247,  252,

      151,  151,  151,  151,  151,  331,  334,  334,  334,  334,
      334,  334,  253,  246,  462,  331,  331,  331,  331,  331,
      331,  281,  281,  281,  281,  287,  154,  289,  154,  154,
      154,  335,  289,  289,  290,  455,  457,  154,  131,  131,
      291,  335,  335,  335,  335,  335,  335,  292,  336,  131,
      291,  291,  291,  291,  291,  291,  338,  466,  336,  336,
      336,  336,  336,  336,  339,  154,  338,  338,  338,  338,
      338,  338,  341,  131,  339,  339,  339,  339,  339,  339,
      342,  154,  341,  341,  341,  341,  341,  341,  470,  226,
      342,  342,  342,  342,  342,  342,   89,   89,   89,   89,

       89,  346,  463,  154,  154,  116,  217,  214,   92,  460,
      471,  346,  346,  346,  346,  346,  346,  347,  154,  154,
      164,  154,   94,  154,  477,  473,  475,  347,  347,  347,
      347,  347,  347,  355,  319,  319,  319,  355,  154,  283,
      461,  359,  319,  319,  319,  359,  356,  197,  154,  131,
      131,  131,  283,  131,  360,  474,  131,  131,  363,  284,
      322,  357,  357,  357,  322,  131,  283,  286,  363,  363,
      363,  363,  363,  363,  355,  319,  319,  319,  355,  358,
      283,  179,  179,  179,  179,  179,  284,  356,  131,  358,
      358,  358,  358,  358,  358,  282,  282,  282,  321,  131,

      284,  323,  131,  131,  131,   39,  127,  116,  116,  188,
      188,  188,  188,  188,  324,   39,   39,   39,   39,   39,
       39,  325,  116,  174,  324,  324,  324,  324,  324,  324,
      327,  361,  361,  361,  327,  131,  164,  154,  149,  131,
      365,  283,  131,  200,  200,  200,  200,  200,   57,  362,
      365,  365,  365,  365,  365,  365,  286,   63,   59,  362,
      362,  362,  362,  362,  362,  285,  285,  285,  326,  154,
      127,  123,  116,  106,  101,   48,  328,  100,   91,   79,
       58,   57,   50,   47,  329,   48,   48,   48,   48,   48,
       48,  330,  367,  478,  329,  329,  329,  329,  329,  329,

      369,   35,  367,  367,  367,  367,  367,  367,   35,  478,
      369,  369,  369,  369,  369,  369,  162,  162,  162,  162,
      162,  372,  478,  478,  478,  478,  478,  478,   92,  478,
      478,  372,  372,  372,  372,  372,  372,  373,  478,  478,
      478,  478,   94,  478,  478,  478,  478,  373,  373,  373,
      373,  373,  373,  359,  319,  319,  319,  359,  374,  478,
      478,  478,  478,  478,  283,  478,  360,  478,  374,  374,
      374,  374,  374,  374,  375,  478,  478,  154,  478,  286,
      478,  478,  478,  378,  375,  375,  375,  375,  375,  375,
      379,  478,  380,  386,  478,  478,  478,  381,  382,  387,

      478,  383,  478,  386,  386,  386,  386,  386,  386,  387,
      387,  387,  387,  387,  387,  388,  478,  478,  478,  478,
      478,  389,  478,  478,  478,  388,  388,  388,  388,  388,
      388,  389,  389,  389,  389,  389,  389,  397,  478,  478,
      478,  478,  478,  398,  478,  478,  478,  397,  397,  397,
      397,  397,  397,  398,  398,  398,  398,  398,  398,  399,
      478,  478,  478,  478,  478,  409,  478,  478,  478,  399,
      399,  399,  399,  399,  399,  409,  409,  409,  409,  409,
      409,  410,  478,  478,  478,  478,  478,  249,  478,  478,
      478,  410,  410,  410,  410,  410,  410,  249,  249,  249,

      249,  249,  249,  411,  411,  411,  411,  411,  478,  478,
      282,  478,  478,  478,  478,  478,  478,  478,  478,  412,
      282,  282,  282,  282,  282,  282,  285,  478,  478,  413,
      411,  411,  411,  411,  411,  478,  285,  285,  285,  285,
      285,  285,  478,  478,  478,  478,  412,  424,  478,  478,
      425,  425,  425,  425,  425,  478,  413,  424,  424,  424,
      424,  424,  424,  426,  425,  425,  425,  425,  425,  478,
      425,  425,  425,  425,  425,  478,  428,  426,  478,  478,
      478,  478,  478,  426,  478,  478,  478,  439,  478,  478,
      428,  436,  436,  436,  436,  436,  428,  439,  439,  439,

      439,  439,  439,  478,  426,  425,  425,  425,  425,  425,
      437,  478,  478,  478,  478,  478,  478,  428,  426,  478,
      437,  437,  437,  437,  437,  437,  445,  478,  478,  478,
      478,  428,  478,  478,  478,  478,  445,  445,  445,  445,
      445,  445,  425,  425,  425,  425,  425,  452,  478,  478,
      425,  425,  425,  425,  425,  426,  478,  452,  452,  452,
      452,  452,  452,  426,  478,  478,  478,  453,  428,  446,
      446,  446,  446,  446,  478,  478,  428,  453,  453,  453,
      453,  453,  453,  478,  478,  478,  478,  478,  447,  478,
      478,  478,  478,  478,  458,  478,  478,  478,  447,  447,

      447,  447,  447,  447,  458,  458,  458,  458,  458,  458,
      459,  478,  478,  478,  478,  478,  464,  478,  478,  478,
      459,  459,  459,  459,  459,  459,  464,  464,  464,  464,
      464,  464,  465,  478,  478,  478,  478,  478,  427,  478,
      478,  478,  465,  465,  465,  465,  465,  465,  427,  427,
      427,  427,  427,  427,  469,  478,  478,  478,  478,  478,
      427,  478,  478,  478,  469,  469,  469,  469,  469,  469,
      427,  427,  427,  427,  427,  427,   39,  478,   39,   39,
       39,   39,   39,   39,   39,   39,   39,   45,   45,  478,
       45,   45,   48,  478,   48,   48,   48,   48,   48,   48,

       48,   48,   48,   54,   54,  478,   54,   54,   82,  478,
      478,   82,   82,   89,   89,   89,   89,   89,   89,   89,
       89,   89,   93,  478,   93,   93,  478,   93,   93,  108,
      108,  108,  108,  108,  108,  108,  108,  108,  108,  108,
      113,  113,  113,  113,  113,  113,  113,  113,  113,  115,
      115,  478,  115,  115,  119,  119,  119,  119,  119,  119,
      119,  119,  119,  119,  119,  126,  126,  126,  126,  126,
      126,  126,  126,  126,  126,  126,  126,   65,   65,  128,
      128,  128,  128,  128,  128,  128,  128,  128,  130,  130,
      478,  130,  130,  151,  151,  151,  151,  151,  151,  151,

      151,  151,  153,  153,  478,  153,  153,  162,  162,  162,
      162,  162,  162,  162,  162,  162,  179,  179,  179,  179,
      179,  179,  179,  179,  179,  185,  185,  185,  185,  185,
      185,  185,  185,  185,  185,  185,  185,  188,  188,  188,
      188,  188,  188,  188,  188,  188,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  212,  212,  212,  478,  212,
      225,  225,  225,  225,  225,  225,  225,  225,  225,  225,
      225,  225,  244,  244,  244,  478,  244,  249,  249,  249,
      249,  478,  249,  249,  249,  249,  249,  249,  276,  276,
      276,  478,  276,  282,  478,  282,  282,  282,  282,  282,

      282,  282,  282,  282,  285,  478,  285,  285,  285,  285,
      285,  285,  285,  285,  285,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  313,  313,  313,  478,
      313,  322,  322,  322,  322,  322,  322,  322,  322,  322,
      322,  322,  327,  327,  327,  327,  327,  327,  327,  327,
      327,  327,  327,  348,  348,  348,  478,  348,  414,  414,
      414,  478,  478,  478,  414,  478,  478,  414,  414,  423,
      423,  423,  423,  423,  423,  423,  423,  423,  427,  427,
      427,  478,  478,  427,  427,  427,  478,  427,  427,  438,
      438,  438,  438,  438,  438,  438,  438,  438,    7,  478,

      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478
    } ;

static yyconst flex_int16_t yy_chk[2460] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        3,  134,    4,    9,    9,    9,    9,    9,   12,    3,
      134,    4,   10,   10,   10,   10,   10,   11,   11,   11,
       11,   11,    3,    3,    4,    4,   13,   67,   12,   13,
       15,   39,   52,   25,   67,    3,   13,    4,   31,   13,

       13,   13,   13,   13,   13,   15,   17,   25,   22,   17,
       27,   39,   31,   27,   11,   52,   17,   26,   22,   69,
       26,   26,   71,   22,   27,   48,   22,   42,   31,   22,
       42,   26,   17,   22,   22,  156,   22,   42,   71,   69,
       48,   17,   20,   23,   27,   64,   54,   64,   26,   20,
       20,  156,   20,   23,   23,   23,   23,   23,   23,   20,
       54,   20,   20,   20,   20,   20,   20,   20,   20,   20,
       20,   20,   20,   20,   20,   20,   20,   20,   20,   20,
       20,   20,   20,   20,   20,   20,   20,   20,   33,   32,
       35,   20,   32,   32,   36,   36,   36,   36,   36,   57,

       43,   57,   33,   32,   35,   37,   37,   37,   37,   37,
       43,   43,   43,   43,   43,   43,   44,   84,   33,   55,
       32,   35,   55,   55,   57,   46,   44,   44,   44,   44,
       44,   44,   46,   55,   84,   46,   46,   46,   46,   46,
       46,   53,   37,   41,   41,   41,   41,   56,   66,   41,
       72,   53,   53,   53,   53,   53,   53,   70,  147,   86,
       72,   56,   41,   66,  147,   75,   86,   68,   56,   41,
       75,   73,   41,   41,   41,   41,   41,   41,   49,   49,
       49,   49,   68,   74,   74,   70,   73,   75,   63,   49,
      477,   75,   73,   68,   74,   78,   80,   49,   63,   63,

       63,   63,   63,   63,   49,   83,   80,   49,   49,   49,
       49,   49,   49,   76,   81,   83,   76,   85,   78,   87,
       88,   89,   87,   88,   81,   81,   81,   81,   81,   81,
       93,   80,   85,  102,  108,   89,   90,   90,   90,   90,
       90,  124,  124,  143,   93,  140,   94,  102,   90,   97,
      143,  474,  109,  102,  108,   90,   94,   94,   94,   94,
       94,   94,   90,   97,   96,   90,   90,   90,   90,   90,
       90,   96,  109,  140,  118,  467,   98,  119,   96,   99,
      103,   98,  104,  105,  118,   97,   98,   98,   98,   98,
       98,   98,  119,   99,  103,  107,  104,  105,  120,  118,

      107,  125,  127,  461,  150,  137,  127,   99,  137,  155,
      104,  150,  155,  120,  148,  125,  103,  105,  112,  125,
      107,  110,  110,  110,  110,  110,  132,  110,  112,  112,
      112,  112,  112,  112,  148,  158,  167,  192,  456,  160,
      110,  158,  157,  192,  167,  132,  159,  110,  160,  162,
      110,  110,  110,  110,  110,  110,  111,  111,  111,  111,
      157,  159,  111,  162,  190,  194,  116,  206,  344,  166,
      169,  190,  194,  344,  206,  111,  116,  116,  116,  116,
      116,  116,  111,  166,  169,  111,  111,  111,  111,  111,
      111,  114,  114,  114,  114,  114,  198,  205,  226,  207,

      198,  117,  226,  170,  171,  173,  207,  440,  205,  203,
      114,  117,  117,  117,  117,  117,  117,  170,  171,  173,
      114,  114,  114,  114,  114,  114,  121,  121,  121,  121,
      121,  203,  212,  175,  236,  238,  131,  121,  238,  182,
      212,  392,  434,  429,  236,  121,  131,  131,  131,  131,
      131,  131,  121,  175,  182,  121,  121,  121,  121,  121,
      121,  122,  122,  122,  122,  216,  265,  244,  392,  268,
      269,  154,  122,  196,  184,  244,  268,  265,  269,  216,
      122,  154,  154,  154,  154,  154,  154,  122,  184,  196,
      122,  122,  122,  122,  122,  122,  129,  129,  129,  129,

      129,  184,  276,  202,  340,  307,  161,  204,  307,  309,
      276,  419,  309,  385,  340,  129,  161,  161,  161,  161,
      161,  161,  129,  202,  204,  129,  129,  129,  129,  129,
      129,  152,  152,  152,  152,  152,  232,  165,  172,  229,
      313,  345,  420,  384,  165,  261,  345,  420,  313,  232,
      152,  165,  172,  235,  229,  237,  239,  152,  224,  261,
      152,  152,  152,  152,  152,  152,  163,  163,  163,  163,
      163,  370,  224,  250,  235,  237,  176,  239,  370,  172,
      435,  261,  364,  224,  435,  163,  176,  176,  176,  176,
      176,  176,  177,  250,  251,  163,  163,  163,  163,  163,

      163,  178,  177,  177,  177,  177,  177,  177,  270,  251,
      272,  178,  178,  178,  178,  178,  178,  180,  180,  180,
      180,  180,  281,  281,  281,  281,  281,  181,  272,  285,
      270,  383,  348,  343,  383,  281,  180,  181,  181,  181,
      181,  181,  181,  183,  285,  332,  180,  180,  180,  180,
      180,  180,  187,  183,  183,  183,  183,  183,  183,  282,
      303,  306,  187,  187,  187,  187,  187,  187,  189,  189,
      189,  189,  189,  283,  283,  283,  283,  283,  199,  282,
      300,  327,  303,  306,  300,  318,  283,  189,  199,  199,
      199,  199,  199,  199,  300,  322,  327,  189,  189,  189,

      189,  189,  189,  201,  201,  201,  201,  201,  319,  319,
      319,  319,  319,  208,  418,  322,  360,  418,  317,  316,
      326,  319,  201,  208,  208,  208,  208,  208,  208,  209,
      326,  360,  201,  201,  201,  201,  201,  201,  211,  209,
      209,  209,  209,  209,  209,  326,  356,  315,  211,  211,
      211,  211,  211,  211,  215,  215,  215,  215,  215,  218,
      215,  371,  337,  357,  361,  215,  356,  215,  371,  218,
      218,  218,  218,  218,  218,  219,  337,  321,  314,  361,
      215,  220,  321,  357,  366,  219,  219,  219,  219,  219,
      219,  220,  220,  220,  220,  220,  220,  221,  366,  378,

      337,  366,  321,  222,  381,  407,  378,  221,  221,  221,
      221,  221,  221,  222,  222,  222,  222,  222,  222,  223,
      334,  334,  334,  334,  334,  227,  308,  381,  407,  223,
      223,  223,  223,  223,  223,  227,  227,  227,  227,  227,
      227,  228,  379,  380,  298,  422,  334,  233,  422,  379,
      380,  228,  228,  228,  228,  228,  228,  233,  233,  233,
      233,  233,  233,  234,  338,  338,  338,  338,  338,  241,
      432,  415,  441,  234,  234,  234,  234,  234,  234,  241,
      241,  241,  241,  241,  241,  242,  382,  441,  393,  432,
      338,  243,  415,  382,  393,  242,  242,  242,  242,  242,

      242,  243,  243,  243,  243,  243,  243,  248,  248,  248,
      248,  248,  405,  248,  293,  390,  394,  395,  248,  405,
      248,  249,  249,  249,  249,  249,  255,  249,  377,  390,
      394,  395,  249,  248,  249,  402,  255,  255,  255,  255,
      255,  255,  377,  396,  404,  403,  402,  249,  253,  253,
      253,  253,  253,  403,  253,  404,  463,  396,  256,  253,
      253,  253,  377,  396,  280,  408,  463,  253,  256,  256,
      256,  256,  256,  256,  253,  257,  408,  253,  253,  253,
      253,  253,  253,  258,  416,  257,  257,  257,  257,  257,
      257,  259,  279,  258,  258,  258,  258,  258,  258,  260,

      416,  259,  259,  259,  259,  259,  259,  262,  278,  260,
      260,  260,  260,  260,  260,  263,  277,  262,  262,  262,
      262,  262,  262,  266,  271,  263,  263,  263,  263,  263,
      263,  267,  264,  266,  266,  266,  266,  266,  266,  273,
      254,  267,  267,  267,  267,  267,  267,  274,  247,  273,
      273,  273,  273,  273,  273,  275,  406,  274,  274,  274,
      274,  274,  274,  406,  401,  275,  275,  275,  275,  275,
      275,  284,  284,  284,  284,  391,  443,  284,  401,  417,
      391,  431,  246,  391,  431,  287,  287,  287,  287,  287,
      284,  287,  245,  443,  240,  231,  287,  284,  287,  417,

      284,  284,  284,  284,  284,  284,  286,  286,  286,  286,
      230,  287,  412,  412,  412,  412,  412,  286,  288,  288,
      288,  288,  288,  421,  288,  286,  430,  442,  412,  288,
      421,  288,  286,  430,  450,  286,  286,  286,  286,  286,
      286,  444,  225,  470,  288,  289,  289,  289,  289,  289,
      442,  289,  217,  475,  450,  444,  289,  470,  289,  290,
      290,  290,  290,  290,  294,  290,  448,  475,  462,  433,
      290,  289,  290,  448,  294,  294,  294,  294,  294,  294,
      425,  425,  425,  425,  425,  290,  291,  291,  291,  291,
      291,  433,  291,  425,  455,  462,  296,  291,  214,  291,

      341,  341,  341,  341,  341,  291,  296,  296,  296,  296,
      296,  296,  291,  213,  455,  291,  291,  291,  291,  291,
      291,  292,  292,  292,  292,  292,  341,  292,  449,  451,
      200,  297,  292,  292,  292,  449,  451,  460,  195,  193,
      292,  297,  297,  297,  297,  297,  297,  292,  299,  191,
      292,  292,  292,  292,  292,  292,  301,  460,  299,  299,
      299,  299,  299,  299,  302,  466,  301,  301,  301,  301,
      301,  301,  304,  188,  302,  302,  302,  302,  302,  302,
      305,  457,  304,  304,  304,  304,  304,  304,  466,  185,
      305,  305,  305,  305,  305,  305,  310,  310,  310,  310,

      310,  311,  457,  476,  468,  179,  174,  168,  310,  454,
      468,  311,  311,  311,  311,  311,  311,  312,  471,  454,
      164,  473,  310,  153,  476,  471,  473,  312,  312,  312,
      312,  312,  312,  323,  323,  323,  323,  323,  151,  323,
      454,  328,  328,  328,  328,  328,  323,  149,  472,  146,
      145,  144,  328,  142,  328,  472,  141,  139,  331,  323,
      324,  324,  324,  324,  324,  138,  324,  328,  331,  331,
      331,  331,  331,  331,  355,  355,  355,  355,  355,  324,
      355,  365,  365,  365,  365,  365,  324,  355,  136,  324,
      324,  324,  324,  324,  324,  325,  325,  325,  325,  135,

      355,  325,  133,  130,  128,  333,  126,  365,  115,  367,
      367,  367,  367,  367,  325,  333,  333,  333,  333,  333,
      333,  325,  113,  106,  325,  325,  325,  325,  325,  325,
      329,  329,  329,  329,  329,  367,   95,   82,   79,   77,
      335,  329,   65,  369,  369,  369,  369,  369,   61,  329,
      335,  335,  335,  335,  335,  335,  329,   60,   59,  329,
      329,  329,  329,  329,  329,  330,  330,  330,  330,  369,
       58,   51,   45,   38,   29,  336,  330,   28,   24,   21,
       19,   18,   16,   14,  330,  336,  336,  336,  336,  336,
      336,  330,  339,    7,  330,  330,  330,  330,  330,  330,

      342,    6,  339,  339,  339,  339,  339,  339,    5,    0,
      342,  342,  342,  342,  342,  342,  346,  346,  346,  346,
      346,  347,    0,    0,    0,    0,    0,    0,  346,    0,
        0,  347,  347,  347,  347,  347,  347,  358,    0,    0,
        0,    0,  346,    0,    0,    0,    0,  358,  358,  358,
      358,  358,  358,  359,  359,  359,  359,  359,  362,    0,
        0,    0,    0,    0,  359,    0,  359,    0,  362,  362,
      362,  362,  362,  362,  363,    0,    0,  368,    0,  359,
        0,    0,    0,  368,  363,  363,  363,  363,  363,  363,
      368,    0,  368,  372,    0,    0,    0,  368,  368,  373,

        0,  368,    0,  372,  372,  372,  372,  372,  372,  373,
      373,  373,  373,  373,  373,  374,    0,    0,    0,    0,
        0,  375,    0,    0,    0,  374,  374,  374,  374,  374,
      374,  375,  375,  375,  375,  375,  375,  387,    0,    0,
        0,    0,    0,  388,    0,    0,    0,  387,  387,  387,
      387,  387,  387,  388,  388,  388,  388,  388,  388,  389,
        0,    0,    0,    0,    0,  397,    0,    0,    0,  389,
      389,  389,  389,  389,  389,  397,  397,  397,  397,  397,
      397,  398,    0,    0,    0,    0,    0,  399,    0,    0,
        0,  398,  398,  398,  398,  398,  398,  399,  399,  399,

      399,  399,  399,  400,  400,  400,  400,  400,    0,    0,
      409,    0,    0,    0,    0,    0,    0,    0,    0,  400,
      409,  409,  409,  409,  409,  409,  410,    0,    0,  400,
      411,  411,  411,  411,  411,    0,  410,  410,  410,  410,
      410,  410,    0,    0,    0,    0,  411,  413,    0,    0,
      414,  414,  414,  414,  414,    0,  411,  413,  413,  413,
      413,  413,  413,  414,  423,  423,  423,  423,  423,    0,
      427,  427,  427,  427,  427,    0,  414,  423,    0,    0,
        0,    0,    0,  427,    0,    0,    0,  428,    0,    0,
      423,  424,  424,  424,  424,  424,  427,  428,  428,  428,

      428,  428,  428,    0,  424,  436,  436,  436,  436,  436,
      424,    0,    0,    0,    0,    0,    0,  424,  436,    0,
      424,  424,  424,  424,  424,  424,  437,    0,    0,    0,
        0,  436,    0,    0,    0,    0,  437,  437,  437,  437,
      437,  437,  438,  438,  438,  438,  438,  445,    0,    0,
      446,  446,  446,  446,  446,  438,    0,  445,  445,  445,
      445,  445,  445,  446,    0,    0,    0,  447,  438,  439,
      439,  439,  439,  439,    0,    0,  446,  447,  447,  447,
      447,  447,  447,    0,    0,    0,    0,    0,  439,    0,
        0,    0,    0,    0,  452,    0,    0,    0,  439,  439,

      439,  439,  439,  439,  452,  452,  452,  452,  452,  452,
      453,    0,    0,    0,    0,    0,  458,    0,    0,    0,
      453,  453,  453,  453,  453,  453,  458,  458,  458,  458,
      458,  458,  459,    0,    0,    0,    0,    0,  464,    0,
        0,    0,  459,  459,  459,  459,  459,  459,  464,  464,
      464,  464,  464,  464,  465,    0,    0,    0,    0,    0,
      469,    0,    0,    0,  465,  465,  465,  465,  465,  465,
      469,  469,  469,  469,  469,  469,  479,    0,  479,  479,
      479,  479,  479,  479,  479,  479,  479,  480,  480,    0,
      480,  480,  481,    0,  481,  481,  481,  481,  481,  481,

      481,  481,  481,  482,  482,    0,  482,  482,  483,    0,
        0,  483,  483,  484,  484,  484,  484,  484,  484,  484,
      484,  484,  485,    0,  485,  485,    0,  485,  485,  486,
      486,  486,  486,  486,  486,  486,  486,  486,  486,  486,
      487,  487,  487,  487,  487,  487,  487,  487,  487,  488,
      488,    0,  488,  488,  489,  489,  489,  489,  489,  489,
      489,  489,  489,  489,  489,  490,  490,  490,  490,  490,
      490,  490,  490,  490,  490,  490,  490,  491,  491,  492,
      492,  492,  492,  492,  492,  492,  492,  492,  493,  493,
        0,  493,  493,  494,  494,  494,  494,  494,  494,  494,

      494,  494,  495,  495,    0,  495,  495,  496,  496,  496,
      496,  496,  496,  496,  496,  496,  497,  497,  497,  497,
      497,  497,  497,  497,  497,  498,  498,  498,  498,  498,
      498,  498,  498,  498,  498,  498,  498,  499,  499,  499,
      499,  499,  499,  499,  499,  499,  500,  500,  500,  500,
      500,  500,  500,  500,  500,  501,  501,  501,    0,  501,
      502,  502,  502,  502,  502,  502,  502,  502,  502,  502,
      502,  502,  503,  503,  503,    0,  503,  504,  504,  504,
      504,    0,  504,  504,  504,  504,  504,  504,  505,  505,
      505,    0,  505,  506,    0,  506,  506,  506,  506,  506,

      506,  506,  506,  506,  507,    0,  507,  507,  507,  507,
      507,  507,  507,  507,  507,  508,  508,  508,  508,  508,
      508,  508,  508,  508,  508,  508,  509,  509,  509,    0,
      509,  510,  510,  510,  510,  510,  510,  510,  510,  510,
      510,  510,  511,  511,  511,  511,  511,  511,  511,  511,
      511,  511,  511,  512,  512,  512,    0,  512,  513,  513,
      513,    0,    0,    0,  513,    0,    0,  513,  513,  514,
      514,  514,  514,  514,  514,  514,  514,  514,  515,  515,
      515,    0,    0,  515,  515,  515,    0,  515,  515,  516,
      516,  516,  516,  516,  516,  516,  516,  516,  478,  478,

      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478
    } ;

#line 1 "<stdin>"
YY_DECL
{
	register yy_state_type yy_current_state;
	register UChar *yy_cp, *yy_bp;
	register int yy_act;
	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 479 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 2399 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 31 "<stdin>"
/* ignore comments */
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 33 "<stdin>"
{yyTok = WHITESPACE; return yyTok;}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 35 "<stdin>"
{yyTok = SGML_CD; return yyTok;}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 36 "<stdin>"
{yyTok = SGML_CD; return yyTok;}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 37 "<stdin>"
{yyTok = INCLUDES; return yyTok;}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 38 "<stdin>"
{yyTok = DASHMATCH; return yyTok;}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 39 "<stdin>"
{yyTok = BEGINSWITH; return yyTok;}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 40 "<stdin>"
{yyTok = ENDSWITH; return yyTok;}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 41 "<stdin>"
{yyTok = CONTAINS; return yyTok;}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 42 "<stdin>"
{yyTok = MEDIA_NOT; return yyTok;}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 43 "<stdin>"
{yyTok = MEDIA_ONLY; return yyTok;}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 44 "<stdin>"
{yyTok = MEDIA_AND; return yyTok;}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 45 "<stdin>"
{BEGIN(mediaquery); yyTok = VARIABLES_FOR; return yyTok; }
	YY_BREAK
case 14:
/* rule 14 can match eol */
YY_RULE_SETUP
#line 47 "<stdin>"
{yyTok = STRING; return yyTok;}
	YY_BREAK
case 15:
/* rule 15 can match eol */
YY_RULE_SETUP
#line 48 "<stdin>"
{yyTok = IDENT; return yyTok;}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 49 "<stdin>"
{yyTok = NTH; return yyTok;}
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 51 "<stdin>"
{yyTok = HEX; return yyTok;}
	YY_BREAK
case 18:
/* rule 18 can match eol */
YY_RULE_SETUP
#line 52 "<stdin>"
{yyTok = IDSEL; return yyTok;}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 54 "<stdin>"
{BEGIN(mediaquery); yyTok = IMPORT_SYM; return yyTok;}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 55 "<stdin>"
{yyTok = PAGE_SYM; return yyTok;}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 56 "<stdin>"
{BEGIN(mediaquery); yyTok = MEDIA_SYM; return yyTok;}
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 57 "<stdin>"
{yyTok = FONT_FACE_SYM; return yyTok;}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 58 "<stdin>"
{yyTok = CHARSET_SYM; return yyTok;}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 59 "<stdin>"
{yyTok = NAMESPACE_SYM; return yyTok; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 60 "<stdin>"
{yyTok = WEBKIT_RULE_SYM; return yyTok; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 61 "<stdin>"
{yyTok = WEBKIT_DECLS_SYM; return yyTok; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 62 "<stdin>"
{yyTok = WEBKIT_VALUE_SYM; return yyTok; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 63 "<stdin>"
{BEGIN(mediaquery); yyTok = WEBKIT_MEDIAQUERY_SYM; return yyTok; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 64 "<stdin>"
{yyTok = WEBKIT_SELECTOR_SYM; return yyTok; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 65 "<stdin>"
{BEGIN(mediaquery); yyTok = WEBKIT_VARIABLES_SYM; return yyTok; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 66 "<stdin>"
{BEGIN(forkeyword); yyTok = WEBKIT_DEFINE_SYM; return yyTok; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 67 "<stdin>"
{ yyTok = WEBKIT_VARIABLES_DECLS_SYM; return yyTok; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 68 "<stdin>"
{yyTok = WEBKIT_KEYFRAMES_SYM; return yyTok; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 69 "<stdin>"
{yyTok = WEBKIT_KEYFRAME_RULE_SYM; return yyTok; }
	YY_BREAK
case 35:
/* rule 35 can match eol */
YY_RULE_SETUP
#line 71 "<stdin>"
{yyTok = ATKEYWORD; return yyTok; }
	YY_BREAK
case 36:
/* rule 36 can match eol */
YY_RULE_SETUP
#line 73 "<stdin>"
{yyTok = IMPORTANT_SYM; return yyTok;}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 75 "<stdin>"
{yyTok = EMS; return yyTok;}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 76 "<stdin>"
{yyTok = QEMS; return yyTok;} /* quirky ems */
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 77 "<stdin>"
{yyTok = EXS; return yyTok;}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 78 "<stdin>"
{yyTok = PXS; return yyTok;}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 79 "<stdin>"
{yyTok = CMS; return yyTok;}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 80 "<stdin>"
{yyTok = MMS; return yyTok;}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 81 "<stdin>"
{yyTok = INS; return yyTok;}
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 82 "<stdin>"
{yyTok = PTS; return yyTok;}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 83 "<stdin>"
{yyTok = PCS; return yyTok;}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 84 "<stdin>"
{yyTok = DEGS; return yyTok;}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 85 "<stdin>"
{yyTok = RADS; return yyTok;}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 86 "<stdin>"
{yyTok = GRADS; return yyTok;}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 87 "<stdin>"
{yyTok = TURNS; return yyTok;}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 88 "<stdin>"
{yyTok = MSECS; return yyTok;}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 89 "<stdin>"
{yyTok = SECS; return yyTok;}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 90 "<stdin>"
{yyTok = HERZ; return yyTok;}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 91 "<stdin>"
{yyTok = KHERZ; return yyTok;}
	YY_BREAK
case 54:
/* rule 54 can match eol */
YY_RULE_SETUP
#line 92 "<stdin>"
{yyTok = DIMEN; return yyTok;}
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 93 "<stdin>"
{yyTok = PERCENTAGE; return yyTok;}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 94 "<stdin>"
{yyTok = INTEGER; return yyTok;}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 95 "<stdin>"
{yyTok = FLOATTOKEN; return yyTok;}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 97 "<stdin>"
{yyTok = NOTFUNCTION; return yyTok;}
	YY_BREAK
case 59:
/* rule 59 can match eol */
YY_RULE_SETUP
#line 98 "<stdin>"
{yyTok = URI; return yyTok;}
	YY_BREAK
case 60:
/* rule 60 can match eol */
YY_RULE_SETUP
#line 99 "<stdin>"
{yyTok = URI; return yyTok;}
	YY_BREAK
case 61:
/* rule 61 can match eol */
YY_RULE_SETUP
#line 100 "<stdin>"
{ yyTok = VARCALL; return yyTok; }
	YY_BREAK
case 62:
/* rule 62 can match eol */
YY_RULE_SETUP
#line 101 "<stdin>"
{yyTok = FUNCTION; return yyTok;}
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 103 "<stdin>"
{yyTok = UNICODERANGE; return yyTok;}
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 104 "<stdin>"
{yyTok = UNICODERANGE; return yyTok;}
	YY_BREAK
case 65:
#line 107 "<stdin>"
case 66:
YY_RULE_SETUP
#line 107 "<stdin>"
{BEGIN(INITIAL); yyTok = *yytext; return yyTok; }
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 108 "<stdin>"
{yyTok = *yytext; return yyTok;}
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 110 "<stdin>"
ECHO;
	YY_BREAK
#line 1761 "<stdout>"
case YY_STATE_EOF(INITIAL):
case YY_END_OF_BUFFER:
case YY_STATE_EOF(mediaquery):
case YY_STATE_EOF(forkeyword):
	yyterminate();

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of yylex */
