/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileLock {
    public static final FileLock NONE = new FileLock(){

        public boolean isValid() {
            return false;
        }
    };
    private boolean locked = true;
    private Throwable lockedBy;

    public FileLock() {
        assert ((this.lockedBy = new Throwable()) != null);
    }

    public void releaseLock() {
        this.locked = false;
    }

    public boolean isValid() {
        return this.locked;
    }

    public void finalize() {
        assert (!this.isValid()) : this.assertMessageForInvalidLocks();
        this.releaseLock();
    }

    private String assertMessageForInvalidLocks() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.lockedBy != null) {
            Logger.getLogger(FileLock.class.getName()).log(Level.WARNING, null, new Exception("Not released lock for file: " + this.toString() + " (traped in finalizer)").initCause(this.lockedBy));
        }
        this.releaseLock();
        return byteArrayOutputStream.toString();
    }
}

