/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbCollections;

final class ExternalUtil {
    static Repository repository;
    private static Logger LOG;

    ExternalUtil() {
    }

    public static Repository getRepository() {
        ExternalUtil.initialize();
        return repository;
    }

    public static void exception(Exception exception) {
        LOG.log(Level.INFO, null, exception);
    }

    public static Throwable copyAnnotation(Throwable throwable, Throwable throwable2) {
        return throwable.initCause(throwable2);
    }

    public static void annotate(Throwable throwable, String string) {
        Exceptions.attachLocalizedMessage((Throwable)throwable, (String)string);
    }

    public static Throwable annotate(Throwable throwable, Throwable throwable2) {
        Throwable throwable3 = throwable;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        throwable.initCause(throwable2);
        return throwable3;
    }

    public static void log(String string) {
        LOG.fine(string);
    }

    public static Class findClass(String string) throws ClassNotFoundException {
        ExternalUtil.initialize();
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (classLoader == null) {
            return Class.forName(string);
        }
        return Class.forName(string, true, classLoader);
    }

    private static void initialize() {
        if (!ExternalUtil.isInitialized()) {
            Lookup lookup = Lookup.getDefault();
            Repository repository = (Repository)lookup.lookup(Repository.class);
            ExternalUtil.setRepository(repository);
        }
    }

    private static synchronized boolean isInitialized() {
        return repository != null;
    }

    private static synchronized void setRepository(Repository repository) {
        ExternalUtil.repository = repository;
        if (ExternalUtil.repository == null) {
            ExternalUtil.repository = new Repository(new MainFS());
        }
    }

    static {
        LOG = Logger.getLogger("org.openide.filesystems");
    }

    private static final class MainFS
    extends MultiFileSystem
    implements LookupListener {
        private static final Lookup.Result<FileSystem> ALL = Lookup.getDefault().lookupResult(FileSystem.class);
        private static final FileSystem MEMORY = FileUtil.createMemoryFileSystem();
        private static final XMLFileSystem layers = new XMLFileSystem();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MainFS() {
            ALL.addLookupListener((LookupListener)this);
            ArrayList<URL> arrayList = new ArrayList<URL>();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                for (URL uRL : NbCollections.iterable(classLoader.getResources("META-INF/MANIFEST.MF"))) {
                    InputStream inputStream = uRL.openStream();
                    try {
                        Manifest manifest = new Manifest(inputStream);
                        String string = manifest.getMainAttributes().getValue("OpenIDE-Module-Layer");
                        if (string == null) continue;
                        URL uRL2 = classLoader.getResource(string);
                        if (uRL2 != null) {
                            arrayList.add(uRL2);
                            continue;
                        }
                        LOG.warning("No such layer: " + string);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                layers.setXmlUrls(arrayList.toArray(new URL[arrayList.size()]));
                LOG.log(Level.FINE, "Loading classpath layers: {0}", arrayList);
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Setting layer URLs: " + arrayList, exception);
            }
            this.resultChanged(null);
        }

        private static FileSystem[] computeDelegates() {
            ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>();
            arrayList.add(MEMORY);
            arrayList.add(layers);
            arrayList.addAll(ALL.allInstances());
            return arrayList.toArray(new FileSystem[0]);
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.setDelegates(MainFS.computeDelegates());
        }
    }
}

