/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.common.integration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.integration.IntegrationProvider2;
import org.netbeans.lib.profiler.global.Platform;

public class IntegrationUtils {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.common.integration.Bundle");
    public static final String PLATFORM_JAVA_50 = messages.getString("IntegrationUtils_PlatformJava50");
    public static final String PLATFORM_JAVA_60 = messages.getString("IntegrationUtils_PlatformJava60");
    public static final String PLATFORM_JAVA_70 = messages.getString("IntegrationUtils_PlatformJava70");
    public static final String PLATFORM_WINDOWS_OS = messages.getString("IntegrationUtils_PlatformWindowsOs");
    public static final String PLATFORM_WINDOWS_AMD64_OS = messages.getString("IntegrationUtils_PlatformWindowsAmd64Os");
    public static final String PLATFORM_LINUX_OS = messages.getString("IntegrationUtils_PlatformLinuxOs");
    public static final String PLATFORM_LINUX_AMD64_OS = messages.getString("IntegrationUtils_PlatformLinuxAmd64Os");
    public static final String PLATFORM_SOLARIS_INTEL_OS = messages.getString("IntegrationUtils_PlatformSolarisIntelOs");
    public static final String PLATFORM_SOLARIS_AMD64_OS = messages.getString("IntegrationUtils_PlatformSolarisAmd64Os");
    public static final String PLATFORM_SOLARIS_SPARC_OS = messages.getString("IntegrationUtils_PlatformSolarisSparcOs");
    public static final String PLATFORM_SOLARIS_SPARC64_OS = messages.getString("IntegrationUtils_PlatformSolarisSparc64Os");
    public static final String PLATFORM_MAC_OS = messages.getString("IntegrationUtils_PlatformMacOs");
    public static final String MODIFIED_FOR_PROFILER_STRING = messages.getString("IntegrationUtils_ModifiedForProfilerString");
    public static final String ORIGINAL_BACKUP_LOCATION_STRING = messages.getString("IntegrationUtils_OriginalBackupLocationString");
    private static final String APPLICATION_STRING = messages.getString("IntegrationUtils_ApplicationString");
    private static final String APPLET_STRING = messages.getString("IntegrationUtils_AppletString");
    private static final String SERVER_STRING = messages.getString("IntegrationUtils_ServerString");
    private static final String DATABASE_STRING = messages.getString("IntegrationUtils_DatabaseString");
    private static final String TARGET_STRING = messages.getString("IntegrationUtils_TargetString");
    private static final String JDK_50_NAME = messages.getString("IntegrationUtils_Jdk50Name");
    private static final String JDK_60_NAME = messages.getString("IntegrationUtils_Jdk60Name");
    private static final String JDK_70_NAME = messages.getString("IntegrationUtils_Jdk70Name");
    private static final String HTML_REMOTE_STRING = "&lt;" + messages.getString("IntegrationUtils_RemoteString") + "&gt;";
    private static final String EXPORT_SETENV_MESSAGE = messages.getString("IntegrationUtils_ExportSetenvMessage");
    private static final String REDUCE_OVERHEAD_MESSAGE = messages.getString("IntegrationUtils_ReduceOverheadMessage");
    private static final String COPY_FILE_NOT_FOUND_MESSAGE = messages.getString("IntegrationUtils_CopyFileNotFoundMessage");
    private static final String COPY_CANNOT_DELETE_FILE_MESSAGE = messages.getString("IntegrationUtils_CopyCannotDeleteFileMessage");
    private static final String COPY_ERROR_MESSAGE = messages.getString("IntegrationUtils_CopyErrorMessage");
    private static final String BACKUP_FILE_NOT_FOUND_MESSAGE = messages.getString("IntegrationUtils_BackupFileNotFoundMessage");
    private static final String BACKUP_CANNOT_DELETE_FILE_MESSAGE = messages.getString("IntegrationUtils_BackupCannotDeleteFileMessage");
    private static final String BACKUP_ERROR_MESSAGE = messages.getString("IntegrationUtils_BackupErrorMessage");
    private static final String BACKUP_ERROR_COPY_FILE_MESSAGE = messages.getString("IntegrationUtils_BackupErrorCopyFileMessage");
    private static final String RESTORE_FILE_NOT_FOUND_MESSAGE = messages.getString("IntegrationUtils_RestoreFileNotFoundMessage");
    private static final String RESTORE_CANNOT_DELETE_FILE_MESSAGE = messages.getString("IntegrationUtils_RestoreCannotDeleteFileMessage");
    private static final String RESTORE_ERROR_MESSAGE = messages.getString("IntegrationUtils_RestoreErrorMessage");
    private static final String MANUAL_REMOTE_STEP1_MESSAGE = messages.getString("IntegrationUtils_ManualRemoteStep1Message");
    private static final String MANUAL_REMOTE_STEP2_MESSAGE = messages.getString("IntegrationUtils_ManualRemoteStep2Message");
    private static final String REMOTE_ABSOLUTE_PATH_HINT = messages.getString("IntegrationUtils_RemoteAbsolutePathHint");
    private static final String SPACES_IN_PATH_WARNING_MSG = messages.getString("IntegrationUtils_SpacesInPathWarningMsg");
    public static final String FILE_BACKUP_EXTENSION = ".backup";

    public static String getAddProfilerLibrariesToPathString(String targetPlatform, String targetJVM, boolean isRemote, boolean formatAsHTML) {
        return IntegrationUtils.getExportEnvVariableValueString(targetPlatform, IntegrationUtils.getNativePathEnvVariableString(targetPlatform), IntegrationUtils.getNativeLibrariesPath(targetPlatform, targetJVM, isRemote) + IntegrationUtils.getPathSeparator(targetPlatform) + IntegrationUtils.getEnvVariableReference(IntegrationUtils.getNativePathEnvVariableString(targetPlatform), targetPlatform), formatAsHTML);
    }

    public static String getAssignEnvVariableValueString(String targetPlatform, String variableName, String variableValue) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return IntegrationUtils.getExportCommandString(targetPlatform) + " " + variableName + "=" + variableValue;
        }
        return variableName + "=" + variableValue;
    }

    public static String getBatchExtensionString(String targetPlatform) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return ".bat";
        }
        return ".sh";
    }

    public static String getCPUReduceOverheadHint() {
        return REDUCE_OVERHEAD_MESSAGE;
    }

    public static String getDirectorySeparator(String targetPlatform) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return "\\";
        }
        return "/";
    }

    public static String getEnvVariableReference(String envVariable, String targetPlatform) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return "%" + envVariable + "%";
        }
        return "$" + envVariable;
    }

    public static String getExportCommandString(String targetPlatform) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return "SET";
        }
        return "export";
    }

    public static String getExportEnvVariableValueString(String targetPlatform, String variableName, String variableValue, boolean formatAsHTML) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return IntegrationUtils.getAssignEnvVariableValueString(targetPlatform, variableName, variableValue);
        }
        if (targetPlatform.equals(PLATFORM_LINUX_OS)) {
            return IntegrationUtils.getExportCommandString(targetPlatform) + " " + IntegrationUtils.getAssignEnvVariableValueString(targetPlatform, variableName, variableValue);
        }
        return IntegrationUtils.getAssignEnvVariableValueString(targetPlatform, variableName, variableValue) + (formatAsHTML ? "<br>" : IntegrationUtils.getLineBreak(targetPlatform)) + IntegrationUtils.getExportCommandString(targetPlatform) + " " + variableName;
    }

    public static String getExportVSSetenvNote() {
        return EXPORT_SETENV_MESSAGE;
    }

    public static boolean isFileModifiedForProfiler(File file) {
        try {
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            String line = br.readLine();
            if (line == null) {
                br.close();
                return false;
            }
            if (line.indexOf(MODIFIED_FOR_PROFILER_STRING) != -1) {
                br.close();
                return true;
            }
            line = br.readLine();
            if (line == null) {
                br.close();
                return false;
            }
            if (line.indexOf(MODIFIED_FOR_PROFILER_STRING) != -1) {
                br.close();
                return true;
            }
            br.close();
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String getJavaPlatformFromJavaVersionString(String javaVersionString) {
        if (javaVersionString.equals("jdk15")) {
            return PLATFORM_JAVA_50;
        }
        if (javaVersionString.equals("jdk16")) {
            return PLATFORM_JAVA_60;
        }
        if (javaVersionString.equals("jdk17")) {
            return PLATFORM_JAVA_70;
        }
        return null;
    }

    public static String getJavaPlatformName(String javaPlatform) {
        if (javaPlatform.equals(PLATFORM_JAVA_50)) {
            return JDK_50_NAME;
        }
        if (javaPlatform.equals(PLATFORM_JAVA_60)) {
            return JDK_60_NAME;
        }
        if (javaPlatform.equals(PLATFORM_JAVA_70)) {
            return JDK_70_NAME;
        }
        return javaPlatform;
    }

    public static String getJavaPlatformNativeLibrariesDirectoryName(String javaPlatform) {
        if (javaPlatform.equals(PLATFORM_JAVA_50)) {
            return "jdk15";
        }
        if (javaPlatform.equals(PLATFORM_JAVA_60)) {
            return "jdk16";
        }
        if (javaPlatform.equals(PLATFORM_JAVA_70)) {
            return "jdk16";
        }
        throw new IllegalArgumentException("Unsupported platform " + javaPlatform);
    }

    public static String getLibsDir(String targetPlatform, boolean isRemote) {
        if (isRemote) {
            return HTML_REMOTE_STRING + IntegrationUtils.getDirectorySeparator(targetPlatform) + "lib";
        }
        return Profiler.getDefault().getLibsDir();
    }

    public static String getLineBreak(String targetPlatform) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return "\r\n";
        }
        return "\n";
    }

    public static String getLocalJavaPlatform() {
        int jdkVersion = Platform.getJDKVersionNumber();
        if (jdkVersion == 2) {
            return PLATFORM_JAVA_50;
        }
        if (jdkVersion == 3) {
            return PLATFORM_JAVA_60;
        }
        if (jdkVersion == 4) {
            return PLATFORM_JAVA_70;
        }
        return null;
    }

    public static String getLocalPlatform(int architecture) {
        if (architecture == -1) {
            architecture = Platform.getSystemArchitecture();
        }
        if (architecture == 32) {
            if (Platform.isWindows()) {
                return PLATFORM_WINDOWS_OS;
            }
            if (Platform.isLinux()) {
                return PLATFORM_LINUX_OS;
            }
            if (Platform.isSolarisIntel()) {
                return PLATFORM_SOLARIS_INTEL_OS;
            }
            if (Platform.isSolarisSparc()) {
                return PLATFORM_SOLARIS_SPARC_OS;
            }
            if (Platform.isMac()) {
                return PLATFORM_MAC_OS;
            }
            return PLATFORM_SOLARIS_SPARC_OS;
        }
        if (Platform.isWindows()) {
            return PLATFORM_WINDOWS_AMD64_OS;
        }
        if (Platform.isLinux()) {
            return PLATFORM_LINUX_AMD64_OS;
        }
        if (Platform.isSolarisIntel()) {
            return PLATFORM_SOLARIS_AMD64_OS;
        }
        if (Platform.isSolarisSparc()) {
            return PLATFORM_SOLARIS_SPARC64_OS;
        }
        if (Platform.isMac()) {
            return PLATFORM_MAC_OS;
        }
        return PLATFORM_SOLARIS_SPARC64_OS;
    }

    public static String getManualRemoteStep1(String targetOS, String targetJVM) {
        return MessageFormat.format(MANUAL_REMOTE_STEP1_MESSAGE, "JDK 5.0/6.0/7.0", targetOS, HTML_REMOTE_STRING);
    }

    public static String getManualRemoteStep2(String targetOS, String targetJVM) {
        return MessageFormat.format(MANUAL_REMOTE_STEP2_MESSAGE, IntegrationUtils.getRemoteCalibrateCommandString(targetOS));
    }

    public static String getNativeLibrariesPath(String targetPlatform, String targetJVM, boolean isRemote) {
        return IntegrationUtils.getLibsDir(targetPlatform, isRemote) + IntegrationUtils.getDirectorySeparator(targetPlatform) + "deployed" + IntegrationUtils.getDirectorySeparator(targetPlatform) + IntegrationUtils.getJavaPlatformNativeLibrariesDirectoryName(targetJVM) + IntegrationUtils.getDirectorySeparator(targetPlatform) + IntegrationUtils.getOSPlatformNativeLibrariesDirectoryName(targetPlatform, isRemote);
    }

    public static String getNativePathEnvVariableString(String targetPlatform) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return "Path";
        }
        return "LD_LIBRARY_PATH";
    }

    public static String getOSPlatformNativeLibrariesDirectoryName(String targetPlatform, boolean isRemote) {
        if (targetPlatform.equals(PLATFORM_WINDOWS_OS)) {
            return "windows";
        }
        if (targetPlatform.equals(PLATFORM_WINDOWS_AMD64_OS)) {
            return "windows-amd64";
        }
        if (targetPlatform.equals(PLATFORM_LINUX_OS)) {
            return "linux";
        }
        if (targetPlatform.equals(PLATFORM_LINUX_AMD64_OS)) {
            return "linux-amd64";
        }
        if (targetPlatform.equals(PLATFORM_SOLARIS_INTEL_OS)) {
            return "solaris-i386";
        }
        if (targetPlatform.equals(PLATFORM_SOLARIS_AMD64_OS)) {
            return "solaris-amd64";
        }
        if (targetPlatform.equals(PLATFORM_SOLARIS_SPARC_OS)) {
            return "solaris-sparc";
        }
        if (targetPlatform.equals(PLATFORM_SOLARIS_SPARC64_OS)) {
            return "solaris-sparcv9";
        }
        if (targetPlatform.equals(PLATFORM_MAC_OS)) {
            return "mac";
        }
        return null;
    }

    public static String getPathSeparator(String targetPlatform) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return ";";
        }
        return ":";
    }

    public static String getProfilerAgentCommandLineArgs(String targetPlatform, String targetJVM, boolean isRemote, int portNumber) {
        if (IntegrationUtils.getNativeLibrariesPath(targetPlatform, targetJVM, isRemote).indexOf(32) == -1) {
            return IntegrationUtils.getProfilerAgentCommandLineArgsWithoutQuotes(targetPlatform, targetJVM, isRemote, portNumber);
        }
        if (!IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            try {
                File tmpFile = File.createTempFile("NBProfiler", ".link");
                String tmpPath = tmpFile.getAbsolutePath();
                String libsDirPath = IntegrationUtils.getLibsDir(targetPlatform, isRemote);
                String args = IntegrationUtils.getProfilerAgentCommandLineArgsWithoutQuotes(targetPlatform, targetJVM, isRemote, portNumber);
                tmpFile.delete();
                Runtime.getRuntime().exec(new String[]{"/bin/ln", "-s", libsDirPath, tmpPath});
                new File(tmpPath).deleteOnExit();
                return args.replace(libsDirPath, tmpPath);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return "-agentpath:\"" + IntegrationUtils.getNativeLibrariesPath(targetPlatform, targetJVM, isRemote) + IntegrationUtils.getDirectorySeparator(targetPlatform) + IntegrationUtils.getProfilerAgentLibraryFile(targetPlatform) + "=" + "\\\"" + IntegrationUtils.getLibsDir(targetPlatform, isRemote) + "\\\"\"" + "," + portNumber;
    }

    public static String getProfilerAgentCommandLineArgsWithoutQuotes(String targetPlatform, String targetJVM, boolean isRemote, int portNumber) {
        return "-agentpath:" + IntegrationUtils.getNativeLibrariesPath(targetPlatform, targetJVM, isRemote) + IntegrationUtils.getDirectorySeparator(targetPlatform) + IntegrationUtils.getProfilerAgentLibraryFile(targetPlatform) + "=" + IntegrationUtils.getLibsDir(targetPlatform, isRemote) + "," + portNumber;
    }

    public static String getProfilerAgentLibraryFile(String targetPlatform) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return "profilerinterface.dll";
        }
        if (targetPlatform.equals(PLATFORM_MAC_OS)) {
            return "libprofilerinterface.jnilib";
        }
        return "libprofilerinterface.so";
    }

    public static String getProfilerModifiedFileHeader(String targetPlatform) {
        return IntegrationUtils.getSilentScriptCommentSign(targetPlatform) + " " + MODIFIED_FOR_PROFILER_STRING + IntegrationUtils.getLineBreak(targetPlatform);
    }

    public static String getProfilerModifiedReplaceFileHeader(String targetPlatform) {
        return IntegrationUtils.getProfilerModifiedFileHeader(targetPlatform) + IntegrationUtils.getSilentScriptCommentSign(targetPlatform) + " " + ORIGINAL_BACKUP_LOCATION_STRING + IntegrationUtils.getLineBreak(targetPlatform);
    }

    public static String getRemoteAbsolutePathHint() {
        return MessageFormat.format(REMOTE_ABSOLUTE_PATH_HINT, HTML_REMOTE_STRING);
    }

    public static String getRemoteCalibrateCommandString(String targetPlatform) {
        return HTML_REMOTE_STRING + IntegrationUtils.getDirectorySeparator(targetPlatform) + "bin" + IntegrationUtils.getDirectorySeparator(targetPlatform) + "calibrate" + IntegrationUtils.getBatchExtensionString(targetPlatform);
    }

    public static String getRemoteProfileCommandString(String targetPlatform) {
        return HTML_REMOTE_STRING + IntegrationUtils.getDirectorySeparator(targetPlatform) + "bin" + IntegrationUtils.getDirectorySeparator(targetPlatform) + "profile" + IntegrationUtils.getBatchExtensionString(targetPlatform);
    }

    public static String getScriptCommentSign(String targetPlatform) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return "rem";
        }
        return "#";
    }

    public static String getSilentScriptCommentSign(String targetPlatform) {
        if (IntegrationUtils.isWindowsPlatform(targetPlatform)) {
            return "@rem";
        }
        return "#";
    }

    public static String getSpacesInPathWarning() {
        return SPACES_IN_PATH_WARNING_MSG;
    }

    public static String getTargetTypeName(String targetType, boolean startsUpperCase) {
        if (targetType.equals(IntegrationProvider2.TARGET_TYPE_APPLICATION)) {
            return startsUpperCase ? APPLICATION_STRING : APPLICATION_STRING.toLowerCase();
        }
        if (targetType.equals(IntegrationProvider2.TARGET_TYPE_APPLET)) {
            return startsUpperCase ? APPLET_STRING : APPLET_STRING.toLowerCase();
        }
        if (targetType.equals(IntegrationProvider2.TARGET_TYPE_J2EEAPPLICATION)) {
            return startsUpperCase ? SERVER_STRING : SERVER_STRING.toLowerCase();
        }
        if (targetType.equals(IntegrationProvider2.TARGET_TYPE_DATABASE)) {
            return startsUpperCase ? DATABASE_STRING : DATABASE_STRING.toLowerCase();
        }
        return startsUpperCase ? TARGET_STRING : TARGET_STRING.toLowerCase();
    }

    public static boolean isWindowsPlatform(String targetPlatform) {
        return targetPlatform.equals(PLATFORM_WINDOWS_OS) || targetPlatform.equals(PLATFORM_WINDOWS_AMD64_OS);
    }

    public static String getXMLCommendEndSign() {
        return "-->";
    }

    public static String getXMLCommentStartSign() {
        return "<!--";
    }

    public static boolean backupFile(File file) {
        File source = new File(file.getAbsolutePath());
        File target = new File(source.getAbsolutePath() + FILE_BACKUP_EXTENSION);
        if (!source.exists()) {
            ProfilerLogger.severe((String)MessageFormat.format(BACKUP_FILE_NOT_FOUND_MESSAGE, source.getAbsolutePath()));
            return false;
        }
        if (target.exists() && !target.delete()) {
            ProfilerLogger.severe((String)MessageFormat.format(BACKUP_CANNOT_DELETE_FILE_MESSAGE, target.getAbsolutePath()));
            return false;
        }
        if (!source.renameTo(target)) {
            ProfilerLogger.severe((String)MessageFormat.format(BACKUP_ERROR_MESSAGE, source.getAbsolutePath(), target.getAbsolutePath()));
            return false;
        }
        try {
            source = new File(file.getAbsolutePath());
            source.createNewFile();
            target = new File(source.getAbsolutePath() + FILE_BACKUP_EXTENSION);
            FileChannel sourceChannel = new FileOutputStream(source).getChannel();
            FileChannel targetChannel = new FileInputStream(target).getChannel();
            targetChannel.transferTo(0L, targetChannel.size(), sourceChannel);
            targetChannel.close();
            sourceChannel.close();
            return true;
        }
        catch (Exception ex) {
            ProfilerLogger.severe((String)MessageFormat.format(BACKUP_ERROR_COPY_FILE_MESSAGE, target.getAbsolutePath(), source.getAbsolutePath(), ex));
            return false;
        }
    }

    public static boolean copyFile(File sourceFile, File targetFile) {
        if (!sourceFile.exists()) {
            ProfilerLogger.severe((String)MessageFormat.format(COPY_FILE_NOT_FOUND_MESSAGE, sourceFile.getAbsolutePath()));
            return false;
        }
        if (targetFile.exists() && !targetFile.delete()) {
            ProfilerLogger.severe((String)MessageFormat.format(COPY_CANNOT_DELETE_FILE_MESSAGE, targetFile.getAbsolutePath()));
            return false;
        }
        try {
            FileChannel sourceChannel = new FileInputStream(sourceFile).getChannel();
            FileChannel destinationChannel = new FileOutputStream(targetFile).getChannel();
            sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
            sourceChannel.close();
            destinationChannel.close();
            return true;
        }
        catch (Exception ex) {
            ProfilerLogger.log((Exception)ex);
            ProfilerLogger.severe((String)MessageFormat.format(COPY_ERROR_MESSAGE, sourceFile.getAbsolutePath(), targetFile.getAbsolutePath()));
            return false;
        }
    }

    public static boolean fileBackupExists(File file) {
        File target = new File(file.getAbsolutePath());
        File source = new File(target.getAbsolutePath() + FILE_BACKUP_EXTENSION);
        return source.exists();
    }

    public static boolean restoreFile(File file) {
        File target = file;
        File source = new File(target.getAbsolutePath() + FILE_BACKUP_EXTENSION);
        if (!source.exists()) {
            ProfilerLogger.severe((String)MessageFormat.format(RESTORE_FILE_NOT_FOUND_MESSAGE, source.getAbsolutePath(), target.getAbsolutePath()));
            return false;
        }
        if (target.exists() && !target.delete()) {
            ProfilerLogger.severe((String)MessageFormat.format(RESTORE_CANNOT_DELETE_FILE_MESSAGE, target.getAbsolutePath()));
            return false;
        }
        if (!source.renameTo(target)) {
            ProfilerLogger.severe((String)MessageFormat.format(RESTORE_ERROR_MESSAGE, source.getAbsolutePath(), target.getAbsolutePath()));
            return false;
        }
        return true;
    }
}

