/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.memory.AllocResultsPanel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;

public class SnapshotAllocResultsPanel
extends AllocResultsPanel
implements ActionListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String GO_SOURCE_POPUP_ITEM_NAME = messages.getString("AllocResultsPanel_GoSourcePopupItemName");
    private static final String SHOW_STACK_TRACES_POPUP_ITEM_NAME = messages.getString("AllocResultsPanel_ShowStackTracesPopupItemName");
    private AllocMemoryResultsSnapshot snapshot;
    private JMenuItem popupShowStacks;
    private JPopupMenu memoryResPopupMenu;

    public SnapshotAllocResultsPanel(AllocMemoryResultsSnapshot snapshot, MemoryResUserActionsHandler actionsHandler) {
        super(actionsHandler);
        this.snapshot = snapshot;
        this.fetchResultsFromSnapshot();
    }

    public ResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.popupShowStacks) {
            this.actionsHandler.showStacksForClass(this.selectedClassId, this.getSortingColumn(), this.getSortingOrder());
        }
    }

    protected String getClassName(int classId) {
        return this.snapshot.getClassName(classId);
    }

    protected String[] getClassNames() {
        return this.snapshot.getClassNames();
    }

    protected JPopupMenu getPopupMenu() {
        if (this.memoryResPopupMenu == null) {
            this.memoryResPopupMenu = new JPopupMenu();
            if (this.snapshot.containsStacks()) {
                this.memoryResPopupMenu.addSeparator();
                this.popupShowStacks = new JMenuItem();
                this.popupShowStacks.setText(SHOW_STACK_TRACES_POPUP_ITEM_NAME);
                this.memoryResPopupMenu.add(this.popupShowStacks);
                this.popupShowStacks.addActionListener(this);
            }
        }
        return this.memoryResPopupMenu;
    }

    private void fetchResultsFromSnapshot() {
        this.totalAllocObjectsSize = UIUtils.copyArray(this.snapshot.getObjectsSizePerClass());
        this.nTotalAllocObjects = UIUtils.copyArray(this.snapshot.getObjectsCounts());
        this.nTrackedItems = this.snapshot.getNProfiledClasses();
        if (this.nTrackedItems > this.nTotalAllocObjects.length) {
            this.nTrackedItems = this.nTotalAllocObjects.length;
        }
        if (this.nTrackedItems > this.totalAllocObjectsSize.length) {
            this.nTrackedItems = this.totalAllocObjectsSize.length;
        }
        this.maxValue = 0L;
        this.nTotalBytes = 0L;
        this.nTotalClasses = 0L;
        for (int i = 0; i < this.nTrackedItems; ++i) {
            if (this.maxValue < this.totalAllocObjectsSize[i]) {
                this.maxValue = this.totalAllocObjectsSize[i];
            }
            this.nTotalBytes += this.totalAllocObjectsSize[i];
            this.nTotalClasses += (long)this.nTotalAllocObjects[i];
        }
        this.initDataUponResultsFetch();
    }
}

