/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu.statistics.drilldown;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.results.cpu.marking.Mark;
import org.netbeans.lib.profiler.ui.cpu.statistics.drilldown.DrillDownPieChartModel;
import org.netbeans.lib.profiler.ui.cpu.statistics.drilldown.IDrillDown;

public class ProjectPieChartModel
extends DrillDownPieChartModel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.cpu.statistics.drilldown.Bundle");
    private static final String SELF_BADGE_TEXT = messages.getString("ProjectPieChartModel_SelfBadgeText");

    public ProjectPieChartModel(IDrillDown model) {
        super(model);
    }

    public String getItemName(int index) {
        return this.getItemNameAt(this.getMappedIndex(index));
    }

    public double getItemValue(int index) {
        double ret = this.getItemValueAt(this.getMappedIndex(index));
        System.out.println("Getting value for category n." + index + "  : " + ret);
        return ret;
    }

    public double getItemValueRel(int index) {
        long allTime = this.drillDown.getCurrentTime(false);
        long allTimeCalc = 0L;
        for (int i = 0; i < this.drillDown.getSubmarks().size(); ++i) {
            allTimeCalc = (long)((double)allTimeCalc + this.getItemValueAt(i));
        }
        if (allTimeCalc != allTime) {
            System.err.println("time mismatch: " + allTime + " != " + allTimeCalc);
        }
        if (allTime == 0L) {
            return 1.0;
        }
        return this.getItemValueAt(this.getMappedIndex(index)) / (double)allTime;
    }

    public boolean isSelectable(int index) {
        if (this.drillDown.getSubmarks().size() <= index) {
            return false;
        }
        if (index != -1) {
            return this.drillDown.canDrilldown((Mark)this.drillDown.getSubmarks().get(index));
        }
        return false;
    }

    private String getItemNameAt(int index) {
        if (this.drillDown.getSubmarks().size() <= index) {
            return "";
        }
        if ((index == -1 || this.drillDown.isCurrent((Mark)this.drillDown.getSubmarks().get(index))) && !this.drillDown.isInSelf()) {
            return MessageFormat.format(SELF_BADGE_TEXT, this.drillDown.getCurrentMark().description);
        }
        return ((Mark)this.drillDown.getSubmarks().get((int)index)).description;
    }

    private double getItemValueAt(int index) {
        if (this.drillDown.getSubmarks().size() <= index) {
            return 0.0;
        }
        if ((index == -1 || this.drillDown.isCurrent((Mark)this.drillDown.getSubmarks().get(index))) && !this.drillDown.isInSelf()) {
            return this.drillDown.getCurrentTime(true);
        }
        return this.drillDown.getMarkTime((Mark)this.drillDown.getSubmarks().get(index), false);
    }
}

